/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization;

import com.businessobjects.visualization.common.internal.VisuVersion;
import com.businessobjects.visualization.common.internal.XmlReaderVersion;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataAdapter;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLDataDescriptor;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLSessionDictionary;
import com.businessobjects.visualization.feed.definition.generated.XMLDataFeedDefinitionList;
import com.businessobjects.visualization.feed.generated.XMLDataFeed;
import com.businessobjects.visualization.graphic.xml.migration.generated.XMLMigrations;
import com.businessobjects.visualization.graphic.xml.scoring.generated.XMLScoringRules;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLSettings;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLVisualizationLibraries;
import com.businessobjects.visualization.util.xml.Helper;
import com.businessobjects.visualization.util.xml.XmlEventType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlReader;
import com.businessobjects.visualization.util.xml.XmlWriter;
import com.businessobjects.visualization.xml.generated.XMLcvom;

public class VisuXmlRoot {
    private static final String MAIN_ELEMENT = "Root";
    private static final String VERSION_ATTR = "Version";
    public XMLVisualizationLibraries m_MyVisualizationLibraries = null;
    public XMLSettings m_Settings = null;
    public XMLDataFeed m_DataFeed = null;
    public XMLDataFeedDefinitionList m_DataFeedDefinitionList = null;
    public XMLDataDescriptor m_DataDescriptor = null;
    public XMLSessionDictionary m_SessionDictionary = null;
    public XMLDataAdapter m_DataAdapter = null;
    public XMLScoringRules m_ScoringRules = null;
    public XMLMigrations m_Migrations;
    public XMLcvom m_cvom;

    public void unmarshall(XmlReader reader, VisuVersion currentVersion) throws XmlException {
        XmlReaderVersion xmlReaderVersion = new XmlReaderVersion(reader, currentVersion, null);
        while (!(reader.next() == XmlEventType.END_DOCUMENT || reader.getEventType() == XmlEventType.END_ELEMENT && reader.getName() != null && reader.getName().equals(MAIN_ELEMENT))) {
            String sNode = reader.getName();
            if (sNode != null && sNode.equals(MAIN_ELEMENT) && reader.getEventType() == XmlEventType.START_ELEMENT) {
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    String prefixName = reader.getAttributePrefix(i);
                    String attName = reader.getAttributeName(i);
                    String finalName = (prefixName != null ? prefixName : "") + (prefixName != null && attName != null ? ":" : "") + (attName != null ? attName : "");
                    if (!finalName.equals(VERSION_ATTR)) continue;
                    VisuVersion serializedVersion = new VisuVersion(reader.getAttributeValue(i));
                    xmlReaderVersion = new XmlReaderVersion(reader, currentVersion, serializedVersion);
                }
            }
            if (sNode != null && sNode.equals("MyVisualizationLibraries")) {
                this.m_MyVisualizationLibraries = new XMLVisualizationLibraries();
                this.m_MyVisualizationLibraries.unmarshall(xmlReaderVersion);
                continue;
            }
            if (sNode != null && sNode.equals("Settings")) {
                this.m_Settings = new XMLSettings();
                this.m_Settings.unmarshall(xmlReaderVersion);
                continue;
            }
            if (sNode != null && sNode.equals("DataFeed")) {
                this.m_DataFeed = new XMLDataFeed();
                this.m_DataFeed.unmarshall(xmlReaderVersion);
                continue;
            }
            if (sNode != null && sNode.equals("DataFeedDefinitionList")) {
                this.m_DataFeedDefinitionList = new XMLDataFeedDefinitionList();
                this.m_DataFeedDefinitionList.unmarshall(xmlReaderVersion);
                continue;
            }
            if (sNode != null && sNode.equals("DataDescriptor")) {
                this.m_DataDescriptor = new XMLDataDescriptor();
                this.m_DataDescriptor.unmarshall(xmlReaderVersion);
                continue;
            }
            if (sNode != null && sNode.equals("SessionDictionary")) {
                this.m_SessionDictionary = new XMLSessionDictionary();
                this.m_SessionDictionary.unmarshall(xmlReaderVersion);
                continue;
            }
            if (sNode != null && sNode.equals("DataAdapter")) {
                this.m_DataAdapter = new XMLDataAdapter();
                this.m_DataAdapter.unmarshall(xmlReaderVersion);
                continue;
            }
            if (sNode != null && sNode.equals("ScoringRules")) {
                this.m_ScoringRules = new XMLScoringRules();
                this.m_ScoringRules.unmarshall(xmlReaderVersion);
                continue;
            }
            if (sNode != null && sNode.equals("Migrations")) {
                this.m_Migrations = new XMLMigrations();
                this.m_Migrations.unmarshall(xmlReaderVersion);
                continue;
            }
            if (sNode == null || !sNode.equals("cvom")) continue;
            this.m_cvom = new XMLcvom();
            this.m_cvom.unmarshall(xmlReaderVersion);
        }
    }

    public void dump() {
        ++Helper.indent;
        Helper.print("XMLRoot");
        if (this.m_MyVisualizationLibraries != null) {
            this.m_MyVisualizationLibraries.dump();
        }
        if (this.m_Settings != null) {
            this.m_Settings.dump();
        }
        if (this.m_DataFeed != null) {
            this.m_DataFeed.dump();
        }
        if (this.m_DataFeedDefinitionList != null) {
            this.m_DataFeedDefinitionList.dump();
        }
        if (this.m_DataDescriptor != null) {
            this.m_DataDescriptor.dump();
        }
        if (this.m_SessionDictionary != null) {
            this.m_SessionDictionary.dump();
        }
        if (this.m_DataAdapter != null) {
            this.m_DataAdapter.dump();
        }
        if (this.m_ScoringRules != null) {
            this.m_ScoringRules.dump();
        }
        if (this.m_cvom != null) {
            this.m_cvom.dump();
        }
        Helper.println("XMLRoot ");
        --Helper.indent;
    }

    public void marshall(XmlWriter xw, VisuVersion currentVersion) throws XmlException {
        xw.startDocument();
        xw.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xw.startElement(MAIN_ELEMENT);
        xw.attribute(null, VERSION_ATTR, currentVersion != null ? currentVersion.getXmlVersion() : "1.0.0.0");
        if (this.m_MyVisualizationLibraries != null) {
            xw.startElement("MyVisualizationLibraries");
            this.m_MyVisualizationLibraries.marshall2(xw);
            xw.endElement("MyVisualizationLibraries");
        }
        if (this.m_Settings != null) {
            xw.startElement("Settings");
            this.m_Settings.marshall2(xw);
            xw.endElement("Settings");
        }
        if (this.m_DataFeed != null) {
            xw.startElement("DataFeed");
            this.m_DataFeed.marshall2(xw);
            xw.endElement("DataFeed");
        }
        if (this.m_DataFeedDefinitionList != null) {
            xw.startElement("DataFeedDefinitionList");
            this.m_DataFeedDefinitionList.marshall2(xw);
            xw.endElement("DataFeedDefinitionList");
        }
        if (this.m_DataDescriptor != null) {
            xw.startElement("DataDescriptor");
            this.m_DataDescriptor.marshall2(xw);
            xw.endElement("DataDescriptor");
        }
        if (this.m_SessionDictionary != null) {
            xw.startElement("SessionDictionary");
            this.m_SessionDictionary.marshall2(xw);
            xw.endElement("SessionDictionary");
        }
        if (this.m_DataAdapter != null) {
            xw.startElement("DataAdapter");
            this.m_DataAdapter.marshall2(xw);
            xw.endElement("DataAdapter");
        }
        if (this.m_ScoringRules != null) {
            xw.startElement("ScoringRules");
            this.m_ScoringRules.marshall2(xw);
            xw.endElement("ScoringRules");
        }
        if (this.m_cvom != null) {
            xw.startElement("cvom");
            this.m_cvom.marshall2(xw);
            xw.endElement("cvom");
        }
        xw.endElement(MAIN_ELEMENT);
        xw.endDocument();
    }

    public boolean equals(Object o) {
        VisuXmlRoot obj = (VisuXmlRoot)o;
        if (!this.m_MyVisualizationLibraries.equals(obj.m_MyVisualizationLibraries)) {
            return false;
        }
        if (!this.m_Settings.equals(obj.m_Settings)) {
            return false;
        }
        if (!this.m_DataFeed.equals(obj.m_DataFeed)) {
            return false;
        }
        if (!this.m_DataFeedDefinitionList.equals(obj.m_DataFeedDefinitionList)) {
            return false;
        }
        if (!this.m_DataDescriptor.equals(obj.m_DataDescriptor)) {
            return false;
        }
        if (!this.m_SessionDictionary.equals(obj.m_SessionDictionary)) {
            return false;
        }
        if (!this.m_DataAdapter.equals(obj.m_DataAdapter)) {
            return false;
        }
        if (!this.m_ScoringRules.equals(obj.m_ScoringRules)) {
            return false;
        }
        return this.m_cvom.equals(obj.m_cvom);
    }
}

