/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.util.xml;

import com.businessobjects.visualization.internal.util.Strings;
import com.businessobjects.visualization.util.xml.IXmlNameTable;
import com.businessobjects.visualization.util.xml.XmlEventType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlValidationException;
import com.businessobjects.visualization.util.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlReader {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final String LANG_ATTR = "lang";
    private String[] attNames;
    private String[] attNamespaces;
    private String[] attPrefixes;
    private String[] attValues;
    private XmlEventType eventType = XmlEventType.NONE;
    private final InputStream is;
    private Stack langs;
    private String name;
    private final IXmlNameTable nameTable = new XmlNameTable();
    private String ns;
    private final XmlPullParser parser;
    private String prefix;
    private final Reader reader;
    private String xmlLang;

    public XmlReader(InputStream is) throws XmlException {
        if (is == null) {
            throw new NullPointerException("is == null");
        }
        try {
            this.parser = XmlPullParserFactory.newInstance().newPullParser();
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.parser.setInput(is, "UTF-8");
            this.is = is;
            this.reader = null;
        }
        catch (XmlPullParserException e) {
            throw XmlException.createXmlException(e);
        }
    }

    public XmlReader(Reader reader) throws XmlException {
        if (reader == null) {
            throw new NullPointerException("reader == null");
        }
        try {
            this.parser = XmlPullParserFactory.newInstance().newPullParser();
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.parser.setInput(reader);
            this.is = null;
            this.reader = reader;
        }
        catch (XmlPullParserException e) {
            throw XmlException.createXmlException(e);
        }
    }

    private static XmlEventType getEventType(int event) {
        switch (event) {
            case 5: {
                return XmlEventType.CDATA;
            }
            case 1: {
                return XmlEventType.END_DOCUMENT;
            }
            case 3: {
                return XmlEventType.END_ELEMENT;
            }
            case 7: {
                return XmlEventType.WHITESPACE;
            }
            case 0: {
                return XmlEventType.START_DOCUMENT;
            }
            case 2: {
                return XmlEventType.START_ELEMENT;
            }
            case 4: {
                return XmlEventType.TEXT;
            }
        }
        return XmlEventType.NONE;
    }

    private static boolean isText(XmlEventType eventType) {
        switch (eventType.value()) {
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public final void close() throws XmlException {
        try {
            if (this.is != null) {
                this.is.close();
            } else {
                this.reader.close();
            }
        }
        catch (IOException e) {
            throw new XmlException(e.getMessage(), this, e);
        }
    }

    public final int getAttributeCount() {
        return this.attNames != null ? this.attNames.length : 0;
    }

    public final String getAttributeName(int index) {
        return this.attNames[index];
    }

    public final String getAttributeNamespace(int index) {
        return this.attNamespaces[index];
    }

    public final String getAttributePrefix(int index) {
        return this.attPrefixes[index];
    }

    public final String getAttributeValue(int index) {
        return this.attValues[index];
    }

    public final String getAttributeValue(String localName) {
        return this.getAttributeValue(null, localName);
    }

    public final String getAttributeValue(String namespace, String localName) {
        if ("http://www.w3.org/2000/xmlns/".equals(namespace)) {
            return this.parser.getNamespace(localName);
        }
        if (localName == null) {
            throw new NullPointerException("localName == null");
        }
        return this.parser.getAttributeValue(namespace, localName);
    }

    public final int getColumnNumber() {
        return this.parser.getColumnNumber();
    }

    public int getDepth() {
        return this.parser.getDepth();
    }

    public final XmlEventType getEventType() {
        return this.eventType;
    }

    public final int getLineNumber() {
        return this.eventType == XmlEventType.NONE ? 0 : this.parser.getLineNumber();
    }

    public String getLocationDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("line ").append(this.getLineNumber()).append(", column ").append(this.getColumnNumber());
        return buffer.toString();
    }

    public final String getName() {
        if (this.name == null) {
            this.name = this.nameTable.add(this.parser.getName());
        }
        return this.name;
    }

    public final String getNamespace() {
        if (this.ns == null) {
            this.ns = this.nameTable.add(Strings.nullForEmpty(this.parser.getNamespace()));
        }
        return this.ns;
    }

    public final IXmlNameTable getNameTable() {
        return this.nameTable;
    }

    public final String getPrefix() {
        if (this.prefix == null) {
            this.prefix = this.nameTable.add(this.parser.getPrefix());
        }
        return this.prefix;
    }

    public final String getText() {
        if (this.eventType == XmlEventType.START_ELEMENT || this.eventType == XmlEventType.END_ELEMENT) {
            return null;
        }
        return this.parser.getText();
    }

    public final String getXmlLang() {
        if (this.xmlLang != null) {
            return this.xmlLang;
        }
        if (this.langs != null && !this.langs.isEmpty()) {
            XmlLangContext context = (XmlLangContext)this.langs.peek();
            return context.lang;
        }
        return null;
    }

    public boolean hasNext() {
        return this.eventType != XmlEventType.END_DOCUMENT;
    }

    public final int indexOfAttribute(String namespace, String localName) {
        if (this.eventType != XmlEventType.START_ELEMENT) {
            return -1;
        }
        String singleName = this.nameTable.get(localName);
        if (singleName == null) {
            return -1;
        }
        String singleNs = this.nameTable.get(namespace);
        for (int i = 0; i < this.attNames.length; ++i) {
            if (this.attNames[i] != singleName || this.attNamespaces[i] != singleNs) continue;
            return i;
        }
        return -1;
    }

    public final boolean isEmptyElementTag() {
        try {
            return this.parser.isEmptyElementTag();
        }
        catch (XmlPullParserException e) {
            return false;
        }
    }

    public final boolean isWhitespace() {
        return this.eventType == XmlEventType.WHITESPACE;
    }

    public final String lookupNamespace(String nsPrefix) {
        return this.nameTable.add(this.parser.getNamespace(nsPrefix));
    }

    public XmlEventType next() throws XmlException {
        this.name = null;
        this.ns = null;
        this.prefix = null;
        this.xmlLang = null;
        try {
            this.setEventType(this.parser.next());
            while (this.eventType == XmlEventType.WHITESPACE || this.eventType == XmlEventType.NONE) {
                this.setEventType(this.parser.next());
            }
            return this.eventType;
        }
        catch (XmlPullParserException e) {
            throw XmlException.createXmlException(e);
        }
        catch (IOException e) {
            throw new XmlException(e.getMessage(), this, e);
        }
    }

    public final void readEndElement(String namespace, String localName) throws XmlException {
        this.require(XmlEventType.END_ELEMENT, namespace, localName);
        this.next();
    }

    public final void readStartElement(String namespace, String localName) throws XmlException {
        this.require(XmlEventType.START_ELEMENT, namespace, localName);
        this.next();
    }

    public final String readText() throws XmlException {
        if (!XmlReader.isText(this.eventType)) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(this.getText());
        while (XmlReader.isText(this.next())) {
            buffer.append(this.getText());
        }
        return buffer.toString();
    }

    public final String readTextElement(String namespace, String localName) throws XmlException {
        this.readStartElement(namespace, localName);
        String text = this.readText();
        this.readEndElement(namespace, localName);
        return text;
    }

    public boolean readToEndElement(String namespace, String localName) throws XmlException {
        return this.readToEvent(XmlEventType.END_ELEMENT, namespace, localName, this.getDepth());
    }

    public boolean readToEvent(XmlEventType type, String namespace, String localName, int minDepth) throws XmlException {
        String singleNs = this.nameTable.add(namespace);
        String singleName = this.nameTable.add(localName);
        while (this.getDepth() >= minDepth) {
            if (this.eventType == type) {
                if (singleNs != null && singleNs != this.getNamespace()) {
                    this.next();
                    continue;
                }
                if (singleName != null && singleName != this.getName()) {
                    this.next();
                    continue;
                }
                return true;
            }
            if (this.eventType == XmlEventType.END_DOCUMENT) {
                return false;
            }
            this.next();
        }
        return false;
    }

    public boolean readToStartElement(String namespace, String localName) throws XmlException {
        return this.readToEvent(XmlEventType.START_ELEMENT, namespace, localName, this.getDepth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readXml() throws XmlException {
        this.require(XmlEventType.START_ELEMENT, null, null);
        StringWriter writer = new StringWriter();
        String value = null;
        XmlWriter xmlWriter = null;
        try {
            xmlWriter = new XmlWriter(writer, Charset.forName("UTF-16"));
            xmlWriter.node(this);
            value = ((Object)writer).toString();
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.close();
            }
        }
        return value;
    }

    public void require(XmlEventType type, String namespace, String localName) throws XmlValidationException {
        if (type != XmlEventType.NONE && type != this.eventType) {
            throw new XmlValidationException("Not on correct event type; expected " + type + " but was " + this.eventType, this, null);
        }
        if (namespace != null && this.getNamespace() != this.nameTable.get(namespace)) {
            throw new XmlValidationException("Invalid namespace: expected \"" + namespace + "\" but was: \"" + this.getNamespace() + '\"', this, null);
        }
        if (localName != null && this.getName() != this.nameTable.get(localName)) {
            throw new XmlValidationException("Invalid name: expected \"" + localName + "\" but was: \"" + this.getName() + '\"', this, null);
        }
    }

    private void checkAddLangContext() {
        String lang = this.parser.getAttributeValue("http://www.w3.org/XML/1998/namespace", LANG_ATTR);
        if (lang != null) {
            if (this.langs == null) {
                this.langs = new Stack();
            }
            this.langs.push(new XmlLangContext(this.parser.getDepth(), lang));
        }
    }

    private void checkRemoveLangContext() {
        XmlLangContext context;
        if (this.langs != null && !this.langs.isEmpty() && (context = (XmlLangContext)this.langs.peek()).getDepth() == this.getDepth()) {
            this.langs.pop();
            this.xmlLang = context.getLang();
        }
    }

    private void handleEvent() throws XmlException {
        this.setAttributes();
        switch (this.eventType.value()) {
            case 3: {
                this.checkAddLangContext();
                break;
            }
            case 4: {
                this.checkRemoveLangContext();
                break;
            }
        }
    }

    private void setAttributes() throws XmlException {
        if (this.eventType != XmlEventType.START_ELEMENT) {
            this.attNames = EMPTY_STRINGS;
            this.attValues = EMPTY_STRINGS;
            this.attPrefixes = EMPTY_STRINGS;
            this.attNamespaces = EMPTY_STRINGS;
            return;
        }
        try {
            int i;
            int attrCount = this.parser.getAttributeCount();
            int nsStart = this.parser.getNamespaceCount(this.parser.getDepth() - 1);
            int nsEnd = this.parser.getNamespaceCount(this.parser.getDepth());
            int nsCount = nsEnd - nsStart;
            int count = attrCount + nsCount;
            this.attNames = new String[count];
            this.attValues = new String[count];
            this.attPrefixes = new String[count];
            this.attNamespaces = new String[count];
            for (i = 0; i < attrCount; ++i) {
                this.attNames[i] = this.nameTable.add(Strings.nullForEmpty(this.parser.getAttributeName(i)));
                this.attValues[i] = this.parser.getAttributeValue(i);
                this.attPrefixes[i] = this.parser.getAttributePrefix(i);
                this.attNamespaces[i] = this.nameTable.add(Strings.nullForEmpty(this.parser.getAttributeNamespace(i)));
            }
            for (i = attrCount; i < count; ++i) {
                int nsIndex = nsStart + i - attrCount;
                this.attNames[i] = this.parser.getNamespacePrefix(nsIndex);
                this.attValues[i] = this.parser.getNamespaceUri(nsIndex);
                this.attPrefixes[i] = "xmlns";
                this.attNamespaces[i] = "http://www.w3.org/2000/xmlns/";
            }
        }
        catch (XmlPullParserException e) {
            throw XmlException.createXmlException(e);
        }
    }

    private void setEventType(int event) throws XmlException {
        this.setEventType(XmlReader.getEventType(event));
    }

    private void setEventType(XmlEventType event) throws XmlException {
        XmlEventType e = event;
        if (e == XmlEventType.TEXT) {
            try {
                e = this.parser.isWhitespace() ? XmlEventType.WHITESPACE : e;
            }
            catch (XmlPullParserException xmlPullParserException) {
                // empty catch block
            }
        }
        this.eventType = e;
        this.handleEvent();
    }

    private static class XmlNameTable
    implements IXmlNameTable {
        private final Map map = new HashMap();

        XmlNameTable() {
        }

        public final String add(String text) {
            if (text == null) {
                return null;
            }
            String shared = this.map.put(text, text);
            if (shared != null) {
                this.map.put(text, shared);
            } else {
                shared = text;
            }
            return shared;
        }

        public final String get(String text) {
            if (text == null) {
                return null;
            }
            return (String)this.map.get(text);
        }
    }

    private static class XmlLangContext {
        private final int depth;
        private final String lang;

        public XmlLangContext(int depth, String lang) {
            this.depth = depth;
            this.lang = lang;
        }

        public final int getDepth() {
            return this.depth;
        }

        public final String getLang() {
            return this.lang;
        }
    }
}

