/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.internal.util;

import com.businessobjects.visualization.internal.util.Cmp;
import com.businessobjects.visualization.util.xml.IXmlNameTable;
import com.businessobjects.visualization.util.xml.XmlEventType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlReader;
import com.businessobjects.visualization.util.xml.XmlReaderState;
import com.businessobjects.visualization.util.xml.XmlUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

class BolocXppParser {
    BolocXppParser() {
    }

    public Map parse(Locale targetLocale, InputStream stream) throws IOException {
        if (targetLocale != null && stream != null) {
            try {
                String lcs;
                String[] locales;
                HashMap<String, String> map = new HashMap<String, String>();
                XmlReader reader = new XmlReader(stream);
                IXmlNameTable nameTable = reader.getNameTable();
                String datatype = nameTable.add("datatype");
                String file = nameTable.add("file");
                String grp = nameTable.add("grp");
                String p = nameTable.add("p");
                if (reader.readToEvent(XmlEventType.START_ELEMENT, null, datatype, 0) && (locales = this.parseLocales(lcs = reader.getAttributeValue("lcs"))).length > 0 && this.matchLocale(locales, targetLocale)) {
                    XmlEventType eventType = reader.getEventType();
                    while (eventType != XmlEventType.END_ELEMENT || file != reader.getName()) {
                        if (eventType == XmlEventType.START_ELEMENT && grp == reader.getName()) {
                            String id = XmlUtilities.getRequiredAttribute(reader, null, "id");
                            XmlReaderState state = new XmlReaderState(reader);
                            while (state.next()) {
                                String lc;
                                String name;
                                if (reader.getEventType() != XmlEventType.START_ELEMENT || !Cmp.equalsByReference(name = reader.getName(), p) || !this.matchLocale(lc = XmlUtilities.getRequiredAttribute(reader, null, "lc"), targetLocale)) continue;
                                reader.readStartElement(null, p);
                                String text = reader.getText();
                                map.put(id, text);
                            }
                        }
                        reader.next();
                        eventType = reader.getEventType();
                    }
                    return map;
                }
            }
            catch (XmlException xmlException) {
                // empty catch block
            }
        }
        return null;
    }

    private String[] parseLocales(String locales) {
        if (locales != null && locales.length() > 0) {
            StringTokenizer st = new StringTokenizer(locales, ";");
            ArrayList<String> list = new ArrayList<String>();
            while (st.hasMoreElements()) {
                list.add(st.nextToken());
            }
            return list.toArray(new String[0]);
        }
        return new String[0];
    }

    private boolean matchLocale(String[] locales, Locale targetLocale) {
        for (int i = 0; i < locales.length; ++i) {
            if (!this.matchLocale(locales[i], targetLocale)) continue;
            return true;
        }
        return false;
    }

    private boolean matchLocale(String locale, Locale targetLocale) {
        if (locale != null && targetLocale != null) {
            String locale1lang = this.getLanguage(locale);
            String locale1country = this.getCountry(locale);
            if (locale1lang != null && targetLocale.getLanguage().equals(locale1lang)) {
                if (locale1country != null) {
                    String locale2country = targetLocale.getCountry();
                    return locale2country == null || locale1country.equals(locale2country);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private String getLanguage(String locale) {
        if (locale != null && locale.length() > 0) {
            int ind = locale.indexOf(95);
            if (ind > 0) {
                return locale.substring(0, ind);
            }
            for (int i = 0; i < locale.length(); ++i) {
                if (!Character.isUpperCase(locale.charAt(i))) continue;
                return null;
            }
            return locale;
        }
        return null;
    }

    private String getCountry(String locale) {
        if (locale != null && locale.length() > 0) {
            int ind = locale.indexOf(95);
            if (ind > 0) {
                return locale.substring(ind + 1);
            }
            return null;
        }
        return null;
    }
}

