/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.graphic.IRegion;
import com.businessobjects.visualization.graphic.Region;
import com.businessobjects.visualization.graphic.RegionCoordinates;
import com.businessobjects.visualization.graphic.RegionDefType;
import com.businessobjects.visualization.map.GraphicMapElement;
import com.businessobjects.visualization.map.IGraphicMap;
import java.util.ArrayList;
import java.util.Iterator;

public final class VisuGraphicMap
implements IGraphicMap {
    private ArrayList regionList_ = new ArrayList();
    private int lastHit_;

    private IRegion computeRegion(int x, int y) {
        this.lastHit_ = -1;
        return this.getHotSpot(x, y);
    }

    private Region getHotSpot(int x, int y) {
        Region region;
        if (this.lastHit_ >= 0 && this.checkRegionCordinates((region = (Region)this.regionList_.get(this.lastHit_)).getRegionCoordinates(), x, y)) {
            return region;
        }
        for (int i = 0; i < this.regionList_.size(); ++i) {
            Region region2 = (Region)this.regionList_.get(i);
            if (!this.checkRegionCordinates(region2.getRegionCoordinates(), x, y)) continue;
            this.lastHit_ = i;
            return region2;
        }
        this.lastHit_ = -1;
        return null;
    }

    private boolean checkRegionCordinates(RegionCoordinates[] list, int x, int y) {
        boolean result = false;
        for (int i = 0; !result && i < list.length; ++i) {
            RegionCoordinates coordinates = list[i];
            result = this.inShape(coordinates.getCoordinates(), x, y);
        }
        return result;
    }

    private boolean inShape(int[] xy, int x, int y) {
        if (xy.length == 3) {
            return (x - xy[0]) * (x - xy[0]) + (y - xy[1]) * (y - xy[1]) <= xy[2] * xy[2];
        }
        if (xy.length == 5) {
            return (double)(x - xy[0]) * (double)(x - xy[0]) / (double)(xy[2] * xy[2]) + (double)(y - xy[1]) * (double)(y - xy[1]) / (double)(xy[3] * xy[3]) <= 1.0;
        }
        if (xy.length == 4) {
            return (x >= xy[0] && x <= xy[2] || x >= xy[2] && x <= xy[0]) && (y >= xy[1] && y <= xy[3] || y >= xy[3] && y <= xy[1]);
        }
        int k = xy.length - 2;
        boolean b = false;
        for (int j = 0; j < xy.length; j += 2) {
            if ((y >= xy[j + 1] && y < xy[k + 1] || y >= xy[k + 1] && y < xy[j + 1]) && (double)x < (double)(xy[j] - xy[k]) * (double)(y - xy[k + 1]) / (double)(xy[j + 1] - xy[k + 1]) + (double)xy[k]) {
                b = !b;
            }
            k = j;
        }
        return b;
    }

    public IRegion getRegion(int x, int y) {
        IRegion region = this.computeRegion(x, y);
        return region;
    }

    public GraphicMapElement[] getGraphicElements() {
        ArrayList list = this.getGraphicElementList();
        GraphicMapElement[] result = new GraphicMapElement[list.size()];
        list.toArray(result);
        return result;
    }

    private ArrayList getGraphicElementList() {
        ArrayList<GraphicMapElement> list = new ArrayList<GraphicMapElement>();
        Iterator iter = this.regionList_.iterator();
        while (iter.hasNext()) {
            Region reg = (Region)iter.next();
            if (reg.getRegionDef().getType() != RegionDefType.DYNAMIC) continue;
            GraphicMapElement gme = new GraphicMapElement(reg.getRegionCoordinates()[0], reg.getDataContext(), reg);
            list.add(gme);
        }
        return list;
    }

    public void addRegion(IRegion reg) {
        this.regionList_.add(reg);
    }

    public void addRegion(IRegion reg, int idx) {
        this.regionList_.add(idx, reg);
    }

    public IRegion[] getRegions() {
        ArrayList<Region> list = new ArrayList<Region>();
        Iterator iter = this.regionList_.iterator();
        while (iter.hasNext()) {
            Region reg = (Region)iter.next();
            if (reg.getRegionDef().getType() != RegionDefType.DYNAMIC) continue;
            list.add(reg);
        }
        IRegion[] result = new IRegion[list.size()];
        list.toArray(result);
        return result;
    }

    public Iterator iterator() {
        return this.regionList_.iterator();
    }

    public int size() {
        return this.regionList_.size();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GraphicMap[");
        buffer.append("elements_ = ");
        buffer.append("[");
        IRegion[] list = this.getRegions();
        int maxIndex = list.length - 1;
        for (int i = 0; i < list.length; ++i) {
            buffer.append(((Region)list[i]).toMapString());
            if (i == maxIndex) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        buffer.append("]");
        return buffer.toString();
    }
}

