/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.graphic.ColorZone;
import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuColor;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.internal.util.Strings;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VisuColorZones
extends VisuObject {
    private static final int[] PARAMSIZE = new int[]{3};
    private static VisuObjectType type = VisuObjectType.COLORZONES;
    public static final double MIN_POSSIBLE_VALUE = -1.7976931348623157E308;
    public static final double MAX_POSSIBLE_VALUE = Double.MAX_VALUE;
    public static final double MIN = -1.7976931348623157E308;
    public static final double MAX = Double.MAX_VALUE;
    private VisuBool percentage_;
    private double[] zones_;
    private VisuColor[] colors_;
    private transient double measureMinimalValue_ = -1.7976931348623157E308;
    private transient double measureMaximalValue_ = Double.MAX_VALUE;
    private transient double[] ticks_;
    private transient ColorZone[] colorZones_;

    public VisuColorZones(boolean percentage, double[] zones, VisuColor[] colors) {
        this.percentage_ = percentage ? VisuBool.TRUE : VisuBool.FALSE;
        this.zones_ = zones;
        this.colors_ = colors;
        this.checkZones();
    }

    public VisuColorZones(String xmlValue) {
        this.setXmlValue(xmlValue);
    }

    VisuColorZones(JSONObject jobj) {
        try {
            this.percentage_ = new VisuBool(jobj.getJSONObject("percentage"));
            JSONArray jaZones = jobj.getJSONArray("zones");
            this.zones_ = new double[jaZones.length()];
            for (int i = 0; i < jaZones.length(); ++i) {
                this.zones_[i] = jaZones.getDouble(i);
            }
            JSONArray jaColors = jobj.getJSONArray("colors");
            this.colors_ = new VisuColor[jaColors.length()];
            for (int i = 0; i < jaColors.length(); ++i) {
                this.colors_[i] = new VisuColor(jaColors.getJSONObject(i));
            }
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
        this.checkZones();
    }

    public void setMinMax(double min, double max) {
        if (this.measureMinimalValue_ != min || this.measureMaximalValue_ != max) {
            this.measureMinimalValue_ = min;
            this.measureMaximalValue_ = max;
            this.initZones();
        }
    }

    public double getMin() {
        return this.measureMinimalValue_;
    }

    public double getMax() {
        return this.measureMaximalValue_;
    }

    public String toString() {
        StringBuffer objStringBuffer = new StringBuffer();
        for (int i = 0; i < this.zones_.length; ++i) {
            if (this.zones_[i] == -1.7976931348623157E308) {
                objStringBuffer.append("Min ");
                continue;
            }
            if (this.zones_[i] == Double.MAX_VALUE) {
                objStringBuffer.append("Max ");
                continue;
            }
            objStringBuffer.append(this.zones_[i]).append(" ");
        }
        return objStringBuffer.toString();
    }

    public VisuObjectType getType() {
        return type;
    }

    public VisuColor getColor(double value, VisuColor otherColor) {
        if (this.colorZones_ == null || this.colorZones_.length == 0) {
            this.initZones();
        }
        return VisuColorZones.getColor(value, this.colorZones_, this.ticks_, otherColor);
    }

    public static VisuColor getColor(double value, ColorZone[] colorZones, double[] ticks, VisuColor otherColor) {
        int iRangeCount = colorZones.length;
        for (int iRangeIndex = 0; iRangeIndex < iRangeCount; ++iRangeIndex) {
            if (!ColorZone.isInRange(value, ticks[iRangeIndex], ticks[iRangeIndex + 1], iRangeIndex + 1 == iRangeCount)) continue;
            if (ticks[iRangeIndex] == ticks[iRangeIndex + 1]) {
                return colorZones[iRangeIndex].getMinColor();
            }
            return new VisuColor(colorZones[iRangeIndex].getColor(ColorZone.getProportion(value, ticks[iRangeIndex], ticks[iRangeIndex + 1])));
        }
        return otherColor;
    }

    public int getRangeCount() {
        if (this.colorZones_ == null || this.colorZones_.length == 0) {
            this.initZones();
        }
        return this.colorZones_.length;
    }

    public VisuColor getColorForRange(int iRangeIndex) {
        if (this.colorZones_ == null || this.colorZones_.length == 0) {
            this.initZones();
        }
        if (iRangeIndex < 0 || iRangeIndex >= this.colorZones_.length) {
            throw new IllegalArgumentException(Strings.concatenate(new String[]{"VisuColorZones::getColorForRange(iRangeIndex) iRangeIndex was ", String.valueOf(iRangeIndex), ", it should be in [0, ", String.valueOf(this.colorZones_.length), "]."}));
        }
        return this.colorZones_[iRangeIndex].getColor();
    }

    public ColorZone[] getColorZones() {
        if (this.colorZones_ == null || this.colorZones_.length == 0) {
            this.initZones();
        }
        return this.colorZones_;
    }

    public double[] getTicks() {
        if (this.colorZones_ == null || this.colorZones_.length == 0) {
            this.initZones();
        }
        return this.ticks_;
    }

    public boolean isPercentage() {
        return this.percentage_.booleanValue();
    }

    public boolean equals(Object obj) {
        boolean result = true;
        if (obj instanceof VisuColorZones) {
            int i;
            VisuColorZones vcz = (VisuColorZones)obj;
            if (vcz.colors_.length != this.colors_.length || !vcz.percentage_.equals(this.percentage_) || vcz.zones_.length != this.zones_.length) {
                return false;
            }
            for (i = 0; i < this.zones_.length; ++i) {
                if (this.zones_[i] == vcz.zones_[i]) continue;
                result = false;
                break;
            }
            for (i = 0; i < this.colors_.length; ++i) {
                if (this.colors_[i].equals(vcz.colors_[i])) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected void setXmlValue(String xmlValue) {
        this.setXmlValue(VisuColorZones.stringToArray(xmlValue));
    }

    protected String getXmlValue() {
        int i;
        StringBuffer xmlValue = new StringBuffer();
        xmlValue.append("[");
        xmlValue.append(this.percentage_.getXmlValue());
        xmlValue.append("]");
        xmlValue.append(";");
        xmlValue.append("[");
        int maxIndex = this.zones_.length - 1;
        for (i = 0; i < this.zones_.length; ++i) {
            xmlValue.append(String.valueOf(this.zones_[i]));
            if (i == maxIndex) continue;
            xmlValue.append(";");
        }
        xmlValue.append("]");
        xmlValue.append(";");
        xmlValue.append("[");
        maxIndex = this.colors_.length - 1;
        for (i = 0; i < this.colors_.length; ++i) {
            xmlValue.append("[");
            xmlValue.append(this.colors_[i].getXmlValue());
            xmlValue.append("]");
            if (i == maxIndex) continue;
            xmlValue.append(";");
        }
        xmlValue.append("]");
        return xmlValue.toString();
    }

    protected Object clone() {
        VisuColorZones vcz = (VisuColorZones)super.clone();
        vcz.percentage_ = (VisuBool)this.percentage_.clone();
        for (int i = 0; i < this.colors_.length; ++i) {
            vcz.colors_[i] = (VisuColor)this.colors_[i].clone();
        }
        return vcz;
    }

    protected JSONObject getJSONObject() {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("type", new Integer(type.value()));
            jsonObj.put("percentage", this.percentage_.getJSONObject());
            JSONArray jaZones = new JSONArray();
            for (int i = 0; i < this.zones_.length; ++i) {
                jaZones.put(this.zones_[i]);
            }
            jsonObj.put("zones", jaZones);
            JSONArray jaColors = new JSONArray();
            for (int i = 0; i < this.colors_.length; ++i) {
                jaColors.put(this.colors_[i].getJSONObject());
            }
            jsonObj.put("colors", jaColors);
            return jsonObj;
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    private void setXmlValue(String[] values) {
        this.checkParams(values, PARAMSIZE);
        this.percentage_ = new VisuBool(values[0]);
        String[] zoneList = VisuObject.stringToArray(values[1]);
        this.zones_ = new double[zoneList.length];
        for (int i = 0; i < zoneList.length; ++i) {
            this.zones_[i] = Double.parseDouble(zoneList[i]);
        }
        String[] colorList = VisuObject.stringToArray(values[2]);
        this.colors_ = new VisuColor[colorList.length];
        for (int i = 0; i < colorList.length; ++i) {
            this.colors_[i] = new VisuColor(colorList[i]);
        }
        this.checkZones();
    }

    private void checkZones() {
        if (this.zones_ == null || this.zones_.length < 2) {
            throw new VisualizationInternalException("2 values minimum to define zones");
        }
        if (this.colors_ == null || this.colors_.length < 1) {
            throw new VisualizationInternalException("1 color minimum");
        }
        for (int i = 0; i < this.zones_.length; ++i) {
            if (this.percentage_.equals(VisuBool.TRUE) && (this.zones_[i] < 0.0 || this.zones_[i] > 100.0)) {
                throw new VisualizationInternalException("Values must be defined between 0 and 100)");
            }
            if (i <= 0 || !(this.zones_[i] <= this.zones_[i - 1])) continue;
            throw new VisualizationInternalException("Values must be consecutive and different");
        }
    }

    private void initZones() {
        int iTickIndex;
        double[] adTicks = new double[this.zones_.length];
        ColorZone[] aobjColorZones = new ColorZone[this.zones_.length];
        int iTickCount = 0;
        int iColorCount = 0;
        for (iTickIndex = 0; iTickIndex < this.zones_.length - 1; ++iTickIndex) {
            if (this.zones_[0] == -1.7976931348623157E308 && this.measureMinimalValue_ > this.zones_[iTickIndex + 1] || this.zones_[this.zones_.length - 1] == Double.MAX_VALUE && this.measureMaximalValue_ < this.zones_[iTickIndex]) continue;
            aobjColorZones[iColorCount++] = new ColorZone(this.colors_[iTickIndex % this.colors_.length]);
            if (iTickCount == 0) {
                adTicks[iTickCount++] = this.zones_[0] == -1.7976931348623157E308 && this.measureMinimalValue_ > this.zones_[iTickIndex] && this.measureMinimalValue_ < this.zones_[iTickIndex + 1] ? this.measureMinimalValue_ : this.zones_[iTickIndex];
            }
            adTicks[iTickCount++] = this.zones_[this.zones_.length - 1] == Double.MAX_VALUE && this.measureMaximalValue_ > this.zones_[iTickIndex] && this.measureMaximalValue_ < this.zones_[iTickIndex + 1] ? this.measureMaximalValue_ : this.zones_[iTickIndex + 1];
        }
        this.ticks_ = new double[iTickCount];
        for (iTickIndex = 0; iTickIndex < iTickCount; ++iTickIndex) {
            this.ticks_[iTickIndex] = adTicks[iTickIndex];
        }
        this.colorZones_ = new ColorZone[iColorCount];
        for (int iColorIndex = 0; iColorIndex < iColorCount; ++iColorIndex) {
            this.colorZones_[iColorIndex] = aobjColorZones[iColorIndex];
            this.colorZones_[iColorIndex].trace();
        }
    }
}

