/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.graphic.Graphic;
import com.businessobjects.visualization.graphic.GraphicDefNode;
import com.businessobjects.visualization.graphic.IGraphicDefNode;
import com.businessobjects.visualization.graphic.IGraphicNode;
import com.businessobjects.visualization.graphic.IProperty;
import com.businessobjects.visualization.graphic.IRegion;
import com.businessobjects.visualization.graphic.Property;
import com.businessobjects.visualization.graphic.PropertyDef;
import com.businessobjects.visualization.graphic.PropertyDefVisibilityType;
import com.businessobjects.visualization.graphic.Region;
import com.businessobjects.visualization.graphic.RegionDef;
import com.businessobjects.visualization.graphic.VisuObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class RegionPropertyBase
implements IGraphicNode {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$graphic$RegionPropertyBase == null ? (class$com$businessobjects$visualization$graphic$RegionPropertyBase = RegionPropertyBase.class$("com.businessobjects.visualization.graphic.RegionPropertyBase")) : class$com$businessobjects$visualization$graphic$RegionPropertyBase));
    private GraphicDefNode defNode_;
    private int index_ = -1;
    private IGraphicNode parent_;
    private VisuObject value_;
    private Graphic graphic_;
    private HashMap regionPropertyMap_;
    private String id_;
    private HashMap hm_ = new HashMap();
    static /* synthetic */ Class class$com$businessobjects$visualization$graphic$RegionPropertyBase;

    RegionPropertyBase(Graphic graphic, IGraphicNode parent, GraphicDefNode defNode, int index) {
        this.defNode_ = defNode;
        this.index_ = index;
        this.parent_ = parent;
        this.graphic_ = graphic;
        this.id_ = this.parent_.getDef().getNodeType() == this.defNode_.getNodeType() ? this.parent_.getId() + "/" + this.getBasicId() : this.getBasicId();
    }

    protected void initChildrenMap(RegionDef[] regionChildren, PropertyDef[] propChildren) {
        this.regionPropertyMap_ = regionChildren != null && regionChildren.length != 0 || propChildren != null && propChildren.length != 0 ? new HashMap() : null;
    }

    public final String toString() {
        return this.getId();
    }

    public IGraphicNode[] getChildren() {
        if (this.regionPropertyMap_ == null) {
            return new IGraphicNode[0];
        }
        IGraphicNode[] result = new IGraphicNode[this.regionPropertyMap_.values().size()];
        return this.regionPropertyMap_.values().toArray(result);
    }

    final ArrayList getChildren(IGraphicDefNode.GraphicDefNodeType type) {
        ArrayList<RegionPropertyBase> result = new ArrayList<RegionPropertyBase>();
        if (this.regionPropertyMap_ == null) {
            return result;
        }
        Iterator iter = this.regionPropertyMap_.values().iterator();
        while (iter.hasNext()) {
            RegionPropertyBase rpb = (RegionPropertyBase)iter.next();
            if (type != null && rpb.getDef().getNodeType() != type) continue;
            result.add(rpb);
        }
        return result;
    }

    ArrayList getChildrenWithDef(GraphicDefNode defNode) {
        ArrayList<RegionPropertyBase> result = new ArrayList<RegionPropertyBase>();
        if (this.regionPropertyMap_ == null) {
            return null;
        }
        Iterator iter = this.regionPropertyMap_.values().iterator();
        while (iter.hasNext()) {
            RegionPropertyBase rpb = (RegionPropertyBase)iter.next();
            if (rpb.getDef() != defNode) continue;
            result.add(rpb);
        }
        return result;
    }

    final ArrayList getChildren(IGraphicDefNode.GraphicDefNodeType type, boolean dynamic) {
        ArrayList<RegionPropertyBase> result = new ArrayList<RegionPropertyBase>();
        if (this.regionPropertyMap_ == null) {
            return null;
        }
        Iterator iter = this.regionPropertyMap_.values().iterator();
        while (iter.hasNext()) {
            RegionPropertyBase rpb = (RegionPropertyBase)iter.next();
            if (type != null && rpb.getDef().getNodeType() != type || dynamic != rpb.isDynamic()) continue;
            result.add(rpb);
        }
        return result;
    }

    RegionPropertyBase getNode(String defNodeId, int index, IGraphicDefNode.GraphicDefNodeType type) {
        RegionPropertyBase result = this.searchNode(defNodeId, index, type, this.regionPropertyMap_);
        if (result == null) {
            LOGGER.debug((Object)("Property:" + defNodeId + " index:" + index + "not exist in :" + this.getId()));
        }
        return result;
    }

    RegionPropertyBase getChild(GraphicDefNode defNode, int index) {
        if (this.regionPropertyMap_ == null) {
            return null;
        }
        RegionPropertyBase result = null;
        Iterator iter = this.regionPropertyMap_.values().iterator();
        while (iter.hasNext()) {
            RegionPropertyBase rpb = (RegionPropertyBase)iter.next();
            if (rpb.getDef() != defNode || rpb.getIndex() != index) continue;
            result = rpb;
            break;
        }
        return result;
    }

    final ArrayList getAllChildren(IGraphicDefNode.GraphicDefNodeType type) {
        ArrayList result = new ArrayList();
        this.populatePropertyList(result, type);
        return result;
    }

    private void populatePropertyList(ArrayList list, IGraphicDefNode.GraphicDefNodeType type) {
        if (this.regionPropertyMap_ == null) {
            return;
        }
        Iterator iter = this.regionPropertyMap_.values().iterator();
        while (iter.hasNext()) {
            RegionPropertyBase rpb = (RegionPropertyBase)iter.next();
            if (rpb.getDef().getNodeType() != type) continue;
            list.add(rpb);
            rpb.populatePropertyList(list, type);
        }
    }

    final ArrayList getAllChildren(IGraphicDefNode.GraphicDefNodeType type, boolean dynamic) {
        ArrayList result = new ArrayList();
        this.populatePropertyList(result, type, dynamic);
        return result;
    }

    private void populatePropertyList(ArrayList list, IGraphicDefNode.GraphicDefNodeType type, boolean dynamic) {
        if (this.regionPropertyMap_ == null) {
            return;
        }
        Iterator iter = this.regionPropertyMap_.values().iterator();
        while (iter.hasNext()) {
            RegionPropertyBase rpb = (RegionPropertyBase)iter.next();
            if (type != null && rpb.getDef().getNodeType() != type || dynamic != rpb.isDynamic()) continue;
            list.add(rpb);
            rpb.populatePropertyList(list, type, dynamic);
        }
    }

    public IProperty[] getProperties() {
        if (this.regionPropertyMap_ == null) {
            return new IProperty[0];
        }
        ArrayList list = this.getChildren(IGraphicDefNode.GraphicDefNodeType.PROPERTY);
        IProperty[] result = new IProperty[list.size()];
        return list.toArray(result);
    }

    public IGraphicDefNode getDef() {
        return this.defNode_;
    }

    public final String getId() {
        return this.id_;
    }

    public String getName() {
        return this.defNode_.getName();
    }

    public IGraphicNode getParent() {
        return this.parent_;
    }

    public String getUid() {
        String result = this.parent_.getUid() + "/" + this.getBasicId();
        return result;
    }

    void setValue(VisuObject value) {
        this.value_ = value;
    }

    VisuObject getInternalValue() {
        return this.value_;
    }

    String getBasicId() {
        String result = this.defNode_.getBasicId();
        if (this.index_ >= 0) {
            result = result + "@" + this.index_;
        }
        return result;
    }

    public final IProperty getProperty(String id) {
        IProperty result = (IProperty)((Object)this.searchNode(id, IGraphicDefNode.GraphicDefNodeType.PROPERTY, this.regionPropertyMap_));
        if (result == null) {
            LOGGER.debug((Object)("Property:" + id + "not exist in :" + this.getId()));
        }
        return result;
    }

    final IRegion getInternalRegion(String id) {
        Region result = (Region)this.searchNode(id, IGraphicDefNode.GraphicDefNodeType.REGION, this.regionPropertyMap_);
        if (result == null) {
            LOGGER.debug((Object)("Region:" + id + "not exist in :" + this.getId()));
        }
        return result;
    }

    public final IRegion getRegion(String id) {
        Region result = (Region)this.searchNode(id, IGraphicDefNode.GraphicDefNodeType.REGION, this.regionPropertyMap_);
        if (result == null) {
            LOGGER.debug((Object)("Region:" + id + "not exist in :" + this.getId()));
        }
        return result;
    }

    final RegionPropertyBase getChild(IGraphicDefNode.GraphicDefNodeType type, String defId, int index) {
        RegionPropertyBase result = (RegionPropertyBase)this.hm_.get(type.toString() + "|" + defId + "|" + index);
        return result;
    }

    private RegionPropertyBase searchNode(String key, IGraphicDefNode.GraphicDefNodeType type, HashMap map) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (map == null) {
            return null;
        }
        RegionPropertyBase result = (RegionPropertyBase)map.get(key);
        if (result != null) {
            return result;
        }
        Iterator iter = map.values().iterator();
        while (iter.hasNext() && result == null) {
            RegionPropertyBase rpb = (RegionPropertyBase)iter.next();
            if (rpb.getDef().getNodeType() != type) continue;
            if (key.equals(rpb.getId())) {
                result = rpb;
                break;
            }
            if (!key.startsWith(rpb.getId())) continue;
            result = this.searchNode(key, type, rpb.regionPropertyMap_);
        }
        return result;
    }

    private RegionPropertyBase searchNode(String defId, int index, IGraphicDefNode.GraphicDefNodeType type, HashMap map) {
        if (map == null) {
            return null;
        }
        if (defId == null) {
            throw new IllegalArgumentException("def is null");
        }
        if (index < -1) {
            throw new IllegalArgumentException("index >= -1");
        }
        RegionPropertyBase result = null;
        Iterator iter = map.values().iterator();
        while (iter.hasNext() && result == null) {
            RegionPropertyBase rpb = (RegionPropertyBase)iter.next();
            if (rpb.getDef().getNodeType() != type) continue;
            if (defId.equals(rpb.defNode_.getId()) && index == rpb.index_) {
                result = rpb;
                break;
            }
            if (!defId.startsWith(rpb.defNode_.getId())) continue;
            result = this.searchNode(defId, index, type, rpb.regionPropertyMap_);
        }
        return result;
    }

    public final int getIndex() {
        return this.index_;
    }

    final Graphic getGraphic() {
        return this.graphic_;
    }

    public abstract void notifyPropertyChange(Region var1, PropertyDef var2, VisuObject var3);

    public boolean isDynamic() {
        boolean result = false;
        if (this.index_ >= 0) {
            result = true;
        } else if (this.parent_.getDef().getNodeType() == this.getDef().getNodeType() && ((RegionPropertyBase)this.parent_).isDynamic()) {
            result = true;
        }
        return result;
    }

    Property addProperty(PropertyDef pdef, int index) {
        Property result = null;
        if (!this.defNode_.contains(pdef)) {
            throw new IllegalArgumentException("Invalid property definition to add property : " + pdef);
        }
        if (index < -1) {
            throw new IllegalArgumentException("index should be >= -1");
        }
        result = (Property)this.addChild(pdef, index);
        return result;
    }

    final RegionPropertyBase addChild(GraphicDefNode node, int index) {
        RegionPropertyBase result = null;
        if (node.getNodeType() == IGraphicDefNode.GraphicDefNodeType.PROPERTY) {
            PropertyDef nodeDef = (PropertyDef)node;
            if (nodeDef.getVisibility() != PropertyDefVisibilityType.NOTAVAILABLE) {
                result = new Property(this, nodeDef, index, this.graphic_);
            }
        } else {
            result = new Region(this, (RegionDef)node, index, this.graphic_);
        }
        if (result != null) {
            this.regionPropertyMap_.put(result.getId(), result);
            this.hm_.put(result.getKey(), result);
        }
        return result;
    }

    final void removeElement(GraphicDefNode defNode, int index) {
        RegionPropertyBase property = this.getChild(defNode, index);
        if (property != null && this.regionPropertyMap_ != null) {
            this.regionPropertyMap_.remove(property.getId());
            this.hm_.remove(property.getKey());
        }
    }

    final void removeAllElements() {
        this.hm_.clear();
        if (this.regionPropertyMap_ == null) {
            return;
        }
        this.regionPropertyMap_.clear();
    }

    final String getKey() {
        return this.getDef().getNodeType().toString() + "|" + this.defNode_.getId() + "|" + this.index_;
    }

    public abstract void restoreDefaultSettings();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

