/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.VisuVersion;
import com.businessobjects.visualization.dataexchange.DataContext;
import com.businessobjects.visualization.dataexchange.data.InvalidDataTypeException;
import com.businessobjects.visualization.graphic.Graphic;
import com.businessobjects.visualization.graphic.GraphicDef;
import com.businessobjects.visualization.graphic.IGraphicDefNode;
import com.businessobjects.visualization.graphic.IGraphicNode;
import com.businessobjects.visualization.graphic.IProperty;
import com.businessobjects.visualization.graphic.IRegion;
import com.businessobjects.visualization.graphic.Property;
import com.businessobjects.visualization.graphic.PropertyDef;
import com.businessobjects.visualization.graphic.PropertyDefVisibilityType;
import com.businessobjects.visualization.graphic.PropertyTree;
import com.businessobjects.visualization.graphic.RegionActionType;
import com.businessobjects.visualization.graphic.RegionCoordinates;
import com.businessobjects.visualization.graphic.RegionDef;
import com.businessobjects.visualization.graphic.RegionDefType;
import com.businessobjects.visualization.graphic.RegionDefVisiblity;
import com.businessobjects.visualization.graphic.RegionPropertyBase;
import com.businessobjects.visualization.graphic.RegionTree;
import com.businessobjects.visualization.graphic.SettingsTree;
import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuSerializationMode;
import com.businessobjects.visualization.graphic.VisuString;
import com.businessobjects.visualization.graphic.VisuTemplate;
import com.businessobjects.visualization.graphic.VisuTemplateType;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLGraphic;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLProperty;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLRegion;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlReader;
import com.businessobjects.visualization.util.xml.XmlWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class Region
extends RegionPropertyBase
implements IRegion,
IXMLDelegator {
    private RegionActionType action_;
    private boolean excludeFromTemplate_;
    private ArrayList listExcludeFromTemplate_;
    private RegionCoordinates[] regionCoordinates_;
    private Region actionRegionDelegate_;
    private DataContext dataContext_;
    private String uidAlert_;
    private String name_;

    Region(IGraphicNode parent, RegionDef rd, Graphic graphic) {
        super(graphic, parent, rd, -1);
        this.initChildrenMap(rd.getRegions(), rd.getProperties());
        this.setVisibility(rd.getVisibility());
        this.initRegion(rd.getRegions());
        this.initProperties(rd.getProperties());
        this.name_ = this.getDef().getName();
    }

    Region(Graphic parent, RegionDef rd) {
        super(parent, parent, rd, -1);
        this.initChildrenMap(rd.getRegions(), rd.getProperties());
        this.setVisibility(rd.getVisibility());
        this.initRegion(rd.getRegions());
        this.initProperties(rd.getProperties());
        this.name_ = this.getDef().getName();
    }

    Region(IGraphicNode parent, RegionDef rd, int index, Graphic graphic) {
        super(graphic, parent, rd, index);
        this.initChildrenMap(rd.getRegions(), rd.getProperties());
        this.setVisibility(rd.getVisibility());
        this.initRegion(rd.getRegions());
        this.initProperties(rd.getProperties());
        this.name_ = this.getDef().getName();
    }

    public void restoreDefaultSettings() {
        this.setVisibility(this.getRegionDef().getVisibility());
        ArrayList childs = this.getChildren(null);
        Iterator iter = childs.iterator();
        while (iter.hasNext()) {
            RegionPropertyBase base = (RegionPropertyBase)iter.next();
            base.restoreDefaultSettings();
        }
    }

    public RegionDef getRegionDef() {
        return (RegionDef)this.getDef();
    }

    public VisuBool getValue() {
        return (VisuBool)super.getInternalValue();
    }

    public boolean setValue(VisuBool value) {
        boolean result = false;
        if (this.getRegionDef().getType() == RegionDefType.STATIC) {
            if (this.getRegionDef().getVisibility() == RegionDefVisiblity.MANDATORY) {
                super.setValue(VisuBool.TRUE);
            } else if (this.getRegionDef().getVisibility() == RegionDefVisiblity.ENABLE) {
                super.setValue(value);
                result = true;
            } else if (this.getRegionDef().getVisibility() == RegionDefVisiblity.DISABLE) {
                super.setValue(value);
                result = true;
            } else if (this.getRegionDef().getVisibility() == RegionDefVisiblity.NOTAVAILABLE) {
                super.setValue(VisuBool.FALSE);
            }
        }
        return result;
    }

    void setVisibility(RegionDefVisiblity rdv) {
        if (rdv == RegionDefVisiblity.DISABLE || rdv == RegionDefVisiblity.NOTAVAILABLE) {
            super.setValue(VisuBool.FALSE);
        } else {
            super.setValue(VisuBool.TRUE);
        }
    }

    public void excludeFromTemplate(String propId, boolean exclude) {
        PropertyDef pdef = this.getRegionDef().getProperty(propId);
        if (pdef == null) {
            throw new VisualizationRuntimeException("VIZ_00101_ERR_UNEXPECTED_PROPERTY_", new Object[]{propId});
        }
        if (exclude) {
            if (this.listExcludeFromTemplate_ == null) {
                this.listExcludeFromTemplate_ = new ArrayList();
            }
            if (!this.listExcludeFromTemplate_.contains(propId)) {
                this.listExcludeFromTemplate_.add(propId);
            }
        } else if (this.listExcludeFromTemplate_ != null && this.listExcludeFromTemplate_.contains(propId)) {
            this.listExcludeFromTemplate_.remove(propId);
        }
    }

    public void excludeFromTemplate(boolean exclude) {
        this.excludeFromTemplate_ = exclude;
    }

    public boolean isExcludeFromTemplate() {
        return this.excludeFromTemplate_;
    }

    public void setPropertyValue(String propId, String value) {
        this.setPropertyValue(propId, (VisuObject)new VisuString(value));
    }

    public void setPropertyValue(PropertyDef prop, String value) {
        if (prop == null) {
            throw new InvalidDataTypeException("VIZ_00035_ERR_PROPERTYDEF__IS_NULL");
        }
        this.setPropertyValue(prop.getId(), value);
    }

    public final void setPropertyValue(PropertyDef prop, VisuObject value) {
        if (prop == null) {
            throw new InvalidDataTypeException("VIZ_00035_ERR_PROPERTYDEF__IS_NULL");
        }
        this.setPropertyValue(prop.getId(), value);
    }

    private void initRegion(RegionDef[] regs) {
        if (regs != null) {
            for (int i = 0; i < regs.length; ++i) {
                if (regs[i].getType() != RegionDefType.STATIC || regs[i].getVisibility() == RegionDefVisiblity.NOTAVAILABLE) continue;
                this.addRegion(regs[i], -1);
            }
        }
    }

    private void initProperties(PropertyDef[] props) {
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                this.addProperty(props[i], -1);
            }
        }
    }

    public String getName() {
        return this.name_;
    }

    public DataContext getDataContext() {
        return this.dataContext_;
    }

    public DataContext getDataFilters() {
        return this.getDataContext();
    }

    public Object getUidAlert() {
        return this.uidAlert_;
    }

    public Object getXMLDelegate() {
        return this.getXMLDelegate(VisuSerializationMode.SERIALIZATION);
    }

    public XMLRegion getXMLDelegate(VisuSerializationMode mode) {
        XMLRegion xr = new XMLRegion();
        xr.m_a_Id = this.getDef().getId();
        xr.m_a_Visibility = mode == VisuSerializationMode.TEMPLATE && this.excludeFromTemplate_ ? -1 : (this.getValue().equals(VisuBool.TRUE) ? 1 : 0);
        xr.m_a_Type = this.getRegionDef().getType().value();
        xr.m_a_Index = this.getIndex();
        Iterator iter = null;
        iter = mode == VisuSerializationMode.TEMPLATE ? this.getChildren(IGraphicDefNode.GraphicDefNodeType.REGION, false).iterator() : this.getChildren(IGraphicDefNode.GraphicDefNodeType.REGION).iterator();
        while (iter.hasNext()) {
            Region region = (Region)iter.next();
            xr.m_list_Region.add(region.getXMLDelegate(mode));
        }
        iter = this.getChildren(IGraphicDefNode.GraphicDefNodeType.PROPERTY).iterator();
        ArrayList propertiesList = new ArrayList();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            property.getXMLDelegateEX(propertiesList);
        }
        for (int i = 0; i < propertiesList.size(); ++i) {
            XMLProperty property = (XMLProperty)propertiesList.get(i);
            boolean exclude = false;
            if (this.listExcludeFromTemplate_ != null) {
                exclude = this.listExcludeFromTemplate_.contains(property.m_a_Id);
            }
            if (mode == VisuSerializationMode.TEMPLATE && exclude) continue;
            xr.m_list_Property.add(property);
        }
        return xr;
    }

    void init(XMLRegion xr, VisuSerializationMode mode, VisuVersion serializedVersion) {
        if (xr.m_a_Visibility == 0) {
            super.setValue(VisuBool.FALSE);
        } else if (xr.m_a_Visibility == 1) {
            super.setValue(VisuBool.TRUE);
        }
        Iterator iter1 = xr.m_list_Property.iterator();
        this.initPropertyList(xr, iter1, mode, serializedVersion);
        Iterator iter2 = xr.m_list_Region.iterator();
        this.initRegionList(iter2, mode, serializedVersion);
    }

    private void initPropertyList(XMLRegion xr, Iterator iter, VisuSerializationMode mode, VisuVersion serializedVersion) {
        while (iter.hasNext()) {
            XMLProperty xp = (XMLProperty)iter.next();
            String currentId = this.getGraphic().getVisuVersionManager().getCurrentPropertyId(serializedVersion.getXmlVersion(), this.getRegionDef().getRootParent().getUid(), xr.m_a_Id, xp.m_a_Id);
            Property property = (Property)this.getNode(currentId, xp.m_a_Index, IGraphicDefNode.GraphicDefNodeType.PROPERTY);
            if (property != null) {
                boolean exclude = false;
                if (mode == VisuSerializationMode.TEMPLATE && exclude) continue;
                property.init(xp, mode, serializedVersion);
                continue;
            }
            if (mode != VisuSerializationMode.FULLCHECK) {
                this.initPropertyList(xr, xp.m_list_Property.iterator(), mode, serializedVersion);
                continue;
            }
            if (mode != VisuSerializationMode.FULLCHECK) continue;
            throw new VisualizationRuntimeException("VIZ_00105_ERR_UNEXPECTED_PROPERTY_", new Object[]{currentId, this.getId()});
        }
    }

    private void initRegionList(Iterator iter, VisuSerializationMode mode, VisuVersion serializedVersion) {
        while (iter.hasNext()) {
            RegionDef rdef;
            XMLRegion nestedXr = (XMLRegion)iter.next();
            String currentId = this.getGraphic().getVisuVersionManager().getCurrentRegionId(serializedVersion.getXmlVersion(), this.getDef().getRootParent().getUid(), nestedXr.m_a_Id);
            if (nestedXr.m_a_Type == 0) {
                Region reg = (Region)this.getNode(currentId, nestedXr.m_a_Index, IGraphicDefNode.GraphicDefNodeType.REGION);
                if (reg != null) {
                    reg.init(nestedXr, mode, serializedVersion);
                    continue;
                }
                this.initRegionList(nestedXr.m_list_Region.iterator(), mode, serializedVersion);
                continue;
            }
            if (nestedXr.m_a_Type != 1 || mode == VisuSerializationMode.TEMPLATE || (rdef = this.getRegionDef().getRegion(currentId)) == null) continue;
            Region reg = this.addRegion(rdef, nestedXr.m_a_Index);
            reg.init(nestedXr, mode, serializedVersion);
        }
    }

    public void dumpProperties() {
    }

    public Object[] setAction(RegionActionType action) {
        Object[] list = null;
        boolean bAvailable = this.getRegionDef().isActionAvailable(action);
        if (bAvailable) {
            this.action_ = action;
            if (action == RegionActionType.MOVE || action == RegionActionType.XMOVE) {
                list = new Object[]{this.getRegionCoordinates()};
            } else if (action == RegionActionType.EXPLODE) {
                list = new Object[]{this.getPropertyValue("explode")};
            }
        }
        return list;
    }

    public void doAction(Object[] values) {
        if (this.action_ != null) {
            if (this.action_ == RegionActionType.MOVE && !this.getDef().getId().equals("root/label")) {
                if (this.getRegionDef().getRootParent() instanceof GraphicDef) {
                    if (this.getId().equals("root/title")) {
                        if (this.getProperty("mode/x") != null) {
                            this.setPropertyValue("mode/x", (VisuObject)values[0]);
                        }
                        if (this.getProperty("mode/y") != null) {
                            this.setPropertyValue("mode/y", (VisuObject)values[1]);
                        }
                    } else {
                        if (this.getProperty("x") != null) {
                            this.setPropertyValue("x", (VisuObject)values[0]);
                        }
                        if (this.getProperty("y") != null) {
                            this.setPropertyValue("y", (VisuObject)values[1]);
                        }
                    }
                }
            } else if (!(this.action_ == RegionActionType.MOVE && this.getDef().getId().equals("root/label") || this.action_ != RegionActionType.EXPLODE || this.getProperty("explode") == null)) {
                this.setPropertyValue("explode", (VisuObject)values[0]);
            }
        } else if (this.actionRegionDelegate_ != null) {
            this.actionRegionDelegate_.doAction(values);
        }
        this.actionRegionDelegate_ = null;
        this.action_ = null;
    }

    public void saveAsTemplate(Writer writer) {
        try {
            VisuTemplate vt = this.saveAsTemplate("", "");
            XmlWriter xw = new XmlWriter(writer, Charset.forName("UTF-8"));
            vt.marshall(xw);
        }
        catch (XmlException xe) {
            throw new VisualizationInternalException(xe);
        }
    }

    public void initFromTemplate(Reader reader) {
        try {
            XmlReader xr = new XmlReader(reader);
            VisuTemplate vt = new VisuTemplate();
            vt.unmarshall(xr);
            this.initFromTemplate(vt);
        }
        catch (XmlException xe) {
            throw new VisualizationInternalException(xe);
        }
    }

    public VisuTemplate saveAsTemplate(String id, String name) {
        XMLGraphic xg = new XMLGraphic();
        XMLRegion xr = new XMLRegion();
        xr = this.getXMLDelegate(VisuSerializationMode.TEMPLATE);
        xg.m_list_Region.add(xr);
        VisuTemplate vt = new VisuTemplate(id, name, this.getGraphic().getVisuVersionManager().getCurrentVersion(), VisuTemplateType.REGION, xg);
        return vt;
    }

    public void initFromTemplate(VisuTemplate visuTemplate) {
        if (visuTemplate == null) {
            throw new VisualizationRuntimeException("VIZ_00034_ERR_TEMPLATE_IS_NULL");
        }
        if (visuTemplate.getType() != VisuTemplateType.REGION) {
            throw new VisualizationRuntimeException("VIZ_00092_ERR_INVALID_TEMPLATE_TYP", new Object[]{visuTemplate.getType()});
        }
        if (visuTemplate.getXmlGraphic() == null || visuTemplate.getXmlGraphic().m_list_Region == null || visuTemplate.getXmlGraphic().m_list_Region.size() != 1) {
            throw new VisualizationRuntimeException("VIZ_00039_ERR_INVALID_VISUTEMPLATE");
        }
        XMLRegion xr = (XMLRegion)visuTemplate.getXmlGraphic().m_list_Region.get(0);
        this.init(xr, VisuSerializationMode.TEMPLATE, visuTemplate.getVersion());
    }

    public void setRegionCoordinates(RegionCoordinates rc) {
        this.regionCoordinates_ = new RegionCoordinates[]{rc};
    }

    public void setRegionCoordinates(RegionCoordinates[] rcs) {
        this.regionCoordinates_ = rcs;
    }

    public void setDataContext(DataContext dc) {
        this.dataContext_ = dc;
    }

    public RegionCoordinates getCoord() {
        RegionCoordinates result = null;
        if (this.regionCoordinates_ != null && this.regionCoordinates_.length > 0) {
            result = this.regionCoordinates_[0];
        }
        return result;
    }

    public RegionCoordinates[] getRegionCoordinates() {
        return this.regionCoordinates_;
    }

    public void notifyPropertyChange(Region region, PropertyDef pdef, VisuObject vo) {
        Region reg = region;
        if (reg == null) {
            reg = this;
        }
        this.getParent().notifyPropertyChange(reg, pdef, vo);
    }

    public SettingsTree getTree(PropertyDefVisibilityType visibility) {
        RegionTree tree = new RegionTree(this, null, visibility);
        return tree;
    }

    PropertyTree getPropertyTree(PropertyDef definition, SettingsTree parent, PropertyDefVisibilityType visibility) {
        PropertyTree tree = null;
        if (this.isPropertyDefValid(definition) && (definition.getVisibility() == visibility || definition.containsChildWithVisibility(visibility))) {
            Property prop = (Property)this.getProperty(definition.getId());
            tree = new PropertyTree(prop, parent, visibility);
        }
        return tree;
    }

    private boolean isPropertyDefValid(PropertyDef pdef) {
        boolean result = false;
        if (pdef != null && pdef.getRootParent() == this.getRegionDef() && pdef == this.getRegionDef().getProperty(pdef.getId())) {
            result = true;
        }
        return result;
    }

    public String toMapString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GMElem[");
        buffer.append(" filters_ = ").append(this.dataContext_);
        for (int i = 0; this.regionCoordinates_ != null && i < this.regionCoordinates_.length; ++i) {
            buffer.append(" rCoord_ = ").append(this.regionCoordinates_[i]);
            if (i >= this.regionCoordinates_.length - 1) continue;
            buffer.append(System.getProperty("line.separator"));
        }
        buffer.append("]" + System.getProperty("line.separator"));
        return buffer.toString();
    }

    public final VisuObject getPropertyValue(PropertyDef prop) {
        if (prop == null) {
            throw new InvalidDataTypeException("VIZ_00035_ERR_PROPERTYDEF__IS_NULL");
        }
        return this.getPropertyValue(prop.getId());
    }

    public VisuObject getPropertyValue(String propId) {
        IProperty property = this.getProperty(propId);
        if (property != null) {
            return property.getPropertyValue();
        }
        throw new VisualizationInternalException("Invalid Property Id :" + propId);
    }

    public boolean hasProperty(String propId) {
        return this.getProperty(propId) != null;
    }

    public void setPropertyValue(String propId, VisuObject value) {
        IProperty property = this.getProperty(propId);
        if (property == null) {
            throw new VisualizationInternalException("Invalid Property Id :" + propId);
        }
        property.setPropertyValue(value);
    }

    Region addRegion(RegionDef rd, int index) {
        Region result = null;
        if (!(this.getRegionDef().contains(rd) || rd == this.getRegionDef() && rd.isRecursive())) {
            throw new IllegalArgumentException("Invalid region definition to add region : " + rd);
        }
        if (index < 0 && rd.getType() == RegionDefType.DYNAMIC) {
            throw new IllegalArgumentException("index must be zero or positive for dynamic region");
        }
        if (index != -1 && rd.getType() == RegionDefType.STATIC) {
            throw new IllegalArgumentException("index must be -1 for static region");
        }
        result = (Region)this.addChild(rd, index);
        return result;
    }

    public final Region dynamicRegion(RegionDef rd, int index) {
        Region result = null;
        if (index < 0) {
            throw new IllegalArgumentException("index must be zero or positive");
        }
        if (rd.getType() != RegionDefType.DYNAMIC) {
            throw new IllegalArgumentException("region must be dynamic");
        }
        result = (Region)this.getChild(IGraphicDefNode.GraphicDefNodeType.REGION, rd.getId(), index);
        if (result == null) {
            result = this.addRegion(rd, index);
        }
        if (result == null) {
            throw new VisualizationInternalException("unable to add dynamic region id = " + rd + " index = " + index);
        }
        return result;
    }

    public final Region dynamicRegion(RegionDef rd, int index, String name, Hashtable props) {
        Region result = this.dynamicRegion(rd, index);
        if (name != null) {
            result.name_ = name;
        }
        if (props != null) {
            Enumeration myenum = props.keys();
            while (myenum.hasMoreElements()) {
                String key = (String)myenum.nextElement();
                VisuObject val = (VisuObject)props.get(key);
                Property prop = (Property)result.getProperty(key);
                if (prop == null) {
                    throw new VisualizationInternalException("Invalid property  :" + key + " for region " + rd.getId());
                }
                if (prop.getPropertyDef().getType() == val.getType()) {
                    prop.setValue(val);
                    continue;
                }
                throw new VisualizationInternalException("Invalid VisuObject : " + val.getType() + " for property :" + this.getId());
            }
        }
        return result;
    }

    public final IRegion[] getRegions() {
        ArrayList list = this.getChildren(IGraphicDefNode.GraphicDefNodeType.REGION);
        IRegion[] result = new IRegion[list.size()];
        return list.toArray(result);
    }
}

