/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.feed.definition;

import com.businessobjects.visualization.LocalizedEngine;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.common.DimensionType;
import com.businessobjects.visualization.feed.definition.DataContainerDef;
import com.businessobjects.visualization.feed.definition.DataContainerType;
import com.businessobjects.visualization.feed.definition.generated.XMLDataContainerDef;
import com.businessobjects.visualization.feed.definition.generated.XMLFeedDef;
import java.util.ArrayList;
import java.util.Iterator;

public class FeedDef
implements IXMLDelegator {
    private final transient FeedDef parent_;
    private final ArrayList dataContainerList_;
    private final ArrayList nestedFeedDefList_;
    private final String id_;
    private final String nameId_;
    private final String localizedName_;
    private final String descId_;
    private final String localizedDesc_;
    private final String designViewPlacementId_;
    private final int min_;
    private final int max_;
    public static final int UNBOUND = Integer.MAX_VALUE;

    public FeedDef(FeedDef parent, XMLFeedDef def, SerializationHelper sh, LocalizedEngine.Localizator loc) {
        Iterator iter;
        this.parent_ = parent;
        this.id_ = def.m_a_Id;
        this.nameId_ = def.m_a_Name;
        this.localizedName_ = loc != null ? loc.getValue(this.nameId_) : this.nameId_;
        this.descId_ = def.m_a_Description;
        this.localizedDesc_ = loc != null ? loc.getValue(this.descId_) : this.descId_;
        this.designViewPlacementId_ = def.m_a_DesignViewPlacementID;
        this.min_ = FeedDef.minFromXmlDouble(def.m_a_min);
        this.max_ = FeedDef.maxFromXmlDouble(def.m_a_max);
        if (def.m_list_DataContainerDef == null || def.m_list_DataContainerDef.isEmpty()) {
            this.dataContainerList_ = null;
        } else {
            this.dataContainerList_ = new ArrayList();
            iter = def.m_list_DataContainerDef.iterator();
            while (iter.hasNext()) {
                this.dataContainerList_.add(new DataContainerDef((XMLDataContainerDef)iter.next(), sh, loc));
            }
        }
        if (def.m_list_FeedDef == null || def.m_list_FeedDef.isEmpty()) {
            this.nestedFeedDefList_ = null;
        } else {
            this.nestedFeedDefList_ = new ArrayList();
            iter = def.m_list_FeedDef.iterator();
            while (iter.hasNext()) {
                this.nestedFeedDefList_.add(new FeedDef(this, (XMLFeedDef)iter.next(), sh, loc));
            }
        }
    }

    public Object getXMLDelegate() {
        Iterator iter;
        XMLFeedDef spec = new XMLFeedDef();
        spec.m_a_DesignViewPlacementID = this.designViewPlacementId_;
        spec.m_a_Id = this.id_;
        spec.m_a_Name = this.nameId_;
        spec.m_a_Description = this.descId_;
        spec.m_a_min = FeedDef.minFromInt(this.min_);
        spec.m_a_max = FeedDef.maxFromInt(this.max_);
        if (this.dataContainerList_ != null) {
            iter = this.dataContainerList_.iterator();
            while (iter.hasNext()) {
                spec.m_list_DataContainerDef.add((XMLDataContainerDef)((DataContainerDef)iter.next()).getXMLDelegate());
            }
        }
        if (this.nestedFeedDefList_ != null) {
            iter = this.nestedFeedDefList_.iterator();
            while (iter.hasNext()) {
                spec.m_list_FeedDef.add((XMLFeedDef)((FeedDef)iter.next()).getXMLDelegate());
            }
        }
        return spec;
    }

    public int getMin() {
        return this.min_;
    }

    public int getMax() {
        return this.max_;
    }

    public int getMax(DataContainerType dcTypeName) {
        if (this.dataContainerList_ == null) {
            return Integer.MAX_VALUE;
        }
        Iterator iter = this.dataContainerList_.iterator();
        while (iter.hasNext()) {
            DataContainerDef dcType = (DataContainerDef)iter.next();
            if (!dcType.getType().equals(dcTypeName)) continue;
            return dcType.getMax();
        }
        return Integer.MAX_VALUE;
    }

    public int getMin(DataContainerType dcTypeName) {
        if (this.dataContainerList_ == null) {
            return 0;
        }
        Iterator iter = this.dataContainerList_.iterator();
        while (iter.hasNext()) {
            DataContainerDef dcType = (DataContainerDef)iter.next();
            if (!dcType.getType().equals(dcTypeName)) continue;
            return dcType.getMin();
        }
        return 0;
    }

    public String getDesignViewPlacementId() {
        return this.designViewPlacementId_;
    }

    public String getId() {
        return this.id_;
    }

    public String getName() {
        return this.localizedName_;
    }

    public String getDescription() {
        return this.localizedDesc_;
    }

    public boolean hasNestedFeedDefs() {
        return this.nestedFeedDefList_ != null;
    }

    public boolean hasDataContainerDefs() {
        return this.dataContainerList_ != null;
    }

    public FeedDef[] getNestedFeedDefList() {
        if (this.nestedFeedDefList_ != null) {
            return this.nestedFeedDefList_.toArray(new FeedDef[0]);
        }
        return new FeedDef[0];
    }

    public DataContainerDef[] getDataContainerDefList() {
        if (this.dataContainerList_ != null) {
            return this.dataContainerList_.toArray(new DataContainerDef[0]);
        }
        return new DataContainerDef[0];
    }

    public FeedDef findById(String id) {
        if (id.equals(this.id_)) {
            return this;
        }
        if (this.nestedFeedDefList_ == null) {
            return null;
        }
        FeedDef feed = null;
        Iterator iter = this.nestedFeedDefList_.iterator();
        while (iter.hasNext() && feed == null) {
            FeedDef tempFeed = (FeedDef)iter.next();
            if (!tempFeed.getId().equals(id)) {
                feed = tempFeed.findById(id);
                continue;
            }
            feed = tempFeed;
        }
        return feed;
    }

    public FeedDef getParent() {
        return this.parent_;
    }

    public boolean isNested() {
        return this.parent_ != null;
    }

    public boolean isOptional() {
        return this.getMin() == 0;
    }

    public boolean accepts(DataContainerType dcTypeName) {
        if (!this.hasDataContainerDefs()) {
            return false;
        }
        Iterator iter = this.dataContainerList_.iterator();
        while (iter.hasNext()) {
            DataContainerDef dcType = (DataContainerDef)iter.next();
            if (!dcType.getType().equals(dcTypeName)) continue;
            return true;
        }
        return false;
    }

    public boolean accepts(DimensionType dimensionType) {
        if (!this.hasDataContainerDefs()) {
            return false;
        }
        Iterator iter = this.dataContainerList_.iterator();
        while (iter.hasNext()) {
            DataContainerDef dcType = (DataContainerDef)iter.next();
            if (!dcType.getType().equals(DataContainerType.DIMENSIONSHIERARCHY) || !dcType.getDimensionType().equals(dimensionType) && dcType.getDimensionType() != DimensionType.STANDARD) continue;
            return true;
        }
        return false;
    }

    public void getFullNestedFeedDefList(ArrayList fullList, boolean onlyDataContainerHolders) {
        if (this.nestedFeedDefList_ != null) {
            Iterator iter = this.nestedFeedDefList_.iterator();
            while (iter.hasNext()) {
                FeedDef aDef = (FeedDef)iter.next();
                aDef.getFullNestedFeedDefList(fullList, onlyDataContainerHolders);
                if (onlyDataContainerHolders && !aDef.hasDataContainerDefs()) continue;
                fullList.add(aDef);
            }
        }
    }

    public String getStructureId(DataContainerType dcTypeName) {
        DataContainerDef[] dcTypeList = this.getDataContainerDefList();
        for (int i = 0; i < dcTypeList.length; ++i) {
            if (!dcTypeList[i].hasDataStructureInfo() || !dcTypeList[i].getType().equals(dcTypeName)) continue;
            if (dcTypeName.equals(DataContainerType.DIMENSIONSHIERARCHY)) {
                return dcTypeList[i].getAxisId();
            }
            return dcTypeList[i].getMeasureValueGroupId();
        }
        return "";
    }

    public static int minFromXmlDouble(double min) {
        return (int)min;
    }

    public static int maxFromXmlDouble(double max) {
        if (Double.isInfinite(max)) {
            return Integer.MAX_VALUE;
        }
        return (int)max;
    }

    static double minFromInt(int min) {
        return min;
    }

    static double maxFromInt(int max) {
        if (FeedDef.isUnbound(max)) {
            return Double.POSITIVE_INFINITY;
        }
        return max;
    }

    public static boolean isUnbound(int max) {
        return max == Integer.MAX_VALUE;
    }

    public boolean isBaseFeed() {
        if (this.hasDataContainerDefs()) {
            Iterator iter = this.dataContainerList_.iterator();
            while (iter.hasNext()) {
                if (!((DataContainerDef)iter.next()).getType().equals(DataContainerType.MEASUREVALUES)) continue;
                return false;
            }
        }
        return true;
    }
}

