/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.feed;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.dataexchange.definition.DataContainer;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.feed.definition.DataContainerType;
import com.businessobjects.visualization.feed.definition.FeedDef;

class FeedStructureHelper {
    static final int UNDEFINED_STRUCTURE_INDEX = -1;
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$feed$FeedStructureHelper == null ? (class$com$businessobjects$visualization$feed$FeedStructureHelper = FeedStructureHelper.class$("com.businessobjects.visualization.feed.FeedStructureHelper")) : class$com$businessobjects$visualization$feed$FeedStructureHelper));
    private static final String AA_PREFIX = "AA";
    private static final String MG_PREFIX = "MG";
    static final String NOT_DEFINED_PREFIX = "ZZ";
    private final String[] axisMappingTable_;
    private final String[] mgMappingTable_;
    private String measureNamesFeedDefId_;
    static /* synthetic */ Class class$com$businessobjects$visualization$feed$FeedStructureHelper;

    FeedStructureHelper(DataDescriptor dd) {
        this.axisMappingTable_ = new String[dd.getDatasetDescriptor().getAxisList().length + 1];
        this.mgMappingTable_ = new String[dd.getDatasetDescriptor().getValueGroupList().length + 1];
    }

    private static int indexOf(String[] aList, String match) {
        for (int i = 0; i < aList.length; ++i) {
            if (aList[i] == null || !aList[i].equals(match)) continue;
            return i;
        }
        return -1;
    }

    private boolean checkStructureMapping(boolean bCheckPerfectMatching, String[] mappingTable, int iStructureIndex, String axisOrMeasureGroupId, int structureSize) {
        boolean bIsStructureCompatible;
        int iFoundStructureIndex = FeedStructureHelper.indexOf(mappingTable, axisOrMeasureGroupId);
        int iFeedStructureIndex = this.getFeedStructureIndexFromId(axisOrMeasureGroupId);
        if (iFoundStructureIndex == -1) {
            bIsStructureCompatible = iFeedStructureIndex != -1 && iFeedStructureIndex != iStructureIndex && structureSize > 1 && bCheckPerfectMatching ? false : (mappingTable[iStructureIndex] == null ? true : axisOrMeasureGroupId.equals(mappingTable[iStructureIndex]));
        } else {
            boolean bl = bIsStructureCompatible = iStructureIndex == iFoundStructureIndex;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Structure Compatible:" + bIsStructureCompatible + " iFoundStructureIndex=" + iFoundStructureIndex + " iFeedStructureIndex=" + iFeedStructureIndex + " iStructureIndex=" + iStructureIndex + "structureSize=" + structureSize));
        }
        return bIsStructureCompatible;
    }

    int getFeedStructureIndexFromId(String structureId) {
        int result = -1;
        if (structureId == null || structureId.equals("")) {
            return -1;
        }
        int pos = -1;
        pos = structureId.lastIndexOf(AA_PREFIX);
        if (pos == -1) {
            pos = structureId.lastIndexOf(MG_PREFIX);
        }
        if (pos != -1 && pos < structureId.length() - 2) {
            return Integer.parseInt(structureId.substring(pos += 2)) - 1;
        }
        char lastChar = structureId.charAt(structureId.length() - 1);
        if (lastChar > '0' && lastChar < '9') {
            return lastChar - 48 - 1;
        }
        return result;
    }

    int getStructureIndex(DatasetDescriptor dataset, DataContainer dc) {
        int iStructureIndex = dc instanceof DimensionLabels ? dataset.getAxisIndex((DimensionLabels)dc) : dataset.getMeasureGroupIndex((MeasureValues)dc);
        if (iStructureIndex == -1) {
            return -1;
        }
        return iStructureIndex;
    }

    boolean checkFeedType(FeedDef currentDef, DataContainer currentDC) {
        return currentDef.accepts(DataContainerType.DIMENSIONSHIERARCHY) && currentDC instanceof DimensionLabels || currentDef.accepts(DataContainerType.MEASUREVALUES) && currentDC instanceof MeasureValues;
    }

    boolean checkDimensionType(FeedDef currentDef, DataContainer currentDC) {
        if (!(currentDC instanceof DimensionLabels)) {
            return true;
        }
        return currentDef.accepts(((DimensionLabels)currentDC).getDimensionType());
    }

    private String getAxisId(DatasetDescriptor dataset, int iStructureIndex, FeedDef feedDef) {
        String axisId = feedDef.getStructureId(DataContainerType.DIMENSIONSHIERARCHY);
        if (axisId.equals("") && dataset.getAxisList().length >= 2) {
            axisId = feedDef.getId() + iStructureIndex;
        }
        return axisId;
    }

    boolean isMatchingStructure(DatasetDescriptor dataset, DataContainer currentDC, FeedDef feedDef) {
        int iStructureIndex = this.getStructureIndex(dataset, currentDC);
        boolean bIsStructureMatching = false;
        if (currentDC instanceof DimensionLabels && !currentDC.equals(DimensionLabels.MEASURENAMES_DIMENSION)) {
            String axisId = this.getAxisId(dataset, iStructureIndex, feedDef);
            bIsStructureMatching = this.checkStructureMapping(true, this.axisMappingTable_, iStructureIndex, axisId, dataset.getAxisList().length);
        } else if (currentDC.equals(DimensionLabels.MEASURENAMES_DIMENSION)) {
            bIsStructureMatching = this.measureNamesFeedDefId_ == null || this.measureNamesFeedDefId_.equals(feedDef.getId());
        } else {
            String mgId = feedDef.getStructureId(DataContainerType.MEASUREVALUES);
            bIsStructureMatching = this.checkStructureMapping(true, this.mgMappingTable_, iStructureIndex, mgId, dataset.getValueGroupList().length);
        }
        return bIsStructureMatching;
    }

    boolean isValidStructure(DatasetDescriptor dataset, DataContainer currentDC, FeedDef feedDef) {
        int iStructureIndex = this.getStructureIndex(dataset, currentDC);
        boolean bIsStructureCompatible = false;
        if (currentDC instanceof DimensionLabels && !currentDC.equals(DimensionLabels.MEASURENAMES_DIMENSION)) {
            String axisId = this.getAxisId(dataset, iStructureIndex, feedDef);
            bIsStructureCompatible = this.checkStructureMapping(false, this.axisMappingTable_, iStructureIndex, axisId, dataset.getAxisList().length);
        } else if (currentDC.equals(DimensionLabels.MEASURENAMES_DIMENSION)) {
            bIsStructureCompatible = this.measureNamesFeedDefId_ == null || this.measureNamesFeedDefId_.equals(feedDef.getId());
        } else {
            String mgId = feedDef.getStructureId(DataContainerType.MEASUREVALUES);
            bIsStructureCompatible = this.checkStructureMapping(false, this.mgMappingTable_, iStructureIndex, mgId, dataset.getValueGroupList().length);
        }
        return bIsStructureCompatible;
    }

    void markStructure(DatasetDescriptor dataset, DataContainer currentDC, FeedDef feedDef) {
        int iStructureIndex = this.getStructureIndex(dataset, currentDC);
        if (currentDC instanceof DimensionLabels && !currentDC.equals(DimensionLabels.MEASURENAMES_DIMENSION)) {
            String axisId = this.getAxisId(dataset, iStructureIndex, feedDef);
            if (axisId.equals("")) {
                return;
            }
            this.axisMappingTable_[iStructureIndex] = axisId;
        } else if (currentDC.equals(DimensionLabels.MEASURENAMES_DIMENSION)) {
            this.measureNamesFeedDefId_ = feedDef.getId();
        } else {
            String mgId = feedDef.getStructureId(DataContainerType.MEASUREVALUES);
            if (mgId.equals("")) {
                return;
            }
            this.mgMappingTable_[iStructureIndex] = mgId;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

