/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.definition;

import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.HashCodeHelper;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesAdapter;
import com.businessobjects.visualization.dataexchange.definition.ClientInfoHolder;
import com.businessobjects.visualization.dataexchange.definition.DataContainer;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLMeasureValues;
import com.businessobjects.visualization.formatting.FormatHelper;
import com.businessobjects.visualization.formatting.IFormatPattern;

public class MeasureValues
extends DataContainer {
    public static final double AUTO_SCALE = 1.7E308;
    private double minScale_ = 1.7E308;
    private double maxScale_ = 1.7E308;
    private boolean aggregable_ = true;

    public MeasureValues(String title) {
        this(title, DataContainer.UNDEFINED_CLIENTINFOHOLDER, FormatHelper.UNDEFINED_FORMAT, true, 1.7E308, 1.7E308);
    }

    public MeasureValues(String title, ClientInfoHolder clientInfo, IFormatPattern formatPattern, boolean aggregable, double minScale, double maxScale) {
        this.setTitle(title);
        this.setClientInfoHolder(clientInfo);
        this.setFormat(formatPattern);
        this.aggregable_ = aggregable;
        this.minScale_ = minScale;
        this.maxScale_ = maxScale;
        if (this.maxScale_ <= this.minScale_ && this.minScale_ != 1.7E308) {
            throw new VisualizationRuntimeException("VIZ_00151_ERR_IN_MEASURE_SCALE");
        }
    }

    MeasureValues(XMLMeasureValues mesValues, SerializationHelper sh) {
        super.fromXMLDelegate(mesValues, sh);
        this.maxScale_ = mesValues.m_a_maxScale;
        this.minScale_ = mesValues.m_a_minScale;
        this.aggregable_ = mesValues.m_a_aggregable;
    }

    public double getMaxScale() {
        return this.maxScale_;
    }

    public double getMinScale() {
        return this.minScale_;
    }

    public boolean isAggregable() {
        return this.aggregable_;
    }

    MeasureValuesAdapter getValueAdapter() {
        return new MeasureValuesAdapter(this.getClientInfoHolder().getAdapter(), this.getUid(), this.getId());
    }

    public Object getXMLDelegate() {
        XMLMeasureValues xmlMeasureValues = new XMLMeasureValues();
        xmlMeasureValues.m_a_maxScale = this.maxScale_;
        xmlMeasureValues.m_a_minScale = this.minScale_;
        xmlMeasureValues.m_a_aggregable = this.aggregable_;
        super.toXMLDelegate(xmlMeasureValues);
        return xmlMeasureValues;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof MeasureValues)) {
            return false;
        }
        MeasureValues that = (MeasureValues)oThat;
        if (!super.equals(that)) {
            return false;
        }
        return this.maxScale_ == that.maxScale_ && this.minScale_ == that.minScale_ && this.aggregable_ == that.aggregable_;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = HashCodeHelper.hash(result, this.aggregable_);
        result = HashCodeHelper.hash(result, this.minScale_);
        result = HashCodeHelper.hash(result, this.maxScale_);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MeasureValues[");
        buffer.append("dataContainer = ").append(super.toString());
        buffer.append(", aggregable = ").append(this.aggregable_);
        buffer.append(", maxScale = ").append(this.maxScale_);
        buffer.append(", minScale = ").append(this.minScale_);
        buffer.append("]");
        return buffer.toString();
    }
}

