/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.definition;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.internal.HashCodeHelper;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLFilterInfo;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

public class FilterInfo
implements IXMLDelegator {
    private static final ILogger LOGGER = LoggerManager.getLogger((String)(class$com$businessobjects$visualization$dataexchange$definition$FilterInfo == null ? (class$com$businessobjects$visualization$dataexchange$definition$FilterInfo = FilterInfo.class$("com.businessobjects.visualization.dataexchange.definition.FilterInfo")) : class$com$businessobjects$visualization$dataexchange$definition$FilterInfo).getName());
    private int axisIdx_;
    private int start_;
    private int end_;
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$definition$FilterInfo;

    public FilterInfo(int axisIdx, int start, int end) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"FilterInfo()");
        }
        this.axisIdx_ = axisIdx;
        this.start_ = start;
        this.end_ = end;
    }

    protected FilterInfo(XMLFilterInfo xmlFilterInfo, SerializationHelper sh) {
        this.axisIdx_ = xmlFilterInfo.m_a_axis;
        this.start_ = xmlFilterInfo.m_a_start;
        this.end_ = xmlFilterInfo.m_a_end;
    }

    public int getAxisIndex() {
        return this.axisIdx_;
    }

    public int getStartIndex() {
        return this.start_;
    }

    public int getEndIndex() {
        return this.end_;
    }

    public void clear() {
    }

    public Object getXMLDelegate() {
        XMLFilterInfo xmlFilterInfo = new XMLFilterInfo();
        xmlFilterInfo.m_a_axis = this.axisIdx_;
        xmlFilterInfo.m_a_start = this.start_;
        xmlFilterInfo.m_a_end = this.end_;
        return xmlFilterInfo;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof FilterInfo)) {
            return false;
        }
        FilterInfo that = (FilterInfo)oThat;
        return this.axisIdx_ == that.getAxisIndex() && this.start_ == that.getStartIndex() && this.end_ == that.getEndIndex();
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeHelper.hash(result, this.axisIdx_);
        result = HashCodeHelper.hash(result, this.start_);
        result = HashCodeHelper.hash(result, this.end_);
        return result;
    }

    public static double[] filter(double[] values, FilterInfo[] filters, int axisIndex) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < values.length; ++i) {
            boolean keep = true;
            for (int j = 0; j < filters.length && keep; ++j) {
                if (filters[j].getAxisIndex() != axisIndex || i < filters[j].getStartIndex() || i > filters[j].getEndIndex()) continue;
                keep = false;
            }
            if (!keep) continue;
            list.add(new Double(values[i]));
        }
        int k = 0;
        double[] res = new double[list.size()];
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            res[k++] = (Double)itr.next();
        }
        return res;
    }

    public static TreeMap filter(TreeMap values, FilterInfo[] filters, int axisIndex) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < values.size(); ++i) {
            boolean keep = true;
            for (int j = 0; j < filters.length && keep; ++j) {
                if (filters[j].getAxisIndex() != axisIndex || i < filters[j].getStartIndex() || i > filters[j].getEndIndex()) continue;
                keep = false;
            }
            if (!keep) continue;
            list.add(values.get(new Double(i)));
        }
        int k = 0;
        TreeMap res = new TreeMap();
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            res.put(new Double(k++), itr.next());
        }
        return res;
    }

    public static int[] filter(int[] values, FilterInfo[] filters, int axisIndex) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            boolean keep = true;
            for (int j = 0; j < filters.length && keep; ++j) {
                if (filters[j].getAxisIndex() != axisIndex || i < filters[j].getStartIndex() || i > filters[j].getEndIndex()) continue;
                keep = false;
            }
            if (!keep) continue;
            list.add(new Integer(values[i]));
        }
        int k = 0;
        int[] res = new int[list.size()];
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            res[k++] = (Integer)itr.next();
        }
        return res;
    }

    public static Object filter(Object[] values, FilterInfo[] filters, int axisIndex) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < values.length; ++i) {
            boolean keep = true;
            for (int j = 0; j < filters.length && keep; ++j) {
                if (filters[j].getAxisIndex() != axisIndex || i < filters[j].getStartIndex() || i > filters[j].getEndIndex()) continue;
                keep = false;
            }
            if (!keep) continue;
            list.add(values[i]);
        }
        Class<?> type = values.getClass().getComponentType();
        Object[] res = (Object[])Array.newInstance(type, list.size());
        res = list.toArray(res);
        return res;
    }

    public static int[] getIndexes(int len, FilterInfo[] filters, int axisIndex) {
        int[] idx = new int[len];
        for (int i = 0; i < len; ++i) {
            idx[i] = i;
        }
        if (filters == null || filters.length == 0) {
            return idx;
        }
        return FilterInfo.filter(idx, filters, axisIndex);
    }

    public static boolean inFilter(FilterInfo[] filters, int axisIdx, int dataIdx) {
        if (filters == null) {
            return false;
        }
        for (int i = 0; i < filters.length; ++i) {
            if (axisIdx != filters[i].getAxisIndex() || dataIdx < filters[i].getStartIndex() || dataIdx > filters[i].getEndIndex()) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

