/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.impl;

import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.DataContainerIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class TreeNode
implements Serializable {
    private static final long serialVersionUID = 2623601998900130045L;
    private ArrayList childNodeList_;
    private TreeNode parentNode_;
    private Object value_;
    private Properties properties_;
    private long index_;
    private static long mlIndexCounter;

    public TreeNode() {
    }

    public TreeNode(String value, TreeNode parentNode, Properties props) {
        this.parentNode_ = parentNode;
        if (parentNode != null) {
            parentNode.addChild(this);
        }
        this.value_ = value;
        if (props != null) {
            this.setProperties(props);
        }
    }

    public TreeNode(String value, TreeNode parentNode, String propKey, String propValue) {
        this(value, parentNode, null);
        Properties props = new Properties();
        props.setProperty(propKey, propValue);
        this.setProperties(props);
    }

    public TreeNode(String value, TreeNode parentNode) {
        this(value, parentNode, null);
    }

    public TreeNode(String value) {
        this(value, null, null);
    }

    private void createChildNodeList() {
        if (this.childNodeList_ == null) {
            this.childNodeList_ = new ArrayList();
        }
    }

    public TreeNode addChild(TreeNode child) {
        this.createChildNodeList();
        this.childNodeList_.add(child);
        child.parentNode_ = this;
        return this;
    }

    public TreeNode addChildren(TreeNode[] children) {
        this.createChildNodeList();
        for (int i = 0; i < children.length; ++i) {
            this.childNodeList_.add(children[i]);
            children[i].parentNode_ = this;
        }
        return this;
    }

    public TreeNode[] getChildren() {
        if (this.childNodeList_ == null) {
            return null;
        }
        return this.childNodeList_.toArray(new TreeNode[0]);
    }

    public Collection getChildrenCollection() {
        if (this.childNodeList_ == null) {
            return null;
        }
        return (ArrayList)this.childNodeList_.clone();
    }

    public int getLevel() {
        if (this.parentNode_ != null) {
            return this.parentNode_.getLevel() + 1;
        }
        return 0;
    }

    public TreeNode getParent() {
        return this.parentNode_;
    }

    public Object getValue() {
        return this.value_;
    }

    public DataType getType() {
        return DataType.STRING;
    }

    public boolean isLeaf() {
        return this.childNodeList_ == null;
    }

    public boolean isRoot() {
        return this.parentNode_ == null;
    }

    public int getDepth() {
        if (this.isLeaf()) {
            return 0;
        }
        Iterator iter = this.childNodeList_.iterator();
        int iMaxDepth = 0;
        while (iter.hasNext()) {
            int currDepth = ((TreeNode)iter.next()).getDepth() + 1;
            if (iMaxDepth >= currDepth) continue;
            iMaxDepth = currDepth;
        }
        return iMaxDepth;
    }

    public TreeNode[] getTreeNodesByLevel(int iTargetLevel) {
        Collection returnedTree = this.getTreeNodesByLevelInternal(iTargetLevel);
        if (returnedTree == null) {
            return new TreeNode[0];
        }
        return returnedTree.toArray(new TreeNode[0]);
    }

    private Collection getTreeNodesByLevelInternal(int iTargetLevel) {
        ArrayList<TreeNode> theTreeList = null;
        int iCurrLevel = this.getLevel();
        if (iCurrLevel == iTargetLevel) {
            theTreeList = new ArrayList<TreeNode>();
            theTreeList.add(this);
        } else if (iCurrLevel < iTargetLevel) {
            Collection c = this.getChildrenCollection();
            if (c == null) {
                return null;
            }
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                ArrayList newAl = (ArrayList)((TreeNode)iter.next()).getTreeNodesByLevelInternal(iTargetLevel);
                if (newAl == null) continue;
                if (theTreeList == null) {
                    theTreeList = new ArrayList();
                }
                theTreeList.addAll(newAl);
            }
        }
        return theTreeList;
    }

    public boolean isIndexedBy(DataContainerIndex dataIndex) {
        return (long)dataIndex.getX() == this.getIndex();
    }

    public TreeNode[] getTreeNodesByIndex(DataContainerIndex[] dataIndex) {
        Collection returnedTree = this.getTreeNodesByIndexInternal(dataIndex);
        if (returnedTree == null) {
            return new TreeNode[0];
        }
        return returnedTree.toArray(new TreeNode[0]);
    }

    private Collection getTreeNodesByIndexInternal(DataContainerIndex[] dataIndexes) {
        Collection c;
        ArrayList<TreeNode> theTreeList = null;
        for (int i = 0; i < dataIndexes.length; ++i) {
            if (!this.isIndexedBy(dataIndexes[i])) continue;
            theTreeList = new ArrayList<TreeNode>();
            theTreeList.add(this);
            break;
        }
        if ((c = this.getChildrenCollection()) == null) {
            return theTreeList;
        }
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            ArrayList newAl = (ArrayList)((TreeNode)iter.next()).getTreeNodesByIndexInternal(dataIndexes);
            if (newAl == null) continue;
            if (theTreeList == null) {
                theTreeList = new ArrayList();
            }
            theTreeList.addAll(newAl);
        }
        return theTreeList;
    }

    public int getNodeCount() {
        if (this.childNodeList_ == null) {
            return 0;
        }
        Iterator iter = this.childNodeList_.iterator();
        int returnedSize = 0;
        while (iter.hasNext()) {
            returnedSize += ((TreeNode)iter.next()).getNodeCount() + 1;
        }
        return returnedSize;
    }

    public void setProperties(Properties props) {
        this.properties_ = props;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public TreeNode getRoot() {
        TreeNode node = this;
        while (node.getParent() != null) {
            node = node.getParent();
        }
        return node;
    }

    private long getIndex() {
        if (this.index_ == 0L) {
            this.index_ = TreeNode.getNextIndex();
        }
        return this.index_;
    }

    public DataContainerIndex getDataIndex() {
        return new DataContainerIndex((int)this.getIndex());
    }

    private static synchronized long getNextIndex() {
        return ++mlIndexCounter;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TreeNode[");
        buffer.append("value_ = ").append(this.value_);
        buffer.append("]");
        return buffer.toString();
    }

    public static TreeNode newMissingNodeInstance() {
        return new TreeNode(null, null, null);
    }
}

