/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data;

import com.businessobjects.visualization.common.exceptions.SerializationException;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.data.ClientInfoAdapter;
import com.businessobjects.visualization.dataexchange.data.Data;
import com.businessobjects.visualization.dataexchange.data.generated.XMLCalculationAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLClientInfoAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLData;
import com.businessobjects.visualization.dataexchange.data.impl.DoubleValueData;

public class CalculationAdapter {
    private ClientInfoAdapter clientInfoAdapter_;
    private Data data_;

    public CalculationAdapter(ClientInfoAdapter cia) {
        this.clientInfoAdapter_ = cia;
    }

    public CalculationAdapter(XMLCalculationAdapter xmlAdapter, SerializationHelper sh) {
        if (xmlAdapter.m_clientInfoAdapter != null) {
            this.clientInfoAdapter_ = new ClientInfoAdapter(xmlAdapter.m_clientInfoAdapter, sh);
        }
        if (xmlAdapter.m_values != null) {
            if (xmlAdapter.m_values.m_dataType.value() != 1) {
                throw new SerializationException("VIZ_00002_ERR_DESERIALIZATION_ERROR", "Invalid datatype for calculation:" + xmlAdapter.m_values.m_dataType);
            }
            this.data_ = new DoubleValueData(xmlAdapter.m_values, sh);
        }
    }

    public Data getData() {
        return this.data_;
    }

    public void setData(Data data) {
        this.data_ = data;
    }

    public Object getXMLDelegate() {
        XMLCalculationAdapter xmlAdapter = new XMLCalculationAdapter();
        xmlAdapter.m_clientInfoAdapter = (XMLClientInfoAdapter)this.clientInfoAdapter_.getXMLDelegate();
        if (this.data_ != null) {
            xmlAdapter.m_values = (XMLData)this.data_.getXMLDelegate();
        }
        return xmlAdapter;
    }
}

