/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.reports.jdbinterface.common;

import com.businessobjects.reports.jdbinterface.common.DBException;
import com.businessobjects.reports.jdbinterface.common.DbFieldInfo;
import com.businessobjects.reports.jdbinterface.common.FieldBindingInfo;
import com.businessobjects.reports.jdbinterface.common.FieldInfo;
import com.businessobjects.reports.jdbinterface.common.FieldKind;
import com.businessobjects.reports.jdbinterface.common.FieldType;
import com.businessobjects.reports.jdbinterface.common.ITable;
import com.businessobjects.reports.jdbinterface.common.JDBInterfaceResources;
import com.businessobjects.reports.jdbinterface.common.JDBUtils;
import com.businessobjects.reports.jdbinterface.common.ParameterDirection;
import com.businessobjects.reports.jdbinterface.common.ParameterInfo;
import com.businessobjects.reports.jdbinterface.common.RSBindingHandle;
import com.businessobjects.reports.jdbinterface.common.ServerDriverType;
import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.data.CrystalResultSet;
import com.crystaldecisions.reports.common.data.CrystalResultSetMetaData;
import com.crystaldecisions.reports.common.value.BinaryValue;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetReader {
    private static final int new = 1642;
    private static final int int = 2052;
    static final int for = 2048;
    private static final int do = -101;
    private static final int a = -101;
    private static final int if = -102;

    public static List<DbFieldInfo> GetFields(CrystalResultSet crystalResultSet, ITable iTable) throws Exception {
        if (crystalResultSet == null) {
            return null;
        }
        CrystalResultSetMetaData crystalResultSetMetaData = crystalResultSet.getMetaData();
        if (crystalResultSetMetaData == null) {
            return null;
        }
        int n = crystalResultSetMetaData.getColumnCount();
        if (n == 0) {
            return null;
        }
        ArrayList<DbFieldInfo> arrayList = new ArrayList<DbFieldInfo>();
        for (int i = 1; i <= n; ++i) {
            ValueType valueType;
            String string;
            DbFieldInfo dbFieldInfo = new DbFieldInfo(iTable.getInfo());
            dbFieldInfo.m_Name = string = crystalResultSetMetaData.getColumnName(i);
            dbFieldInfo.m_Description = string;
            dbFieldInfo.m_Alias = string;
            int n2 = crystalResultSetMetaData.getColumnType(i);
            dbFieldInfo.dataType = valueType = ResultSetReader.GetBestValueTypeForSQLType(n2, crystalResultSetMetaData.isSigned(i));
            int n3 = crystalResultSetMetaData.getColumnDisplaySize(i);
            dbFieldInfo.fieldSize = ResultSetReader.GetNBytesInField(valueType, n3, ResultSetReader.IsBinarySQLType(n2));
            dbFieldInfo.m_Attributes = valueType == ValueType.string ? 2 : 0;
            dbFieldInfo.fieldKind = FieldKind.database;
            dbFieldInfo.m_Type = FieldType.Normal;
            dbFieldInfo.m_Precision = 0;
            dbFieldInfo.table = iTable.getInfo();
            arrayList.add(dbFieldInfo);
        }
        return arrayList;
    }

    public static List<FieldInfo> GetFieldsFromResultSetMetaData(CrystalResultSetMetaData crystalResultSetMetaData, ServerDriverType serverDriverType) throws SQLException {
        ArrayList<FieldInfo> arrayList = new ArrayList<FieldInfo>();
        int n = crystalResultSetMetaData.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            String string = crystalResultSetMetaData.getColumnName(i);
            if (serverDriverType.isHana()) {
                string = crystalResultSetMetaData.getColumnLabel(i);
            }
            int n2 = crystalResultSetMetaData.getColumnType(i);
            String string2 = crystalResultSetMetaData.getColumnTypeName(i);
            int n3 = crystalResultSetMetaData.getColumnDisplaySize(i);
            int n4 = crystalResultSetMetaData.getScale(i);
            if (serverDriverType.isOracle() && string2.toUpperCase().indexOf("INTERVAL") >= 0) {
                n3 = 64;
            }
            FieldInfo fieldInfo = new FieldInfo();
            JDBUtils.FillInFieldInfo(fieldInfo, serverDriverType, n2, string2, n4, n3);
            fieldInfo.m_Alias = null;
            fieldInfo.m_Name = string;
            fieldInfo.m_Description = null;
            fieldInfo.m_Type = FieldType.Normal;
            fieldInfo.m_Properties = null;
            fieldInfo.fieldKind = FieldKind.database;
            arrayList.add(fieldInfo);
        }
        return arrayList;
    }

    public static ValueType GetBestValueTypeForSQLType(int n, String string) {
        boolean bl = true;
        if (string != null && string.toUpperCase().indexOf("UNSIGNED") >= 0) {
            bl = false;
        }
        return ResultSetReader.GetBestValueTypeForSQLType(n, bl);
    }

    public static ValueType GetBestValueTypeForSQLType(int n, boolean bl) {
        switch (n) {
            case 2003: {
                return ValueType.string;
            }
            case -5: {
                if (bl) {
                    return ValueType.int64s;
                }
                return ValueType.int64u;
            }
            case -2: {
                return ValueType.string;
            }
            case -7: {
                return ValueType.bool;
            }
            case 2004: {
                return ValueType.blob;
            }
            case -13: {
                return ValueType.blob;
            }
            case 16: {
                return ValueType.bool;
            }
            case 1: {
                return ValueType.string;
            }
            case 2005: {
                return ValueType.memo;
            }
            case 91: {
                return ValueType.date;
            }
            case 3: {
                return ValueType.decimal;
            }
            case 2001: {
                return ValueType.string;
            }
            case 8: {
                return ValueType.number;
            }
            case 6: {
                return ValueType.number;
            }
            case 4: {
                if (bl) {
                    return ValueType.int32s;
                }
                return ValueType.int32u;
            }
            case 2000: {
                return ValueType.string;
            }
            case -4: {
                return ValueType.blob;
            }
            case -1: {
                return ValueType.memo;
            }
            case 0: {
                return ValueType.string;
            }
            case 2: {
                return ValueType.number;
            }
            case 1111: {
                return ValueType.string;
            }
            case 7: {
                return ValueType.number;
            }
            case 2006: {
                return ValueType.string;
            }
            case 5: {
                if (bl) {
                    return ValueType.int16s;
                }
                return ValueType.int16u;
            }
            case 2002: {
                return ValueType.string;
            }
            case 92: {
                return ValueType.time;
            }
            case 93: {
                return ValueType.dateTime;
            }
            case -6: {
                if (bl) {
                    return ValueType.int8s;
                }
                return ValueType.int8u;
            }
            case -3: {
                return ValueType.string;
            }
            case 12: {
                return ValueType.string;
            }
            case -9: {
                return ValueType.string;
            }
        }
        CrystalAssert.ASSERT((boolean)false);
        return ValueType.unknown;
    }

    public static boolean IsBinarySQLType(int n) {
        switch (n) {
            case -2: {
                return true;
            }
            case 2004: {
                return true;
            }
            case -4: {
                return true;
            }
            case -3: {
                return true;
            }
        }
        return false;
    }

    public static int GetNBytesInField(ValueType valueType, int n, boolean bl) {
        switch (valueType.value()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 4;
            }
            case 17: {
                return 8;
            }
            case 18: {
                return 8;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 8;
            }
            case 16: {
                return 8;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 4;
            }
            case 15: {
                return 8;
            }
            case 13: {
                return Integer.MAX_VALUE;
            }
            case 14: {
                return Integer.MAX_VALUE;
            }
            case 11: {
                if (bl) {
                    n *= 2;
                }
                if (n == 0 || n >= 65535) {
                    return 131070;
                }
                return (n + 1) * 2;
            }
        }
        CrystalAssert.ASSERT((boolean)false);
        return 0;
    }

    protected int a(ValueType valueType) {
        switch (valueType.value()) {
            case 0: 
            case 1: {
                return -6;
            }
            case 2: 
            case 3: {
                return 5;
            }
            case 4: 
            case 5: {
                return 4;
            }
            case 17: 
            case 18: {
                return -5;
            }
            case 6: 
            case 7: 
            case 16: {
                return 2;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 91;
            }
            case 10: {
                return 92;
            }
            case 15: {
                return 93;
            }
            case 11: {
                return 1;
            }
            case 13: {
                return 2005;
            }
            case 14: {
                return 2004;
            }
        }
        CrystalAssert.ASSERT((boolean)false);
        return 1111;
    }

    public static List<ParameterInfo> GetParameters(Class<?>[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return null;
        }
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        for (int i = 0; i < classArray.length; ++i) {
            int n;
            ValueType valueType;
            ParameterInfo parameterInfo = new ParameterInfo();
            Class<?> clazz = classArray[i];
            String string = "Parameter";
            parameterInfo.m_Name = string = string + Integer.toString(i + 1);
            parameterInfo.m_Alias = string;
            parameterInfo.m_Description = string;
            int n2 = ResultSetReader.GetJavaSQLType(clazz.getName());
            boolean bl = clazz.isPrimitive();
            parameterInfo.dataType = valueType = ResultSetReader.GetBestValueTypeForSQLType(n2, true);
            parameterInfo.fieldSize = n = ResultSetReader.GetNBytesInField(valueType, 255, ResultSetReader.IsBinarySQLType(n2));
            int n3 = 0;
            if (valueType == ValueType.string) {
                n3 = 2;
                if (bl) {
                    n3 |= 0x10;
                }
            } else if (valueType == ValueType.number && n2 == 6) {
                n3 |= 8;
            }
            boolean bl2 = false;
            if (!bl) {
                n3 |= 4;
                bl2 = true;
            }
            parameterInfo.m_Attributes = n3;
            parameterInfo.isNullable = bl2;
            parameterInfo.parameterDirection = ParameterDirection.input;
            parameterInfo.m_Properties = new HashMap();
            parameterInfo.m_Properties.put("Java Type", StringValue.fromString((String)clazz.getName()));
            arrayList.add(parameterInfo);
        }
        return arrayList;
    }

    public static int GetJavaSQLType(String string) {
        int n = 0;
        if (string.compareTo("int") == 0 || string.compareTo("java.lang.Integer") == 0) {
            n = 4;
        } else if (string.compareTo("double") == 0 || string.compareTo("java.lang.Double") == 0) {
            n = 8;
        } else if (string.compareTo("byte") == 0 || string.compareTo("java.lang.Byte") == 0) {
            n = -6;
        } else if (string.compareTo("short") == 0 || string.compareTo("java.lang.Short") == 0) {
            n = 5;
        } else if (string.compareTo("long") == 0 || string.compareTo("java.lang.Long") == 0) {
            n = -5;
        } else if (string.compareTo("float") == 0 || string.compareTo("java.lang.Float") == 0) {
            n = 6;
        } else if (string.compareTo("java.math.BigDecimal") == 0) {
            n = 3;
        } else if (string.compareTo("boolean") == 0 || string.compareTo("java.lang.Boolean") == 0) {
            n = 16;
        } else if (string.compareTo("java.sql.Timestamp") == 0) {
            n = 93;
        } else if (string.compareTo("java.sql.Date") == 0) {
            n = 91;
        } else if (string.compareTo("java.sql.Time") == 0) {
            n = 92;
        } else if (string.compareTo("java.lang.String") == 0) {
            n = 12;
        } else if (string.compareTo("char") == 0) {
            n = 1;
        }
        return n;
    }

    public static Object GetRealValue(CrystalValue crystalValue, String string) {
        Object object = null;
        ValueType valueType = crystalValue.getValueType();
        if (valueType.isNumeric()) {
            NumberValue numberValue = (NumberValue)crystalValue;
            if (string.compareTo("int") == 0 || string.compareTo("java.lang.Integer") == 0) {
                object = new Integer(numberValue.getInt());
            } else if (string.compareTo("double") == 0 || string.compareTo("java.lang.Double") == 0) {
                object = new Double(numberValue.getDouble());
            } else if (string.compareTo("byte") == 0 || string.compareTo("java.lang.Byte") == 0) {
                Integer n = new Integer(numberValue.getInt());
                object = new Byte(n.byteValue());
            } else if (string.compareTo("short") == 0 || string.compareTo("java.lang.Short") == 0) {
                Integer n = new Integer(numberValue.getInt());
                object = new Short(n.shortValue());
            } else if (string.compareTo("long") == 0 || string.compareTo("java.lang.Long") == 0) {
                object = new Long(numberValue.getLong());
            } else if (string.compareTo("float") == 0 || string.compareTo("java.lang.Float") == 0) {
                object = new Float(numberValue.getDouble());
            } else if (string.compareTo("java.math.BigDecimal") == 0) {
                object = new BigDecimal(numberValue.getDouble());
            }
        } else if (string.compareTo("boolean") == 0 || string.compareTo("java.lang.Boolean") == 0) {
            BooleanValue booleanValue = (BooleanValue)crystalValue;
            object = new Boolean(booleanValue.getBoolean());
        } else if (string.compareTo("java.sql.Timestamp") == 0) {
            DateTimeValue dateTimeValue = (DateTimeValue)crystalValue;
            object = new Timestamp(ResultSetReader.CrystalDateTimeInMilliseconds(dateTimeValue));
        } else if (string.compareTo("java.sql.Date") == 0) {
            DateValue dateValue = (DateValue)crystalValue;
            object = new Date(ResultSetReader.CrystalDateInMilliseconds(dateValue));
        } else if (string.compareTo("java.sql.Time") == 0) {
            TimeValue timeValue = (TimeValue)crystalValue;
            object = new Time(ResultSetReader.CrystalTimeInMilliseconds(timeValue));
        } else if (string.compareTo("java.lang.String") == 0) {
            StringValue stringValue = (StringValue)crystalValue;
            object = new String(stringValue.getString());
        } else if (string.compareTo("char") == 0) {
            StringValue stringValue = (StringValue)crystalValue;
            object = new Character(stringValue.getString().charAt(0));
        }
        return object;
    }

    public static long CrystalDateInMilliseconds(DateValue dateValue) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(dateValue.getYear(), dateValue.getMonth() - 1, dateValue.getDay());
        return calendar.getTimeInMillis();
    }

    public static long CrystalDateTimeInMilliseconds(DateTimeValue dateTimeValue) {
        DateValue dateValue = dateTimeValue.getDateValue();
        TimeValue timeValue = dateTimeValue.getTimeValue();
        long l = ResultSetReader.CrystalDateInMilliseconds(dateValue) + ResultSetReader.CrystalTimeInMilliseconds(timeValue);
        return l;
    }

    public static long CrystalTimeInMilliseconds(TimeValue timeValue) {
        return timeValue.getTimeInNs() / 1000000L;
    }

    public static List<Object> ConvertParameterInfoToArgumentList(List<ParameterInfo> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String string = ((CrystalValue)list.get((int)i).m_Properties.get("Java Type")).toString();
                if (string != null && string.startsWith("s(") && string.endsWith(")")) {
                    string = string.substring(2, string.length() - 1);
                }
                arrayList.add(ResultSetReader.GetRealValue(list.get((int)i).currentValue, string));
            }
        }
        return arrayList;
    }

    public static int GetAdjustedSQLDataType(int n, String string, int n2, ServerDriverType serverDriverType) {
        if (serverDriverType.isSQLServer()) {
            if (n == -2) {
                if (string.equalsIgnoreCase("TIMESTAMP")) {
                    return 12;
                }
            } else {
                if (n == 7) {
                    return 6;
                }
                if (n == 6) {
                    return 8;
                }
            }
        } else if (serverDriverType.isMySQL()) {
            if (n == -2) {
                if (string.equalsIgnoreCase("TIMESTAMP")) {
                    return 12;
                }
                if (string.equalsIgnoreCase("TINYBLOB")) {
                    return 2004;
                }
            } else {
                if (n == 7) {
                    return 6;
                }
                if (n == 6) {
                    return 8;
                }
                if (n == 91) {
                    if (string.equalsIgnoreCase("YEAR")) {
                        return 2;
                    }
                } else {
                    if (n == 5) {
                        return 4;
                    }
                    if (n == 4) {
                        if (string.equalsIgnoreCase("int") || string.equalsIgnoreCase("mediumint") || string.equalsIgnoreCase("mediumint unsigned")) {
                            return 4;
                        }
                        return -5;
                    }
                    if (n == -3) {
                        return 2004;
                    }
                    if (n == -5) {
                        return 8;
                    }
                    if (n == 1111) {
                        if (string.equalsIgnoreCase("float unsigned")) {
                            return 8;
                        }
                        if (string.equalsIgnoreCase("double unsigned")) {
                            return 8;
                        }
                        if (string.equalsIgnoreCase("longtext")) {
                            return -1;
                        }
                        if (string.equalsIgnoreCase("bigint unsigned")) {
                            return -5;
                        }
                        if (string.equalsIgnoreCase("int unsigned")) {
                            return -5;
                        }
                        if (string.equalsIgnoreCase("mediumint unsigned")) {
                            return 4;
                        }
                        if (string.equalsIgnoreCase("smallint unsigned")) {
                            return 4;
                        }
                        if (string.equalsIgnoreCase("tinyint unsigned")) {
                            return -6;
                        }
                        if (string.equalsIgnoreCase("decimal unsigned")) {
                            return 3;
                        }
                        if (string.equalsIgnoreCase("float unsigned unsigned")) {
                            return 8;
                        }
                        if (string.equalsIgnoreCase("double unsigned unsigned")) {
                            return 8;
                        }
                    }
                }
            }
        } else if (serverDriverType.isOracle()) {
            if (n == -101 || n == -101 || n == -102) {
                return 93;
            }
            if (n == 1111) {
                if (string.equalsIgnoreCase("NCHAR")) {
                    return 1;
                }
                if (string.equalsIgnoreCase("NVARCHAR2")) {
                    return 12;
                }
                if (string.equalsIgnoreCase("BLOB")) {
                    return 2004;
                }
                if (string.equalsIgnoreCase("CLOB") || string.equals("NCLOB")) {
                    return 2005;
                }
                if (string.equalsIgnoreCase("FLOAT")) {
                    return 2;
                }
                if (string.equalsIgnoreCase("ROWID")) {
                    return 12;
                }
                if (string.equalsIgnoreCase("UROWID")) {
                    return 2005;
                }
                if (string.length() >= 9 && string.substring(0, 9).equalsIgnoreCase("TIMESTAMP")) {
                    return 93;
                }
                if (string.equalsIgnoreCase("REF CURSOR")) {
                    return 2006;
                }
            } else {
                if (n == 3) {
                    return 2;
                }
                if (n == 2) {
                    return 6;
                }
                if (n == 93) {
                    return 91;
                }
            }
        } else if (serverDriverType.isIBMDB2()) {
            if (n == 0 && string.equalsIgnoreCase("CHAR")) {
                return 1;
            }
            if (n == 0 && string.equalsIgnoreCase("TIMESTAMP")) {
                return 93;
            }
        } else if (serverDriverType.isInformix()) {
            if (n == 7) {
                return 6;
            }
            if (n == 6) {
                return 8;
            }
            if (n == 5) {
                return 4;
            }
            if (n == 4) {
                if (string.equalsIgnoreCase("int") || string.equalsIgnoreCase("integer")) {
                    return 4;
                }
                return -5;
            }
            if (n == -5) {
                return 8;
            }
            if (n == 93) {
                if (n2 == 1642) {
                    return 92;
                }
                if (n2 == 2052) {
                    return 91;
                }
            }
        } else if (serverDriverType.isNetezza()) {
            if (string.equalsIgnoreCase("NVARCHAR")) {
                return 12;
            }
            if (string.equalsIgnoreCase("NCHAR")) {
                return 1;
            }
        } else if (serverDriverType == ServerDriverType.UNKNOWN && string.equalsIgnoreCase("UNIVARCHAR")) {
            return 12;
        }
        return n;
    }

    public static Object bindToField(ServerDriverType serverDriverType, CrystalResultSet crystalResultSet, FieldBindingInfo fieldBindingInfo) throws DBException {
        try {
            CrystalResultSetMetaData crystalResultSetMetaData = crystalResultSet.getMetaData();
            if (fieldBindingInfo.bindByName) {
                int n = crystalResultSetMetaData.getColumnCount();
                int n2 = 0;
                for (int i = 1; i <= n; ++i) {
                    boolean bl;
                    String string = crystalResultSetMetaData.getColumnName(i);
                    if (serverDriverType.isHana()) {
                        string = crystalResultSetMetaData.getColumnLabel(i);
                    }
                    boolean bl2 = bl = fieldBindingInfo.caseSensitive ? string.equals(fieldBindingInfo.fieldName) : string.equalsIgnoreCase(fieldBindingInfo.fieldName);
                    if (!bl) continue;
                    if (n2 == fieldBindingInfo.occurrence) {
                        return new RSBindingHandle(i, crystalResultSetMetaData.getColumnType(i), crystalResultSetMetaData.getColumnTypeName(i), crystalResultSetMetaData.getColumnDisplaySize(i), serverDriverType, fieldBindingInfo.bindType);
                    }
                    ++n2;
                }
                return null;
            }
            return new RSBindingHandle(fieldBindingInfo.fieldOrdinal, crystalResultSetMetaData.getColumnType(fieldBindingInfo.fieldOrdinal), crystalResultSetMetaData.getColumnTypeName(fieldBindingInfo.fieldOrdinal), crystalResultSetMetaData.getColumnDisplaySize(fieldBindingInfo.fieldOrdinal), serverDriverType, fieldBindingInfo.bindType);
        }
        catch (SQLException sQLException) {
            throw new DBException("RCICRC99999999", "", JDBInterfaceResources.getFactory(), "UnexpectedJDBInterfaceError", sQLException);
        }
    }

    public static CrystalValue readColumnValue(ServerDriverType serverDriverType, CrystalResultSet crystalResultSet, Object object) throws DBException {
        try {
            RSBindingHandle rSBindingHandle = (RSBindingHandle)object;
            int n = rSBindingHandle.a;
            Object object2 = null;
            switch (rSBindingHandle.do) {
                case -5: {
                    boolean bl = crystalResultSet.getMetaData().isSigned(n);
                    if (bl) {
                        long l = crystalResultSet.getLong(n);
                        if (crystalResultSet.wasNull()) {
                            return null;
                        }
                        if (rSBindingHandle.if == ValueType.int64u && l < 0L) {
                            double d = (double)l + 1.8446744073709552E19;
                            object2 = NumberValue.fromDouble((double)d);
                            break;
                        }
                        object2 = NumberValue.fromLong((long)l);
                        break;
                    }
                    double d = crystalResultSet.getDouble(n);
                    if (crystalResultSet.wasNull()) {
                        return null;
                    }
                    if (rSBindingHandle.if == ValueType.int64u && d < 0.0) {
                        d += 1.8446744073709552E19;
                    }
                    object2 = NumberValue.fromDouble((double)d);
                    break;
                }
                case 2004: {
                    Blob blob = crystalResultSet.getBlob(n);
                    if (blob == null) {
                        return null;
                    }
                    int n2 = (int)blob.length();
                    byte[] byArray = new byte[n2];
                    InputStream inputStream = blob.getBinaryStream();
                    if (inputStream == null) {
                        return null;
                    }
                    try {
                        inputStream.read(byArray);
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    object2 = BinaryValue.fromByteArray((byte[])byArray);
                    break;
                }
                case -4: {
                    int n3;
                    byte[] byArray;
                    InputStream inputStream = crystalResultSet.getBinaryStream(n);
                    if (inputStream == null) {
                        return null;
                    }
                    Vector<byte[]> vector = new Vector<byte[]>();
                    int n4 = 0;
                    try {
                        byArray = new byte[2048];
                        n3 = inputStream.read(byArray);
                        while (n3 > 0) {
                            vector.add(byArray);
                            n4 = n3;
                            byArray = new byte[2048];
                            n3 = inputStream.read(byArray);
                        }
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    if (vector.size() == 0) {
                        return null;
                    }
                    byArray = new byte[(vector.size() - 1) * 2048 + n4];
                    n3 = 0;
                    for (int i = 0; i < vector.size() - 1; ++i) {
                        byte[] byArray2 = (byte[])vector.elementAt(i);
                        System.arraycopy(byArray2, 0, byArray, n3, 2048);
                        n3 += 2048;
                    }
                    byte[] byArray3 = (byte[])vector.elementAt(vector.size() - 1);
                    System.arraycopy(byArray3, 0, byArray, n3, n4);
                    object2 = BinaryValue.fromByteArray((byte[])byArray);
                    break;
                }
                case -3: 
                case -2: {
                    object2 = rSBindingHandle.if.value() == 11 ? StringValue.fromString((String)crystalResultSet.getString(n)) : BinaryValue.fromByteArray((byte[])crystalResultSet.getBytes(n));
                    if (!crystalResultSet.wasNull()) break;
                    return null;
                }
                case -7: 
                case 16: {
                    object2 = BooleanValue.fromBoolean((boolean)crystalResultSet.getBoolean(n));
                    if (!crystalResultSet.wasNull()) break;
                    return null;
                }
                case 91: {
                    if (serverDriverType.isOracle()) {
                        Timestamp timestamp = crystalResultSet.getTimestamp(n);
                        if (crystalResultSet.wasNull() || timestamp == null) {
                            return null;
                        }
                        GregorianCalendar gregorianCalendar = new GregorianCalendar();
                        gregorianCalendar.setTime(timestamp);
                        long l = timestamp.getTime();
                        if (crystalResultSet.getMetaData().getColumnName(n).toUpperCase().indexOf("((CURRENT_DATE))") != -1) {
                            long l2 = gregorianCalendar.getTimeInMillis();
                            int n5 = ((Calendar)gregorianCalendar).getTimeZone().getOffset(l2);
                            l += (long)n5;
                        }
                        gregorianCalendar.setTimeInMillis(l);
                        int n6 = timestamp.getNanos();
                        object2 = DateTimeValue.fromDateAndTimeValues((DateValue)DateValue.fromCalendar((Calendar)gregorianCalendar), (TimeValue)TimeValue.fromHMSN((int)gregorianCalendar.get(11), (int)gregorianCalendar.get(12), (int)gregorianCalendar.get(13), (long)n6));
                        break;
                    }
                    Date date = crystalResultSet.getDate(n);
                    if (crystalResultSet.wasNull() || date == null) {
                        return null;
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    object2 = DateValue.fromCalendar((Calendar)calendar);
                    break;
                }
                case 92: {
                    Time time = crystalResultSet.getTime(n);
                    if (crystalResultSet.wasNull() || time == null) {
                        return null;
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(time);
                    object2 = TimeValue.fromCalendar((Calendar)calendar);
                    break;
                }
                case 93: {
                    Timestamp timestamp = null;
                    timestamp = serverDriverType.isOracle() ? crystalResultSet.getTimestamp(n, Calendar.getInstance()) : crystalResultSet.getTimestamp(n);
                    if (crystalResultSet.wasNull() || timestamp == null) {
                        return null;
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(timestamp);
                    int n7 = timestamp.getNanos();
                    object2 = DateTimeValue.fromDateAndTimeValues((DateValue)DateValue.fromCalendar((Calendar)calendar), (TimeValue)TimeValue.fromHMSN((int)calendar.get(11), (int)calendar.get(12), (int)calendar.get(13), (long)n7));
                    break;
                }
                case 2: 
                case 3: {
                    CrystalResultSetMetaData crystalResultSetMetaData = crystalResultSet.getMetaData();
                    BigDecimal bigDecimal = crystalResultSet.getBigDecimal(n);
                    if (crystalResultSet.wasNull()) {
                        return null;
                    }
                    double d = bigDecimal.movePointRight(2).doubleValue();
                    object2 = NumberValue.fromScaledDouble((double)d);
                    if (serverDriverType.isOracle() && crystalResultSetMetaData.getScale(n) == 0) {
                        if (crystalResultSet.getMetaData().getColumnName(n).toUpperCase().indexOf("(EXTRACT(HOURFROM(CURRENT_TIMESTAMP)))") == -1) break;
                        GregorianCalendar gregorianCalendar = new GregorianCalendar();
                        long l = gregorianCalendar.getTimeInMillis();
                        int n8 = ((Calendar)gregorianCalendar).getTimeZone().getOffset(l);
                        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2003, 0, 1, crystalResultSet.getInt(n), 0);
                        ((Calendar)gregorianCalendar2).add(11, n8 / 3600000);
                        object2 = NumberValue.fromLong((long)gregorianCalendar2.get(11));
                        break;
                    }
                    if (!crystalResultSetMetaData.getColumnTypeName(n).equalsIgnoreCase("MONEY") && !crystalResultSetMetaData.getColumnTypeName(n).equalsIgnoreCase("SMALLMONEY")) break;
                    object2 = CurrencyValue.fromScaledDouble((double)d);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    double d = crystalResultSet.getDouble(n);
                    if (crystalResultSet.wasNull()) {
                        return null;
                    }
                    if (Double.isInfinite(d * 100.0)) {
                        if (d > 0.0) {
                            object2 = NumberValue.fromScaledDouble((double)Double.MAX_VALUE);
                            break;
                        }
                        object2 = NumberValue.fromScaledDouble((double)-1.7976931348623157E308);
                        break;
                    }
                    object2 = NumberValue.fromDouble((double)d);
                    break;
                }
                case 4: {
                    long l = crystalResultSet.getLong(n);
                    if (crystalResultSet.wasNull()) {
                        return null;
                    }
                    if (rSBindingHandle.if == ValueType.int32u && l < 0L) {
                        l &= 0xFFFFFFFFL;
                    }
                    object2 = NumberValue.fromLong((long)l);
                    break;
                }
                case 0: {
                    return null;
                }
                case 5: {
                    boolean bl = crystalResultSet.getMetaData().isSigned(n);
                    long l = 0L;
                    l = bl ? (long)crystalResultSet.getShort(n) : crystalResultSet.getLong(n);
                    if (crystalResultSet.wasNull()) {
                        return null;
                    }
                    if (rSBindingHandle.if == ValueType.int16u && l < 0L) {
                        l &= 0xFFFFL;
                    }
                    object2 = NumberValue.fromLong((long)l);
                    break;
                }
                case -6: {
                    long l = crystalResultSet.getShort(n);
                    if (crystalResultSet.wasNull()) {
                        return null;
                    }
                    if (rSBindingHandle.if == ValueType.int8u && l < 0L) {
                        l &= 0xFFL;
                    }
                    object2 = NumberValue.fromLong((long)l);
                    break;
                }
                case 1: 
                case 12: {
                    int n9;
                    String string = crystalResultSet.getString(n);
                    if (crystalResultSet.wasNull()) {
                        return null;
                    }
                    if (serverDriverType.isMySQL() && crystalResultSet.getMetaData().getColumnDisplaySize(n) > 65535 && (n9 = string.length()) < 65535) {
                        string = string.trim();
                    }
                    object2 = StringValue.fromString((String)string);
                    break;
                }
                case 2005: {
                    Clob clob = crystalResultSet.getClob(n);
                    if (crystalResultSet.wasNull() || clob == null) {
                        return null;
                    }
                    int n10 = (int)clob.length();
                    if (n10 <= 0) {
                        return null;
                    }
                    Reader reader = null;
                    try {
                        reader = clob.getCharacterStream();
                    }
                    catch (Exception exception) {
                        try {
                            InputStream inputStream = clob.getAsciiStream();
                            if (inputStream == null) {
                                return null;
                            }
                            byte[] byArray = new byte[n10 * 2];
                            inputStream.read(byArray);
                            String string = new String(byArray);
                            object2 = StringValue.fromString((String)string);
                            break;
                        }
                        catch (Exception exception2) {
                            return null;
                        }
                    }
                    if (reader == null) {
                        return null;
                    }
                    char[] cArray = new char[n10];
                    try {
                        reader.read(cArray);
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    object2 = StringValue.fromString((String)String.copyValueOf(cArray));
                    break;
                }
                case -1: {
                    if (!serverDriverType.isIBMDB2()) {
                        try {
                            Reader reader = crystalResultSet.getCharacterStream(n);
                            if (reader == null) {
                                return null;
                            }
                            StringBuffer stringBuffer = new StringBuffer();
                            char[] cArray = new char[2048];
                            int n11 = reader.read(cArray);
                            while (n11 > 0) {
                                String string = new String(cArray, 0, n11);
                                stringBuffer.append(string);
                                n11 = reader.read(cArray);
                            }
                            object2 = StringValue.fromString((String)stringBuffer.toString());
                            break;
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                    }
                    try {
                        InputStream inputStream = crystalResultSet.getAsciiStream(n);
                        if (inputStream == null) {
                            return null;
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        byte[] byArray = new byte[2048];
                        int n12 = inputStream.read(byArray);
                        while (n12 > 0) {
                            String string = new String(byArray, 0, n12);
                            stringBuffer.append(string);
                            n12 = inputStream.read(byArray);
                        }
                        object2 = StringValue.fromString((String)stringBuffer.toString());
                        break;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                case 2003: {
                    if (serverDriverType.isPostgreSQL()) {
                        object2 = StringValue.fromString((String)crystalResultSet.getArray(n).toString());
                        break;
                    }
                }
                case 70: 
                case 1111: 
                case 2000: 
                case 2001: 
                case 2002: 
                case 2006: {
                    Object object3 = crystalResultSet.getObject(n);
                    if (object3 == null) {
                        return null;
                    }
                    object2 = StringValue.fromString((String)object3.toString());
                    break;
                }
                case -13: {
                    try {
                        Class<?> clazz = crystalResultSet.getClass();
                        while (clazz.getSuperclass() != null && !clazz.getName().endsWith("OracleResultSet")) {
                            clazz = clazz.getSuperclass();
                        }
                        Method method = clazz.getMethod("getBFILE", Integer.TYPE);
                        Object object4 = method.invoke((Object)crystalResultSet, new Integer(n));
                        if (object4 == null) {
                            return null;
                        }
                        object4.getClass().getMethod("openFile", new Class[0]).invoke(object4, new Object[0]);
                        InputStream inputStream = (InputStream)object4.getClass().getMethod("getBinaryStream", new Class[0]).invoke(object4, new Object[0]);
                        if (inputStream == null) {
                            return null;
                        }
                        Long l = (Long)object4.getClass().getMethod("length", new Class[0]).invoke(object4, new Object[0]);
                        byte[] byArray = new byte[l.intValue()];
                        inputStream.read(byArray);
                        object2 = BinaryValue.fromByteArray((byte[])byArray);
                        inputStream.close();
                        object4.getClass().getMethod("closeFile", new Class[0]).invoke(object4, new Object[0]);
                        break;
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                }
                default: {
                    try {
                        object2 = StringValue.fromString((String)crystalResultSet.getString(n));
                    }
                    catch (SQLException sQLException) {
                        return null;
                    }
                    if (!crystalResultSet.wasNull()) break;
                    return null;
                }
            }
            if (object2 != null && object2 instanceof FormulaValue) {
                return ResultSetReader.a((FormulaValue)object2, rSBindingHandle.if);
            }
            return object2;
        }
        catch (SQLException sQLException) {
            throw new DBException("RCICRC99999999", "", JDBInterfaceResources.getFactory(), "UnexpectedJDBInterfaceError", sQLException);
        }
    }

    static FormulaValue a(FormulaValue formulaValue, ValueType valueType) {
        switch (valueType.value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 18: {
                return FormulaValue.coerce((FormulaValue)formulaValue, (FormulaValueType)FormulaValueType.number);
            }
            case 7: {
                return FormulaValue.coerce((FormulaValue)formulaValue, (FormulaValueType)FormulaValueType.currency);
            }
            case 8: {
                return FormulaValue.coerce((FormulaValue)formulaValue, (FormulaValueType)FormulaValueType.bool);
            }
            case 9: {
                return FormulaValue.coerce((FormulaValue)formulaValue, (FormulaValueType)FormulaValueType.date);
            }
            case 10: {
                return FormulaValue.coerce((FormulaValue)formulaValue, (FormulaValueType)FormulaValueType.time);
            }
            case 15: {
                return FormulaValue.coerce((FormulaValue)formulaValue, (FormulaValueType)FormulaValueType.dateTime);
            }
            case 11: {
                return FormulaValue.coerce((FormulaValue)formulaValue, (FormulaValueType)FormulaValueType.string);
            }
        }
        return formulaValue;
    }

    class ExtendedSQLTypes {
        public static final int ORACLE_BFILE = -13;

        ExtendedSQLTypes() {
        }
    }
}

