/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.io.DataInput;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class TimeValue
extends FormulaValue
implements Comparable {
    public static final int nullCRTime = -1;
    public static final int hoursPerDay = 24;
    public static final int minutesPerHour = 60;
    public static final int secondsPerMinute = 60;
    public static final int secondsPerDay = 86400;
    public static final int millisecondsPerSecond = 1000;
    public static final int nanosecondsPerMillisecond = 1000000;
    public static final long nanosecondsPerSecond = 1000000000L;
    public static final long nanosecondsPerMinute = 60000000000L;
    public static final long nanosecondsPerHour = 3600000000000L;
    public static final long nanosecondsPerDay = 86400000000000L;
    public static final long minTimeInNs = 0L;
    public static final long maxTimeInNs = 86399999999999L;
    public static final TimeValue min = new TimeValue(0L);
    public static final TimeValue max = new TimeValue(86399999999999L);
    public static final TimeValue maxTimeValueInSeconds = new TimeValue(86399000000000L);
    private final long s;

    private TimeValue(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("timeInNs is less than minTimeInNs");
        }
        if (l > 86399999999999L) {
            throw new IllegalArgumentException("timeInNs is greater than maxTimeInNs");
        }
        this.s = l;
    }

    public void store(ValueType valueType, ExtendedDataOutput extendedDataOutput) throws IOException {
        assert (valueType == this.getValueType());
        extendedDataOutput.writeLong(this.s);
    }

    public void storeToArchive(ValueType valueType, IOutputArchive iOutputArchive) throws ArchiveException {
        assert (valueType == this.getValueType());
        iOutputArchive.storeInt64(this.s);
    }

    public static TimeValue Load(DataInput dataInput) throws IOException {
        return TimeValue.fromTimeInNs(dataInput.readLong());
    }

    public static TimeValue LoadFromArchive(IInputArchive iInputArchive) throws ArchiveException {
        return TimeValue.fromTimeInNs(iInputArchive.loadInt64());
    }

    public static int GetMaxEncodedSize() {
        return 8;
    }

    public int getEncodedSizeForArchive(ValueType valueType) {
        assert (valueType == this.getValueType());
        return 4;
    }

    public int getEncodedSize(ValueType valueType) {
        assert (valueType == this.getValueType());
        return TimeValue.GetMaxEncodedSize();
    }

    private static long a(int n, int n2, int n3, long l) {
        return (long)n * 3600000000000L + (long)n2 * 60000000000L + (long)n3 * 1000000000L + l;
    }

    private static long a(int n, int n2, double d) {
        return (long)n * 3600000000000L + (long)n2 * 60000000000L + Math.round(d * 1.0E9);
    }

    public static long NormalizeTimeInNs(long l) {
        boolean bl;
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l - 1L;
        }
        long l2 = l % 86400000000000L;
        return bl ? 86400000000000L - l2 - 1L : l2;
    }

    public static TimeValue now() {
        return TimeValue.fromCalendar(new GregorianCalendar(Locale.US));
    }

    public static TimeValue fromTimeInNs(long l) {
        if (l == TimeValue.min.s) {
            return min;
        }
        if (l == TimeValue.max.s) {
            return max;
        }
        return new TimeValue(l);
    }

    public static TimeValue fromCRTime(int n) {
        if (n == -1) {
            return null;
        }
        return TimeValue.fromTimeInNs((long)n * 1000000000L);
    }

    public static TimeValue fromOleDate(double d) {
        double d2 = Math.abs(d - (double)((int)d));
        return TimeValue.fromTimeInNs(Math.round(d2 * 8.64E13));
    }

    public double getOleDate() {
        return (double)this.s / 8.64E13;
    }

    public static TimeValue fromHMSN(int n, int n2, int n3, long l) {
        if (n < 0 || n >= 24) {
            throw new IllegalArgumentException("hours must be between 0 and 23");
        }
        if (n2 < 0 || n2 >= 60) {
            throw new IllegalArgumentException("minutes must be between 0 and 59");
        }
        if (n3 < 0 || n3 >= 60) {
            throw new IllegalArgumentException("seconds must be between 0 and 59");
        }
        if (l < 0L || l >= 1000000000L) {
            throw new IllegalArgumentException("nanseconds must be between 0 and 999999999");
        }
        return TimeValue.fromTimeInNs(TimeValue.a(n, n2, n3, l));
    }

    public static TimeValue fromHMS(int n, int n2, double d) {
        if (n < 0 || n >= 24) {
            throw new IllegalArgumentException("hours must be between 0 and 23");
        }
        if (n2 < 0 || n2 >= 60) {
            throw new IllegalArgumentException("minutes must be between 0 and 59");
        }
        if (d < 0.0 || d >= 60.0) {
            throw new IllegalArgumentException("seconds must be between 0 and 59");
        }
        return TimeValue.fromTimeInNs(TimeValue.a(n, n2, d));
    }

    public static TimeValue fromCalendar(Calendar calendar) {
        return TimeValue.fromHMSN(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000);
    }

    public long getTimeInNs() {
        return this.s;
    }

    public static int getCRTime(TimeValue timeValue) {
        return timeValue == null ? -1 : timeValue.getCRTime();
    }

    public static int getHours(TimeValue timeValue) {
        return timeValue == null ? 0 : timeValue.getHours();
    }

    public static int getMinutes(TimeValue timeValue) {
        return timeValue == null ? 0 : timeValue.getMinutes();
    }

    public static int getWholeSeconds(TimeValue timeValue) {
        return timeValue == null ? 0 : timeValue.getWholeSeconds();
    }

    public static long getNanoseconds(TimeValue timeValue) {
        return timeValue == null ? 0L : timeValue.getNanoseconds();
    }

    public int getCRTime() {
        return (int)(this.s / 1000000000L);
    }

    public int getHours() {
        return (int)(this.s / 3600000000000L);
    }

    public int getMinutes() {
        return (int)(this.s / 60000000000L % 60L);
    }

    public int getWholeSeconds() {
        return (int)(this.s / 1000000000L % 60L);
    }

    public double getSeconds() {
        return (double)this.s / 1.0E9 % 60.0;
    }

    public long getNanoseconds() {
        return this.s % 1000000000L;
    }

    public double getMilliseconds() {
        return (double)this.s / 1000000.0 % 1000.0;
    }

    public int getWholeMilliseconds() {
        return (int)(this.s / 1000000L % 1000L);
    }

    public ValueType getValueType() {
        return ValueType.time;
    }

    public FormulaValue coerceToTime() {
        return this;
    }

    public FormulaValue coerceToDateTime() {
        return DateTimeValue.fromDateAndTimeValues(null, this);
    }

    public boolean equals(Object object, boolean bl) {
        return object != null && object.getClass() == this.getClass() && ((TimeValue)object).s == this.s;
    }

    public int compareTo(Object object, Comparator comparator) {
        return this.compareTo(object);
    }

    public int hashCode(boolean bl) {
        return (int)(this.s ^ this.s >>> 32);
    }

    public int compareTo(Object object) {
        TimeValue timeValue = (TimeValue)object;
        if (this.s < timeValue.s) {
            return -1;
        }
        if (this.s > timeValue.s) {
            return 1;
        }
        return 0;
    }

    public TimeValue addNumberToTime(double d) {
        return new TimeValue(TimeValue.NormalizeTimeInNs(this.s + Math.round(d * 1.0E9)));
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(2);
        String string = "t(" + numberFormat.format(this.getHours()) + ":" + numberFormat.format(this.getMinutes()) + ":" + numberFormat.format(this.getWholeSeconds());
        numberFormat.setMinimumIntegerDigits(9);
        string = string + "." + numberFormat.format(this.getNanoseconds()) + ")";
        return string;
    }

    public static double To1900Format(TimeValue timeValue) {
        return (double)timeValue.getCRTime() / 86400.0;
    }

    public static TimeValue From1900Format(double d) {
        long l = (long)(d * 8.64E13);
        return new TimeValue(l);
    }

    public Date getJavaDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, this.getHours());
        calendar.set(12, this.getMinutes());
        calendar.set(13, this.getWholeSeconds());
        calendar.set(14, this.getWholeMilliseconds());
        return calendar.getTime();
    }
}

