/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;

public class RAW
extends Datum {
    static final long serialVersionUID = -3298750557928937840L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int hexDigit2Nibble(char hex) throws SQLException {
        try {
            int result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(hex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((result = Character.digit(hex, 16)) == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RAW.logger().log(Level.SEVERE, "         Throwing SQLException: 59Invalid hex digit: " + hex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 59, "Invalid hex digit: " + hex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hexString2Bytes(String hexString) throws SQLException {
        try {
            byte[] bytes;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(hexString));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int len = hexString.length();
            char[] hexChars = new char[len];
            hexString.getChars(0, len, hexChars, 0);
            int i2 = 0;
            int j2 = 0;
            if (len == 0) {
                byte[] __result__ = new byte[]{};
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RAW.logger().log(Level.FINER, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = __result__;
                return byArray;
            }
            if (len % 2 > 0) {
                bytes = new byte[(len + 1) / 2];
                bytes[i2++] = (byte)RAW.hexDigit2Nibble(hexChars[j2++]);
            } else {
                bytes = new byte[len / 2];
            }
            while (i2 < bytes.length) {
                bytes[i2] = (byte)(RAW.hexDigit2Nibble(hexChars[j2++]) << 4 | RAW.hexDigit2Nibble(hexChars[j2++]));
                ++i2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, "         Return: " + bytes);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RAW newRAW(Object obj) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(obj));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RAW result = new RAW(obj);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RAW rAW = result;
            return rAW;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RAW oldRAW(Object obj) throws SQLException {
        try {
            RAW result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(obj));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (obj instanceof String) {
                String s2 = (String)obj;
                byte[] bytes = null;
                try {
                    bytes = s2.getBytes("ISO8859_1");
                }
                catch (UnsupportedEncodingException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            RAW.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 109ISO8859_1 character encoding not found");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 109, "ISO8859_1 character encoding not found");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                result = new RAW(bytes);
            } else {
                result = new RAW(obj);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RAW rAW = result;
            return rAW;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW() {
        block12: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    RAW.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RAW.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW(byte[] raw_bytes) {
        block12: {
            super(raw_bytes);
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    RAW.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RAW.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW(Object val) throws SQLException {
        block21: {
            this();
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RAW.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(val));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (val instanceof byte[]) {
                    this.setShareBytes((byte[])val);
                    break block21;
                }
                if (val instanceof String) {
                    this.setShareBytes(RAW.hexString2Bytes((String)val));
                    break block21;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RAW.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + val);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, val);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toJdbc() throws SQLException {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] __result__ = this.getBytes();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byArray = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConvertibleTo(Class jClass) {
        block28: {
            boolean bl;
            try {
                String class_name;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RAW.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(jClass));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((class_name = jClass.getName()).compareTo("java.lang.String") != 0 && class_name.compareTo("java.io.InputStream") != 0 && class_name.compareTo("java.io.Reader") != 0) break block28;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RAW.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = true;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RAW.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        boolean bl = false;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValue() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String ret = RepConversion.bArray2String(this.getBytes());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader characterStreamValue() throws SQLException {
        CharArrayReader charArrayReader;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int nbytes = (int)this.getLength();
            char[] chars = new char[nbytes * 2];
            byte[] bytes = this.shareBytes();
            DBConversion.RAWBytesToHexChars(bytes, nbytes, chars);
            CharArrayReader ret = new CharArrayReader(chars);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            charArrayReader = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return charArrayReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream asciiStreamValue() throws SQLException {
        ByteArrayInputStream byteArrayInputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int nbytes = (int)this.getLength();
            char[] chars = new char[nbytes * 2];
            byte[] bytes = this.shareBytes();
            DBConversion.RAWBytesToHexChars(bytes, nbytes, chars);
            byte[] buf = new byte[nbytes * 2];
            DBConversion.javaCharsToAsciiBytes(chars, nbytes * 2, buf);
            ByteArrayInputStream ret = new ByteArrayInputStream(buf);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byteArrayInputStream = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream binaryStreamValue() throws SQLException {
        InputStream inputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream __result__ = this.getStream();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            inputStream = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                RAW.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object makeJdbcArray(int arraySize) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[][] __result__ = new byte[arraySize][];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[][] byArrayArray = __result__;
            return byArrayArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.RAW"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

