/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAResource;

public class OracleXAHeteroResource
extends OracleXAResource {
    private int rmid = -1;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAHeteroResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pm_conn) + ", " + OracleLog.argument(xaconn));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.connection = pm_conn;
            this.xaconnection = xaconn;
            if (this.connection == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -7);
                        Object var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new XAException(-7);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int flags) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flags));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (xid == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.start(): XAER_INVAL: xid is null");
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        Object var8_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new XAException(-5);
            }
            int isolFlag = flags & 0xFF00;
            if (((flags &= 0xFFFF00FF) & 0x8200002) != flags) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.start(): XAER_INVAL: invalid flag");
                        Object var10_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_19 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        Object var12_21 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_22 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new XAException(-5);
            }
            if ((isolFlag & 0xFF00) != 0 && isolFlag != 256 && isolFlag != 512 && isolFlag != 1024) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.start():XAER_INVAL: invalid Isolation flag");
                        Object var14_24 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_25 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        Object var16_27 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_28 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new XAException(-5);
            }
            if ((isolFlag & 0xFF00) != 0 && (flags & 0x8200000) != 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.start(): XAER_INVAL: Isolation flags not allowed for JOIN/RESUME");
                        Object var18_30 = null;
                    }
                    catch (Throwable throwable) {
                        Object var18_31 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        Object var20_33 = null;
                    }
                    catch (Throwable throwable) {
                        Object var20_34 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new XAException(-5);
            }
            try {
                this.saveAndAlterAutoCommitModeForGlobalTransaction();
                int formatId = xid.getFormatId();
                byte[] gTrid = xid.getGlobalTransactionId();
                byte[] bQual = xid.getBranchQualifier();
                int status = this.t2cDoXaStart(formatId, gTrid, bQual, this.rmid, flags |= isolFlag, 0);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.start(): return status = " + status);
                        Object var22_36 = null;
                    }
                    catch (Throwable throwable) {
                        Object var22_37 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                this.checkStatus(status);
                this.enterGlobalTxnMode();
            }
            catch (XAException ea) {
                this.restoreAutoCommitModeForGlobalTransaction();
                throw ea;
            }
            Object var24_39 = null;
        }
        catch (Throwable throwable) {
            Object var24_40 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var26_43 = null;
                }
                catch (Throwable throwable2) {
                    Object var26_44 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var26_41 = null;
            }
            catch (Throwable throwable) {
                Object var26_42 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void end(Xid xid, int flag) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            try {
                if (xid == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.end(): XAER_INVAL: xid is null");
                            Object var6_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if (!TRACE || !OracleLog.recursiveEnter()) throw new XAException(-5);
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        Object var8_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                        throw new XAException(-5);
                    }
                }
                int validFlags = 638582786;
                if ((flag & validFlags) != flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.end(): XAER_INVAL: invalid flag");
                            Object var10_17 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_18 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if (!TRACE || !OracleLog.recursiveEnter()) throw new XAException(-5);
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        Object var12_20 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_21 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                        throw new XAException(-5);
                    }
                }
                int formatId = xid.getFormatId();
                byte[] gTrid = xid.getGlobalTransactionId();
                byte[] bQual = xid.getBranchQualifier();
                this.exitGlobalTxnMode();
                int status = this.t2cDoXaEnd(formatId, gTrid, bQual, this.rmid, flag, 0);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.end(): return status = " + status);
                        Object var14_23 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_24 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                this.checkStatus(status);
                Object var16_26 = null;
            }
            catch (Throwable throwable) {
                Object var16_27 = null;
                this.restoreAutoCommitModeForGlobalTransaction();
                throw throwable;
            }
            this.restoreAutoCommitModeForGlobalTransaction();
            Object var18_29 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var18_30 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var20_33 = null;
            }
            catch (Throwable throwable2) {
                Object var20_34 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var20_31 = null;
        }
        catch (Throwable throwable) {
            Object var20_32 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(onePhase));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (xid == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.commit(): XAER_INVAL: xid is null");
                        Object var6_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        Object var8_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new XAException(-5);
            }
            int flags = onePhase ? 0x40000000 : 0;
            int formatId = xid.getFormatId();
            byte[] gTrid = xid.getGlobalTransactionId();
            byte[] bQual = xid.getBranchQualifier();
            int status = this.t2cDoXaCommit(formatId, gTrid, bQual, this.rmid, flags, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.commit(): return status = " + status);
                    Object var10_17 = null;
                }
                catch (Throwable throwable) {
                    Object var10_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkStatus(status);
            Object var12_20 = null;
        }
        catch (Throwable throwable) {
            Object var12_21 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_24 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_22 = null;
            }
            catch (Throwable throwable) {
                Object var14_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (xid == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.prepare(): XAER_INVAL: xid is null");
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new XAException(-5);
            }
            int formatId = xid.getFormatId();
            byte[] gTrid = xid.getGlobalTransactionId();
            byte[] bQual = xid.getBranchQualifier();
            int status = this.t2cDoXaPrepare(formatId, gTrid, bQual, this.rmid, 0, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.prepare(): return status = " + status);
                    Object var9_15 = null;
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (status != 0 && status != 3) {
                this.checkStatus(status);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + status);
                    Object var11_18 = null;
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = status;
            Object var13_21 = null;
        }
        catch (Throwable throwable) {
            Object var13_22 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_25 = null;
                }
                catch (Throwable throwable2) {
                    Object var15_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_23 = null;
            }
            catch (Throwable throwable) {
                Object var15_24 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (xid == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.forget(): XAER_INVAL: xid is null");
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new XAException(-5);
            }
            int formatId = xid.getFormatId();
            byte[] gTrid = xid.getGlobalTransactionId();
            byte[] bQual = xid.getBranchQualifier();
            int status = this.t2cDoXaForget(formatId, gTrid, bQual, this.rmid, 0, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.forget(): return status = " + status);
                    Object var9_14 = null;
                }
                catch (Throwable throwable) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkStatus(status);
            Object var11_17 = null;
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_19 = null;
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (xid == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.rollback(): XAER_INVAL: xid is null");
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new XAException(-5);
            }
            int formatId = xid.getFormatId();
            byte[] gTrid = xid.getGlobalTransactionId();
            byte[] bQual = xid.getBranchQualifier();
            int status = this.t2cDoXaRollback(formatId, gTrid, bQual, this.rmid, 0, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXAHeteroResource.rollback(): return status = " + status);
                    Object var9_14 = null;
                }
                catch (Throwable throwable) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkStatus(status);
            Object var11_17 = null;
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAHeteroResource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_19 = null;
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    private native int t2cDoXaStart(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaEnd(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaCommit(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaPrepare(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaForget(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaRollback(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setRmid(int rmid) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rmid));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.rmid = rmid;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAHeteroResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int getRmid() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rmid);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.rmid;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAHeteroResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static byte[] getSerializedBytes(Xid xid) {
        try {
            byte[] byArray;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(xid));
                    byArray = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                byte[] __result__ = Util.serializeObject(xid);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.FINER, "         Return: " + __result__);
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                byArray = __result__;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.FINER, "         Return: " + null);
                        Object var6_22 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var6_23 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                byte[] byArray2 = null;
                Object var8_11 = null;
                if (!TRACE) return byArray2;
                if (!OracleLog.recursiveEnter()) return byArray2;
                try {}
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleXAHeteroResource.logger().log(Level.FINER, "         Exit");
                Object var10_15 = null;
                OracleLog.recursiveExit();
                return byArray2;
            }
            Object var8_10 = null;
            if (!TRACE) return byArray;
            if (!OracleLog.recursiveEnter()) return byArray;
            try {
                OracleXAHeteroResource.logger().log(Level.FINER, "         Exit");
                Object var10_13 = null;
                OracleLog.recursiveExit();
                return byArray;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_18 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleXAHeteroResource.logger().log(Level.FINER, "         Exit");
            Object var10_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStatus(int status) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(status));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (status != 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + status);
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new XAException(status);
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAHeteroResource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa.client");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXAHeteroResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

