/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4Ctoh;
import oracle.sql.TIMESTAMP;

class T4CTTIaqm {
    static final int ATTR_ORIGINAL_MSGID = 69;
    static final byte ATTR_AGENT_NAME = 64;
    static final byte ATTR_AGENT_ADDRESS = 65;
    static final byte ATTR_AGENT_PROTOCOL = 66;
    static final int AQM_MSG_NO_DELAY = 0;
    static final int AQM_MSG_NO_EXPIRATION = -1;
    static final int AQM_MSGPROP_CORRID_SIZE = 128;
    int aqmpri;
    int aqmdel;
    int aqmexp;
    byte[] aqmcorBytes;
    int aqmcorBytesLength;
    int aqmatt;
    byte[] aqmeqnBytes;
    int aqmeqnBytesLength;
    int aqmsta;
    private byte[] aqmeqtBuffer = new byte[7];
    private int[] retInt = new int[1];
    TIMESTAMP aqmeqt;
    byte[] aqmetiBytes;
    byte[] senderAgentName = null;
    int senderAgentNameLength = 0;
    byte[] senderAgentAddress = null;
    int senderAgentAddressLength = 0;
    byte senderAgentProtocol = 0;
    byte[] originalMsgId;
    T4Ctoh toh;
    int aqmcsn;
    int aqmdsn;
    int aqmflg;
    T4CMAREngine mar;
    T4CConnection connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIaqm(T4CConnection _connection, T4Ctoh _toh) {
        this.toh = _toh;
        this.connection = _connection;
        this.mar = this.connection.mare;
    }

    void initToDefaultValues() {
        this.aqmpri = 0;
        this.aqmdel = 0;
        this.aqmexp = -1;
        this.aqmcorBytes = null;
        this.aqmcorBytesLength = 0;
        this.aqmatt = 0;
        this.aqmeqnBytes = null;
        this.aqmeqnBytesLength = 0;
        this.aqmsta = 0;
        this.aqmeqt = null;
        this.aqmetiBytes = null;
        this.senderAgentName = null;
        this.senderAgentNameLength = 0;
        this.senderAgentAddress = null;
        this.senderAgentAddressLength = 0;
        this.senderAgentProtocol = 0;
        this.originalMsgId = null;
        this.aqmcsn = 0;
        this.aqmdsn = 0;
        this.aqmflg = 0;
    }

    void marshal() throws IOException {
        this.mar.marshalSB4(this.aqmpri);
        this.mar.marshalSB4(this.aqmdel);
        this.mar.marshalSB4(this.aqmexp);
        if (this.aqmcorBytes != null && this.aqmcorBytes.length != 0) {
            this.mar.marshalSWORD(this.aqmcorBytes.length);
            this.mar.marshalCLR(this.aqmcorBytes, 0, this.aqmcorBytes.length);
        } else {
            this.mar.marshalSWORD(0);
        }
        this.mar.marshalSB4(0);
        if (this.aqmeqnBytes != null && this.aqmeqnBytes.length != 0) {
            this.mar.marshalSWORD(this.aqmeqnBytes.length);
            this.mar.marshalCLR(this.aqmeqnBytes, 0, this.aqmeqnBytes.length);
        } else {
            this.mar.marshalSWORD(0);
        }
        this.mar.marshalSB4(this.aqmsta);
        this.mar.marshalSWORD(0);
        if (this.connection.getTTCVersion() >= 3) {
            if (this.aqmetiBytes != null && this.aqmetiBytes.length > 0) {
                this.mar.marshalSWORD(this.aqmetiBytes.length);
                this.mar.marshalCLR(this.aqmetiBytes, 0, this.aqmetiBytes.length);
            } else {
                this.mar.marshalSWORD(0);
            }
        }
        int nbExtentions = 4;
        byte[][] extensionTextValues = new byte[nbExtentions][];
        byte[][] extensionBinaryValues = new byte[nbExtentions][];
        int[] extensionKeywords = new int[nbExtentions];
        extensionTextValues[0] = this.senderAgentName;
        extensionBinaryValues[0] = null;
        extensionKeywords[0] = 64;
        extensionTextValues[1] = this.senderAgentAddress;
        extensionBinaryValues[1] = null;
        extensionKeywords[1] = 65;
        extensionTextValues[2] = null;
        extensionBinaryValues[2] = new byte[1];
        extensionBinaryValues[2][0] = this.senderAgentProtocol;
        extensionKeywords[2] = 66;
        extensionTextValues[3] = null;
        extensionBinaryValues[3] = this.originalMsgId;
        extensionKeywords[3] = 69;
        this.mar.marshalSWORD(nbExtentions);
        this.mar.marshalUB1((short)14);
        this.mar.marshalKPDKV(extensionTextValues, extensionBinaryValues, extensionKeywords);
        if (this.connection.getTTCVersion() >= 3) {
            this.mar.marshalUB4(1L);
            this.toh.init(T4Ctoh.ANYDATA_TOID, 0);
            this.toh.marshal(this.mar);
            this.mar.marshalUB4(0L);
            this.mar.marshalUB4(0L);
            if (this.connection.getTTCVersion() >= 4) {
                this.mar.marshalUB4(0L);
            }
        }
    }

    void receive() throws SQLException, IOException {
        this.aqmpri = this.mar.unmarshalSB4();
        this.aqmdel = this.mar.unmarshalSB4();
        this.aqmexp = this.mar.unmarshalSB4();
        int correlationLength = this.mar.unmarshalSWORD();
        if (correlationLength > 0) {
            this.aqmcorBytes = new byte[correlationLength];
            int[] intAr = new int[1];
            this.mar.unmarshalCLR(this.aqmcorBytes, 0, intAr, this.aqmcorBytes.length);
            this.aqmcorBytesLength = intAr[0];
        } else {
            this.aqmcorBytes = null;
        }
        this.aqmatt = this.mar.unmarshalSB4();
        int exceptionQueueLength = this.mar.unmarshalSWORD();
        if (exceptionQueueLength > 0) {
            this.aqmeqnBytes = new byte[exceptionQueueLength];
            int[] intAr = new int[1];
            this.mar.unmarshalCLR(this.aqmeqnBytes, 0, intAr, this.aqmeqnBytes.length);
            this.aqmeqnBytesLength = intAr[0];
        } else {
            this.aqmeqnBytes = null;
        }
        this.aqmsta = this.mar.unmarshalSB4();
        int enqueueTimeLength = this.mar.unmarshalSB4();
        if (enqueueTimeLength > 0) {
            this.mar.unmarshalCLR(this.aqmeqtBuffer, 0, this.retInt, 7);
            this.aqmeqt = new TIMESTAMP(this.aqmeqtBuffer);
        }
        if (this.connection.getTTCVersion() >= 3) {
            int aqmetil = this.mar.unmarshalSWORD();
            if (aqmetil > 0) {
                this.aqmetiBytes = new byte[aqmetil];
                int[] intAr = new int[1];
                this.mar.unmarshalCLR(this.aqmetiBytes, 0, intAr, this.aqmetiBytes.length);
            } else {
                this.aqmetiBytes = null;
            }
        }
        int nbExtentions = this.mar.unmarshalSWORD();
        this.mar.unmarshalUB1();
        if (nbExtentions > 0) {
            byte[][] extensionTextValues = new byte[nbExtentions][];
            int[] extensionTextValuesLength = new int[nbExtentions];
            byte[][] extensionBinaryValues = new byte[nbExtentions][];
            int[] extensionKeywords = new int[nbExtentions];
            this.mar.unmarshalKPDKV(extensionTextValues, extensionTextValuesLength, extensionBinaryValues, extensionKeywords);
            for (int i2 = 0; i2 < nbExtentions; ++i2) {
                if (extensionKeywords[i2] == 64 && extensionTextValues[i2] != null && extensionTextValuesLength[i2] > 0) {
                    this.senderAgentName = extensionTextValues[i2];
                    this.senderAgentNameLength = extensionTextValuesLength[i2];
                }
                if (extensionKeywords[i2] == 65 && extensionTextValues[i2] != null && extensionTextValuesLength[i2] > 0) {
                    this.senderAgentAddress = extensionTextValues[i2];
                    this.senderAgentAddressLength = extensionTextValuesLength[i2];
                }
                if (extensionKeywords[i2] == 66 && extensionBinaryValues[i2] != null && extensionBinaryValues[i2].length > 0) {
                    this.senderAgentProtocol = extensionBinaryValues[i2][0];
                }
                if (extensionKeywords[i2] != 69 || extensionBinaryValues[i2] == null || extensionBinaryValues[i2].length <= 0) continue;
                this.originalMsgId = extensionBinaryValues[i2];
            }
        }
        if (this.connection.getTTCVersion() >= 3) {
            int aqmuprl = this.mar.unmarshalSWORD();
            this.aqmcsn = (int)this.mar.unmarshalUB4();
            this.aqmdsn = (int)this.mar.unmarshalUB4();
            if (this.connection.getTTCVersion() >= 4) {
                this.aqmflg = (int)this.mar.unmarshalUB4();
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIaqm"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

