/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import oracle.jdbc.driver.T4CSocketOutputStreamWrapper;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;

class T4CSocketInputStreamWrapper
extends NetInputStream {
    static final int MAX_BUFFER_SIZE = 2048;
    NetInputStream is = null;
    T4CSocketOutputStreamWrapper os = null;
    boolean eof = false;
    byte[] buffer = new byte[2048];
    int bIndex = 0;
    int bytesAvailable;

    T4CSocketInputStreamWrapper(NetInputStream _is, T4CSocketOutputStreamWrapper _os) throws IOException {
        this.is = _is;
        this.os = _os;
    }

    public final int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.bytesAvailable < 1) {
            this.readNextPacket();
            if (this.eof) {
                return -1;
            }
        }
        --this.bytesAvailable;
        return this.buffer[this.bIndex++] & 0xFF;
    }

    public final int read(byte[] b2, int offset, int length) throws IOException {
        if (this.eof) {
            return 0;
        }
        if (this.bytesAvailable < length) {
            int bytes2Copy = this.bytesAvailable;
            System.arraycopy(this.buffer, this.bIndex, b2, offset, bytes2Copy);
            this.bIndex += bytes2Copy;
            this.bytesAvailable -= bytes2Copy;
            this.is.read(b2, offset += bytes2Copy, length - bytes2Copy);
        } else {
            System.arraycopy(this.buffer, this.bIndex, b2, offset, length);
            this.bIndex += length;
            this.bytesAvailable -= length;
        }
        return length;
    }

    void readNextPacket() throws IOException {
        this.os.flush();
        int x = this.is.read();
        if (x == -1) {
            this.eof = true;
            return;
        }
        this.buffer[0] = (byte)x;
        this.bytesAvailable = this.is.available() + 1;
        int n2 = this.bytesAvailable = this.bytesAvailable > 2048 ? 2048 : this.bytesAvailable;
        if (this.bytesAvailable > 1) {
            this.is.read(this.buffer, 1, this.bytesAvailable - 1);
        }
        this.bIndex = 0;
    }

    public int readB1() throws IOException {
        return this.read();
    }

    public long readLongLSB(int bufSize) throws IOException {
        long returnValue = 0L;
        boolean negative = false;
        if ((bufSize & 0x80) > 0) {
            bufSize &= 0x7F;
            negative = true;
        }
        int i2 = bufSize;
        int j2 = 0;
        while (i2 > 0) {
            if (this.bytesAvailable < 1) {
                this.readNextPacket();
            }
            returnValue |= ((long)this.buffer[this.bIndex++] & 0xFFL) << 8 * j2;
            --this.bytesAvailable;
            --i2;
            ++j2;
        }
        return (long)(negative ? -1 : 1) * returnValue;
    }

    public long readLongMSB(int bufSize) throws IOException {
        long returnValue = 0L;
        boolean negative = false;
        if ((bufSize & 0x80) > 0) {
            bufSize &= 0x7F;
            negative = true;
        }
        for (int i2 = bufSize; i2 > 0; --i2) {
            if (this.bytesAvailable < 1) {
                this.readNextPacket();
            }
            returnValue |= ((long)this.buffer[this.bIndex++] & 0xFFL) << 8 * (i2 - 1);
            --this.bytesAvailable;
        }
        return (long)(negative ? -1 : 1) * returnValue;
    }

    public boolean readZeroCopyIO(byte[] userBuffer, int offset, int[] bytesRead) throws IOException, NetException, BreakNetException {
        this.os.flush();
        return this.is.readZeroCopyIO(userBuffer, offset, bytesRead);
    }
}

