/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.OracleConnection;

class ResultSetUtil {
    static final int[][] allRsetTypes = new int[][]{{0, 0}, {1003, 1007}, {1003, 1008}, {1004, 1007}, {1004, 1008}, {1005, 1007}, {1005, 1008}};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    ResultSetUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static OracleResultSet createScrollResultSet(ScrollRsetStatement owner, OracleResultSet referencedRset, int rsetType) throws SQLException {
        try {
            BaseResultSet baseResultSet;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(owner) + ", " + OracleLog.argument(referencedRset) + ", " + OracleLog.argument(rsetType));
                    baseResultSet = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            switch (rsetType) {
                case 1: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ResultSetUtil.logger().log(Level.FINER, "         Return: " + referencedRset);
                            Object var6_10 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var6_11 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    OracleResultSet oracleResultSet = referencedRset;
                    Object var20_18 = null;
                    if (!TRACE) return oracleResultSet;
                    if (!OracleLog.recursiveEnter()) return oracleResultSet;
                    try {
                        ResultSetUtil.logger().log(Level.FINER, "         Exit");
                        Object var22_25 = null;
                        OracleLog.recursiveExit();
                        return oracleResultSet;
                    }
                    catch (Throwable throwable) {
                        Object var22_26 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                case 2: {
                    UpdatableResultSet __result__ = new UpdatableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                            Object var8_46 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var8_47 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    baseResultSet = __result__;
                    Object var20_19 = null;
                    if (!TRACE) return baseResultSet;
                    if (!OracleLog.recursiveEnter()) return baseResultSet;
                    try {}
                    catch (Throwable throwable) {
                        Object var22_28 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    ResultSetUtil.logger().log(Level.FINER, "         Exit");
                    Object var22_27 = null;
                    OracleLog.recursiveExit();
                    return baseResultSet;
                }
                case 3: {
                    ScrollableResultSet __result__ = new ScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                            Object var10_49 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var10_50 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    baseResultSet = __result__;
                    Object var20_20 = null;
                    if (!TRACE) return baseResultSet;
                    if (!OracleLog.recursiveEnter()) return baseResultSet;
                    try {}
                    catch (Throwable throwable) {
                        Object var22_30 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    ResultSetUtil.logger().log(Level.FINER, "         Exit");
                    Object var22_29 = null;
                    OracleLog.recursiveExit();
                    return baseResultSet;
                }
                case 4: {
                    ScrollableResultSet _rset = new ScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    BaseResultSet __result__ = new UpdatableResultSet(owner, _rset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                            Object var12_52 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var12_53 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    BaseResultSet baseResultSet2 = __result__;
                    Object var20_21 = null;
                    if (!TRACE) return baseResultSet2;
                    if (!OracleLog.recursiveEnter()) return baseResultSet2;
                    try {}
                    catch (Throwable throwable) {
                        Object var22_32 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    ResultSetUtil.logger().log(Level.FINER, "         Exit");
                    Object var22_31 = null;
                    OracleLog.recursiveExit();
                    return baseResultSet2;
                }
                case 5: {
                    BaseResultSet __result__ = new SensitiveScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                            Object var14_55 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var14_56 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SensitiveScrollableResultSet sensitiveScrollableResultSet = __result__;
                    Object var20_22 = null;
                    if (!TRACE) return sensitiveScrollableResultSet;
                    if (!OracleLog.recursiveEnter()) return sensitiveScrollableResultSet;
                    try {}
                    catch (Throwable throwable) {
                        Object var22_34 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    ResultSetUtil.logger().log(Level.FINER, "         Exit");
                    Object var22_33 = null;
                    OracleLog.recursiveExit();
                    return sensitiveScrollableResultSet;
                }
                case 6: {
                    SensitiveScrollableResultSet _rset1 = new SensitiveScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    UpdatableResultSet __result__ = new UpdatableResultSet(owner, _rset1, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                            Object var16_58 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var16_59 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    UpdatableResultSet updatableResultSet = __result__;
                    Object var20_23 = null;
                    if (!TRACE) return updatableResultSet;
                    if (!OracleLog.recursiveEnter()) return updatableResultSet;
                    try {}
                    catch (Throwable throwable) {
                        Object var22_36 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    ResultSetUtil.logger().log(Level.FINER, "         Exit");
                    Object var22_35 = null;
                    OracleLog.recursiveExit();
                    return updatableResultSet;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 23" + null);
                    Object var18_61 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var18_62 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 23, null);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var22_38 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            ResultSetUtil.logger().log(Level.FINER, "         Exit");
            Object var22_37 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getScrollType(int typeCode) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(typeCode));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = allRsetTypes[typeCode][0];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ResultSetUtil.logger().log(Level.FINER, "         Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getUpdateConcurrency(int typeCode) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(typeCode));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = allRsetTypes[typeCode][1];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ResultSetUtil.logger().log(Level.FINER, "         Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static int getRsetTypeCode(int scrollType, int updateConcurrency) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            for (int i2 = 0; i2 < allRsetTypes.length; ++i2) {
                if (allRsetTypes[i2][0] != scrollType || allRsetTypes[i2][1] != updateConcurrency) continue;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ResultSetUtil.logger().log(Level.FINER, "         Return: " + i2);
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                int n2 = i2;
                Object var9_11 = null;
                if (!TRACE) return n2;
                if (!OracleLog.recursiveEnter()) return n2;
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit");
                    Object var11_13 = null;
                    OracleLog.recursiveExit();
                    return n2;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 68");
                    Object var7_19 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 68);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            ResultSetUtil.logger().log(Level.FINER, "         Exit");
            Object var11_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean needIdentifier(int typeCode) throws SQLException {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = __result__ = typeCode != 1 && typeCode != 3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ResultSetUtil.logger().log(Level.FINER, "         Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean needIdentifier(int type, int concur) throws SQLException {
        try {
            if (ResultSetUtil.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                    var3_2 = null;
                }
                catch (Throwable var2_5) {
                    var3_3 = null;
                    OracleLog.recursiveExit();
                    throw var2_5;
                }
                OracleLog.recursiveExit();
            }
            __result__ = ResultSetUtil.needIdentifier(ResultSetUtil.getRsetTypeCode(type, concur));
            if (ResultSetUtil.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    var5_7 = null;
                }
                catch (Throwable var4_9) {
                    var5_8 = null;
                    OracleLog.recursiveExit();
                    throw var4_9;
                }
                OracleLog.recursiveExit();
            }
            var3_4 = __result__;
            var7_10 = null;
            if (ResultSetUtil.TRACE == false) return var3_4;
            ** GOTO lbl47
        }
        catch (Throwable var6_18) {
            var7_11 = null;
            if (ResultSetUtil.TRACE == false) throw var6_18;
            if (OracleLog.recursiveEnter() == false) throw var6_18;
            try {
                ResultSetUtil.logger().log(Level.FINER, "         Exit");
                var9_14 = null;
            }
            catch (Throwable var8_17) {
                var9_15 = null;
                OracleLog.recursiveExit();
                throw var8_17;
            }
lbl47:
            // 1 sources

            if (OracleLog.recursiveEnter() == false) return var3_4;
            try {}
            catch (Throwable var8_16) {
                var9_13 = null;
                OracleLog.recursiveExit();
                throw var8_16;
            }
            ResultSetUtil.logger().log(Level.FINER, "         Exit");
            var9_12 = null;
            OracleLog.recursiveExit();
            return var3_4;
            OracleLog.recursiveExit();
            throw var6_18;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean needCache(int typeCode) throws SQLException {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = __result__ = typeCode >= 3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var6_9 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                ResultSetUtil.logger().log(Level.FINER, "         Exit");
                Object var8_13 = null;
            }
            catch (Throwable throwable2) {
                Object var8_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            ResultSetUtil.logger().log(Level.FINER, "         Exit");
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean needCache(int type, int concur) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean __result__ = ResultSetUtil.needCache(ResultSetUtil.getRsetTypeCode(type, concur));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ResultSetUtil.logger().log(Level.FINER, "         Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    static boolean supportRefreshRow(int typeCode) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean supportRefreshRow(int type, int concur) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean __result__ = ResultSetUtil.supportRefreshRow(ResultSetUtil.getRsetTypeCode(type, concur));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var7_10 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                ResultSetUtil.logger().log(Level.FINER, "         Exit");
                Object var9_14 = null;
            }
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            ResultSetUtil.logger().log(Level.FINER, "         Exit");
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * Exception decompiling
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ResultSetUtil"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

