/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;

abstract class OracleTimeout {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OracleTimeout() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OracleTimeout newTimeout(String name) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeout.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleTimeoutThreadPerVM instance = new OracleTimeoutThreadPerVM(name);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeout.logger().log(Level.FINER, "         Return: " + instance);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM = instance;
            return oracleTimeoutThreadPerVM;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeout.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    abstract void setTimeout(long var1, OracleStatement var3) throws SQLException;

    abstract void cancelTimeout() throws SQLException;

    abstract void close() throws SQLException;

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleTimeout"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

