/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.plist;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.plist.ParseException;
import org.apache.commons.configuration.plist.PropertyListConfiguration;
import org.apache.commons.configuration.plist.PropertyListParserConstants;
import org.apache.commons.configuration.plist.PropertyListParserTokenManager;
import org.apache.commons.configuration.plist.SimpleCharStream;
import org.apache.commons.configuration.plist.Token;
import org.apache.commons.lang.StringUtils;

class PropertyListParser
implements PropertyListParserConstants {
    public PropertyListParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[6];
    private static int[] jj_la1_0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    protected String removeQuotes(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("\"") && s.endsWith("\"") && s.length() >= 2) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    protected String unescapeQuotes(String s) {
        return StringUtils.replace((String)s, (String)"\\\"", (String)"\"");
    }

    protected byte[] filterData(String s) throws ParseException {
        if (s == null) {
            return null;
        }
        if (s.startsWith("<") && s.endsWith(">") && s.length() >= 2) {
            s = s.substring(1, s.length() - 1);
        }
        if ((s = StringUtils.replaceChars((String)s, (String)" \t\n\r", (String)"")).length() % 2 != 0) {
            s = "0" + s;
        }
        try {
            return Hex.decodeHex((char[])s.toCharArray());
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
    }

    public final PropertyListConfiguration parse() throws ParseException {
        PropertyListConfiguration configuration = null;
        configuration = this.Dictionary();
        this.jj_consume_token(0);
        return configuration;
    }

    public final PropertyListConfiguration Dictionary() throws ParseException {
        PropertyListConfiguration configuration = new PropertyListConfiguration();
        ArrayList<HierarchicalConfiguration.Node> children = new ArrayList<HierarchicalConfiguration.Node>();
        HierarchicalConfiguration.Node child = null;
        this.jj_consume_token(8);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            child = this.Property();
            if (child.getValue() instanceof HierarchicalConfiguration) {
                HierarchicalConfiguration conf = (HierarchicalConfiguration)child.getValue();
                HierarchicalConfiguration.Node root = conf.getRoot();
                root.setName(child.getName());
                children.add(root);
                continue;
            }
            children.add(child);
        }
        this.jj_consume_token(9);
        int i = 0;
        while (i < children.size()) {
            child = (HierarchicalConfiguration.Node)children.get(i);
            configuration.getRoot().addChild(child);
            ++i;
        }
        return configuration;
    }

    public final HierarchicalConfiguration.Node Property() throws ParseException {
        HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node();
        String key = this.String();
        node.setName(key);
        this.jj_consume_token(11);
        Object value = this.Element();
        node.setValue(value);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        return node;
    }

    public final Object Element() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                return this.Array();
            }
            case 8: {
                return this.Dictionary();
            }
            case 19: 
            case 20: {
                return this.String();
            }
            case 18: {
                return this.Data();
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List Array() throws ParseException {
        ArrayList<Object> list = new ArrayList<Object>();
        Object element = null;
        this.jj_consume_token(5);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 8: 
            case 18: 
            case 19: 
            case 20: {
                element = this.Element();
                list.add(element);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(7);
                    element = this.Element();
                    list.add(element);
                }
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        this.jj_consume_token(6);
        return list;
    }

    public final String String() throws ParseException {
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                token = this.jj_consume_token(20);
                return this.unescapeQuotes(this.removeQuotes(token.image));
            }
            case 19: {
                token = this.jj_consume_token(19);
                return token.image;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final byte[] Data() throws ParseException {
        Token token = this.jj_consume_token(18);
        return this.filterData(token.image);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0x180000, 1024, 1835296, 128, 1835296, 0x180000};
    }

    public PropertyListParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new PropertyListParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public PropertyListParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new PropertyListParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[22];
        int i = 0;
        while (i < 22) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i2 = 0;
        while (i2 < 6) {
            if (this.jj_la1[i2] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i2] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 22) {
            if (la1tokens[i3]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i3;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i3;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i4 = 0;
        while (i4 < this.jj_expentries.size()) {
            exptokseq[i4] = (int[])this.jj_expentries.elementAt(i4);
            ++i4;
        }
        return new ParseException(this.token, exptokseq, PropertyListParserConstants.tokenImage);
    }

    static {
        PropertyListParser.jj_la1_0();
    }
}

