/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.sdk.occa.report.definition;

import com.crystaldecisions12.client.helper.CloneUtil;
import com.crystaldecisions12.client.helper.XMLSerializationHelper;
import com.crystaldecisions12.sdk.occa.report.definition.FontColor;
import com.crystaldecisions12.sdk.occa.report.definition.IFontColor;
import com.crystaldecisions12.sdk.occa.report.definition.IParagraph;
import com.crystaldecisions12.sdk.occa.report.definition.IParagraphElement;
import com.crystaldecisions12.sdk.occa.report.definition.IParagraphFieldElement;
import com.crystaldecisions12.sdk.occa.report.definition.IParagraphTextElement;
import com.crystaldecisions12.sdk.occa.report.definition.ITextObject;
import com.crystaldecisions12.sdk.occa.report.definition.Paragraph;
import com.crystaldecisions12.sdk.occa.report.definition.ParagraphElements;
import com.crystaldecisions12.sdk.occa.report.definition.ParagraphTextElement;
import com.crystaldecisions12.sdk.occa.report.definition.Paragraphs;
import com.crystaldecisions12.sdk.occa.report.definition.ReadingOrder;
import com.crystaldecisions12.sdk.occa.report.definition.ReportObject;
import com.crystaldecisions12.sdk.occa.report.lib.IClone;
import com.crystaldecisions12.sdk.occa.report.lib.ReportObjectKind;
import com.crystaldecisions12.xml.serialization.ClassFactory;
import com.crystaldecisions12.xml.serialization.IXMLSerializable;
import com.crystaldecisions12.xml.serialization.XMLConverter;
import com.crystaldecisions12.xml.serialization.XMLSerializationContext;
import com.crystaldecisions12.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;

public class TextObject
extends ReportObject
implements ITextObject,
IClone {
    private IFontColor lo = null;
    private Paragraphs lm = null;
    private int lt = 0;
    private ReadingOrder ln = ReadingOrder.leftToRight;
    private boolean lx = false;
    private boolean ls = false;
    private static final String lp = "FontColor";
    private static final String lw = "Paragraphs";
    private static final String lr = "MaxNumberOfLines";
    private static final String lu = "ReadingOrder";
    private static final String lq = "EnableSuppressIfDuplicated";
    private static final String lv = "SuppressEmbeddedFieldBlankLines";

    public TextObject(ITextObject iTextObject) {
        this();
        iTextObject.copyTo(this, true);
    }

    public TextObject() {
        this.a(ReportObjectKind.text);
        this.setWidth(1440);
        this.setHeight(200);
    }

    public TextObject(String string) {
        this.a(ReportObjectKind.text);
        this.setWidth(1440);
        this.setHeight(200);
        Paragraphs paragraphs = this.getParagraphs();
        Paragraph paragraph = new Paragraph();
        paragraphs.add(paragraph);
        ParagraphElements paragraphElements = paragraph.getParagraphElements();
        ParagraphTextElement paragraphTextElement = new ParagraphTextElement();
        paragraphElements.add(paragraphTextElement);
        paragraphTextElement.setText(string);
    }

    public Object clone(boolean bl2) {
        TextObject textObject = new TextObject();
        this.copyTo(textObject, bl2);
        return textObject;
    }

    public void copyTo(Object object, boolean bl2) {
        super.copyTo(object, bl2);
        if (!(object instanceof ITextObject)) {
            throw new ClassCastException();
        }
        ITextObject iTextObject = (ITextObject)object;
        iTextObject.setMaxNumberOfLines(this.lt);
        iTextObject.setReadingOrder(this.ln);
        if (this.lo != null && bl2) {
            iTextObject.setFontColor((IFontColor)this.lo.clone(bl2));
        } else {
            iTextObject.setFontColor(this.lo);
        }
        if (this.lm != null && bl2) {
            iTextObject.setParagraphs((Paragraphs)this.lm.clone(bl2));
        } else {
            iTextObject.setParagraphs(this.lm);
        }
        iTextObject.setEnableSuppressIfDuplicated(this.lx);
        iTextObject.setSuppressEmbeddedFieldBlankLines(this.ls);
    }

    public Object createMember(String string, Attributes attributes, XMLSerializationContext xMLSerializationContext, Map map, boolean[] blArray) {
        Object object = null;
        if (string.equals(lw)) {
            object = ClassFactory.createObject(attributes, xMLSerializationContext, blArray);
            if (object != null) {
                this.lm = (Paragraphs)object;
            }
        } else if (string.equals(lp)) {
            object = ClassFactory.createObject(attributes, xMLSerializationContext, blArray);
            if (object != null) {
                this.lo = (FontColor)object;
            }
        } else {
            return super.createMember(string, attributes, xMLSerializationContext, map, blArray);
        }
        return object;
    }

    public void endElement(String string, Map map) {
    }

    public ReadingOrder getReadingOrder() {
        if (this.lm == null || this.lm.size() == 0) {
            return this.ln;
        }
        return this.lm.getParagraph(0).getReadingOrder();
    }

    public IFontColor getFontColor() {
        if (this.lo == null) {
            this.lo = new FontColor();
        }
        if (this.lm == null || this.lm.size() == 0) {
            return this.lo;
        }
        return this.lm.getParagraph(0).getFontColor();
    }

    public int getMaxNumberOfLines() {
        return this.lt;
    }

    public Paragraphs getParagraphs() {
        if (this.lm == null) {
            this.lm = new Paragraphs();
        }
        return this.lm;
    }

    public String getText() {
        if (this.lm == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.lm.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IParagraph iParagraph = this.lm.getParagraph(i2);
            ParagraphElements paragraphElements = iParagraph.getParagraphElements();
            int n3 = paragraphElements.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                IParagraphElement iParagraphElement;
                IParagraphElement iParagraphElement2 = paragraphElements.getParagraphElement(i3);
                if (iParagraphElement2 instanceof IParagraphTextElement) {
                    iParagraphElement = (IParagraphTextElement)iParagraphElement2;
                    if (iParagraphElement.getText() == null) continue;
                    stringBuilder.append(iParagraphElement.getText());
                    continue;
                }
                if (!(iParagraphElement2 instanceof IParagraphFieldElement) || (iParagraphElement = (IParagraphFieldElement)iParagraphElement2).getDataSource() == null) continue;
                stringBuilder.append(iParagraphElement.getDataSource());
            }
        }
        return stringBuilder.toString();
    }

    public boolean getEnableSuppressIfDuplicated() {
        return this.lx;
    }

    public boolean getSuppressEmbeddedFieldBlankLines() {
        return this.ls;
    }

    public boolean hasContent(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ITextObject)) {
            return false;
        }
        ITextObject iTextObject = (ITextObject)object;
        if (!super.hasContent(iTextObject)) {
            return false;
        }
        if (this.ls != iTextObject.getSuppressEmbeddedFieldBlankLines()) {
            return false;
        }
        if (this.lt != iTextObject.getMaxNumberOfLines()) {
            return false;
        }
        if (!CloneUtil.hasContent(this.getParagraphs(), iTextObject.getParagraphs())) {
            return false;
        }
        if (this.getReadingOrder() != iTextObject.getReadingOrder()) {
            return false;
        }
        if (this.lx != iTextObject.getEnableSuppressIfDuplicated()) {
            return false;
        }
        return CloneUtil.hasContent(this.getFontColor(), iTextObject.getFontColor());
    }

    public void readElement(String string, String string2, Attributes attributes, Map map) {
        super.readElement(string, string2, attributes, map);
        if (string.equals(lr)) {
            this.lt = XMLConverter.getInt(string2);
        } else if (string.equals(lq)) {
            this.lx = XMLConverter.getBooleanValue(string2);
        } else if (string.equals(lv)) {
            this.ls = XMLConverter.getBooleanValue(string2);
        } else if (string.equals(lu)) {
            this.ln = ReadingOrder.from_string(string2);
        }
    }

    public void save(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        String string = XMLConverter.getXMLFromClassName(this.getClass().getName());
        Properties properties = XMLSerializationHelper.getHeaderAttributes(string);
        xMLWriter.writeStartElement(string, properties);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement(string);
    }

    public void save(XMLWriter xMLWriter, String string, XMLSerializationContext xMLSerializationContext) throws IOException {
        xMLWriter.writeStartObjectElement(string, "2", this, xMLSerializationContext);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement(string);
    }

    public void saveContents(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        super.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeIntElement(lr, this.lt, null);
        xMLWriter.writeObjectElement(this.lm, lw, xMLSerializationContext);
        xMLWriter.writeBooleanElement(lq, this.lx, null);
        xMLWriter.writeBooleanElement(lv, this.ls, null);
        xMLWriter.writeObjectElement((IXMLSerializable)((Object)this.lo), lp, xMLSerializationContext);
        xMLWriter.writeEnumElement(lu, this.ln, null);
    }

    public void setFontColor(IFontColor iFontColor) {
        this.lo = iFontColor;
        if (this.lm != null) {
            int n2 = this.lm.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                IFontColor iFontColor2 = null;
                if (iFontColor != null) {
                    iFontColor2 = (IFontColor)iFontColor.clone(true);
                }
                this.lm.getParagraph(i2).setFontColor(iFontColor2);
            }
        }
    }

    public void setMaxNumberOfLines(int n2) {
        this.lt = n2;
    }

    public void setReadingOrder(ReadingOrder readingOrder) {
        this.ln = readingOrder;
        if (this.lm != null) {
            int n2 = this.lm.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.lm.getParagraph(i2).setReadingOrder(readingOrder);
            }
        }
    }

    public void setParagraphs(Paragraphs paragraphs) {
        this.lm = paragraphs;
    }

    public void setEnableSuppressIfDuplicated(boolean bl2) {
        this.lx = bl2;
    }

    public void setSuppressEmbeddedFieldBlankLines(boolean bl2) {
        this.ls = bl2;
    }

    public void startElement(String string, Map map, Attributes attributes) {
    }
}

