/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.asserts.CrystalAssert;
import com.crystaldecisions12.reports.common.value.CrystalValue;
import com.crystaldecisions12.reports.common.value.DateValue;
import com.crystaldecisions12.reports.common.value.FormatterCache;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.TimeValue;
import com.crystaldecisions12.reports.common.value.ValueType;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DateTimeValue
extends FormulaValue
implements Comparable {
    private final DateValue case;
    private final TimeValue char;

    private DateTimeValue(DateValue dateValue, TimeValue timeValue) {
        this.case = dateValue;
        this.char = timeValue;
    }

    public static DateTimeValue Normalize(int n2, long l2) {
        boolean bl2;
        if (l2 >= 0L && l2 < 86400000000000L) {
            return new DateTimeValue(DateValue.fromCRDate(n2), TimeValue.fromTimeInNs(l2));
        }
        boolean bl3 = bl2 = l2 < 0L;
        if (bl2) {
            l2 = -l2 - 1L;
        }
        int n3 = (int)(l2 / 86400000000000L);
        long l3 = l2 % 86400000000000L;
        if (bl2) {
            n2 -= n3 + 1;
            l2 = 86400000000000L - l3 - 1L;
        } else {
            n2 += n3;
            l2 = l3;
        }
        return new DateTimeValue(DateValue.fromCRDate(n2), TimeValue.fromTimeInNs(l2));
    }

    public static DateTimeValue now() {
        return DateTimeValue.fromCalendar(new GregorianCalendar(Locale.US));
    }

    public static DateTimeValue fromDateAndTimeValues(DateValue dateValue, TimeValue timeValue) {
        if (dateValue == null && timeValue == null) {
            return null;
        }
        return new DateTimeValue(dateValue, timeValue);
    }

    public static DateTimeValue fromDateValue(DateValue dateValue) {
        if (dateValue == null) {
            return null;
        }
        return new DateTimeValue(dateValue, null);
    }

    public static DateTimeValue fromCalendar(Calendar calendar) {
        return DateTimeValue.fromDateAndTimeValues(DateValue.fromCalendar(calendar), TimeValue.fromCalendar(calendar));
    }

    public static DateTimeValue fromOleDate(double d10) {
        return DateTimeValue.fromDateAndTimeValues(DateValue.fromOleDate(d10), TimeValue.fromOleDate(d10));
    }

    public FormulaValue coerceToDate() {
        return this.getDateValue();
    }

    public FormulaValue coerceToTime() {
        return this.getTimeValue();
    }

    public FormulaValue coerceToDateTime() {
        return this;
    }

    public double getOleDate() {
        double d10 = this.case.getOleDate();
        double d11 = this.char.getOleDate();
        return d10 >= 0.0 ? d10 + d11 : d10 - d11;
    }

    public DateValue getDateValue() {
        return this.case;
    }

    public TimeValue getTimeValue() {
        return this.char;
    }

    public ValueType getValueType() {
        return ValueType.char;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + (this.case == null ? 0 : this.case.hashCode());
        n2 = 37 * n2 + (this.char == null ? 0 : this.char.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object, Comparator comparator) {
        return this.compareTo(object);
    }

    public int compareTo(Object object) {
        DateTimeValue dateTimeValue = (DateTimeValue)object;
        if (this.case == null && dateTimeValue.getDateValue() == null) {
            return 0;
        }
        if (this.case == null) {
            return -1;
        }
        int n2 = this.case.compareTo(dateTimeValue.case);
        return n2 != 0 ? n2 : this.char.compareTo(dateTimeValue.char);
    }

    public DateTimeValue addNumberToDateTime(double d10) {
        int n2 = (int)d10;
        double d11 = d10 - (double)n2;
        long l2 = Math.round(d11 * 8.64E13);
        return DateTimeValue.Normalize(this.case.getCRDate() + n2, this.char.getTimeInNs() + l2);
    }

    public String toString() {
        return "dt(" + this.case + "," + this.char + ")";
    }

    public static double To1900Format(DateTimeValue dateTimeValue) {
        if (dateTimeValue.getDateValue().getCRDate() == -1 && dateTimeValue.getTimeValue().getCRTime() == -1) {
            return 1.0;
        }
        double d10 = DateValue.To1900Format(dateTimeValue.getDateValue());
        double d11 = TimeValue.To1900Format(dateTimeValue.getTimeValue());
        CrystalAssert.a(d11 < 1.0);
        if (d10 < 0.0) {
            d11 = -d11;
        }
        return d10 + d11;
    }

    public Date getJavaDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(this.case.getYear(), this.case.getMonth() - 1, this.case.getDay(), this.char == null ? 0 : this.char.getHours(), this.char == null ? 0 : this.char.getMinutes(), this.char == null ? 0 : this.char.getWholeSeconds());
        return calendar.getTime();
    }

    public boolean crEquals(DateTimeValue dateTimeValue) {
        if (dateTimeValue == null) {
            return false;
        }
        return this.getDateValue().equals(dateTimeValue.getDateValue()) && this.getTimeValue().getCRTime() == dateTimeValue.getTimeValue().getCRTime();
    }

    public String toValueString(Locale locale) {
        DateValue dateValue = null;
        TimeValue timeValue = null;
        dateValue = this.getDateValue();
        timeValue = this.getTimeValue();
        com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance((Locale)locale);
        calendar.set(DateValue.getYear(dateValue), DateValue.getMonth(dateValue) - 1, DateValue.getDay(dateValue), TimeValue.getHours(timeValue), TimeValue.getMinutes(timeValue), TimeValue.getWholeSeconds(timeValue));
        calendar.set(14, (int)(TimeValue.getNanoseconds(timeValue) / 1000000L));
        return FormatterCache.a(locale).format((Object)calendar);
    }

    public static String toDateTimeValueString(DateTimeValue dateTimeValue, Locale locale) {
        if (dateTimeValue != null) {
            return dateTimeValue.toValueString(locale);
        }
        com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance((Locale)locale);
        calendar.set(DateValue.getYear(null), DateValue.getMonth(null) - 1, DateValue.getDay(null), TimeValue.getHours(null), TimeValue.getMinutes(null), TimeValue.getWholeSeconds(null));
        calendar.set(14, (int)(TimeValue.getNanoseconds(null) / 1000000L));
        return FormatterCache.a(locale).format((Object)calendar);
    }

    public static CrystalValue fromFormattedString(String string) {
        if (!string.startsWith("DateTime(") || !string.endsWith(")")) {
            CrystalAssert.a(false);
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.substring(9, string.length() - 1), ",");
        if (stringTokenizer.countTokens() != 6) {
            CrystalAssert.a(false);
            return null;
        }
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        int n6 = Integer.parseInt(stringTokenizer.nextToken());
        int n7 = Integer.parseInt(stringTokenizer.nextToken());
        DateValue dateValue = DateValue.fromYMD(n2, n3, n4);
        TimeValue timeValue = TimeValue.fromHMS(n5, n6, n7);
        return DateTimeValue.fromDateAndTimeValues(dateValue, timeValue);
    }

    public static boolean Equals(DateTimeValue dateTimeValue, DateTimeValue dateTimeValue2) {
        if (dateTimeValue == null || dateTimeValue2 == null) {
            return false;
        }
        boolean bl2 = DateValue.Equals(dateTimeValue.case, dateTimeValue2.case);
        boolean bl3 = TimeValue.Equals(dateTimeValue.char, dateTimeValue2.char);
        return bl2 && bl3;
    }

    public String toValueString() {
        DateValue dateValue = null;
        TimeValue timeValue = null;
        dateValue = this.getDateValue();
        timeValue = this.getTimeValue();
        com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance((Locale)Locale.US);
        calendar.set(DateValue.getYear(dateValue), DateValue.getMonth(dateValue) - 1, DateValue.getDay(dateValue), TimeValue.getHours(timeValue), TimeValue.getMinutes(timeValue), TimeValue.getWholeSeconds(timeValue));
        calendar.set(14, (int)(TimeValue.getNanoseconds(timeValue) / 1000000L));
        DateFormat dateFormat = FormatterCache.a(Locale.US);
        ((SimpleDateFormat)dateFormat).applyLocalizedPattern("'DateTime('yyyy','MM','dd','HH','mm','ss')'");
        return dateFormat.format((Object)calendar);
    }
}

