/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.report.lib;

import com.crystaldecisions.sdk.occa.report.lib.ArrayListMerger;
import com.crystaldecisions.sdk.occa.report.lib.ClonableList;
import com.crystaldecisions.sdk.occa.report.lib.ControllableHelper;
import com.crystaldecisions.sdk.occa.report.lib.ControllableMixin;
import com.crystaldecisions.sdk.occa.report.lib.IChange;
import com.crystaldecisions.sdk.occa.report.lib.IClone;
import com.crystaldecisions.sdk.occa.report.lib.IControllable;
import com.crystaldecisions.sdk.occa.report.lib.IMemberVisitor;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKException;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKRuntimeException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControllableList<E>
extends ClonableList<E>
implements IControllable {
    protected ControllableMixin m_controllableMixin = new ControllableMixin(this);
    private final AbstractList<E> innerList = new AbstractList<E>(){

        @Override
        public E get(int index) {
            return ControllableList.this.get(index);
        }

        @Override
        public int size() {
            return ControllableList.this.size();
        }

        @Override
        public void add(int index, E element) {
            ControllableList.this.add(index, element);
        }

        @Override
        public E remove(int index) {
            return ControllableList.this.remove(index);
        }

        @Override
        public E set(int index, E element) {
            return ControllableList.this.set(index, element);
        }
    };

    protected abstract void doControllerAdd(int var1, E var2) throws ReportSDKException;

    protected abstract void doControllerRemove(int var1) throws ReportSDKException;

    protected void doControllerSet(int index, E element) throws ReportSDKException {
        IControllable oldObject = (IControllable)this.get(index);
        oldObject.doControllerModification(element);
    }

    protected boolean isOwner(Object element) {
        return true;
    }

    @Override
    public void copyTo(Object dest, boolean deepCopy) {
        ArrayList newList;
        if (dest == this) {
            return;
        }
        ControllableList vDest = (ControllableList)dest;
        if (deepCopy) {
            ArrayListMerger merger = new ArrayListMerger(vDest, this);
            newList = merger.merge();
        } else {
            newList = this;
        }
        vDest.clear();
        vDest.addAll(newList);
        assert (vDest.size() == this.size());
    }

    protected Object getUniqueID(E object) {
        return null;
    }

    @Override
    public void add(final int index, final E element) {
        if (this.isDirectlyControllable()) {
            if (ControllableHelper.hasEnabledController(this)) {
                try {
                    this.doControllerAdd(index, element);
                }
                catch (ReportSDKException e10) {
                    throw new ReportSDKRuntimeException(e10);
                }
                this.m_controllableMixin.getControllerInterface().disable();
                ControllableHelper.copyToPreservingReferences((IClone)this.get(index), (IClone)element, null);
                this.m_controllableMixin.getControllerInterface().enable();
                super.set(index, element);
            } else {
                super.add(index, element);
            }
            if (this.isOwner(element) && this.m_controllableMixin.getControllerInterface() != null) {
                this.m_controllableMixin.propagateController(element);
            }
        } else {
            this.m_controllableMixin.makeChange(new IChange(){

                public void run() {
                    ControllableList.super.add(index, element);
                }
            });
        }
    }

    @Override
    public E remove(final int index) {
        Object obj = this.get(index);
        if (this.isDirectlyControllable()) {
            if (ControllableHelper.hasEnabledController(this)) {
                try {
                    this.doControllerRemove(index);
                }
                catch (ReportSDKException e10) {
                    throw new ReportSDKRuntimeException(e10);
                }
            } else {
                super.remove(index);
            }
            if (this.isOwner(obj) && this.m_controllableMixin.getControllerInterface() != null && obj instanceof IControllable) {
                ((IControllable)obj).getControllableMixin().setControllerInterface(null);
            }
        } else {
            this.m_controllableMixin.makeChange(new IChange(){

                public void run() {
                    ControllableList.super.remove(index);
                }
            });
        }
        return obj;
    }

    @Override
    public E set(final int index, final E element) {
        Object oldElement = super.get(index);
        if (oldElement == element) {
            return oldElement;
        }
        if (this.isDirectlyControllable()) {
            if (ControllableHelper.hasEnabledController(this)) {
                try {
                    this.doControllerSet(index, element);
                }
                catch (ReportSDKException e10) {
                    throw new ReportSDKRuntimeException(e10);
                }
                this.m_controllableMixin.getControllerInterface().disable();
                ControllableHelper.copyToPreservingReferences((IClone)this.get(index), (IClone)element, null);
                this.m_controllableMixin.getControllerInterface().enable();
                super.set(index, element);
            } else {
                super.set(index, element);
            }
            if (this.isOwner(oldElement) && oldElement instanceof IControllable) {
                ((IControllable)oldElement).getControllableMixin().setControllerInterface(null);
            }
            if (this.isOwner(element) && this.m_controllableMixin.getControllerInterface() != null) {
                this.m_controllableMixin.propagateController(element);
            }
        } else {
            this.m_controllableMixin.makeChange(new IChange(){

                public void run() {
                    ControllableList.super.set(index, element);
                }
            });
        }
        return oldElement;
    }

    @Override
    public ControllableMixin getControllableMixin() {
        return this.m_controllableMixin;
    }

    @Override
    public void doControllerModification(Object newObject) {
        assert (false) : "modify should not be called on a vector";
    }

    @Override
    public void enumerateMembers(IMemberVisitor visitor) {
        for (int i2 = 0; i2 < super.size(); ++i2) {
            boolean isOwner = this.isOwner(super.get(i2));
            if (!(super.get(i2) instanceof IControllable)) continue;
            super.set(i2, visitor.visit((IControllable)super.get(i2), isOwner));
        }
    }

    @Override
    public boolean add(E o2) {
        return this.innerList.add(o2);
    }

    @Override
    public boolean addAll(Collection<? extends E> c10) {
        return this.innerList.addAll(c10);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c10) {
        return this.innerList.addAll(index, c10);
    }

    @Override
    public void clear() {
        this.innerList.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.innerList.iterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.innerList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.innerList.listIterator(index);
    }

    @Override
    public boolean remove(Object o2) {
        return this.innerList.remove(o2);
    }

    @Override
    public boolean removeAll(Collection<?> c10) {
        return this.innerList.removeAll(c10);
    }

    @Override
    public boolean retainAll(Collection<?> c10) {
        return this.innerList.retainAll(c10);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.innerList.subList(fromIndex, toIndex);
    }
}

