/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.report.application;

import com.crystaldecisions.client.helper.CloneUtil;
import com.crystaldecisions.client.helper.SDKResourceManager;
import com.crystaldecisions.proxy.remoteagent.ResultInfo;
import com.crystaldecisions.sdk.occa.report.application.ConnectionManager;
import com.crystaldecisions.sdk.occa.report.application.ParameterFieldController;
import com.crystaldecisions.sdk.occa.report.data.CatalogItem;
import com.crystaldecisions.sdk.occa.report.data.CatalogItems;
import com.crystaldecisions.sdk.occa.report.data.Fields;
import com.crystaldecisions.sdk.occa.report.data.IConnection;
import com.crystaldecisions.sdk.occa.report.data.IConnectionInfo;
import com.crystaldecisions.sdk.occa.report.data.IField;
import com.crystaldecisions.sdk.occa.report.data.ITable;
import com.crystaldecisions.sdk.occa.report.data.ParameterField;
import com.crystaldecisions.sdk.occa.report.data.Procedure;
import com.crystaldecisions.sdk.occa.report.data.Records;
import com.crystaldecisions.sdk.occa.report.data.Values;
import com.crystaldecisions.sdk.occa.report.lib.ControllableMap;
import com.crystaldecisions.sdk.occa.report.lib.IConnectionExplorer;
import com.crystaldecisions.sdk.occa.report.lib.PropertyBag;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKException;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKParameterFieldException;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKServerError;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKServerException;
import com.crystaldecisions.sdk.occa.report.lib.Strings;
import com.crystaldecisions.sdk.occa.report.lib.trace.ILogger;
import com.crystaldecisions.sdk.occa.report.lib.trace.TraceManager;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConnectionExplorer
implements IConnectionExplorer {
    private static final ILogger do = TraceManager.getLogger(ConnectionExplorer.class);
    private IConnection if = null;
    private ConnectionManager a = null;

    ConnectionExplorer(IConnection iConnection, ConnectionManager connectionManager) {
        if (iConnection == null || connectionManager == null) {
            throw new IllegalArgumentException();
        }
        this.if = iConnection;
        this.a = connectionManager;
    }

    @Override
    public Locale getLocale() {
        return this.a.getLocale();
    }

    public PropertyBag processConnectionUI(PropertyBag propertyBag) throws ReportSDKException {
        assert (this.a != null && this.if != null);
        PropertyBag propertyBag2 = new PropertyBag();
        propertyBag2.put("Connection", this.if);
        if (propertyBag != null) {
            propertyBag2.put("UIProperties", propertyBag);
        }
        ResultInfo resultInfo = this.a.a(370, propertyBag2);
        do.assertNotNull(resultInfo, "ResultInfo");
        if (!(resultInfo.getResultObj() instanceof PropertyBag)) {
            do.error("processConnectionUI(): The Result object is not an instance of PropertyBag!");
            int n2 = ReportSDKServerError.failed.value();
            ReportSDKServerException.throwReportSDKServerException(n2, "");
        }
        return (PropertyBag)resultInfo.getResultObj();
    }

    public PropertyBag testConnectionUI(PropertyBag propertyBag) throws ReportSDKException {
        assert (this.a != null);
        PropertyBag propertyBag2 = new PropertyBag();
        propertyBag2.put("UIProperties", propertyBag);
        propertyBag2.put("Connection", this.if);
        ResultInfo resultInfo = this.a.a(360, propertyBag2);
        do.assertNotNull(resultInfo, "ResultInfo");
        if (!(resultInfo.getResultObj() instanceof PropertyBag)) {
            do.error("processConnectionUI(): The Result object is not an instance of PropertyBag!");
            int n2 = ReportSDKServerError.failed.value();
            ReportSDKServerException.throwReportSDKServerException(n2, "");
        }
        return (PropertyBag)resultInfo.getResultObj();
    }

    public CatalogItems getCatalogItems() throws ReportSDKException {
        assert (this.a != null && this.if != null);
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("Connection", this.if);
        ResultInfo resultInfo = this.a.a(371, propertyBag);
        do.assertNotNull(resultInfo, "ResultInfo");
        if (!(resultInfo.getResultObj() instanceof CatalogItems)) {
            do.error("getCatalogItems(): The Result object is not an instance of CatalogItems!");
            int n2 = ReportSDKServerError.failed.value();
            ReportSDKServerException.throwReportSDKServerException(n2, "");
        }
        CatalogItems catalogItems = (CatalogItems)resultInfo.getResultObj();
        return this.a(catalogItems);
    }

    @Override
    public CatalogItems getCatalogItemChildren(Strings strings) throws ReportSDKException {
        assert (this.a != null && this.if != null);
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("Connection", this.if);
        propertyBag.put("ParentPath", strings);
        ResultInfo resultInfo = this.a.a(377, propertyBag);
        do.assertNotNull(resultInfo, "ResultInfo");
        CatalogItems catalogItems = (CatalogItems)resultInfo.getResultObj();
        return this.a(catalogItems);
    }

    private CatalogItems a(CatalogItems catalogItems) {
        if (catalogItems == null) {
            return null;
        }
        for (int i2 = 0; i2 < catalogItems.size(); ++i2) {
            CatalogItem catalogItem = catalogItems.getCatalogItem(i2);
            catalogItem.setConnectionExplorer(this);
        }
        return catalogItems;
    }

    public CatalogItems findCatalogItems(String string) throws ReportSDKException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        assert (this.a != null && this.if != null);
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("Connection", this.if);
        propertyBag.put("CatalogItemName", string);
        ResultInfo resultInfo = this.a.a(371, propertyBag);
        do.assertNotNull(resultInfo, "ResultInfo");
        if (!(resultInfo.getResultObj() instanceof CatalogItems)) {
            do.error("findCatalogItems(): The Result object is not an instance of CatalogItems!");
            int n2 = ReportSDKServerError.failed.value();
            ReportSDKServerException.throwReportSDKServerException(n2, "");
        }
        CatalogItems catalogItems = (CatalogItems)resultInfo.getResultObj();
        return this.a(catalogItems);
    }

    public boolean isConnectionOpen() throws ReportSDKException {
        PropertyBag propertyBag;
        assert (this.a != null && this.if != null);
        PropertyBag propertyBag2 = new PropertyBag();
        propertyBag2.put("Connection", this.if);
        ResultInfo resultInfo = this.a.a(362, propertyBag2);
        do.assertNotNull(resultInfo, "ResultInfo");
        if (!(resultInfo.getResultObj() instanceof PropertyBag)) {
            do.error("isConnectionOpen(): The Result object is not an instance of PropertyBag!");
            int n2 = ReportSDKServerError.failed.value();
            ReportSDKServerException.throwReportSDKServerException(n2, "");
        }
        if (!(propertyBag = (PropertyBag)resultInfo.getResultObj()).containsKey("IsOpen")) {
            do.error("isConnectionOpen(): The Result object does not contain correct info!");
            int n3 = ReportSDKServerError.failed.value();
            ReportSDKServerException.throwReportSDKServerException(n3, "");
        }
        return propertyBag.getBooleanValue("IsOpen");
    }

    public void openConnection() throws ReportSDKException {
        assert (this.a != null && this.if != null);
        Fields fields = this.if.getParameters();
        if (this.a(fields)) {
            do.error("openConnection(): The connection parameter value is missing!");
            int n2 = -2147217394;
            String string = SDKResourceManager.getString("Error_MissingParameterValueError", this.a.getLocale());
            ReportSDKParameterFieldException.throwReportSDKParameterFieldException(n2, string);
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("Connection", this.if);
        this.a.a(360, propertyBag);
    }

    public void closeConnection() throws ReportSDKException {
        assert (this.a != null && this.if != null);
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("Connection", this.if);
        this.a.a(361, propertyBag);
    }

    @Override
    public Fields<IField> getTableFields(ITable iTable) throws ReportSDKException {
        Cloneable cloneable;
        if (iTable == null) {
            throw new IllegalArgumentException();
        }
        assert (this.a != null && this.if != null);
        if (iTable instanceof Procedure && this.a((Fields)(cloneable = ((Procedure)iTable).getParameters()))) {
            do.error("getTableFields(table): The connection parameter value is missing!");
            int n2 = -2147217394;
            String string = SDKResourceManager.getString("Error_MissingParameterValueError", this.a.getLocale());
            ReportSDKParameterFieldException.throwReportSDKParameterFieldException(n2, string);
        }
        cloneable = new PropertyBag();
        ((ControllableMap)cloneable).put("Table", iTable);
        ResultInfo resultInfo = this.a.a(376, (PropertyBag)cloneable);
        do.assertNotNull(resultInfo, "ResultInfo");
        if (!(resultInfo.getResultObj() instanceof Fields)) {
            do.error("getTableFields(): The Result object is not an instance of Fields!");
            int n3 = ReportSDKServerError.failed.value();
            ReportSDKServerException.throwReportSDKServerException(n3, "");
        }
        return (Fields)resultInfo.getResultObj();
    }

    private boolean a(Fields fields) {
        if (fields == null || fields.size() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            ParameterField parameterField = (ParameterField)fields.getField(i2);
            try {
                Values values = parameterField.getCurrentValues();
                if (values == null || values.size() == 0) {
                    return true;
                }
                ParameterFieldController.a(this.a.getLocale(), parameterField.getType(), parameterField.getValueRangeKind(), parameterField.getCurrentValues(), parameterField.getMinimumValue(), parameterField.getMaximumValue(), parameterField.getAllowNullValue(), parameterField.getIsOptionalPrompt());
                continue;
            }
            catch (ReportSDKException reportSDKException) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Records browseTableValues(ITable iTable, int n2) throws ReportSDKException {
        Cloneable cloneable;
        if (iTable == null) {
            throw new IllegalArgumentException();
        }
        assert (this.a != null && this.if != null);
        if (iTable instanceof Procedure && this.a((Fields)(cloneable = ((Procedure)iTable).getParameters()))) {
            do.error("browseTableValues(table, cLimit): The connection parameter value is missing!");
            int n3 = -2147217394;
            String string = SDKResourceManager.getString("Error_MissingParameterValueError", this.a.getLocale());
            ReportSDKParameterFieldException.throwReportSDKParameterFieldException(n3, string);
        }
        cloneable = new PropertyBag();
        ((ControllableMap)cloneable).put("Table", iTable);
        ((ControllableMap)cloneable).put("RecordNumber", n2);
        ResultInfo resultInfo = this.a.a(137, (PropertyBag)cloneable);
        do.assertNotNull(resultInfo, "ResultInfo");
        if (!(resultInfo.getResultObj() instanceof Records)) {
            do.error("browseTableValues(): The Result object is not an instance of Records!");
            int n4 = ReportSDKServerError.failed.value();
            ReportSDKServerException.throwReportSDKServerException(n4, "");
        }
        return (Records)resultInfo.getResultObj();
    }

    @Override
    public Values browseFieldValues(ITable iTable, IField iField, int n2) throws ReportSDKException {
        if (iTable == null || iField == null) {
            throw new IllegalArgumentException();
        }
        assert (this.a != null && this.if != null);
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("Table", iTable);
        propertyBag.put("Field", iField);
        propertyBag.put("RecordNumber", n2);
        ResultInfo resultInfo = this.a.a(137, propertyBag);
        do.assertNotNull(resultInfo, "ResultInfo");
        if (!(resultInfo.getResultObj() instanceof Values)) {
            do.error("browseFieldValues(): The Result object is not an instance of Values!");
            int n3 = ReportSDKServerError.failed.value();
            ReportSDKServerException.throwReportSDKServerException(n3, "");
        }
        return (Values)resultInfo.getResultObj();
    }

    public IConnectionInfo getConnectionInfo() {
        assert (this.if != null);
        if (this.if != null) {
            return this.if.getConnectionInfo();
        }
        return null;
    }

    public Fields getParameters() {
        assert (this.if != null);
        if (this.if != null) {
            return this.if.getParameters();
        }
        return null;
    }

    public String getDescription() {
        assert (this.if != null);
        if (this.if != null) {
            return this.if.getDescription();
        }
        return "";
    }

    public String getName() {
        assert (this.if != null);
        if (this.if != null) {
            return this.if.getName();
        }
        return "";
    }

    public void setConnectionInfo(IConnectionInfo iConnectionInfo) throws ReportSDKException {
        if (iConnectionInfo == null) {
            throw new IllegalArgumentException();
        }
        assert (this.a != null && this.if != null);
        if (CloneUtil.equalContent(iConnectionInfo, this.if.getConnectionInfo())) {
            return;
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("Connection", this.if);
        propertyBag.put("NewConnectionInfo", iConnectionInfo);
        this.a.a(375, propertyBag);
        this.if.setConnectionInfo(iConnectionInfo);
    }

    public void setParameters(Fields fields) throws ReportSDKException {
        if (fields == null) {
            throw new IllegalArgumentException();
        }
        assert (this.a != null && this.if != null);
        if (CloneUtil.equalContent(fields, this.if.getParameters())) {
            return;
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("Connection", this.if);
        propertyBag.put("NewParameters", fields);
        this.a.a(375, propertyBag);
        this.if.setParameters(fields);
    }

    public void setDescription(String string) throws ReportSDKException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        assert (this.a != null && this.if != null);
        if (CloneUtil.equalStrings(string, this.if.getDescription())) {
            return;
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("Connection", this.if);
        propertyBag.put("NewDescription", string);
        this.a.a(375, propertyBag);
        this.if.setDescription(string);
    }

    public void setName(String string) throws ReportSDKException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        assert (this.a != null && this.if != null);
        if (CloneUtil.equalStrings(string, this.if.getName())) {
            return;
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("Connection", this.if);
        propertyBag.put("NewName", string);
        this.a.a(375, propertyBag);
        this.if.setName(string);
    }
}

