/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.queryengine;

import com.businessobjects.reports.datainterface.fields.FieldDefinitionType;
import com.businessobjects.reports.datainterface.fields.FieldKey;
import com.businessobjects.reports.datamodel.DFParameterDirection;
import com.businessobjects.reports.jdbinterface.common.FieldInfo;
import com.businessobjects.reports.jdbinterface.common.FieldKind;
import com.businessobjects.reports.jdbinterface.common.ParameterDirection;
import com.businessobjects.reports.jdbinterface.common.ParameterInfo;
import com.crystaldecisions.reports.common.QueryEngineException;
import com.crystaldecisions.reports.common.SaveLoadException;
import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputRecordArchive;
import com.crystaldecisions.reports.common.archive.IOutputRecordArchive;
import com.crystaldecisions.reports.common.archive.RecordInfo;
import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.ValueType;
import com.crystaldecisions.reports.queryengine.DBUtils;
import com.crystaldecisions.reports.queryengine.IParameter;
import com.crystaldecisions.reports.queryengine.IQEPersist;
import com.crystaldecisions.reports.queryengine.ISession;
import com.crystaldecisions.reports.queryengine.ITable;
import com.crystaldecisions.reports.queryengine.LoadState;
import com.crystaldecisions.reports.queryengine.QEBase;
import com.crystaldecisions.reports.queryengine.QEFileFormat;
import com.crystaldecisions.reports.queryengine.SaveState;
import com.crystaldecisions.reports.queryengine.Session;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter
extends QEBase
implements IParameter,
IQEPersist,
Cloneable {
    protected ITable hS = null;
    protected ParameterInfo hT = new ParameterInfo();
    protected CrystalValue hQ = null;
    protected boolean hR = false;
    public static final String hU = "?";

    public Parameter(ITable iTable, FieldInfo fieldInfo) {
        super((Session)iTable.a());
        this.hS = iTable;
        if (fieldInfo != null) {
            this.hT = new ParameterInfo(fieldInfo);
        }
    }

    public Parameter(ITable iTable, ParameterInfo parameterInfo) {
        super((Session)iTable.a());
        this.hS = iTable;
        if (parameterInfo != null) {
            this.hT = parameterInfo;
        }
    }

    public Parameter(ITable iTable) {
        this(iTable, (ParameterInfo)null);
    }

    private Parameter(ISession iSession) {
        super((Session)iSession);
    }

    public Parameter(ISession iSession, FieldInfo fieldInfo) {
        this(iSession);
        if (fieldInfo != null) {
            this.hT = new ParameterInfo(fieldInfo);
        }
    }

    @Override
    public FieldInfo o1() {
        return this.hT;
    }

    @Override
    public FieldKey oU() {
        return new FieldKey(FieldDefinitionType.int, this.oW());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Parameter:");
        stringBuilder.append("<name=" + this.hT.m_Name + ">");
        stringBuilder.append("<description=" + this.hT.m_Description + ">");
        stringBuilder.append("<dataType=" + this.hT.dataType + ">");
        stringBuilder.append("<fieldSize=" + this.hT.fieldSize + ">");
        stringBuilder.append("<attributes=" + this.hT.m_Attributes + ">");
        stringBuilder.append("<precision=" + this.hT.m_Precision + ">");
        stringBuilder.append("<isNullable=" + this.hT.isNullable + ">");
        stringBuilder.append("<direction=" + this.hT.parameterDirection.value() + ">");
        stringBuilder.append("<precision=" + this.hT.m_Precision + ">");
        stringBuilder.append("<allowMultipleValues=" + this.hT.allowMultipleValues + ">");
        stringBuilder.append("<allowRanges=" + this.hT.allowRanges + ">");
        return stringBuilder.toString();
    }

    @Override
    public ITable pb() {
        return this.hS;
    }

    void a(ITable iTable) {
        this.hS = iTable;
    }

    @Override
    public DFParameterDirection pa() {
        return ParameterDirectionConverter.a(this.hT.parameterDirection);
    }

    public void a(ParameterDirection parameterDirection) {
        this.hT.parameterDirection = parameterDirection;
    }

    @Override
    public boolean o6() {
        return this.hT.isNullable;
    }

    public void a6(boolean bl2) {
        this.hT.isNullable = bl2;
    }

    @Override
    public boolean o7() {
        return this.hT.allowMultipleValues;
    }

    public void a7(boolean bl2) {
        this.hT.allowMultipleValues = bl2;
    }

    @Override
    public boolean o8() {
        return this.hT.allowRanges;
    }

    public void a5(boolean bl2) {
        this.hT.allowRanges = bl2;
    }

    @Override
    public CrystalValue pc() {
        return this.hQ;
    }

    public void int(CrystalValue crystalValue) {
        this.hQ = crystalValue;
        if (crystalValue == null) {
            this.hT.defaultValues = null;
        } else {
            if (this.hT.defaultValues == null) {
                this.hT.defaultValues = new ArrayList();
            } else {
                this.hT.defaultValues.clear();
            }
            this.for(crystalValue);
        }
    }

    private void for(Object object) {
        CrystalAssert.ASSERT((this.hT.defaultValues != null ? 1 : 0) != 0);
        if (object == null) {
            this.hT.defaultValues.add(null);
        } else if (object.getClass().isArray() && !DBUtils.if(object)) {
            Object[] objectArray = DBUtils.a(object);
            CrystalAssert.ASSERT((objectArray != null ? 1 : 0) != 0);
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.for(objectArray[i2]);
            }
        } else if (object instanceof CrystalValue) {
            this.hT.defaultValues.add((CrystalValue)object);
        } else {
            this.hT.defaultValues.add(null);
        }
    }

    @Override
    public boolean if(IParameter iParameter) throws QueryEngineException {
        if (iParameter == null) {
            throw new NullPointerException();
        }
        boolean bl2 = false;
        String string = iParameter.oT();
        String string2 = iParameter.oS();
        ParameterDirection parameterDirection = ParameterDirectionConverter.a(iParameter.pa());
        ValueType valueType = iParameter.oQ();
        int n2 = iParameter.oR();
        int n3 = iParameter.o0();
        int n4 = iParameter.oZ();
        boolean bl3 = iParameter.o6();
        boolean bl4 = iParameter.o7();
        boolean bl5 = iParameter.o8();
        CrystalValue crystalValue = iParameter.pc();
        if (!((this.hT.m_Name == null && string == null || this.hT.m_Name != null && string != null && this.hT.m_Name.equals(string)) && (this.hT.m_Description == null && string2 == null || this.hT.m_Description != null && string2 != null && this.hT.m_Description.equals(string2)) && this.hT.parameterDirection != parameterDirection && this.hT.dataType != valueType && this.hT.fieldSize != n2 && this.hT.m_Attributes != n3 && this.hT.m_Precision != n4 && this.hT.isNullable != bl3 && this.hT.allowMultipleValues != bl4 && this.hT.allowRanges != bl5 && (this.hQ == null && crystalValue == null || this.hQ != null && crystalValue != null && this.hQ.compareTo((Object)crystalValue, (Comparator)Collator.getInstance()) == 0))) {
            bl2 = true;
            this.hT.m_Name = string;
            this.hT.m_Description = string2;
            this.hT.parameterDirection = parameterDirection;
            this.hT.dataType = valueType;
            this.hT.fieldSize = n2;
            this.hT.m_Attributes = n3;
            this.hT.m_Precision = n4;
            this.hT.isNullable = bl3;
            this.hT.allowMultipleValues = bl4;
            this.hT.allowRanges = bl5;
            this.hQ = crystalValue;
        }
        return bl2;
    }

    @Override
    public String oT() {
        return this.hT.m_Name;
    }

    public void aC(String string) {
        this.hT.m_Name = string;
    }

    @Override
    public String oS() {
        return this.hT.m_Description;
    }

    public void aB(String string) {
        this.hT.m_Description = string;
    }

    @Override
    public ValueType oQ() {
        return this.hT.dataType;
    }

    public void a(ValueType valueType) {
        this.hT.dataType = valueType;
    }

    @Override
    public int oR() {
        return this.hT.fieldSize;
    }

    public void bb(int n2) {
        this.hT.fieldSize = n2;
    }

    @Override
    public FieldKind o2() {
        return FieldKind.parameter;
    }

    @Override
    public String oW() {
        return this.getFormulaForm();
    }

    @Override
    public int o0() {
        return this.hT.m_Attributes;
    }

    public void bd(int n2) {
        this.hT.m_Attributes = n2;
    }

    @Override
    public int oZ() {
        return this.hT.m_Precision;
    }

    public void bc(int n2) {
        this.hT.m_Precision = n2;
    }

    @Override
    public void if(Object object) throws SaveLoadException, ArchiveException, QueryEngineException {
        SaveState saveState = (SaveState)object;
        saveState.a((IQEPersist)this, (IQEPersist)((Object)this.hS));
    }

    @Override
    public synchronized void do(Object object) throws SaveLoadException, ArchiveException, QueryEngineException {
        SaveState saveState = (SaveState)object;
        IOutputRecordArchive iOutputRecordArchive = saveState.yX();
        iOutputRecordArchive.startRecord(QEFileFormat.if, 2306, 4, saveState.char(this));
        iOutputRecordArchive.storeString("Name", this.hT.m_Name);
        iOutputRecordArchive.storeString("Description", this.hT.m_Description);
        iOutputRecordArchive.storeEnum("Direction", this.hT.parameterDirection.value(), saveState.yU());
        iOutputRecordArchive.storeEnum("DataType", this.hT.dataType.value(), saveState.yN());
        iOutputRecordArchive.storeInt32("FieldSize", this.hT.fieldSize);
        iOutputRecordArchive.storeBoolean("IsNullable", this.hT.isNullable);
        iOutputRecordArchive.storeBoolean("AllowsMultipleValues", this.hT.allowMultipleValues);
        iOutputRecordArchive.storeBoolean("AllowsRanges", this.hT.allowRanges);
        QEFileFormat.a(this.hQ, this.else, saveState, iOutputRecordArchive, QEFileFormat.long);
        iOutputRecordArchive.storeInt32("Attributes", this.hT.m_Attributes);
        iOutputRecordArchive.storeInt32("Precision", this.hT.m_Precision);
        iOutputRecordArchive.endRecord();
    }

    static Parameter a(Session session, ITable iTable, LoadState loadState, IInputRecordArchive iInputRecordArchive) throws SaveLoadException, ArchiveException {
        Parameter parameter = new Parameter(iTable);
        parameter.a(loadState, iInputRecordArchive);
        return parameter;
    }

    static Parameter a(Session session, LoadState loadState, IInputRecordArchive iInputRecordArchive) throws SaveLoadException, ArchiveException {
        Parameter parameter = new Parameter((ISession)session);
        parameter.a(loadState, iInputRecordArchive);
        return parameter;
    }

    synchronized void a(LoadState loadState, IInputRecordArchive iInputRecordArchive) throws SaveLoadException, ArchiveException {
        this.hR = true;
        RecordInfo recordInfo = iInputRecordArchive.a(QEFileFormat.if);
        loadState.a(this, recordInfo.if);
        if (this.hT == null) {
            this.hT = new ParameterInfo();
        }
        this.hT.m_Name = iInputRecordArchive.loadString("Name");
        this.hT.m_Description = iInputRecordArchive.loadString("Description");
        this.hT.parameterDirection = ParameterDirection.from_int((int)iInputRecordArchive.loadEnum("Direction", loadState.Ak()));
        this.hT.dataType = ValueType.fromInt((int)iInputRecordArchive.loadEnum("DataType", loadState.Ak()));
        this.hT.fieldSize = iInputRecordArchive.loadInt32("FieldSize");
        this.hT.isNullable = iInputRecordArchive.loadBoolean("IsNullable");
        this.hT.allowMultipleValues = iInputRecordArchive.loadBoolean("AllowsMultipleValues");
        this.hT.allowRanges = iInputRecordArchive.loadBoolean("AllowsRanges");
        this.hQ = QEFileFormat.a(this.else, loadState, iInputRecordArchive, QEFileFormat.long);
        if (recordInfo.a >= 2305) {
            this.hT.m_Attributes = iInputRecordArchive.loadInt32("Attributes");
        }
        if (recordInfo.a >= 2306) {
            // empty if block
        }
        iInputRecordArchive.skipRestOfRecord();
    }

    @Override
    public boolean o5() {
        return this.hR;
    }

    @Override
    public void a4(boolean bl2) {
        this.hR = bl2;
    }

    public Parameter pd() {
        try {
            Parameter parameter = (Parameter)super.clone();
            if (this.hT != null) {
                parameter.hT = this.hT.clone();
            }
            return parameter;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new UnsupportedOperationException(cloneNotSupportedException);
        }
    }

    @Override
    public ValueType oV() {
        return this.hT.dataType;
    }

    @Override
    public boolean oX() {
        return true;
    }

    @Override
    public boolean oY() {
        return false;
    }

    @Override
    public String getFormulaForm() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append(hU);
        stringBuilder.append(this.oT());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public FormulaValueType getFormulaValueType() {
        if (this.hT.dataType.isNumber()) {
            return FormulaValueType.number;
        }
        int n2 = this.hT.dataType.value();
        switch (n2) {
            case 13: {
                n2 = 11;
                break;
            }
            case 14: {
                n2 = 255;
                break;
            }
            case 100: {
                n2 = 255;
                break;
            }
            case 250: {
                n2 = 11;
            }
        }
        return FormulaValueType.fromInt((int)n2);
    }

    @Override
    public List<CrystalValue> o9() {
        ArrayList<CrystalValue> arrayList = new ArrayList<CrystalValue>();
        if (this.hQ != null) {
            arrayList.add(this.hQ);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static class ParameterDirectionConverter {
        public static DFParameterDirection a(ParameterDirection parameterDirection) {
            switch (parameterDirection.value()) {
                case 1: {
                    return DFParameterDirection.goto;
                }
                case 3: {
                    return DFParameterDirection.new;
                }
                case 2: {
                    return DFParameterDirection.for;
                }
                case 5: {
                    return DFParameterDirection.try;
                }
                case 4: {
                    return DFParameterDirection.if;
                }
                case 0: {
                    return DFParameterDirection.do;
                }
            }
            assert (false);
            return DFParameterDirection.do;
        }

        public static ParameterDirection a(DFParameterDirection dFParameterDirection) {
            switch (dFParameterDirection.a()) {
                case 1: {
                    return ParameterDirection.input;
                }
                case 3: {
                    return ParameterDirection.inputOutput;
                }
                case 2: {
                    return ParameterDirection.output;
                }
                case 5: {
                    return ParameterDirection.returnColumn;
                }
                case 4: {
                    return ParameterDirection.returnValue;
                }
                case 0: {
                    return ParameterDirection.unknown;
                }
            }
            assert (false);
            return ParameterDirection.unknown;
        }
    }
}

