/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.exporters.page.rtf;

import com.crystaldecisions.reports.common.logging.LogLevel;
import com.crystaldecisions.reports.exporters.format.page.rtf.rtfDOM.object.RTFDocument;
import com.crystaldecisions.reports.exporters.format.page.rtf.rtfDOM.object.RTFPage;
import com.crystaldecisions.reports.exportinterface2.IFormatCentricCrystalExporter;
import com.crystaldecisions.reports.exportinterface2.IReportInfoForExportJob;
import com.crystaldecisions.reports.exportinterface2.exceptions.ExportException;
import com.crystaldecisions.reports.exportinterface2.exceptions.IllegalExportPropertyValueException;
import com.crystaldecisions.reports.exportinterface2.exceptions.InternalFormatterException;
import com.crystaldecisions.reports.exportinterface2.util.ExporterBase;
import com.crystaldecisions.reports.exportinterface2.util.PageRangeParser;
import com.crystaldecisions.reports.formattedcontentmodel.IFCMModeller;
import com.crystaldecisions.reports.formattedcontentmodel.IFCMPage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.InvalidParameterException;
import java.util.Properties;

public class RTFExactExporter
extends ExporterBase
implements IFormatCentricCrystalExporter {
    public static final String propertyDefinitionFile = "RTFExact_properties.xml";
    private IReportInfoForExportJob V;
    private OutputStream W;
    private RTFDocument X = null;
    private RTFPage U;

    public RTFExactExporter() throws ExportException, IOException {
        super(propertyDefinitionFile);
    }

    public void setExportProperties(Properties properties) throws IllegalExportPropertyValueException {
        this.validateAndFilterExportProperties(properties, true);
    }

    public void validateAndFilterExportProperties(Properties properties, boolean bl2) throws IllegalExportPropertyValueException {
        String string = properties.getProperty("com.businessobjects.crystalreports.exporter.pageRange");
        if (null != string) {
            PageRangeParser.a(string);
        }
        if (!bl2) {
            properties.clear();
            if (null != string) {
                properties.setProperty("com.businessobjects.crystalreports.exporter.pageRange", string);
            }
        }
    }

    public void initializeExportJob(IReportInfoForExportJob iReportInfoForExportJob, OutputStream outputStream) throws IOException, InternalFormatterException {
        this.V = iReportInfoForExportJob;
        this.W = outputStream;
        this.X = new RTFDocument();
        this.for.logInfo("in startExportJob()");
        if (this.for.isEnabled(LogLevel.c)) {
            this.for.logDebugMessage("temp folder = " + this.V.for());
        }
        try {
            this.X.a(this.V.if(), new RTFDocument.RTFGenerationOptions(true, false, true, true, true), this.V.for(), this.for);
        }
        catch (InvalidParameterException invalidParameterException) {
            this.for.logThrowable("invalid parameter to rtfDocument.initializeDocument", invalidParameterException);
            throw new InternalFormatterException("JRC00003684", invalidParameterException);
        }
        catch (IOException iOException) {
            this.for.logThrowable("RTFFormatter::initializeFormatJob():", iOException);
            throw iOException;
        }
    }

    public void finalizeExportJob(boolean bl2) throws IOException {
        this.for.logInfo("in finalizeFormatJob()");
        try {
            if (!bl2 && this.X.a9() > 0L) {
                this.X.a(new OutputStreamWriter(this.W));
            }
        }
        catch (IOException iOException) {
            this.for.logThrowable("finalizeFormatJob()", iOException);
            throw iOException;
        }
        finally {
            this.X.a6();
        }
    }

    public void processFormattedContent(IFCMModeller iFCMModeller) throws IOException, ExportException {
        IFCMPage iFCMPage = iFCMModeller.modelContents();
        try {
            this.a(iFCMPage);
        }
        catch (IOException iOException) {
            if (null != this.for) {
                this.for.logThrowable("", iOException);
            }
            throw iOException;
        }
    }

    private void a(IFCMPage iFCMPage) throws IOException {
        this.for.logInfo("in formatPage()");
        this.X.aY();
        this.U = this.X.bi();
        int n2 = iFCMPage.getFullSize().getWidth();
        int n3 = iFCMPage.getFullSize().getHeight();
        this.U.processFCMPage(iFCMPage, n3, n2);
        if (this.X.a9() == 0L) {
            this.X.for(this.U.getPageLayout());
        }
        this.X.a2();
    }
}

