/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.reports.sdk.builder;

import com.businessobjects.reports.datainterface.SummaryOperation;
import com.businessobjects.reports.datamodel.IDFTableJoin;
import com.businessobjects.reports.dpom.processingplan.ConvertDateTimeType;
import com.crystaldecisions.reports.common.BitmapImage;
import com.crystaldecisions.reports.common.EMFImage;
import com.crystaldecisions.reports.common.ICrystalImage;
import com.crystaldecisions.reports.common.WMFImage;
import com.crystaldecisions.reports.common.enums.MissingFeatureType;
import com.crystaldecisions.reports.common.enums.SortDirection;
import com.crystaldecisions.reports.common.value.BinaryValue;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import com.crystaldecisions.reports.formulas.FormulaInfo;
import com.crystaldecisions.reports.reportdefinition.CrossTabGroupCondition;
import com.crystaldecisions.reports.reportdefinition.CrossTabStyle;
import com.crystaldecisions.reports.reportdefinition.FieldDefinition;
import com.crystaldecisions.reports.reportdefinition.FieldGrid;
import com.crystaldecisions.reports.reportdefinition.GridGroup;
import com.crystaldecisions.reports.reportdefinition.IGroupOptions;
import com.crystaldecisions.reports.reportdefinition.ParameterType;
import com.crystaldecisions.reports.reportdefinition.RunningTotalCondition;
import com.crystaldecisions.reports.reportdefinition.SortMethod;
import com.crystaldecisions.reports.reportdefinition.StringFieldProperties;
import com.crystaldecisions.reports.reportdefinition.SummaryFieldDefinition;
import com.crystaldecisions.reports.reportdefinition.ValueGridOrientation;
import com.crystaldecisions.sdk.occa.report.data.DateCondition;
import com.crystaldecisions.sdk.occa.report.data.FieldValueType;
import com.crystaldecisions.sdk.occa.report.data.FormulaNullTreatment;
import com.crystaldecisions.sdk.occa.report.data.FormulaSyntax;
import com.crystaldecisions.sdk.occa.report.data.ParameterFieldType;
import com.crystaldecisions.sdk.occa.report.data.ParameterSortOrder;
import com.crystaldecisions.sdk.occa.report.data.RunningTotalCondition;
import com.crystaldecisions.sdk.occa.report.data.TableJoinEnforced;
import com.crystaldecisions.sdk.occa.report.data.TableJoinOperator;
import com.crystaldecisions.sdk.occa.report.data.UnsupportedFeatureType;
import com.crystaldecisions.sdk.occa.report.definition.AMPMFormat;
import com.crystaldecisions.sdk.occa.report.definition.Alignment;
import com.crystaldecisions.sdk.occa.report.definition.BooleanOutputFormat;
import com.crystaldecisions.sdk.occa.report.definition.CrossTabChartOrientation;
import com.crystaldecisions.sdk.occa.report.definition.CurrencyPositionFormat;
import com.crystaldecisions.sdk.occa.report.definition.DateCalendarType;
import com.crystaldecisions.sdk.occa.report.definition.DateEraType;
import com.crystaldecisions.sdk.occa.report.definition.DateOrder;
import com.crystaldecisions.sdk.occa.report.definition.DateSystemDefaultType;
import com.crystaldecisions.sdk.occa.report.definition.DateTimeOrder;
import com.crystaldecisions.sdk.occa.report.definition.DayFormat;
import com.crystaldecisions.sdk.occa.report.definition.DayOfWeekPosition;
import com.crystaldecisions.sdk.occa.report.definition.DayOfWeekType;
import com.crystaldecisions.sdk.occa.report.definition.DetailPrintDirection;
import com.crystaldecisions.sdk.occa.report.definition.HourFormat;
import com.crystaldecisions.sdk.occa.report.definition.ICrossTabGroupFormat;
import com.crystaldecisions.sdk.occa.report.definition.ICrossTabStyle;
import com.crystaldecisions.sdk.occa.report.definition.MinuteFormat;
import com.crystaldecisions.sdk.occa.report.definition.MonthFormat;
import com.crystaldecisions.sdk.occa.report.definition.NegativeType;
import com.crystaldecisions.sdk.occa.report.definition.PictureType;
import com.crystaldecisions.sdk.occa.report.definition.ReadingOrder;
import com.crystaldecisions.sdk.occa.report.definition.SecondFormat;
import com.crystaldecisions.sdk.occa.report.definition.SummarizedFieldDirection;
import com.crystaldecisions.sdk.occa.report.definition.TextFormat;
import com.crystaldecisions.sdk.occa.report.definition.TextRotationAngle;
import com.crystaldecisions.sdk.occa.report.definition.TimeBase;
import com.crystaldecisions.sdk.occa.report.definition.YearFormat;
import com.crystaldecisions.sdk.occa.report.document.PaperOrientation;
import com.crystaldecisions.sdk.occa.report.formulaservice.FormulaSyntaxes;
import com.crystaldecisions.sdk.occa.report.formulaservice.FormulaValueType;
import com.crystaldecisions.sdk.occa.report.lib.ByteArray;
import com.crystalreports.sdk.enums.AMPMType;
import com.crystalreports.sdk.enums.AlignmentType;
import com.crystalreports.sdk.enums.BooleanOutputType;
import com.crystalreports.sdk.enums.CalendarType;
import com.crystalreports.sdk.enums.ClockType;
import com.crystalreports.sdk.enums.CurrencyPosition;
import com.crystalreports.sdk.enums.CurrencySymbolType;
import com.crystalreports.sdk.enums.DayOfWeekEnclosure;
import com.crystalreports.sdk.enums.DayType;
import com.crystalreports.sdk.enums.DetailPrintingDirection;
import com.crystalreports.sdk.enums.EraType;
import com.crystalreports.sdk.enums.HourType;
import com.crystalreports.sdk.enums.HyperlinkType;
import com.crystalreports.sdk.enums.LineSpacingType;
import com.crystalreports.sdk.enums.LineStyle;
import com.crystalreports.sdk.enums.MinuteType;
import com.crystalreports.sdk.enums.MonthType;
import com.crystalreports.sdk.enums.PageOrientationType;
import com.crystalreports.sdk.enums.ReadingOrderType;
import com.crystalreports.sdk.enums.RoundingType;
import com.crystalreports.sdk.enums.SecondType;
import com.crystalreports.sdk.enums.TextInterpretationType;
import com.crystalreports.sdk.enums.YearType;
import java.awt.Color;
import java.sql.Time;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JRCToEROMTypeUtility {
    private static final Logger a = Logger.getLogger((String)"com.businessobjects.reports.sdk.JRCCommunicationAdapter");

    private JRCToEROMTypeUtility() {
    }

    public static FieldValueType convertToFieldValueType(ValueType valueType) {
        switch (valueType.value()) {
            case 0: {
                return FieldValueType.int8sField;
            }
            case 1: {
                return FieldValueType.int8uField;
            }
            case 2: {
                return FieldValueType.int16sField;
            }
            case 3: {
                return FieldValueType.int16uField;
            }
            case 4: 
            case 17: {
                return FieldValueType.int32sField;
            }
            case 5: 
            case 18: {
                return FieldValueType.int32uField;
            }
            case 6: 
            case 16: {
                return FieldValueType.numberField;
            }
            case 7: {
                return FieldValueType.currencyField;
            }
            case 8: {
                return FieldValueType.booleanField;
            }
            case 9: {
                return FieldValueType.dateField;
            }
            case 10: {
                return FieldValueType.timeField;
            }
            case 15: {
                return FieldValueType.dateTimeField;
            }
            case 11: {
                return FieldValueType.stringField;
            }
            case 13: {
                return FieldValueType.persistentMemoField;
            }
            case 14: {
                return FieldValueType.blobField;
            }
            case 255: {
                return FieldValueType.unknownField;
            }
        }
        a.error((Object)"Failed to convert ValueType to FieldValueType");
        throw new IllegalArgumentException();
    }

    static com.crystaldecisions.sdk.occa.report.document.ConvertDateTimeType a(ConvertDateTimeType convertDateTimeType) {
        switch (convertDateTimeType.a()) {
            case 1: {
                return com.crystaldecisions.sdk.occa.report.document.ConvertDateTimeType.toDate;
            }
            case 0: {
                return com.crystaldecisions.sdk.occa.report.document.ConvertDateTimeType.toString;
            }
            case 2: {
                return com.crystaldecisions.sdk.occa.report.document.ConvertDateTimeType.keepDateTimeType;
            }
        }
        a.error((Object)"Cannot convert unknown ConvertDateTime type");
        throw new IllegalArgumentException();
    }

    static Alignment a(AlignmentType alignmentType) {
        switch (alignmentType) {
            case defaultAligned: {
                return Alignment.useDefault;
            }
            case left: {
                return Alignment.left;
            }
            case centred: {
                return Alignment.horizontalCenter;
            }
            case right: {
                return Alignment.right;
            }
            case justified: {
                return Alignment.justified;
            }
            case decimal: {
                return Alignment.decimal;
            }
        }
        a.error((Object)"Failed to convert horizontal alignment types");
        throw new IllegalArgumentException();
    }

    static com.crystaldecisions.sdk.occa.report.definition.HyperlinkType a(HyperlinkType hyperlinkType) {
        switch (hyperlinkType) {
            case website: {
                return com.crystaldecisions.sdk.occa.report.definition.HyperlinkType.website;
            }
            case email: {
                return com.crystaldecisions.sdk.occa.report.definition.HyperlinkType.email;
            }
            case html: {
                return com.crystaldecisions.sdk.occa.report.definition.HyperlinkType.html;
            }
            case crystalReport: {
                return com.crystaldecisions.sdk.occa.report.definition.HyperlinkType.crystalReport;
            }
            case websiteFieldValue: {
                return com.crystaldecisions.sdk.occa.report.definition.HyperlinkType.websiteFieldValue;
            }
            case emailFieldValue: {
                return com.crystaldecisions.sdk.occa.report.definition.HyperlinkType.emailFieldValue;
            }
            case mixed: 
            case undefined: {
                return com.crystaldecisions.sdk.occa.report.definition.HyperlinkType.undefined;
            }
            case drilldown: {
                return com.crystaldecisions.sdk.occa.report.definition.HyperlinkType.drilldown;
            }
            case reportObject: {
                return com.crystaldecisions.sdk.occa.report.definition.HyperlinkType.reportObject;
            }
            case reportObjectDisabled: {
                return com.crystaldecisions.sdk.occa.report.definition.HyperlinkType.reportObjectDisabled;
            }
            case reportObjectAbsolute: {
                return com.crystaldecisions.sdk.occa.report.definition.HyperlinkType.reportObjectAbsolute;
            }
            case reportObjectRelative: {
                return com.crystaldecisions.sdk.occa.report.definition.HyperlinkType.reportObjectRelative;
            }
        }
        a.error((Object)"Failed to convert Hyperlink types");
        throw new IllegalArgumentException();
    }

    static com.crystaldecisions.sdk.occa.report.definition.LineStyle a(LineStyle lineStyle) {
        switch (lineStyle) {
            case noLine: {
                return com.crystaldecisions.sdk.occa.report.definition.LineStyle.noLine;
            }
            case singleLine: {
                return com.crystaldecisions.sdk.occa.report.definition.LineStyle.singleLine;
            }
            case doubleLine: {
                return com.crystaldecisions.sdk.occa.report.definition.LineStyle.doubleLine;
            }
            case dashLine: {
                return com.crystaldecisions.sdk.occa.report.definition.LineStyle.dashedLine;
            }
            case dotLine: {
                return com.crystaldecisions.sdk.occa.report.definition.LineStyle.dottedLine;
            }
        }
        a.error((Object)"Failed to convert LineStyle enums");
        throw new IllegalArgumentException();
    }

    static TextRotationAngle a(int n2) {
        switch (n2) {
            case 0: {
                return TextRotationAngle.rotate0;
            }
            case 90: {
                return TextRotationAngle.rotate90;
            }
            case 270: {
                return TextRotationAngle.rotate270;
            }
        }
        a.error((Object)"Failed to convert rotation value");
        throw new IllegalArgumentException();
    }

    static com.crystaldecisions.sdk.occa.report.data.SummaryOperation a(SummaryOperation summaryOperation) {
        switch (summaryOperation.a()) {
            case 0: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.sum;
            }
            case 1: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.average;
            }
            case 2: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.variance;
            }
            case 3: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.standardDeviation;
            }
            case 4: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.maximum;
            }
            case 5: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.minimum;
            }
            case 6: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.count;
            }
            case 7: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.popVariance;
            }
            case 8: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.popStandardDeviation;
            }
            case 9: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.distinctCount;
            }
            case 10: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.correlation;
            }
            case 11: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.covariance;
            }
            case 12: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.weightedAvg;
            }
            case 13: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.median;
            }
            case 14: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.percentile;
            }
            case 15: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.nthLargest;
            }
            case 16: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.nthSmallest;
            }
            case 17: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.mode;
            }
            case 18: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.nthMostFrequent;
            }
            case 20: {
                return com.crystaldecisions.sdk.occa.report.data.SummaryOperation.noOperation;
            }
        }
        a.error((Object)"Failed to convert summary operations");
        throw new IllegalArgumentException();
    }

    static RunningTotalCondition if(RunningTotalCondition.ConditionType conditionType) {
        switch (conditionType.a()) {
            case 1: {
                return RunningTotalCondition.onchangeoffield;
            }
            case 2: {
                return RunningTotalCondition.onchangeofgroup;
            }
            case 3: {
                return RunningTotalCondition.onformula;
            }
            case 0: {
                return RunningTotalCondition.nocondition;
            }
        }
        a.error((Object)"Unable to convert running total reset condition types");
        throw new IllegalArgumentException();
    }

    static RunningTotalCondition a(RunningTotalCondition.ConditionType conditionType) {
        switch (conditionType.a()) {
            case 1: {
                return RunningTotalCondition.onchangeoffield;
            }
            case 2: {
                return RunningTotalCondition.onchangeofgroup;
            }
            case 3: {
                return RunningTotalCondition.onformula;
            }
            case 0: {
                return RunningTotalCondition.nocondition;
            }
        }
        a.error((Object)"Unable to convert running total reset condition types");
        throw new IllegalArgumentException();
    }

    static ParameterFieldType a(ParameterType parameterType) {
        switch (parameterType.a()) {
            case 0: {
                return ParameterFieldType.reportParameter;
            }
            case 2: {
                return ParameterFieldType.storedProcedureParameter;
            }
            case 3: {
                return ParameterFieldType.connectionParameter;
            }
        }
        a.error((Object)"Failed to convert Parameter field types");
        throw new IllegalArgumentException();
    }

    static ParameterSortOrder a(SortMethod sortMethod, ValueType valueType) {
        switch (sortMethod.a()) {
            case 0: {
                return ParameterSortOrder.noSort;
            }
            case 1: {
                switch (valueType.getBaseValueType().value()) {
                    case 6: 
                    case 7: {
                        return ParameterSortOrder.numericalAscending;
                    }
                    case 9: 
                    case 10: 
                    case 15: {
                        return ParameterSortOrder.datetimeAscending;
                    }
                    case 11: {
                        return ParameterSortOrder.alphabeticalAscending;
                    }
                    case 8: {
                        return ParameterSortOrder.noSort;
                    }
                }
            }
            case 2: {
                switch (valueType.getBaseValueType().value()) {
                    case 6: 
                    case 7: {
                        return ParameterSortOrder.numericalDescending;
                    }
                    case 9: 
                    case 10: 
                    case 15: {
                        return ParameterSortOrder.datetimeDescending;
                    }
                    case 11: {
                        return ParameterSortOrder.alphabeticalDescending;
                    }
                    case 8: {
                        return ParameterSortOrder.noSort;
                    }
                }
            }
        }
        a.error((Object)"Failed to convert SortMethod types");
        throw new IllegalArgumentException();
    }

    static FormulaSyntax a(FormulaInfo.Syntax syntax) {
        switch (syntax.value()) {
            case 1: {
                return FormulaSyntax.basic;
            }
            case 0: {
                return FormulaSyntax.crystal;
            }
        }
        a.error((Object)"Failed to convert formula syntax types");
        throw new IllegalArgumentException();
    }

    public static FormulaSyntaxes convertToFormulaSyntaxes(FormulaInfo.Syntax[] syntaxArray) {
        if (syntaxArray == null) {
            return null;
        }
        FormulaSyntaxes formulaSyntaxes = new FormulaSyntaxes();
        for (int i2 = 0; i2 < syntaxArray.length; ++i2) {
            formulaSyntaxes.add(JRCToEROMTypeUtility.a(syntaxArray[i2]));
        }
        return formulaSyntaxes;
    }

    static FormulaNullTreatment a(FormulaInfo.NullTreatment nullTreatment) {
        switch (nullTreatment.a()) {
            case 0: {
                return FormulaNullTreatment.asException;
            }
            case 1: {
                return FormulaNullTreatment.asDefaultValue;
            }
            case 2: {
                return FormulaNullTreatment.asDefaultValue;
            }
        }
        a.error((Object)"Failed to convert NullTreatment types");
        throw new IllegalArgumentException();
    }

    public static FormulaValueType convertToFormulaValueType(com.crystaldecisions.reports.common.value.FormulaValueType formulaValueType) {
        switch (formulaValueType.value()) {
            case 6: {
                return FormulaValueType.number;
            }
            case 7: {
                return FormulaValueType.currency;
            }
            case 8: {
                return FormulaValueType.bool;
            }
            case 9: {
                return FormulaValueType.date;
            }
            case 10: {
                return FormulaValueType.time;
            }
            case 15: {
                return FormulaValueType.dateTime;
            }
            case 11: {
                return FormulaValueType.string;
            }
            case 255: {
                return FormulaValueType.unknown;
            }
            case 4102: {
                return FormulaValueType.numberRange;
            }
            case 4103: {
                return FormulaValueType.currencyRange;
            }
            case 4105: {
                return FormulaValueType.dateRange;
            }
            case 4106: {
                return FormulaValueType.timeRange;
            }
            case 4111: {
                return FormulaValueType.dateTimeRange;
            }
            case 4107: {
                return FormulaValueType.stringRange;
            }
            case 4351: {
                return FormulaValueType.unknownRange;
            }
            case 8198: {
                return FormulaValueType.numberArray;
            }
            case 8199: {
                return FormulaValueType.currencyArray;
            }
            case 8200: {
                return FormulaValueType.booleanArray;
            }
            case 8201: {
                return FormulaValueType.dateArray;
            }
            case 8202: {
                return FormulaValueType.timeArray;
            }
            case 8207: {
                return FormulaValueType.dateTimeArray;
            }
            case 8203: {
                return FormulaValueType.stringArray;
            }
            case 8447: {
                return FormulaValueType.unknownArray;
            }
            case 12294: {
                return FormulaValueType.numberRangeArray;
            }
            case 12295: {
                return FormulaValueType.currencyRangeArray;
            }
            case 12297: {
                return FormulaValueType.dateRangeArray;
            }
            case 12298: {
                return FormulaValueType.timeRangeArray;
            }
            case 12303: {
                return FormulaValueType.dateTimeRangeArray;
            }
            case 12299: {
                return FormulaValueType.stringRangeArray;
            }
            case 12543: {
                return FormulaValueType.unknownRangeArray;
            }
        }
        a.error((Object)"Failed to convert FormulaValueType types");
        throw new IllegalArgumentException();
    }

    static TableJoinEnforced a(IDFTableJoin.EnforceType enforceType) {
        switch (1.long[enforceType.ordinal()]) {
            case 1: {
                return TableJoinEnforced.notEnforced;
            }
            case 2: {
                return TableJoinEnforced.from;
            }
            case 3: {
                return TableJoinEnforced.to;
            }
            case 4: {
                return TableJoinEnforced.both;
            }
        }
        a.error((Object)"Failed to convert TableJoinEnforced operators");
        throw new IllegalArgumentException();
    }

    static TableJoinOperator a(IDFTableJoin.JoinType joinType) {
        switch (1.for[joinType.ordinal()]) {
            case 1: {
                return TableJoinOperator.innerJoin;
            }
            case 2: {
                return TableJoinOperator.leftOuterJoin;
            }
            case 3: {
                return TableJoinOperator.rightOuterJoin;
            }
            case 4: {
                return TableJoinOperator.fullOuterJoin;
            }
            case 5: {
                return TableJoinOperator.unionJoin;
            }
            case 6: {
                return TableJoinOperator.crossJoin;
            }
            case 7: {
                return TableJoinOperator.parallelJoin;
            }
            case 8: {
                return TableJoinOperator.seriesJoin;
            }
            case 9: {
                return TableJoinOperator.productJoin;
            }
            case 10: {
                return TableJoinOperator.tableRelationJoin;
            }
        }
        a.error((Object)"Failed to convert table join operators");
        throw new IllegalArgumentException();
    }

    public static com.crystaldecisions.sdk.occa.report.data.SortDirection convertToSortDirection(SortDirection sortDirection) {
        switch (sortDirection.value()) {
            case 0: {
                return com.crystaldecisions.sdk.occa.report.data.SortDirection.ascendingOrder;
            }
            case 1: {
                return com.crystaldecisions.sdk.occa.report.data.SortDirection.descendingOrder;
            }
            case 2: {
                return com.crystaldecisions.sdk.occa.report.data.SortDirection.noSort;
            }
            case 3: {
                return com.crystaldecisions.sdk.occa.report.data.SortDirection.noSort;
            }
        }
        a.error((Object)"Failed to convert sort directions");
        throw new IllegalArgumentException();
    }

    static DateCondition a(ValueType valueType, int n2) {
        if (valueType == ValueType.date) {
            switch (n2) {
                case 0: {
                    return DateCondition.daily;
                }
                case 1: {
                    return DateCondition.weekly;
                }
                case 2: {
                    return DateCondition.biweekly;
                }
                case 3: {
                    return DateCondition.semimonthly;
                }
                case 4: {
                    return DateCondition.monthly;
                }
                case 5: {
                    return DateCondition.quarterly;
                }
                case 6: {
                    return DateCondition.semiannually;
                }
                case 7: {
                    return DateCondition.annually;
                }
            }
            a.error((Object)"Failed to convert date conditions");
            throw new IllegalArgumentException();
        }
        if (valueType == ValueType.time) {
            switch (n2) {
                case 0: {
                    return DateCondition.second;
                }
                case 1: {
                    return DateCondition.minute;
                }
                case 2: {
                    return DateCondition.hour;
                }
                case 3: {
                    return DateCondition.amPm;
                }
            }
            a.error((Object)"Failed to convert time conditions");
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                return DateCondition.daily;
            }
            case 1: {
                return DateCondition.weekly;
            }
            case 2: {
                return DateCondition.biweekly;
            }
            case 3: {
                return DateCondition.semimonthly;
            }
            case 4: {
                return DateCondition.monthly;
            }
            case 5: {
                return DateCondition.quarterly;
            }
            case 6: {
                return DateCondition.semiannually;
            }
            case 7: {
                return DateCondition.annually;
            }
            case 8: {
                return DateCondition.second;
            }
            case 9: {
                return DateCondition.minute;
            }
            case 10: {
                return DateCondition.hour;
            }
            case 11: {
                return DateCondition.amPm;
            }
        }
        a.error((Object)"Failed to convert dateTime conditions");
        throw new IllegalArgumentException();
    }

    static TextFormat a(TextInterpretationType textInterpretationType) {
        switch (textInterpretationType) {
            case uninterpreted: {
                return TextFormat.standardText;
            }
            case rtf: {
                return TextFormat.RTFText;
            }
            case html: {
                return TextFormat.HTMLText;
            }
        }
        a.error((Object)"Failed to convert text interpretation types");
        throw new IllegalArgumentException();
    }

    static BooleanOutputFormat a(BooleanOutputType booleanOutputType) {
        switch (booleanOutputType) {
            case trueOrFalse: {
                return BooleanOutputFormat.trueOrFalse;
            }
            case tOrF: {
                return BooleanOutputFormat.TOrF;
            }
            case yesOrNo: {
                return BooleanOutputFormat.yesOrNo;
            }
            case yOrN: {
                return BooleanOutputFormat.YOrN;
            }
            case oneOrZero: {
                return BooleanOutputFormat.oneOrZero;
            }
        }
        a.error((Object)"Failed to convert boolean output types");
        throw new IllegalArgumentException();
    }

    static DateSystemDefaultType a(com.crystalreports.sdk.enums.DateSystemDefaultType dateSystemDefaultType) {
        switch (dateSystemDefaultType) {
            case useWindowsLongDate: {
                return DateSystemDefaultType.useLongDate;
            }
            case useWindowsShortDate: {
                return DateSystemDefaultType.useShortDate;
            }
            case notUsingWindowsDefaults: {
                return DateSystemDefaultType.notUsingDefaults;
            }
        }
        a.error((Object)"Failed to convert system default types");
        throw new IllegalArgumentException();
    }

    static DayOfWeekPosition a(com.crystalreports.sdk.enums.DayOfWeekPosition dayOfWeekPosition) {
        switch (dayOfWeekPosition) {
            case leadingDayOfWeek: {
                return DayOfWeekPosition.leadingPosition;
            }
            case trailingDayOfWeek: {
                return DayOfWeekPosition.trailingPosition;
            }
        }
        a.error((Object)"Failed to convert day of week position types");
        throw new IllegalArgumentException();
    }

    static DayOfWeekType a(com.crystalreports.sdk.enums.DayOfWeekType dayOfWeekType) {
        switch (dayOfWeekType) {
            case shortDayOfWeek: {
                return DayOfWeekType.shortType;
            }
            case longDayOfWeek: {
                return DayOfWeekType.longType;
            }
            case noDayOfWeek: {
                return DayOfWeekType.noType;
            }
        }
        a.error((Object)"Failed to convert day of week types");
        throw new IllegalArgumentException();
    }

    static DateOrder a(com.crystalreports.sdk.enums.DateOrder dateOrder) {
        switch (dateOrder) {
            case yearMonthDay: {
                return DateOrder.yearMonthDay;
            }
            case dayMonthYear: {
                return DateOrder.dayMonthYear;
            }
            case monthDayYear: {
                return DateOrder.monthDayYear;
            }
        }
        a.error((Object)"Failed to convert date order types");
        throw new IllegalArgumentException();
    }

    static DateCalendarType a(CalendarType calendarType) {
        switch (calendarType) {
            case gregorianCalendar: {
                return DateCalendarType.gregorianCalendar;
            }
            case gregorianUSCalendar: {
                return DateCalendarType.gregorianUSCalendar;
            }
            case japaneseCalendar: {
                return DateCalendarType.japaneseCalendar;
            }
            case taiwaneseCalendar: {
                return DateCalendarType.taiwaneseCalendar;
            }
            case koreanCalendar: {
                return DateCalendarType.koreanCalendar;
            }
            case hijriCalendar: {
                return DateCalendarType.hijriCalendar;
            }
            case thaiCalendar: {
                return DateCalendarType.thaiCalendar;
            }
            case hebrewCalendar: {
                return DateCalendarType.hebrewCalendar;
            }
            case gregorianMEFrenchCalendar: {
                return DateCalendarType.gregorianMEFrenchCalendar;
            }
            case gregorianArabicCalendar: {
                return DateCalendarType.gregorianArabicCalendar;
            }
            case gregorianXlitEnglishCalendar: {
                return DateCalendarType.gregorianXlitEnglishCalendar;
            }
            case gregorianXlitFrenchCalendar: {
                return DateCalendarType.gregorianXlitFrenchCalendar;
            }
        }
        a.error((Object)"Failed to convert calendar types");
        throw new IllegalArgumentException();
    }

    static DateEraType a(EraType eraType) {
        switch (eraType) {
            case longEra: {
                return DateEraType.longEra;
            }
            case noEra: {
                return DateEraType.noEra;
            }
            case shortEra: {
                return DateEraType.shortEra;
            }
        }
        a.error((Object)"Failed to convert date era types");
        throw new IllegalArgumentException();
    }

    static YearFormat a(YearType yearType) {
        switch (yearType) {
            case longYear: {
                return YearFormat.longYear;
            }
            case noYear: {
                return YearFormat.noYear;
            }
            case shortYear: {
                return YearFormat.shortYear;
            }
        }
        a.error((Object)"Failed to convert Year formats");
        throw new IllegalArgumentException();
    }

    static MonthFormat a(MonthType monthType) {
        switch (monthType) {
            case numericMonth: {
                return MonthFormat.numericMonth;
            }
            case leadingZeroNumericMonth: {
                return MonthFormat.leadingZeroNumericMonth;
            }
            case shortMonth: {
                return MonthFormat.shortMonth;
            }
            case longMonth: {
                return MonthFormat.longMonth;
            }
            case noMonth: {
                return MonthFormat.noMonth;
            }
        }
        a.error((Object)"Failed to convert month formats");
        throw new IllegalArgumentException();
    }

    static DayFormat a(DayType dayType) {
        switch (dayType) {
            case numericDay: {
                return DayFormat.numericDay;
            }
            case leadingZeroNumericDay: {
                return DayFormat.leadingZeroNumericDay;
            }
            case noDay: {
                return DayFormat.noDay;
            }
        }
        a.error((Object)"Failed to convert day formats");
        throw new IllegalArgumentException();
    }

    static com.crystaldecisions.sdk.occa.report.definition.DayOfWeekEnclosure a(DayOfWeekEnclosure dayOfWeekEnclosure) {
        switch (dayOfWeekEnclosure) {
            case none: {
                return com.crystaldecisions.sdk.occa.report.definition.DayOfWeekEnclosure.none;
            }
            case inParentheses: {
                return com.crystaldecisions.sdk.occa.report.definition.DayOfWeekEnclosure.inParentheses;
            }
            case inFWParentheses: {
                return com.crystaldecisions.sdk.occa.report.definition.DayOfWeekEnclosure.inFWParentheses;
            }
            case inSquareBrackets: {
                return com.crystaldecisions.sdk.occa.report.definition.DayOfWeekEnclosure.inSquareBrackets;
            }
            case inFWSquareBrackets: {
                return com.crystaldecisions.sdk.occa.report.definition.DayOfWeekEnclosure.inFWSquareBrackets;
            }
        }
        a.error((Object)"Failed to convert day of week enclosure");
        throw new IllegalArgumentException();
    }

    static DateTimeOrder a(com.crystalreports.sdk.enums.DateTimeOrder dateTimeOrder) {
        switch (dateTimeOrder) {
            case dateThenTime: {
                return DateTimeOrder.dateThenTime;
            }
            case timeThenDate: {
                return DateTimeOrder.timeThenDate;
            }
            case dateOnly: {
                return DateTimeOrder.dateOnly;
            }
            case timeOnly: {
                return DateTimeOrder.timeOnly;
            }
        }
        a.error((Object)"Failed to convert date time formats");
        throw new IllegalArgumentException();
    }

    static AMPMFormat a(AMPMType aMPMType) {
        switch (aMPMType) {
            case before: {
                return AMPMFormat.before;
            }
            case after: {
                return AMPMFormat.after;
            }
        }
        a.error((Object)"Failed to convert AMPM type");
        throw new IllegalArgumentException();
    }

    static HourFormat a(HourType hourType) {
        switch (hourType) {
            case numericHour: {
                return HourFormat.numericHour;
            }
            case numericHourNoLeadingZero: {
                return HourFormat.noLeadingZeroNumericHour;
            }
            case noHour: {
                return HourFormat.noHour;
            }
        }
        a.error((Object)"Failed to convert hour type");
        throw new IllegalArgumentException();
    }

    static MinuteFormat a(MinuteType minuteType) {
        switch (minuteType) {
            case numericMinute: {
                return MinuteFormat.numericMinute;
            }
            case numericMinuteNoLeadingZero: {
                return MinuteFormat.noLeadingZeroNumericMinute;
            }
            case noMinute: {
                return MinuteFormat.noMinute;
            }
        }
        a.error((Object)"Failed to convert minute type");
        throw new IllegalArgumentException();
    }

    static SecondFormat a(SecondType secondType) {
        switch (secondType) {
            case noSecond: {
                return SecondFormat.noSecond;
            }
            case numericSecond: {
                return SecondFormat.numericSecond;
            }
            case numericSecondNoLeadingZero: {
                return SecondFormat.noLeadingZeroNumericSecond;
            }
        }
        a.error((Object)"Failed to convert seconds type");
        throw new IllegalArgumentException();
    }

    static TimeBase a(ClockType clockType) {
        switch (clockType) {
            case mod12: {
                return TimeBase.TwelveHour;
            }
            case mod24: {
                return TimeBase.TwentyFourHour;
            }
        }
        a.error((Object)"Failed to convert time bases type");
        throw new IllegalArgumentException();
    }

    static CurrencyPositionFormat a(CurrencyPosition currencyPosition) {
        switch (currencyPosition) {
            case leadingCurrencyInsideNegative: {
                return CurrencyPositionFormat.leadingCurrencyInsideNegative;
            }
            case leadingCurrencyOutsideNegative: {
                return CurrencyPositionFormat.leadingCurrencyOutsideNegative;
            }
            case trailingCurrencyInsideNegative: {
                return CurrencyPositionFormat.trailingCurrencyInsideNegative;
            }
            case trailingCurrencyOutsideNegative: {
                return CurrencyPositionFormat.trailingCurrencyOutsideNegative;
            }
        }
        a.error((Object)"Failed to convert currency position formats");
        throw new IllegalArgumentException();
    }

    static com.crystaldecisions.sdk.occa.report.definition.CurrencySymbolType a(CurrencySymbolType currencySymbolType) {
        switch (currencySymbolType) {
            case none: {
                return com.crystaldecisions.sdk.occa.report.definition.CurrencySymbolType.noSymbol;
            }
            case fixed: {
                return com.crystaldecisions.sdk.occa.report.definition.CurrencySymbolType.fixedSymbol;
            }
            case floating: {
                return com.crystaldecisions.sdk.occa.report.definition.CurrencySymbolType.floatingSymbol;
            }
        }
        a.error((Object)"Failed to convert currency symbol types");
        throw new IllegalArgumentException();
    }

    static NegativeType a(com.crystalreports.sdk.enums.NegativeType negativeType) {
        switch (negativeType) {
            case none: {
                return NegativeType.notNegative;
            }
            case leadingMinus: {
                return NegativeType.leadingMinus;
            }
            case trailingMinus: {
                return NegativeType.trailingMinus;
            }
            case bracketed: {
                return NegativeType.bracketed;
            }
        }
        a.error((Object)"Failed to convert negative types");
        throw new IllegalArgumentException();
    }

    static com.crystaldecisions.sdk.occa.report.definition.RoundingType a(RoundingType roundingType) {
        switch (roundingType) {
            case toTenBillionth: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToTenBillionth;
            }
            case toBillionth: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToBillionth;
            }
            case toHundredMillionth: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToHundredMillionth;
            }
            case toTenMillionth: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToTenMillionth;
            }
            case toMillionth: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToMillionth;
            }
            case toHundredThousandth: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToHundredThousandth;
            }
            case toTenThousandth: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToTenThousandth;
            }
            case toThousandth: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToThousandth;
            }
            case toHundredth: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToHundredth;
            }
            case toTenth: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToTenth;
            }
            case toUnit: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToUnit;
            }
            case toTen: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToTen;
            }
            case toHundred: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToHundred;
            }
            case toThousand: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToThousand;
            }
            case toTenThousand: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToTenThousand;
            }
            case toHundredThousand: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToHundredThousand;
            }
            case toMillion: {
                return com.crystaldecisions.sdk.occa.report.definition.RoundingType.roundToMillion;
            }
        }
        a.error((Object)"Failed to convert numeric rounding types");
        throw new IllegalArgumentException();
    }

    static ReadingOrder a(ReadingOrderType readingOrderType) {
        switch (readingOrderType) {
            case leftToRightOrder: {
                return ReadingOrder.leftToRight;
            }
            case rightToLeftOrder: {
                return ReadingOrder.rightToLeft;
            }
        }
        a.error((Object)"Failed to convert reading order types");
        throw new IllegalArgumentException();
    }

    static com.crystaldecisions.sdk.occa.report.definition.LineSpacingType a(LineSpacingType lineSpacingType) {
        switch (lineSpacingType) {
            case exact: {
                return com.crystaldecisions.sdk.occa.report.definition.LineSpacingType.exactSpacing;
            }
            case multiple: {
                return com.crystaldecisions.sdk.occa.report.definition.LineSpacingType.multipleSpacing;
            }
        }
        a.error((Object)"Failed to convert line spacing types");
        throw new IllegalArgumentException();
    }

    static double a(LineSpacingType lineSpacingType, int n2) {
        double d10 = n2;
        if (lineSpacingType == LineSpacingType.multiple) {
            d10 = StringFieldProperties.a(n2);
        }
        return d10;
    }

    static DetailPrintDirection a(DetailPrintingDirection detailPrintingDirection) {
        switch (detailPrintingDirection) {
            case acrossThenDown: {
                return DetailPrintDirection.acrossThenDown;
            }
            case downThenAcross: {
                return DetailPrintDirection.downThenAcross;
            }
        }
        a.error((Object)"Failed to convert detail printing directions");
        throw new IllegalArgumentException();
    }

    static void a(CrossTabStyle crossTabStyle, ICrossTabStyle iCrossTabStyle) {
        iCrossTabStyle.enableIndentColumnLabels(crossTabStyle.char());
        iCrossTabStyle.enableIndentRowLabels(crossTabStyle.h());
        iCrossTabStyle.setColumnLabelIndentHeight(crossTabStyle.b());
        iCrossTabStyle.setRowLabelIndentWidth(crossTabStyle.int());
        iCrossTabStyle.setColumnTotalsOnTop(crossTabStyle.goto());
        iCrossTabStyle.setRowTotalsOnLeft(crossTabStyle.byte());
        iCrossTabStyle.setKeepColumnsTogether(crossTabStyle.new());
        iCrossTabStyle.setRepeatRowLabels(crossTabStyle.f());
        iCrossTabStyle.setSuppressColumnGrandTotals(crossTabStyle.void());
        iCrossTabStyle.setSuppressRowGrandTotals(crossTabStyle.for());
        iCrossTabStyle.setSuppressEmptyColumns(crossTabStyle.c());
        iCrossTabStyle.setSuppressEmptyRows(crossTabStyle.d());
        iCrossTabStyle.setShowSummaryLabels(crossTabStyle.m());
        boolean bl2 = crossTabStyle.if();
        bl2 = bl2 || crossTabStyle.g();
        bl2 = bl2 || crossTabStyle.j();
        bl2 = bl2 || crossTabStyle.l();
        bl2 = bl2 || crossTabStyle.i();
        bl2 = bl2 || crossTabStyle.n();
        iCrossTabStyle.setShowGridlines(bl2);
    }

    static SummarizedFieldDirection a(FieldGrid.FieldGridArrangementType fieldGridArrangementType) {
        return fieldGridArrangementType == FieldGrid.FieldGridArrangementType.if ? SummarizedFieldDirection.horizontal : SummarizedFieldDirection.vertical;
    }

    static void a(GridGroup gridGroup, ICrossTabGroupFormat iCrossTabGroupFormat) {
        IGroupOptions iGroupOptions = ((CrossTabGroupCondition)gridGroup.a()).byte();
        iCrossTabGroupFormat.enableSuppressLabel(iGroupOptions.a4());
        iCrossTabGroupFormat.enableSuppressSubtotal(iGroupOptions.aK());
        iCrossTabGroupFormat.setBackgroundColor(JRCToEROMTypeUtility.a(gridGroup.y()));
    }

    static CrossTabChartOrientation a(ValueGridOrientation valueGridOrientation, boolean bl2) {
        switch (valueGridOrientation.a()) {
            case 1: {
                return bl2 ? CrossTabChartOrientation.bothColumns : CrossTabChartOrientation.firstColumn;
            }
            case 3: {
                return bl2 ? CrossTabChartOrientation.mixedColumnRow : CrossTabChartOrientation.firstColumn;
            }
            case 0: {
                return bl2 ? CrossTabChartOrientation.bothRows : CrossTabChartOrientation.firstRow;
            }
            case 2: {
                return bl2 ? CrossTabChartOrientation.mixedRowColumn : CrossTabChartOrientation.firstRow;
            }
        }
        return CrossTabChartOrientation.noData;
    }

    static Color a(Color color) {
        if (color == null) {
            return new Color(255, 255, 255, 0);
        }
        return color;
    }

    static String a(FieldDefinition fieldDefinition) {
        SummaryFieldDefinition summaryFieldDefinition;
        String string = fieldDefinition.getFormulaForm();
        if (fieldDefinition.pm() && (summaryFieldDefinition = (SummaryFieldDefinition)fieldDefinition).sK().a()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append(", ");
            stringBuilder.append("\"");
            stringBuilder.append("across hierarchy");
            stringBuilder.append("\")");
            string = stringBuilder.toString();
        }
        return string;
    }

    static PaperOrientation a(PageOrientationType pageOrientationType) {
        switch (pageOrientationType) {
            case landscape: {
                return PaperOrientation.landscape;
            }
            case portrait: {
                return PaperOrientation.portrait;
            }
            case reverseLandscape: {
                return PaperOrientation.useDefault;
            }
        }
        a.error((Object)"Failed to convert detail printing directions");
        throw new IllegalArgumentException();
    }

    public static Object convertCrystalValue(CrystalValue crystalValue, TimeZone timeZone) {
        if (crystalValue == null) {
            return null;
        }
        return JRCToEROMTypeUtility.convertCrystalValue(crystalValue, crystalValue.getValueType(), timeZone);
    }

    public static Object convertCrystalValue(CrystalValue crystalValue, ValueType valueType, TimeZone timeZone) {
        if (crystalValue == null) {
            return null;
        }
        switch (valueType.value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new Integer(((NumericValue)crystalValue).getInt());
            }
            case 17: 
            case 18: {
                return new Long(((NumericValue)crystalValue).getLong());
            }
            case 6: 
            case 7: 
            case 16: {
                return new Double(((NumericValue)crystalValue).getDouble());
            }
            case 8: {
                return ((BooleanValue)crystalValue).getBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: 
            case 13: {
                return ((StringValue)crystalValue).getString();
            }
            case 9: {
                DateValue dateValue = (DateValue)crystalValue;
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                ((Calendar)gregorianCalendar).setTimeZone(timeZone == null ? TimeZone.getDefault() : timeZone);
                gregorianCalendar.set(1, dateValue.getYear());
                gregorianCalendar.set(2, dateValue.getMonth() - 1);
                gregorianCalendar.set(5, dateValue.getDay());
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                return gregorianCalendar.getTime();
            }
            case 10: {
                TimeValue timeValue = (TimeValue)crystalValue;
                return new Time(timeValue.getHours(), timeValue.getMinutes(), timeValue.getWholeSeconds());
            }
            case 15: {
                DateTimeValue dateTimeValue = (DateTimeValue)crystalValue;
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                ((Calendar)gregorianCalendar).setTimeZone(timeZone == null ? TimeZone.getDefault() : timeZone);
                DateValue dateValue = dateTimeValue.getDateValue() == null ? DateValue.now() : dateTimeValue.getDateValue();
                gregorianCalendar.set(1, dateValue.getYear());
                gregorianCalendar.set(2, dateValue.getMonth() - 1);
                gregorianCalendar.set(5, dateValue.getDay());
                TimeValue timeValue = dateTimeValue.getTimeValue() == null ? TimeValue.now() : dateTimeValue.getTimeValue();
                gregorianCalendar.set(11, timeValue.getHours());
                gregorianCalendar.set(12, timeValue.getMinutes());
                gregorianCalendar.set(13, timeValue.getWholeSeconds());
                gregorianCalendar.set(14, (int)(timeValue.getNanoseconds() / 1000000L));
                return gregorianCalendar.getTime();
            }
            case 14: {
                BinaryValue binaryValue = (BinaryValue)crystalValue;
                return new ByteArray(binaryValue.getAllBytes());
            }
        }
        a.error((Object)"Failed to convert CrystalValue");
        throw new IllegalArgumentException();
    }

    public static PictureType convertToPictureType(ICrystalImage iCrystalImage) {
        if (iCrystalImage instanceof BitmapImage) {
            return PictureType.bitmap;
        }
        if (iCrystalImage instanceof EMFImage) {
            return PictureType.emf;
        }
        if (iCrystalImage instanceof WMFImage) {
            return PictureType.wmf;
        }
        return PictureType.unknown;
    }

    static UnsupportedFeatureType a(MissingFeatureType missingFeatureType) {
        switch (missingFeatureType.value()) {
            case 0: {
                return UnsupportedFeatureType.reportsWithVBSyntaxFormulas;
            }
            case 1: {
                return UnsupportedFeatureType.fieldObjectsSqlExpressionFields;
            }
            case 2: {
                return UnsupportedFeatureType.objectPropertiesReadOnly;
            }
            case 3: {
                return UnsupportedFeatureType.objectPropertiesLockSizePosition;
            }
            case 4: {
                return UnsupportedFeatureType.chartsChartTexturesAndPictures;
            }
            case 5: {
                return UnsupportedFeatureType.chartsCrosstabOrGroup;
            }
            case 6: {
                return UnsupportedFeatureType.data;
            }
            case 7: {
                return UnsupportedFeatureType.geographicMaps;
            }
            case 8: {
                return UnsupportedFeatureType.flashObjects;
            }
            case 20: {
                return UnsupportedFeatureType.font;
            }
            case 9: {
                return UnsupportedFeatureType.subreportsReimport;
            }
            case 10: {
                return UnsupportedFeatureType.alerts;
            }
            case 11: {
                return UnsupportedFeatureType.dynamicCascadingPrompts;
            }
            case 12: {
                return UnsupportedFeatureType.commandTables;
            }
            case 13: {
                return UnsupportedFeatureType.reposisObject;
            }
            case 14: {
                return UnsupportedFeatureType.textObjects;
            }
            case 15: {
                return UnsupportedFeatureType.readOnlyReport;
            }
            case 16: {
                return UnsupportedFeatureType.olapGridObjects;
            }
            case 17: {
                return UnsupportedFeatureType.chartsOlap;
            }
            case 18: {
                return UnsupportedFeatureType.highlightingExpert;
            }
            case 19: {
                return UnsupportedFeatureType.originalOrderGrouping;
            }
            case 21: {
                return UnsupportedFeatureType.verifyOnFirstRefresh;
            }
            case 22: {
                return UnsupportedFeatureType.interactiveSorting;
            }
            case 23: {
                return UnsupportedFeatureType.webPagination;
            }
            case 24: {
                return UnsupportedFeatureType.enhancedCrosstabFeatures;
            }
        }
        a.error((Object)"Failed to convert CrystalValue");
        throw new IllegalArgumentException();
    }
}

