/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.logging.log4j;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class BOLayout
extends PatternLayout {
    private static final TimeZone utc = new SimpleTimeZone(0, "U_T_C");
    private static final SimpleDateFormat logDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static final String STR_PIPE_NOT_USED = "|||||||||||||||";

    public String format(LoggingEvent event) {
        String strFormatted;
        String msg = super.format(event);
        if (msg.indexOf(STR_PIPE_NOT_USED) == -1) {
            String imp = event.getLevel().toString();
            String severity = "";
            switch (event.getLevel().toInt()) {
                case 10000: {
                    imp = "<<";
                    break;
                }
                case 20000: {
                    imp = "<=";
                    break;
                }
                case 30000: {
                    imp = "==";
                    severity = "W";
                    break;
                }
                case 40000: {
                    imp = ">=";
                    severity = "E";
                    break;
                }
                case 50000: {
                    imp = ">>";
                    severity = "E";
                }
            }
            strFormatted = this.format(imp, severity, msg, " ");
        } else {
            strFormatted = msg;
        }
        return strFormatted;
    }

    private String getLogDateFormatted() {
        GregorianCalendar gc = new GregorianCalendar(utc);
        Date d1 = gc.getTime();
        logDateFormat.setCalendar(gc);
        String sd = logDateFormat.format(d1);
        return sd;
    }

    private String format(String imp, String severity, String msg, String strScope) {
        StringBuffer line = new StringBuffer();
        StringBuffer bufferDate = new StringBuffer();
        bufferDate.append(this.getLogDateFormatted());
        StringBuffer bufferImp = new StringBuffer();
        bufferImp.append(imp);
        StringBuffer bufferSeverity = new StringBuffer();
        bufferSeverity.append(severity);
        StringBuffer bufferMsg = new StringBuffer();
        bufferMsg.append(msg);
        line.append(bufferDate.toString());
        line.append("|");
        line.append(bufferImp.toString());
        line.append("|");
        line.append(bufferSeverity.toString());
        line.append("||");
        line.append(System.getProperty("BO_ASF_TRACE_PID", "0"));
        line.append("|");
        String thid = Thread.currentThread().getName();
        thid = thid.substring(1 + thid.indexOf("-"));
        line.append(thid);
        line.append("|");
        line.append(strScope);
        line.append(STR_PIPE_NOT_USED);
        line.append(bufferMsg.toString());
        return line.toString();
    }
}

