/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.exception;

import com.businessobjects.foundation.exception.ExceptionSerializer;
import com.businessobjects.foundation.exception.IException;
import com.businessobjects.foundation.exception.IInternalException;
import com.businessobjects.foundation.exception.ResourceFinder;
import com.businessobjects.foundation.language.LangException;
import com.businessobjects.foundation.language.LangMgr;
import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class ExceptionWorker
implements Serializable {
    private static final long serialVersionUID = 854575151617074882L;
    private static final Locale DEFAULT_LOCALE;
    private static final String EMPTY_SPACE = " ";
    private static final ILogger LOG;
    private static ThreadLocal s_threadLocale;
    private HashMap m_errorMessages = new HashMap();
    private String m_defaultErrorMessage;
    private Object[] m_args;
    private String m_errorCode;
    private Throwable m_exception;
    private String m_resourceID;
    private ClassLoader m_classLoader;
    private String m_strID;
    private boolean m_installedLanguagesMissing = false;
    private String m_stackTrace = null;
    private boolean m_isCheckedException = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    ExceptionWorker(String errorCode, Object[] args, ClassLoader classLoader, Throwable exception, boolean isCheckedException) {
        if (!$assertionsDisabled && classLoader == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && exception == null) {
            throw new AssertionError();
        }
        this.m_classLoader = classLoader;
        this.m_args = args;
        this.m_exception = exception;
        this.m_errorCode = errorCode;
        this.m_isCheckedException = isCheckedException;
        String resourceID = exception.getClass().getName();
        int delim = (resourceID = resourceID.replace('.', '/')).lastIndexOf(36);
        if (delim != -1) {
            this.m_strID = resourceID.substring(delim + 1);
            resourceID = resourceID.substring(0, delim);
        } else {
            delim = resourceID.lastIndexOf(47);
            this.m_strID = delim != -1 ? resourceID.substring(delim + 1) : resourceID;
        }
        this.m_resourceID = resourceID + "Resources";
        this.initErrorCode();
        this.getErrorMessages();
    }

    ExceptionWorker(String resourceID, String strID, ClassLoader classLoader, Object[] args, Throwable exception, boolean isCheckedException) {
        this.m_isCheckedException = isCheckedException;
        this.m_args = this.verifyArguments(args);
        this.m_exception = exception;
        this.m_resourceID = resourceID;
        this.m_strID = strID;
        this.m_classLoader = classLoader;
        if (!$assertionsDisabled && exception == null) {
            throw new AssertionError();
        }
        this.initErrorCode();
        this.getErrorMessages();
    }

    ExceptionWorker(String resourceID, String strID, ClassLoader classLoader, String errorCode, Object[] args, Throwable exception, boolean isCheckedException) {
        this.m_isCheckedException = isCheckedException;
        this.m_args = this.verifyArguments(args);
        this.m_exception = exception;
        this.m_errorCode = errorCode;
        this.m_resourceID = resourceID;
        this.m_strID = strID;
        this.m_classLoader = classLoader;
        if (!$assertionsDisabled && exception == null) {
            throw new AssertionError();
        }
        this.initErrorCode();
        this.getErrorMessages();
    }

    ExceptionWorker(String errorCode, Object[] args, Throwable exception, HashMap messages, boolean isCheckedException) {
        this.m_isCheckedException = isCheckedException;
        this.m_args = this.verifyArguments(args);
        this.m_exception = exception;
        this.m_errorCode = errorCode;
        this.m_errorMessages = messages;
    }

    protected Throwable getCause() {
        return this.m_exception.getCause();
    }

    public static Locale getMessageLocale() {
        Locale locale = (Locale)s_threadLocale.get();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale == null) {
            locale = DEFAULT_LOCALE;
        }
        return locale;
    }

    protected boolean isCheckedException() {
        return this.m_isCheckedException;
    }

    public String getMessage(Locale locale) {
        String msg;
        block8: {
            msg = null;
            if (this.m_errorMessages.containsKey(locale)) {
                msg = (String)this.m_errorMessages.get(locale);
            } else if (this.m_resourceID != null && this.m_classLoader != null && this.m_strID != null) {
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle(this.m_resourceID, locale, this.m_classLoader);
                    msg = this.constructErrorMessage(bundle, locale);
                    if (!msg.equalsIgnoreCase(this.m_defaultErrorMessage)) {
                        this.m_errorMessages.put(locale, msg);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug("getErrorMessage(): cannot obtain string, bundle: " + this.m_resourceID + ", strID: " + this.m_strID + ", locale: " + locale, e);
                }
            }
        }
        if (msg == null) {
            msg = this.m_defaultErrorMessage;
        }
        if (msg != null) {
            MessageFormat format = new MessageFormat(msg, locale);
            return format.format(this.m_args);
        }
        return null;
    }

    public String getDetailMessage(Locale locale) {
        StringBuffer builder = new StringBuffer();
        String errorMsg = this.getMessage(locale);
        builder.append(errorMsg);
        Throwable cause = this.getCause();
        if (cause != null) {
            String detail = null;
            if (cause instanceof IException) {
                IException bobjException = (IException)((Object)cause);
                detail = bobjException.getDetailMessage(locale);
            } else {
                detail = cause.getLocalizedMessage();
            }
            builder.append(EMPTY_SPACE);
            builder.append(detail);
        }
        return builder.toString();
    }

    public static void setThreadLocale(Locale locale) {
        s_threadLocale.set(locale);
    }

    public String serialize(String stackTrace) {
        this.checkForMoreLanguages();
        ExceptionSerializer serializer = new ExceptionSerializer(this, this.m_errorMessages, this.m_args, stackTrace);
        return serializer.serialize();
    }

    protected void setStackTrace(String stack) {
        this.m_stackTrace = stack;
    }

    public String getErrorCode() {
        return this.m_errorCode;
    }

    public Object[] getParams() {
        return this.m_args;
    }

    public String getDeeperErrorCode() {
        String code = this.m_errorCode;
        for (Throwable baseException = this.getCause(); baseException != null; baseException = baseException.getCause()) {
            if (!(baseException instanceof IException)) continue;
            IException baseEx = (IException)((Object)baseException);
            String tmpErrorCode = baseEx.getErrorCodeString();
            if (tmpErrorCode == null) break;
            code = tmpErrorCode;
            break;
        }
        return code;
    }

    static Throwable deserialize(String serializedException) {
        return ExceptionSerializer.deserialize(serializedException);
    }

    private void getErrorMessages() {
        block9: {
            block8: {
                if (this.m_resourceID == null || this.m_classLoader == null) {
                    LOG.error("getErrorMessage():  resourceID or classLoader is null");
                    return;
                }
                try {
                    ResourceBundle defaultBundle = ResourceBundle.getBundle(this.m_resourceID, Locale.ENGLISH, this.m_classLoader);
                    this.m_defaultErrorMessage = this.constructErrorMessage(defaultBundle, Locale.ENGLISH);
                }
                catch (MissingResourceException e) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug(ExceptionWorker.class.getName() + ".getErrorMessage(): cannot obtain default string English bundle. " + this.m_resourceID + ", strID: " + this.m_strID);
                }
            }
            List locales = null;
            try {
                locales = this.getSupportedLanguages();
            }
            catch (LangException e) {
                this.m_installedLanguagesMissing = true;
                LOG.error("getErrorMessage(): cannot obtain installed locales");
            }
            this.cacheErrorMessages(locales);
            Locale defaultLocale = Locale.getDefault();
            if (!(defaultLocale == null || defaultLocale.equals(Locale.ENGLISH) || locales != null && locales.contains(defaultLocale))) {
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle(this.m_resourceID, defaultLocale, this.m_classLoader);
                    this.m_errorCode = bundle.getString(this.m_strID + "_code");
                    String message = this.constructErrorMessage(bundle, defaultLocale);
                    this.m_errorMessages.put(defaultLocale, message);
                }
                catch (MissingResourceException e) {
                    if (!LOG.isDebugEnabled()) break block9;
                    LOG.debug(ExceptionWorker.class.getName() + ".getErrorMessage(): cannot obtain resource bundle. " + this.m_resourceID + ", strID: " + this.m_strID + ", locale: " + defaultLocale.toString());
                }
            }
        }
    }

    private void cacheErrorMessages(List locales) {
        if (locales != null) {
            Iterator localeIter = locales.iterator();
            while (localeIter.hasNext()) {
                Locale locale = (Locale)localeIter.next();
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle(this.m_resourceID, locale, this.m_classLoader);
                    String message = this.constructErrorMessage(bundle, locale);
                    if (this.m_errorMessages.containsKey(locale)) continue;
                    this.m_errorMessages.put(locale, message);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("getErrorMessage(): cannot obtain string. bundle: " + this.m_resourceID + ", strID: " + this.m_strID + ", locale: " + locale, e);
                }
            }
        }
    }

    private void checkForMoreLanguages() {
        if (this.m_installedLanguagesMissing) {
            List locales = ResourceFinder.findResourceLocales(this.m_classLoader, this.m_resourceID);
            this.cacheErrorMessages(locales);
        }
    }

    private List getSupportedLanguages() throws LangException {
        LangMgr lmgr = LangMgr.makeLangMgr();
        return lmgr.getInstalledLocales();
    }

    private Object[] verifyArguments(Object[] args) {
        if (args != null) {
            Object[] verifiedArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                verifiedArgs[i] = arg instanceof String || arg instanceof Date || arg instanceof Number || arg instanceof Boolean ? arg : (arg != null ? arg.toString() : "null");
            }
            return verifiedArgs;
        }
        return new Object[0];
    }

    protected void printStackTrace() {
        this.printStackTrace(System.err);
    }

    protected void printStackTrace(PrintStream s) {
        if (this.m_stackTrace != null) {
            s.print(this.m_stackTrace);
        } else {
            this.m_exception.getCause().printStackTrace(s);
        }
    }

    private String constructErrorMessage(ResourceBundle bundle, Locale locale) {
        String message = null;
        if (this.m_exception instanceof IInternalException) {
            message = ((IInternalException)((Object)this.m_exception)).constructErrorMessage(bundle, locale, this.m_strID);
        }
        if (message == null) {
            message = bundle.getString(this.m_strID);
            if (this.m_errorCode != null && this.m_errorCode.length() != 0) {
                message = message + " (" + this.m_errorCode + ")";
            }
        }
        return message;
    }

    private void initErrorCode() {
        block3: {
            if (this.m_errorCode == null) {
                Locale defaultLocale = ExceptionWorker.getMessageLocale();
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle(this.m_resourceID, defaultLocale, this.m_classLoader);
                    this.m_errorCode = bundle.getString(this.m_strID + "_code");
                }
                catch (MissingResourceException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("getErrorMessage(): cannot obtain string. bundle: " + this.m_resourceID + ", strID: " + this.m_strID + "_code", e);
                }
            }
        }
    }

    static {
        $assertionsDisabled = !ExceptionWorker.class.desiredAssertionStatus();
        DEFAULT_LOCALE = Locale.ENGLISH;
        LOG = LoggerManager.getLogger(ExceptionWorker.class);
        s_threadLocale = new ThreadLocal();
    }
}

