/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleOpaque;
import oracle.sql.ANYDATA;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;

public class OPAQUE
extends DatumWithConnection
implements OracleOpaque {
    OpaqueDescriptor descriptor;
    byte[] value;
    long imageOffset;
    long imageLength;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public OPAQUE(OpaqueDescriptor opaqueDescriptor, Connection connection, Object object) throws SQLException {
        if (opaqueDescriptor == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 61, "OPAQUE");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.descriptor = opaqueDescriptor;
        if (connection != null) {
            this.setPhysicalConnectionOf(connection);
        }
        if (object instanceof ANYDATA) {
            ANYDATA aNYDATA = (ANYDATA)object;
            byte[] byArray = new byte[aNYDATA.getImageSize()];
            aNYDATA.pickle(byArray, 0);
            this.value = byArray;
        } else if (object instanceof byte[]) {
            this.value = (byte[])object;
        } else {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    public OPAQUE(OpaqueDescriptor opaqueDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        this.setPhysicalConnectionOf(connection);
        this.descriptor = opaqueDescriptor;
        this.value = null;
    }

    public String getSQLTypeName() throws SQLException {
        return this.descriptor.getName();
    }

    public String stringValue() throws SQLException {
        String string;
        block10: {
            string = "OPAQUE";
            try {
                Method method;
                String string2 = null;
                Object object = this.toJdbc();
                Class<?> clazz = object.getClass();
                if (clazz.equals(this.getClass())) break block10;
                try {
                    method = clazz.getMethod("getStringVal", new Class[0]);
                    if (method.getDeclaringClass().equals(clazz)) {
                        string2 = (String)method.invoke(object, new Object[0]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string2 == null) {
                    try {
                        method = clazz.getMethod("stringValue", new Class[0]);
                        if (method.getDeclaringClass() == clazz) {
                            string2 = (String)method.invoke(object, new Object[0]);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string2 != null) {
                    string = string + "(" + string2 + ")";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        return this.getDescriptor();
    }

    public OpaqueDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    public void setDescriptor(OpaqueDescriptor opaqueDescriptor) {
        this.descriptor = opaqueDescriptor;
    }

    public byte[] toBytes() throws SQLException {
        return this.descriptor.toBytes(this, false);
    }

    public Object getValue() throws SQLException {
        return this.descriptor.toValue(this, false);
    }

    public byte[] getBytesValue() throws SQLException {
        return this.descriptor.toValue(this, false);
    }

    public void setValue(byte[] byArray) throws SQLException {
        this.value = byArray;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public Object makeJdbcArray(int n2) {
        return new Object[n2];
    }

    public Map getMap() {
        try {
            return this.getInternalConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public Object toJdbc() throws SQLException {
        Map map = this.getMap();
        return this.toJdbc(map);
    }

    public Object toJdbc(Map map) throws SQLException {
        Class clazz;
        Object object = this;
        if (map != null && (clazz = this.descriptor.getClass(map)) != null) {
            object = this.toClass(clazz, map);
        }
        return object;
    }

    public Object toClass(Class clazz) throws SQLException {
        return this.toClass(clazz, this.getMap());
    }

    public Object toClass(Class clazz, Map map) throws SQLException {
        Object object = null;
        try {
            if (clazz == null || clazz == OPAQUE.class) {
                object = this;
            } else {
                Object object2 = null;
                Object t = clazz.newInstance();
                if (t instanceof ORADataFactory) {
                    ORADataFactory oRADataFactory = (ORADataFactory)t;
                    object2 = oRADataFactory.create(this, 2007);
                } else if (t instanceof OracleDataFactory) {
                    OracleDataFactory oracleDataFactory = (OracleDataFactory)t;
                    object2 = oracleDataFactory.create(this, 2007);
                } else {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                object = object2;
            }
        }
        catch (InstantiationException instantiationException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + instantiationException.getMessage());
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (IllegalAccessException illegalAccessException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + illegalAccessException.getMessage());
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return object;
    }

    public void setImage(byte[] byArray, long l2, long l3) throws SQLException {
        this.setShareBytes(byArray);
        this.imageOffset = l2;
        this.imageLength = l3;
    }

    public void setImageLength(long l2) throws SQLException {
        this.imageLength = l2;
    }

    public long getImageOffset() {
        return this.imageOffset;
    }

    public long getImageLength() {
        return this.imageLength;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }
}

