/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionPoolDataSource
extends OracleDataSource
implements ConnectionPoolDataSource {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public OracleConnectionPoolDataSource() throws SQLException {
        this.dataSourceName = "OracleConnectionPoolDataSource";
        this.isOracleDataSource = false;
        this.connCachingEnabled = false;
        this.fastConnFailover = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledConnection getPooledConnection() throws SQLException {
        String string = null;
        String string2 = null;
        OracleConnectionPoolDataSource oracleConnectionPoolDataSource = this;
        synchronized (oracleConnectionPoolDataSource) {
            string = this.user;
            string2 = this.password;
        }
        return this.getPooledConnection(string, string2);
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        Connection connection = this.getPhysicalConnection(string, string2);
        OraclePooledConnection oraclePooledConnection = new OraclePooledConnection(connection);
        if (string2 == null) {
            string2 = this.password;
        }
        oraclePooledConnection.setUserName(!string.startsWith("\"") ? string.toLowerCase() : string, string2);
        return oraclePooledConnection;
    }

    PooledConnection getPooledConnection(Properties properties) throws SQLException {
        String string;
        Connection connection = this.getPhysicalConnection(properties);
        OraclePooledConnection oraclePooledConnection = new OraclePooledConnection(connection);
        String string2 = properties.getProperty("user");
        if (string2 == null) {
            string2 = ((OracleConnection)connection).getUserName();
        }
        if ((string = properties.getProperty("password")) == null) {
            string = this.password;
        }
        oraclePooledConnection.setUserName(!string2.startsWith("\"") ? string2.toLowerCase() : string2, string);
        return oraclePooledConnection;
    }

    protected Connection getPhysicalConnection() throws SQLException {
        return super.getConnection(this.user, this.password);
    }

    protected Connection getPhysicalConnection(String string, String string2, String string3) throws SQLException {
        this.url = string;
        return super.getConnection(string2, string3);
    }

    protected Connection getPhysicalConnection(String string, String string2) throws SQLException {
        return super.getConnection(string, string2);
    }
}

