/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.settings;

import com.businessobjects.visualization.graphic.VisuColor;
import com.businessobjects.visualization.graphic.VisuFont;
import com.businessobjects.visualization.graphic.VisuInteger;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuRGBA;
import com.businessobjects.visualization.graphic.VisuString;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Attr;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.KeyObject;
import com.businessobjects.visualization.pfjgraphics.settings.CVOMHelper;
import com.businessobjects.visualization.pfjgraphics.settings.CVOMid;
import com.businessobjects.visualization.pfjgraphics.settings.SettingsTransform;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class SettingsExceptionHandler {
    CVOMHelper cvom = null;
    static Map<Integer, CVOMid> idRemap = new HashMap<Integer, CVOMid>();
    static Map<Integer, ExceptionType> exceptions = new HashMap<Integer, ExceptionType>();
    static Map<Integer, Object> constants = new HashMap<Integer, Object>();
    static final int[] fontObjIDs = new int[]{5, 4, 3, 524, 10, 568, 11, 528, 6, 532, 7, 514, 8, 518, 9, 504, 14, 700, 705, 714, 1000, 756, 510, 539, 42, 807, 540, 541, 821, 783, 784, 2504, 2519, 2522};
    static final Attr[] fontAttrs = new Attr[]{Attr.FontName, Attr.FontSizeAbsolute, Attr.FontSizeInPoints, Attr.FontSizeVC, Attr.FontStyle, Attr.FillColor, Attr.TransparentFillColor};
    static final int[] axisColorObjs = new int[]{513, 517, 523, 527, 531, 761, 763, 765, 767, 769, 762, 764, 766, 768, 770};
    static final String[] axes = new String[]{"xaxis", "zaxis", "xaxis", "yaxis", "yaxis2"};

    public SettingsExceptionHandler(CVOMHelper cvom) {
        this.cvom = cvom;
    }

    public Object getValue(KeyObject key, CVOMid id) {
        ExceptionType eType;
        Integer hKey = SettingsExceptionHandler.hashKey(key.getIdentObj().getObjectID(), key.getAttr());
        Object obj = constants.get(hKey);
        if (obj != null) {
            return obj;
        }
        CVOMid mapID = idRemap.get(hKey);
        if (mapID != null) {
            id.remap(mapID);
        }
        if ((eType = exceptions.get(hKey)) != null) {
            switch (eType) {
                case FONT: {
                    return this.getFontObj(id);
                }
            }
            return null;
        }
        return null;
    }

    public boolean setValue(KeyObject key, CVOMid id, Object value) {
        Integer hKey = SettingsExceptionHandler.hashKey(key.getIdentObj().getObjectID(), key.getAttr());
        if (constants.containsKey(hKey)) {
            return true;
        }
        CVOMid mapID = idRemap.get(hKey);
        if (mapID != null) {
            id.remap(mapID);
        }
        if (!(key.getAttr() != Attr.TransparentFillColor && key.getAttr() != Attr.TransparentBorderColor || ((Boolean)value).booleanValue())) {
            return true;
        }
        ExceptionType eType = exceptions.get(hKey);
        if (eType != null) {
            switch (eType) {
                case FONT: {
                    return this.setFontObj(id, value);
                }
            }
            return false;
        }
        return false;
    }

    static Integer hashKey(int objID, Attr attr) {
        int hash = 7;
        hash = 31 * hash + (null == attr ? 0 : attr.hashCode());
        hash = 31 * hash + objID;
        return new Integer(hash);
    }

    Object getFontObj(CVOMid id) {
        VisuString vObj;
        VisuFont vFont = (VisuFont)this.cvom.getProperty(id.region, "font");
        if (vFont == null) {
            return null;
        }
        if (id.property.equals("fontname")) {
            vObj = vFont.getName();
        } else if (id.property.equals("bgcolor") || id.property.equals("bordercolor")) {
            vObj = new VisuColor(vFont.getFontColor());
        } else if (id.property.equals("fontstyle")) {
            vObj = vFont.getStyle();
        } else {
            if (id.property.equals("fontsizeinpoints")) {
                return new Float((float)vFont.getHeight().doubleValue());
            }
            if (id.property.equals("fontsizeabsolute")) {
                return new Boolean(true);
            }
            if (id.property.equals("fontsizevc")) {
                int vc = this.fontSizePointsToVC(vFont.getHeight().doubleValue());
                return new Integer(vc);
            }
            return null;
        }
        return id.transform.toPFJ((VisuObject)vObj);
    }

    boolean setFontObj(CVOMid id, Object value) {
        VisuFont vFont = (VisuFont)this.cvom.getProperty(id.region, "font");
        if (vFont == null) {
            return false;
        }
        String name = vFont.getName().getXmlValue();
        double size = vFont.getHeight().doubleValue();
        int style = vFont.getStyle().intValue();
        VisuRGBA color = vFont.getFontColor();
        if (id.property.equals("fontname")) {
            name = (String)value;
        } else if (id.property.equals("bgcolor")) {
            if (value instanceof Boolean) {
                color = new VisuRGBA(0, 0, 0, 255);
            } else {
                Color c = (Color)value;
                color = new VisuRGBA(c.getRed(), c.getGreen(), c.getBlue(), 255 - c.getAlpha());
            }
        } else {
            if (id.property.equals("bordercolor")) {
                return true;
            }
            if (id.property.equals("fontstyle")) {
                style = ((VisuInteger)id.transform.toCVOM(value, id.valueType)).intValue();
            } else if (id.property.equals("fontsizeinpoints")) {
                size = ((Float)value).floatValue();
            } else {
                if (id.property.equals("fontsizeabsolute")) {
                    return true;
                }
                if (id.property.equals("fontsizevc")) {
                    size = (int)this.fontSizeVCToPoints(((Integer)value).intValue());
                } else {
                    return true;
                }
            }
        }
        VisuFont newFont = new VisuFont(name, size, style, color);
        this.cvom.setProperty(id.region, "font", (VisuObject)newFont);
        return true;
    }

    private double getDocHeightInPoints() {
        VisuInteger twipHeight = (VisuInteger)this.cvom.getProperty("root", "twipheight");
        return (double)twipHeight.intValue() / 20.0;
    }

    private int fontSizePointsToVC(double fontSizePoints) {
        return (int)(fontSizePoints / this.getDocHeightInPoints() * 32000.0);
    }

    private double fontSizeVCToPoints(double fontSizeVC) {
        return fontSizeVC / 32000.0 * this.getDocHeightInPoints();
    }

    static {
        for (int pfjID : fontObjIDs) {
            for (Attr attr : fontAttrs) {
                exceptions.put(SettingsExceptionHandler.hashKey(pfjID, attr), ExceptionType.FONT);
            }
            constants.put(SettingsExceptionHandler.hashKey(pfjID, Attr.BorderColor), Color.black);
            constants.put(SettingsExceptionHandler.hashKey(pfjID, Attr.TransparentBorderColor), Boolean.FALSE);
        }
        for (int i = 0; i < axisColorObjs.length; ++i) {
            idRemap.put(SettingsExceptionHandler.hashKey(axisColorObjs[i], Attr.BorderColor), new CVOMid("root/" + axes[i % 5], "axis_color", SettingsTransform.Identity));
            idRemap.put(SettingsExceptionHandler.hashKey(axisColorObjs[i], Attr.FillColor), new CVOMid("root/" + axes[i % 5], "axis_color", SettingsTransform.Identity));
            idRemap.put(SettingsExceptionHandler.hashKey(axisColorObjs[i], Attr.TransparentBorderColor), new CVOMid("root/" + axes[i % 5], "axis_color", SettingsTransform.Identity));
            idRemap.put(SettingsExceptionHandler.hashKey(axisColorObjs[i], Attr.TransparentFillColor), new CVOMid("root/" + axes[i % 5], "axis_color", SettingsTransform.Identity));
        }
        idRemap.put(SettingsExceptionHandler.hashKey(2, Attr.FillColor), new CVOMid("root/frame", "bgrendermode/bgcolor", SettingsTransform.Identity));
        idRemap.put(SettingsExceptionHandler.hashKey(2, Attr.TransparentFillColor), new CVOMid("root/frame", "bgrendermode/bgcolor", SettingsTransform.Identity));
        idRemap.put(SettingsExceptionHandler.hashKey(546, Attr.FillColor), new CVOMid("root/frame", "bgrendermode/bgcolor", SettingsTransform.Identity));
        idRemap.put(SettingsExceptionHandler.hashKey(546, Attr.TransparentFillColor), new CVOMid("root/frame", "bgrendermode/bgcolor", SettingsTransform.Identity));
        idRemap.put(SettingsExceptionHandler.hashKey(529, Attr.BorderColor), new CVOMid("root/frame", "bgrendermode/hgridcolor", SettingsTransform.Identity));
        idRemap.put(SettingsExceptionHandler.hashKey(529, Attr.TransparentBorderColor), new CVOMid("root/frame", "bgrendermode/hgridcolor", SettingsTransform.Identity));
        for (Attr attr : fontAttrs) {
            Integer key = SettingsExceptionHandler.hashKey(14, attr);
            idRemap.put(key, new CVOMid("root/legend", "*", SettingsTransform.Identity));
            exceptions.put(key, ExceptionType.FONT);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ExceptionType {
        FONT;

    }
}

