/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.settings;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.ICVOMSettings;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.KeyObject;
import com.businessobjects.visualization.pfjgraphics.settings.CVOMHelper;
import com.businessobjects.visualization.pfjgraphics.settings.CVOMid;
import com.businessobjects.visualization.pfjgraphics.settings.IDMapper;
import com.businessobjects.visualization.pfjgraphics.settings.QuickFilter;
import com.businessobjects.visualization.pfjgraphics.settings.SettingsExceptionHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CVOMSettings
implements ICVOMSettings {
    static Logger logger = Logger.getLogger((String)"com.businessobjects.visualization.pfjgraphics.settings.CVOMSettings");
    Map<KeyObject, Object> valueCache = new HashMap<KeyObject, Object>();
    Map<KeyObject, CVOMid> idCache = new HashMap<KeyObject, CVOMid>();
    Set<KeyObject> failCache = new HashSet<KeyObject>();
    SettingsExceptionHandler exceptions = null;
    CVOMHelper cvom = null;
    QuickFilter quickFilter = null;
    private boolean isReadOnly = false;

    public CVOMSettings(CVOMHelper cvom) {
        this.cvom = cvom;
        this.exceptions = new SettingsExceptionHandler(cvom);
        this.quickFilter = new QuickFilter(cvom);
    }

    public Object getValue(KeyObject key) {
        Object value = this.valueCache.get(key);
        if (value != null) {
            return value;
        }
        CVOMid id = this.calcCVOMID(key);
        if (id == null) {
            return null;
        }
        value = this.exceptions.getValue(key, id);
        if (value != null) {
            this.valueCache.put(key, value);
            return value;
        }
        try {
            value = this.cvom.getProperty(id);
        }
        catch (RuntimeException e) {
            logger.warn((Object)("Missing XML get property: " + id.toString() + " " + key.toString()));
            return null;
        }
        this.valueCache.put(key, value);
        return value;
    }

    public boolean setValue(KeyObject key, Object value) {
        if (this.isReadOnly) {
            return false;
        }
        if (value.equals(this.valueCache.get(key))) {
            return true;
        }
        CVOMid id = this.calcCVOMID(key);
        if (id == null) {
            return false;
        }
        if (this.exceptions.setValue(key, id, value)) {
            this.valueCache.put(key, value);
            return true;
        }
        try {
            this.cvom.setProperty(id, value);
        }
        catch (RuntimeException e) {
            logger.warn((Object)("Missing XML set property: " + id.toString() + " " + key.toString()));
            return false;
        }
        this.valueCache.put(key, value);
        return true;
    }

    CVOMid calcCVOMID(KeyObject key) {
        if (this.quickFilter.keyFilter(key)) {
            return null;
        }
        if (this.failCache.contains(key)) {
            return null;
        }
        CVOMid id = this.idCache.get(key);
        if (id == null) {
            id = IDMapper.GetID(key);
        }
        if (id == null) {
            logger.warn((Object)("Cannot resolve CVOM ID: " + key.toString()));
        } else if (id != CVOMid.IgnoreCVOMID && id.property == null) {
            logger.warn((Object)("Cannot find Attribute: " + key.toString()));
        }
        if (id == null || id.property == null || id == CVOMid.IgnoreCVOMID) {
            this.failCache.add(key);
            return null;
        }
        this.idCache.put(key, id);
        return id;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }
}

