/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility.LineSegment;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonUtility {
    public static Polygon createPolygon(Point[] vertices) {
        Polygon polygon = new Polygon();
        for (int i = 0; i < vertices.length; ++i) {
            polygon.addPoint(vertices[i].x, vertices[i].y);
        }
        return polygon;
    }

    public static List<LineSegment> getAllSegments(Polygon[] polygons) {
        ArrayList<LineSegment> vector = new ArrayList<LineSegment>();
        for (int i = 0; i < polygons.length; ++i) {
            PolygonUtility.addAllSegments(polygons[i], vector);
        }
        return vector;
    }

    public static void addAllSegments(Polygon polygon, List<LineSegment> segments) {
        for (int i = 0; i < polygon.npoints; ++i) {
            segments.add(new LineSegment(polygon, i));
        }
    }

    public static List<LineSegment> orderSegmentsByAdjacency(List<LineSegment> unorderedSegments) {
        ArrayList<LineSegment> orderedSegments = new ArrayList<LineSegment>();
        if (unorderedSegments.isEmpty()) {
            return orderedSegments;
        }
        LineSegment segment = unorderedSegments.get(0);
        orderedSegments.add(segment);
        unorderedSegments.remove(0);
        do {
            segment = segment.removeAdjacentSegment(unorderedSegments);
            orderedSegments.add(segment);
        } while (!unorderedSegments.isEmpty());
        return orderedSegments;
    }

    public static void copyPolygonPoints(Polygon polyIn, Polygon polyOut) {
        if (polyIn != null && polyOut != null) {
            for (int i = 0; i < polyIn.npoints; ++i) {
                polyOut.addPoint(polyIn.xpoints[i], polyIn.ypoints[i]);
            }
        }
    }

    public static List<Point2D> copyPolygonToList(Polygon polyIn) {
        ArrayList<Point2D> listOfPoint = new ArrayList<Point2D>();
        for (int i = 0; i < polyIn.npoints; ++i) {
            Point pt = new Point(polyIn.xpoints[i], polyIn.ypoints[i]);
            listOfPoint.add(pt);
        }
        return listOfPoint;
    }

    public static List<Point2D> copyPolygonToArrayListSwapXandYReorder(Polygon polyIn) {
        ArrayList<Point2D> listOfPoint = new ArrayList<Point2D>();
        for (int i = polyIn.npoints - 1; i >= 0; --i) {
            Point pt = new Point(polyIn.ypoints[i], polyIn.xpoints[i]);
            listOfPoint.add(pt);
        }
        return listOfPoint;
    }
}

