/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.place;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Funnel;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceUtilities;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility.RectangleUtil;
import java.awt.Rectangle;
import org.apache.log4j.Logger;

class PlaceDefaultElementsCircular {
    private static final Logger s_logger = Logger.getLogger((String)"PlaceDefaultElementsCircular");

    private PlaceDefaultElementsCircular() {
    }

    static final void place(Perspective p, Rectangle rAvailableSpace) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"placing circular frame");
        }
        if (p.getJGraphType().isFunnelType()) {
            int maxLabelWidth = ((JChart_2D_Funnel)p.getGraphObject()).getMaxFunnelLabelDim().width;
            int maxValueWidth = ((JChart_2D_Funnel)p.getGraphObject()).getMaxFunnelValueDim().width;
            int maxWidth = Math.max(maxLabelWidth, maxValueWidth);
            RectangleUtil.subtract(rAvailableSpace, 500, 6);
            RectangleUtil.subtract(rAvailableSpace, 500, 6);
            RectangleUtil.subtract(rAvailableSpace, maxWidth, 6);
            RectangleUtil.subtract(rAvailableSpace, (int)((double)rAvailableSpace.height * 0.1), 5);
            PlaceUtilities.setChartFrame(p, rAvailableSpace);
        } else if (p.getJGraphType().isPieType()) {
            PlaceDefaultElementsCircular.placePie(p, rAvailableSpace);
        }
    }

    private static void placePie(Perspective perspective, Rectangle rVC) {
        int nGroups;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"placing the pie frame");
        }
        if ((nGroups = perspective.getNumGroups()) > 16) {
            s_logger.warn((Object)"Too many pies (more than 16) skipping place default elements.");
            return;
        }
        int nGraphType = PlaceDefaultElementsCircular.chooseGraphType(perspective);
        perspective.setGraphType(nGraphType);
    }

    private static int chooseGraphType(Perspective perspective) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"choosing the pie type based on data");
        }
        JGraphType gt = perspective.getJGraphType();
        boolean bMultiPie = false;
        boolean bRing = false;
        boolean bPoportional = false;
        switch (gt.getIntegerGraphType()) {
            case 55: {
                break;
            }
            case 56: {
                bRing = true;
                break;
            }
            case 57: {
                bMultiPie = true;
                break;
            }
            case 58: {
                bMultiPie = true;
                bRing = true;
                break;
            }
            case 59: {
                bMultiPie = true;
                bPoportional = true;
                break;
            }
            case 60: {
                bMultiPie = true;
                bRing = true;
                bPoportional = true;
            }
        }
        int nGroups = perspective.getNumGroups();
        bMultiPie = nGroups > 1;
        int nGraphType = 55;
        nGraphType = bMultiPie ? (bRing ? (bPoportional ? 60 : 58) : (bPoportional ? 59 : 57)) : (bRing ? 56 : 55);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("pie type = " + nGraphType));
        }
        return nGraphType;
    }
}

