/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.place;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceDefaultElements2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceDefaultElementsLegend;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceMode;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceUtilities;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility.RectangleUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.apache.log4j.Logger;

public class PlaceDefaultElements {
    private static final Logger s_logger = Logger.getLogger((String)"com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceDefaultElements");
    public static int MIN_FRAME_DIMENSION_VC = 5000;

    private PlaceDefaultElements() {
    }

    static Rectangle placeYLabels(Perspective p, Rectangle containingRectVC, Rectangle desiredFrame) {
        int y2MarginMult;
        int rectangleSideY1;
        int y2Space;
        if (!p.getDisplay(Identity.Y1Label) && !p.getDisplay(Identity.Y2Label)) {
            return containingRectVC;
        }
        Rectangle rContainingRectVC = new Rectangle(containingRectVC);
        IdentObj id = Identity.Y1Label;
        JGraphType type = p.getJGraphType();
        boolean isHoriz = type.isOrientHorz();
        Dimension maxY1Label = new Dimension(0, 0);
        Dimension maxY2Label = new Dimension(0, 0);
        boolean hasY1 = false;
        boolean hasY2 = false;
        if (p.getDisplay(Identity.Y1Label)) {
            maxY1Label = PlaceUtilities.getAxisMaxSize(p, id.getObjectID(), true, PlaceUtilities.getPlaceResizeFrame(p, containingRectVC, desiredFrame));
            hasY1 = true;
        }
        if ((!type.isStockType() || !p.getDisplay(Identity.O1Label)) && type.isDualY() && p.getDisplay(Identity.Y2Label)) {
            maxY2Label = PlaceUtilities.getAxisMaxSize(p, 532, true, containingRectVC);
            hasY2 = true;
        }
        if (type.isThreeY() || type.isFourY() || type.isFiveY()) {
            Dimension maxYNLabel = PlaceUtilities.getAxisMaxSize(p, 685, true, containingRectVC);
            if (type.isFourY() || type.isFiveY()) {
                Dimension maxY4Label = PlaceUtilities.getAxisMaxSize(p, 690, true, containingRectVC);
                if (maxYNLabel.width < maxY4Label.width) {
                    maxYNLabel.width = maxY4Label.width;
                }
                if (maxYNLabel.height < maxY4Label.height) {
                    maxYNLabel.height = maxY4Label.height;
                }
                if (type.isFiveY()) {
                    Dimension maxY5Label = PlaceUtilities.getAxisMaxSize(p, 695, true, containingRectVC);
                    if (maxYNLabel.width < maxY5Label.width) {
                        maxYNLabel.width = maxY5Label.width;
                    }
                    if (maxYNLabel.height < maxY5Label.height) {
                        maxYNLabel.height = maxY5Label.height;
                    }
                }
            }
            if (maxY2Label.width < maxYNLabel.width) {
                maxY2Label.width = maxYNLabel.width;
            }
            if (maxY2Label.height < maxYNLabel.height) {
                maxY2Label.height = maxYNLabel.height;
            }
        }
        int y1Space = isHoriz ? maxY1Label.height : maxY1Label.width;
        int n = y2Space = isHoriz ? maxY2Label.height : maxY2Label.width;
        if (hasY1 && p.getY1TitleDisplay() && p.getY1TitleString().length() != 0) {
            y1Space += 50;
        }
        if (hasY2 && p.getY2TitleDisplay() && p.getY2TitleString().length() != 0) {
            y2Space += 50;
        }
        if (p.getJGraphType().is3DType()) {
            JChart_3D chart = (JChart_3D)p.getGraphObject();
            INumericAxis axis = (INumericAxis)chart.getAxisObj(1);
            List<String> y1LabelList = axis.getNumericLabels();
            String y1TopLabel = y1LabelList.get(y1LabelList.size() - 1);
            Dimension d = TextUtil.getTextDimensionVC(p, Identity.Y1Label, y1TopLabel);
            int y1TopLabelWidth = d.width;
            y1Space = y1TopLabelWidth + 12;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("top label = " + y1TopLabel + " width = " + y1TopLabelWidth));
            }
        }
        int n2 = hasY1 ? AxisUtils.getRectangleSide(p, Identity.Y1Axis, !isHoriz) : (rectangleSideY1 = 0);
        int rectangleSideY2 = hasY2 ? AxisUtils.getRectangleSide(p, Identity.Y2Axis, !isHoriz) : 0;
        int y1MarginMult = hasY1 && p.getAxisSide(Identity.Y1Axis) == 2 ? 2 : 1;
        int n3 = y2MarginMult = hasY2 && p.getAxisSide(Identity.Y2Axis) == 2 ? 2 : 1;
        if (isHoriz) {
            y1Space += y1MarginMult * 100;
            y2Space += y2MarginMult * 100;
        } else {
            y1Space += y1MarginMult * 100;
            y2Space += y2MarginMult * 100;
        }
        if (hasY1 && hasY2 && rectangleSideY1 == rectangleSideY2) {
            if (y1Space > y2Space) {
                hasY2 = false;
            } else {
                hasY1 = false;
            }
        }
        if (hasY1) {
            RectangleUtil.subtract(rContainingRectVC, y1Space, rectangleSideY1);
        }
        if (hasY2) {
            RectangleUtil.subtract(rContainingRectVC, y2Space, rectangleSideY2);
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("final rect =" + rContainingRectVC));
        }
        return rContainingRectVC;
    }

    private static boolean hasPdeLogic(int chartType) {
        boolean hasPdeLogic = true;
        switch (chartType) {
            case 108: 
            case 109: 
            case 113: 
            case 114: 
            case 115: {
                hasPdeLogic = false;
            }
        }
        return hasPdeLogic;
    }

    public static Dimension getTitleDim(Perspective p, IdentObj o, int maxWidth) {
        String titleStr = p.getTextString(o.getObjectID());
        Dimension titleDim = PlaceUtilities.getTextDim(p, o, titleStr, maxWidth);
        return titleDim;
    }

    public static void placeTitles(Perspective p, Rectangle r) {
        boolean titleExists = PlaceDefaultElements.placeTitle(p, r, Identity.Title, true);
        titleExists |= PlaceDefaultElements.placeTitle(p, r, Identity.Subtitle, true);
        if (titleExists |= PlaceDefaultElements.placeTitle(p, r, Identity.Footnote, false)) {
            RectangleUtil.subtract(r, 500, 5);
        }
    }

    private static boolean placeTitle(Perspective p, Rectangle r, IdentObj objID, boolean top) {
        if (!p.getDisplay(objID)) {
            return false;
        }
        Rectangle rManual = p.getRect(objID);
        Dimension titleDim = PlaceDefaultElements.getTitleDim(p, objID, r.width);
        int topAdjust = top ? r.height - titleDim.height : 0;
        Rectangle rFull = new Rectangle(r.x, r.y + topAdjust, r.width, titleDim.height);
        Rectangle rTitleOnly = new Rectangle(r.x + (r.width - titleDim.width) / 2, r.y + topAdjust, titleDim.width, titleDim.height);
        p.setRect(objID, PlaceDefaultElements.getMovableTitle(p, objID, rManual, rFull, rTitleOnly));
        if (titleDim.height == 0) {
            return false;
        }
        RectangleUtil.subtract(r, titleDim.height, top ? 4 : 1);
        return true;
    }

    private static Rectangle getMovableTitle(Perspective p, IdentObj o, Rectangle rManual, Rectangle full, Rectangle suggestedTitle) {
        PlaceMode titleLocationMode = p.getPlaceLocation(o);
        if (titleLocationMode == PlaceMode.FULL_AUTO) {
            return suggestedTitle;
        }
        if (titleLocationMode == PlaceMode.MANUAL) {
            return rManual;
        }
        assert (titleLocationMode == PlaceMode.SEMI_AUTO);
        if (!rManual.intersects(suggestedTitle)) {
            return rManual;
        }
        double minArea = Math.min(rManual.width * rManual.height, suggestedTitle.width * suggestedTitle.height);
        assert (minArea > 0.0);
        if (minArea <= 0.0) {
            return suggestedTitle;
        }
        Rectangle2D intersect = rManual.createIntersection(suggestedTitle);
        double overlap = intersect.getWidth() * intersect.getHeight();
        if (overlap / minArea < 0.75) {
            return rManual;
        }
        return suggestedTitle;
    }

    private static void specialCases(Perspective p, Rectangle rFrame) {
        JGraphType type = p.getJGraphType();
        boolean isHoriz = type.isOrientHorz();
        boolean showLegend = p.getDisplay(Identity.LegendArea);
        boolean showTitle = p.getDisplay(Identity.Title) && !p.getTitleString().equals("");
        boolean showSubtitle = p.getDisplay(Identity.Subtitle) && !p.getSubtitleString().equals("");
        boolean showFootnote = p.getDisplay(Identity.Footnote) && !p.getFootnoteString().equals("");
        boolean showY1 = p.getDisplay(Identity.Y1Label) || p.getDisplay(Identity.Y1Title);
        boolean showX1 = p.getDisplay(Identity.X1Label) || p.getDisplay(Identity.X1Title);
        boolean isBubble = p.getJGraphType().isBubble();
        if (isBubble) {
            boolean makeRightSpace;
            int legendPosition = p.getLegendPosition();
            int x1Side = AxisUtils.getRectangleSide(p, Identity.X1Axis, isHoriz);
            int y1Side = AxisUtils.getRectangleSide(p, Identity.Y1Axis, !isHoriz);
            boolean makeTopSpace = !(showTitle || showSubtitle || showY1 && RectangleUtil.hasSide(y1Side, 4) || showX1 && RectangleUtil.hasSide(x1Side, 4));
            boolean makeBottomSpace = !(showFootnote || showY1 && RectangleUtil.hasSide(y1Side, 1) || showX1 && RectangleUtil.hasSide(x1Side, 1) || showLegend && legendPosition == 1);
            boolean makeLeftSpace = !(showY1 && RectangleUtil.hasSide(y1Side, 3) || showX1 && RectangleUtil.hasSide(x1Side, 3) || showLegend && legendPosition == 3);
            boolean bl = makeRightSpace = !(showY1 && RectangleUtil.hasSide(y1Side, 2) || showX1 && RectangleUtil.hasSide(x1Side, 2) || showLegend && legendPosition == 2);
            if (makeTopSpace) {
                RectangleUtil.subtract(rFrame, 1000, 4);
            }
            if (makeBottomSpace) {
                RectangleUtil.subtract(rFrame, 1000, 1);
            }
            if (makeLeftSpace) {
                RectangleUtil.subtract(rFrame, 1000, 3);
            }
            if (makeRightSpace) {
                RectangleUtil.subtract(rFrame, 1000, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void place(Perspective p) {
        try {
            assert (p != null);
            if (!PlaceDefaultElements.hasPdeLogic(p.getJGraphType().getIntegerGraphType())) {
                s_logger.warn((Object)("Place default elements does not operate on '" + p.getJGraphType().getChartName() + "' chart types."));
            }
            PlaceUtilities.calc(p, true);
            PlaceUtilities.alignAllIfOK(p);
            PlaceUtilities.truncateAllIfOK(p);
            Rectangle desiredFrame = p.getFullFrame(p.getCurrentFrame());
            Rectangle rAvailableSpace = PlaceDefaultElements.getInitialAvailableSpace(p);
            PlaceDefaultElements.placeTitles(p, rAvailableSpace);
            PlaceDefaultElementsLegend.place(p, rAvailableSpace);
            PlaceDefaultElements.specialCases(p, rAvailableSpace);
            PlaceUtilities.setChartFrame(p, PlaceUtilities.getPlaceResizeFrame(p, rAvailableSpace, desiredFrame));
            PlaceUtilities.setAvailableSpace(p, rAvailableSpace);
            if (p.getJGraphType().isFunnelType()) {
            } else if (p.getJGraphType().is3DType()) {
            } else if (p.getJGraphType().isPolar() || p.getJGraphType().isRadarType()) {
                int labelHeight = p.getFontSizeVC(Identity.O1Label);
                RectangleUtil.subtract(rAvailableSpace, labelHeight, 5);
                PlaceUtilities.setChartFrame(p, PlaceUtilities.getPlaceResizeFrame(p, rAvailableSpace, desiredFrame));
            } else if (p.getJGraphType().isCircularType()) {
            } else {
                PlaceDefaultElements2D.place(p, rAvailableSpace, desiredFrame);
            }
        }
        finally {
            p.setPDECalc(false);
        }
    }

    private static Rectangle getInitialAvailableSpace(Perspective p) {
        Rectangle initialSpace = p.getPlaceMargin();
        Rectangle desiredFrame = p.getFullFrame(p.getCurrentFrame());
        int left = desiredFrame.x < initialSpace.x ? -16000 : initialSpace.x;
        int right = desiredFrame.x + desiredFrame.width > initialSpace.x + initialSpace.width ? 16000 : initialSpace.x + initialSpace.width;
        int bottom = desiredFrame.y < initialSpace.y ? -16000 : initialSpace.y;
        int top = desiredFrame.y + desiredFrame.height > initialSpace.y + initialSpace.height ? 16000 : initialSpace.y + initialSpace.height;
        return new Rectangle(left, bottom, right - left, top - bottom);
    }
}

