/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.SphereView;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.AbstractPaintContext;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;

class SpherePaintContext
extends AbstractPaintContext {
    private final Point3d spherePoint = new Point3d();
    private SphereView sphereView;
    private final Point3d lightPoint = new Point3d();
    private final Point3d lightDirection = new Point3d();
    private double sphereRadius;

    SpherePaintContext(Rectangle2D.Float bounds, Color color1, Color color2, SphereView sphereView, AffineTransform trans) throws NoninvertibleTransformException {
        super((Rectangle2D)bounds, color1, color2, trans);
        this.sphereView = sphereView;
        sphereView.getLightDirection(this.lightPoint);
        this.sphereRadius = sphereView.getSphereRadius();
    }

    public final double calcGradientValue(double X, double Y) {
        boolean isOK = this.sphereView.inverseProjection(X, Y, this.spherePoint);
        if (!isOK) {
            this.sphereView.setInverseProjectionOK(false);
            return 1.0;
        }
        this.lightDirection.x = this.spherePoint.x - this.lightPoint.x;
        this.lightDirection.y = this.spherePoint.y - this.lightPoint.y;
        this.lightDirection.z = this.spherePoint.z - this.lightPoint.z;
        this.lightDirection.normalize();
        double f = 1.0 - this.spherePoint.mult(this.lightDirection) / this.sphereRadius;
        if (f < 0.0) {
            return 0.0;
        }
        if (f < 1.0) {
            return f;
        }
        return 1.0;
    }
}

