/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.PaintExt;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.RadialGradientPaintExtContext;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class RadialGradientPaintExt
implements PaintExt {
    private Rectangle2D.Float gradientBounds;
    private int transparency;
    private Color[] colors;
    private double[] intervals;

    public RadialGradientPaintExt(Rectangle2D bounds, Color[] colors, double[] I) {
        if (bounds == null) {
            throw new IllegalArgumentException();
        }
        this.gradientBounds = new Rectangle2D.Float();
        this.gradientBounds.setRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        this.setIntervalsColors(I, colors);
    }

    public Color[] getColors() {
        Color[] colors = new Color[this.colors.length];
        System.arraycopy(this.colors, 0, colors, 0, this.colors.length);
        return colors;
    }

    public double[] getIntervals() {
        double[] I = new double[this.intervals.length];
        System.arraycopy(this.intervals, 0, I, 0, this.intervals.length);
        return I;
    }

    public double[] getStopPoints() {
        double fSum = 0.0;
        for (int i = 0; i < this.intervals.length; ++i) {
            fSum += this.intervals[i];
        }
        double[] p = new double[this.intervals.length];
        p[0] = this.intervals[0];
        for (int i = 1; i < this.intervals.length; ++i) {
            p[i] = p[i - 1] + this.intervals[i];
        }
        if (FP.nonzero(fSum - 1.0)) {
            double dd = 1.0 / fSum;
            int i = 0;
            while (i < this.intervals.length) {
                int n = i++;
                p[n] = p[n] * dd;
            }
        }
        return p;
    }

    public void setIntervalsColors(double[] I, Color[] colors) {
        int i;
        if (I == null || colors == null || I.length != colors.length - 1 || colors.length < 2) {
            throw new IllegalArgumentException();
        }
        double[] temp = new double[I.length];
        System.arraycopy(I, 0, temp, 0, I.length);
        I = temp;
        double sum = 0.0;
        for (i = 0; i < I.length; ++i) {
            if (I[i] < 0.0) {
                String str = "AngularGradientPaint cannot use negative  interval: " + I[i];
                System.out.println(str);
                I[i] = -I[i];
            }
            sum += I[i];
        }
        if (sum <= 0.0) {
            throw new IllegalArgumentException("AngularGradientPant cannot use negative sum of  intervals ");
        }
        i = 0;
        while (i < I.length) {
            int n = i++;
            I[n] = I[n] / sum;
        }
        this.intervals = I;
        this.colors = new Color[colors.length];
        System.arraycopy(colors, 0, this.colors, 0, colors.length);
        boolean opaque = true;
        for (int i2 = 0; i2 < colors.length; ++i2) {
            opaque = opaque && colors[i2].getAlpha() == 255;
        }
        this.transparency = opaque ? 1 : 3;
    }

    public Rectangle2D getBounds() {
        return (Rectangle2D)this.gradientBounds.clone();
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform transform, RenderingHints hints) {
        try {
            return new RadialGradientPaintExtContext(this.gradientBounds, this.colors, this.intervals, transform);
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("transform should be invertible");
        }
    }

    public int getTransparency() {
        return this.transparency;
    }
}

