/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DFlatFace;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;

public class Model3DRectPyramid
extends Model3DFlatFace {
    public static final int FRONT = 0;
    public static final int LEFT = 1;
    public static final int BACK = 2;
    public static final int RIGHT = 3;
    public static final int BOTTOM = 4;
    protected Point3d m_origin;
    protected Point3d m_size;
    protected boolean m_bInverted;
    private static final int[][] m_myfaces = new int[][]{{3, 2, 4}, {0, 3, 4}, {1, 0, 4}, {2, 1, 4}, {0, 1, 2, 3}};

    public Model3DRectPyramid(JChart_3D chart, IdentObj id, IBlackBox bb, Point3d origin, Point3d size, boolean[][] bGridStatus, boolean bAutoshading, boolean bInverted) {
        super(chart, id, bb, 5, 5, bGridStatus, bAutoshading);
        this.m_origin = new Point3d(origin);
        this.m_size = new Point3d(size);
        this.m_bInverted = bInverted;
        this.m_faces = m_myfaces;
        for (int i = 0; i < this.m_nVertices; ++i) {
            this.m_vertices[i] = new Point3d(origin);
        }
        if (bInverted) {
            this.m_vertices[0].x += this.m_size.x;
            this.m_vertices[0].y += this.m_size.y;
            this.m_vertices[1].y += this.m_size.y;
            this.m_vertices[2].y += this.m_size.y;
            this.m_vertices[2].z += this.m_size.z;
            this.m_vertices[3].x += this.m_size.x;
            this.m_vertices[3].y += this.m_size.y;
            this.m_vertices[3].z += this.m_size.z;
            this.m_vertices[4].x += this.m_size.x / 2.0;
            this.m_vertices[4].z += this.m_size.z / 2.0;
        } else {
            this.m_vertices[1].x += this.m_size.x;
            this.m_vertices[2].x += this.m_size.x;
            this.m_vertices[2].z += this.m_size.z;
            this.m_vertices[3].z += this.m_size.z;
            this.m_vertices[4].x += this.m_size.x / 2.0;
            this.m_vertices[4].y += this.m_size.y;
            this.m_vertices[4].z += this.m_size.z / 2.0;
        }
        this.calcGrids();
    }

    public Model3DRectPyramid(Model3DRectPyramid model) {
        this(model.m_chart, model.m_id, model.m_bb, model.m_origin, model.m_size, model.m_bGridStatus, model.m_bAutoshading, model.m_bInverted);
    }

    public Point3d getCenter() {
        return new Point3d(this.m_origin.x + this.m_size.x / 2.0, this.m_origin.y + this.m_size.y / 2.0, this.m_origin.z + this.m_size.z / 2.0);
    }

    public Point3d getGridLineEnd(int nAxis, int nFace, double d) {
        double dxl = this.m_vertices[0].x;
        double dxh = this.m_vertices[1].x;
        double dyl = this.m_vertices[0].y;
        double dyh = this.m_vertices[4].y;
        double dzl = this.m_vertices[0].z;
        double dzh = this.m_vertices[3].z;
        double c = 0.0;
        switch (nAxis) {
            case 0: {
                break;
            }
            case 1: {
                c = (d - dyl) / (dyh - dyl);
                switch (nFace) {
                    case 0: {
                        return new Point3d(dxl + (dxh - dxl) * (1.0 - c / 2.0), d, dzl + (dzh - dzl) * (1.0 - c / 2.0));
                    }
                    case 1: {
                        return new Point3d(dxl + (dxh - dxl) * c / 2.0, d, dzl + (dzh - dzl) * (1.0 - c / 2.0));
                    }
                    case 2: {
                        return new Point3d(dxl + (dxh - dxl) * (1.0 - c / 2.0), d, dzl + (dzh - dzl) * c / 2.0);
                    }
                    case 3: {
                        return new Point3d(dxl + (dxh - dxl) * (1.0 - c / 2.0), d, dzl + (dzh - dzl) * (1.0 - c / 2.0));
                    }
                    case 4: {
                        return null;
                    }
                }
                break;
            }
        }
        return null;
    }

    protected Point3d getGridLineStart(int nAxis, int nFace, double d) {
        double dxl = this.m_vertices[0].x;
        double dxh = this.m_vertices[1].x;
        double dyl = this.m_vertices[0].y;
        double dyh = this.m_vertices[4].y;
        double dzl = this.m_vertices[0].z;
        double dzh = this.m_vertices[3].z;
        double c = 0.0;
        switch (nAxis) {
            case 0: {
                break;
            }
            case 1: {
                c = (d - dyl) / (dyh - dyl);
                switch (nFace) {
                    case 0: {
                        return new Point3d(dxl + (dxh - dxl) * c / 2.0, d, dzl + (dzh - dzl) * (1.0 - c / 2.0));
                    }
                    case 1: {
                        return new Point3d(dxl + (dxh - dxl) * c / 2.0, d, dzl + (dzh - dzl) * c / 2.0);
                    }
                    case 2: {
                        return new Point3d(dxl + (dxh - dxl) * c / 2.0, d, dzl + (dzh - dzl) * c / 2.0);
                    }
                    case 3: {
                        return new Point3d(dxl + (dxh - dxl) * (1.0 - c / 2.0), d, dzl + (dzh - dzl) * c / 2.0);
                    }
                    case 4: {
                        return null;
                    }
                }
                break;
            }
        }
        return null;
    }

    public int getNumPtsPerFace(int f) {
        if (f == 4) {
            return 4;
        }
        return 3;
    }
}

