/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillGradientObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DFlatFace;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.FillRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.GradientRenderer1;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.StrokeRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d.FaceHidingComparator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d.Patch;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class Model3DMesh
extends Model3DFlatFace {
    private static final Logger logger = Logger.getLogger((String)"Model3DMesh");
    public static final boolean[] HONEY_COMB = new boolean[]{true, true, true, true};
    public static final boolean[] NO_SIDES = new boolean[]{false, false, false, false};
    public boolean m_bHorizontalGridlinesWanted = true;
    public boolean m_bVerticalGridlinesWanted = true;
    protected boolean m_bTop = true;
    protected int m_nRows;
    protected int m_nColumns;
    protected int m_nTriangles;
    protected int m_nTopIndex;
    protected boolean m_bOrderedFaces = false;
    protected boolean m_bOneColorForSide = false;
    protected boolean[] m_bSides = null;
    protected FillGradientObj m_fillGradientObj = null;
    private final int[][] nn = new int[2][4];

    private static int countVertices(boolean bTop, boolean[] bSides, int nRows, int nColumns) {
        int nCount = (nRows + 1) * (nColumns + 1);
        if (bSides[0] || bSides[1] || bSides[2] || bSides[3]) {
            nCount += 4;
        }
        return nCount;
    }

    private static int countMaxSurfaceIndex(int nRows, int nColumns) {
        return (nRows + 1) * (nColumns + 1);
    }

    private static int countTriangles(boolean bTop, int nRows, int nColumns) {
        return bTop ? 2 * nRows * nColumns : 0;
    }

    private static int countFaces(boolean bTop, boolean[] bSides, int nRows, int nColumns) {
        if (bSides == null) {
            throw new RuntimeException("bSides cannot be null , set NO_SIDES instead.");
        }
        int nCount = Model3DMesh.countTriangles(bTop, nRows, nColumns);
        for (int i = 0; i < 4; ++i) {
            if (!bSides[i]) continue;
            ++nCount;
        }
        return nCount;
    }

    public Model3DMesh(JChart_3D chart, IdentObj id, int nRows, int nColumns, boolean[][] bGridStatus, boolean bAutoshading, boolean bTop, boolean[] bSides) {
        this(chart, id, null, Model3DMesh.countFaces(bTop, bSides, nRows, nColumns), Model3DMesh.countVertices(bTop, bSides, nRows, nColumns), nRows, nColumns, bGridStatus, bAutoshading, bTop, bSides);
    }

    protected Model3DMesh(JChart_3D chart, IdentObj id, IBlackBox bb, int nFaces, int nVertices, int nRows, int nColumns, boolean[][] bGridStatus, boolean bAutoshading, boolean bTop, boolean[] bSides) {
        super(chart, id, bb, nFaces, nVertices, bGridStatus, bAutoshading);
        this.m_nRows = nRows;
        this.m_nColumns = nColumns;
        this.m_bTop = bTop;
        this.m_bSides = bSides;
        this.init();
    }

    protected void init() {
        if (!this.m_bTop) {
            this.m_bSides = HONEY_COMB;
        }
        this.m_nTriangles = Model3DMesh.countTriangles(this.m_bTop, this.m_nRows, this.m_nColumns);
        this.m_nTopIndex = Model3DMesh.countMaxSurfaceIndex(this.m_nRows, this.m_nColumns);
        this.m_faces = new int[this.m_nFaces][];
        for (int index = 0; index < this.m_nTriangles; ++index) {
            this.m_faces[index] = this.calcIndicesOfTriangle(index);
        }
        this.calcSideIndices();
    }

    private void calcSideIndices() {
        int row;
        int col;
        this.nn[1][3] = this.getIndex(0, 0);
        this.nn[1][2] = this.getIndex(0, this.m_nColumns);
        this.nn[1][1] = this.getIndex(this.m_nRows, this.m_nColumns);
        this.nn[1][0] = this.getIndex(this.m_nRows, 0);
        this.nn[0][3] = this.m_nVertices - 4;
        this.nn[0][2] = this.m_nVertices - 3;
        this.nn[0][1] = this.m_nVertices - 2;
        this.nn[0][0] = this.m_nVertices - 1;
        int[] ff = null;
        int index = this.m_nTriangles;
        int nCount = 0;
        if (this.m_bSides[0]) {
            ff = new int[this.m_nColumns + 3];
            ff[1] = this.nn[0][1];
            ff[0] = this.nn[0][0];
            nCount = 2;
            col = 0;
            while (col <= this.m_nColumns) {
                ff[nCount] = this.getIndex(this.m_nRows, this.m_nColumns - col);
                ++col;
                ++nCount;
            }
            this.m_faces[index] = ff;
            ++index;
        }
        if (this.m_bSides[1]) {
            ff = new int[this.m_nRows + 3];
            ff[1] = this.nn[0][2];
            ff[0] = this.nn[0][1];
            nCount = 2;
            row = 0;
            while (row <= this.m_nRows) {
                ff[nCount] = this.getIndex(row, this.m_nColumns);
                ++row;
                ++nCount;
            }
            this.m_faces[index] = ff;
            ++index;
        }
        if (this.m_bSides[2]) {
            ff = new int[this.m_nColumns + 3];
            ff[1] = this.nn[0][3];
            ff[0] = this.nn[0][2];
            nCount = 2;
            col = 0;
            while (col <= this.m_nColumns) {
                ff[nCount] = this.getIndex(0, col);
                ++col;
                ++nCount;
            }
            this.m_faces[index] = ff;
            ++index;
        }
        if (this.m_bSides[3]) {
            ff = new int[this.m_nRows + 3];
            ff[1] = this.nn[0][0];
            ff[0] = this.nn[0][3];
            nCount = 2;
            row = 0;
            while (row <= this.m_nRows) {
                ff[nCount] = this.getIndex(this.m_nRows - row, 0);
                ++row;
                ++nCount;
            }
            this.m_faces[index] = ff;
            ++index;
        }
        if (index != this.m_nFaces) {
            System.out.println("calcSideIndices error");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append(" Model3dMesh\n");
        int i = 0;
        for (i = 0; i < this.m_vertices.length; ++i) {
            StringBuffer buf1 = Patch.write(this.m_vertices[i]);
            buf.append(i).append('>').append(buf1).append('\n');
        }
        buf.append("FACES:\n");
        for (i = 0; i < this.m_nFaces; ++i) {
            int[] face = this.m_faces[i];
            buf.append("Face nr ").append(i).append('>');
            for (int j = 0; j < face.length; ++j) {
                buf.append('\t').append(face[j]);
            }
            buf.append('\n');
        }
        buf.append("Model3dMesh END\n");
        return buf.toString();
    }

    public void sortFaces() {
        if (!this.m_bOrderedFaces) {
            this.projectVertices();
            Point3d viewer = this.m_chart.getViewer();
            FaceHidingComparator comp = new FaceHidingComparator(viewer, this.m_xVertices);
            Arrays.sort(this.m_faces, comp);
            for (int f = 0; f < this.m_nFaces; ++f) {
                this.m_vNormal[f] = null;
            }
            this.m_bOrderedFaces = true;
        }
    }

    public void calcLowerVertices() {
        Point3d p = null;
        if (this.m_vertices == null || this.m_bSides == null) {
            return;
        }
        int index = 0;
        for (int j = 0; j < 4; ++j) {
            index = this.nn[0][j];
            if (index < this.m_nTopIndex || (p = this.m_vertices[this.nn[1][j]]) == null) continue;
            this.m_vertices[index] = new Point3d(p.x, 0.0, p.z);
        }
    }

    protected int[] calcIndicesOfTriangle(int index) {
        int[] triangle = new int[3];
        boolean isFrontTriangle = index % 2 == 0;
        int nRow = (index /= 2) / this.m_nColumns;
        int nColumn = index % this.m_nColumns;
        int[] rect = new int[4];
        this.getRectangleIndices(nRow, nColumn, rect);
        if (isFrontTriangle) {
            triangle[0] = rect[3];
            triangle[1] = rect[0];
            triangle[2] = rect[1];
        } else {
            triangle[0] = rect[1];
            triangle[1] = rect[2];
            triangle[2] = rect[3];
        }
        return triangle;
    }

    private void getRectangleIndices(int nRow, int nColumn, int[] rect) {
        int nn;
        rect[0] = nn = nRow * (this.m_nColumns + 1) + nColumn;
        rect[1] = nn + (this.m_nColumns + 1);
        rect[3] = nn + 1;
        rect[2] = nn + (this.m_nColumns + 1) + 1;
    }

    public void display() {
        this.m_fillGradientObj = this.m_chart.getFillGradientObj();
        super.display();
        if (this.m_bSides == NO_SIDES) {
            if (this.m_bHorizontalGridlinesWanted) {
                this.displayHorizontalGridline(0);
            }
            if (this.m_bVerticalGridlinesWanted) {
                this.displayVerticalGridline(0);
            }
        }
    }

    public Point3d visibility(int f) {
        Point3d normalVector = null;
        if (this.m_faces[f].length == 3) {
            normalVector = this.getFaceNormal(f);
            if (normalVector == null) {
                System.out.println("null normal");
            }
        } else {
            normalVector = super.visibility(f);
        }
        return normalVector;
    }

    public final Point3d superVisibility(int f) {
        return super.visibility(f);
    }

    public void displayHorizontalGridline(int nRow) {
        IBlackBox bb = null;
        bb = this.m_bb == null ? this.m_chart.getModelBlackBox(this.m_id) : this.m_bb;
        IdentObj newId = this.m_id;
        Color strokePaint = Color.yellow;
        double strokeWidth = 2.0;
        StrokeRenderer renderer = new StrokeRenderer((Paint)strokePaint, strokeWidth);
        GeneralPath path = new GeneralPath();
        if (!this.m_bIsProjected) {
            this.projectVertices();
        }
        Point2D point = this.getProjVertex(nRow, 0);
        path.moveTo((float)point.getX(), (float)point.getY());
        this.addHorizontalGridline(path, nRow);
        DrawFactory.createShape(this.drawContainer, newId, (Shape)path, bb, null, renderer);
    }

    public void displayVerticalGridline(int nCol) {
        IBlackBox bb = null;
        bb = this.m_bb == null ? this.m_chart.getModelBlackBox(this.m_id) : this.m_bb;
        IdentObj newId = this.m_id;
        Color strokePaint = Color.yellow;
        double strokeWidth = 20.0;
        StrokeRenderer renderer = new StrokeRenderer((Paint)strokePaint, strokeWidth);
        GeneralPath path = new GeneralPath();
        if (!this.m_bIsProjected) {
            this.projectVertices();
        }
        Point2D point = this.getProjVertex(0, nCol);
        path.moveTo((float)point.getX(), (float)point.getY());
        this.addVerticalGridline(path, nCol);
        DrawFactory.createShape(this.drawContainer, newId, (Shape)path, bb, null, renderer);
    }

    protected void addHorizontalGridline(GeneralPath path, int nRow) {
        Point2D point = null;
        for (int j = 0; j <= this.m_nColumns; ++j) {
            point = this.getProjVertex(nRow, j);
            path.lineTo((float)point.getX(), (float)point.getY());
        }
    }

    protected void addVerticalGridline(GeneralPath path, int nCol) {
        Point2D point = null;
        for (int i = 0; i <= this.m_nRows; ++i) {
            point = this.getProjVertex(i, nCol);
            path.lineTo((float)point.getX(), (float)point.getY());
        }
    }

    public void displayFace(int f, IBlackBox bb, double fIntensity) {
        IdentObj newId = this.m_id;
        GeneralPath path = this.projectVerticesFloat(f);
        BlackBoxRenderer renderer = null;
        if (this.m_bOneColorForSide && f >= this.m_nTriangles && bb != null) {
            Color color1 = bb.getFillColor();
            renderer = new FillRenderer(color1);
        } else {
            int[] face = this.m_faces[f];
            int[] selectV = null;
            if (face.length < 3) {
                return;
            }
            selectV = face.length == 3 ? face : new int[]{face[0], face[1], face[2]};
            double[] fHeightRatio = new double[3];
            Point2D[] triangle = new Point2D[3];
            Point3d[] vertices3D = new Point3d[3];
            int vertIndex = 0;
            Point3d vertex = null;
            for (int i = 0; i < 3; ++i) {
                vertIndex = selectV[i];
                vertex = this.m_vertices[vertIndex];
                fHeightRatio[i] = this.m_chart.getHeightRatio(vertex.y);
                triangle[i] = this.m_projVertices[vertIndex];
                vertices3D[i] = vertex;
            }
            try {
                renderer = new GradientRenderer1(triangle, fHeightRatio, this.m_fillGradientObj, fIntensity);
            }
            catch (NoninvertibleTransformException ex) {
                assert (false);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)ex.getMessage());
                }
                return;
            }
        }
        DrawFactory.createShape(this.drawContainer, newId, (Shape)path, bb, null, renderer);
        if (this.m_bWantGrids) {
            this.displayGridFace(true, 0, f);
            this.displayGridFace(true, 1, f);
            this.displayGridFace(true, 2, f);
            this.displayGridFace(false, 0, f);
            this.displayGridFace(false, 1, f);
            this.displayGridFace(false, 2, f);
        }
    }

    public Point3d getCenter() {
        return new Point3d(this.m_vertices[0].x, 0.0, this.m_vertices[0].z);
    }

    public Point3d getVertex(int nRow, int nCol) {
        return this.m_vertices[nRow * (this.m_nColumns + 1) + nCol];
    }

    public Point2D getProjVertex(int nRow, int nCol) {
        return this.m_projVertices[nRow * (this.m_nColumns + 1) + nCol];
    }

    public void setVertex(int nRow, int nCol, Point3d vertex) {
        int nr = nRow * (this.m_nColumns + 1) + nCol;
        this.m_vertices[nr] = vertex;
    }

    public int getIndex(int nRow, int nCol) {
        return nRow * (this.m_nColumns + 1) + nCol;
    }

    public static boolean isNegative(double[] a, double[] b, double[] c) {
        double det = (b[0] - a[0]) * (c[1] - a[1]) - (b[1] - a[1]) * (c[0] - a[0]);
        return det < 0.0;
    }

    public static boolean isNegative(Polygon poly) {
        if (poly.npoints < 3) {
            return true;
        }
        double[] a = new double[]{poly.xpoints[0], poly.ypoints[0]};
        double[] b = new double[]{poly.xpoints[1], poly.ypoints[1]};
        double[] c = new double[]{poly.xpoints[2], poly.ypoints[2]};
        return Model3DMesh.isNegative(a, b, c);
    }

    static class FaceDistanceComparator
    implements Comparator {
        Point3d center;
        Point3d[] vertices;

        FaceDistanceComparator(Point3d viewer, Point3d[] verts) {
            if (verts == null || viewer == null) {
                throw new IllegalArgumentException("Null data");
            }
            for (int i = 0; i < verts.length; ++i) {
                if (verts[i] != null) continue;
                throw new IllegalArgumentException("Vertex is null");
            }
            this.center = viewer;
            this.vertices = verts;
        }

        public int compare(Object obj1, Object obj2) {
            int[] face1 = (int[])obj1;
            int[] face2 = (int[])obj2;
            Point3d a11 = this.vertices[face1[0]];
            Point3d a12 = this.vertices[face1[1]];
            double dist1 = Math.abs((a11.x + a12.x) * 0.5 - this.center.x) + Math.abs((a11.z + a12.z) * 0.5 - this.center.z);
            Point3d a21 = this.vertices[face2[0]];
            Point3d a22 = this.vertices[face2[1]];
            Point3d a23 = this.vertices[face2[2]];
            double dist2 = Math.abs((a21.x + a22.x + a23.x) / 3.0 - this.center.x) + Math.abs((a21.z + a22.z + a23.z) / 3.0 - this.center.z);
            if (dist1 < dist2) {
                return 1;
            }
            if (dist2 < dist1) {
                return -1;
            }
            return 0;
        }
    }
}

