/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics;

import com.businessobjects.visualization.pfjgraphics.rendering.common.CheckParam;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.IStandardLook;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Attr;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.ObjectID;
import java.util.HashMap;
import java.util.Map;

public class StandardLookPFJ
implements IStandardLook {
    private static final String kszFONTSIZE_ATTR = "FontSize";
    private static final String kszFONTSIZEREF_ATTR = "FontSizeRef";
    private final Map<String, ObjectID> m_ObjectList = new HashMap<String, ObjectID>();
    private final Map<String, Attr> m_AttrMap = new HashMap<String, Attr>();
    private final Perspective m_Perspective;

    public StandardLookPFJ(Perspective p) {
        this.m_Perspective = p;
        this.initObjectList();
        this.initAttributesList();
    }

    private void initObjectList() {
        this.addObjectPFJ("GaugeBackground", 2501);
        this.addObjectPFJ("GaugeArea", 2502);
        this.addObjectPFJ("GaugeScaleArea", 2503);
        this.addObjectPFJ("GaugeLabel", 2504);
        this.addObjectPFJ("GaugeNeedle", 2505);
        this.addObjectPFJ("GaugeMajorGrid", 2506);
        this.addObjectPFJ("GaugeMinorGrid", 2507);
        this.addObjectPFJ("GaugeBand1", 2508);
        this.addObjectPFJ("GaugeBand2", 2509);
        this.addObjectPFJ("GaugeBand3", 2510);
        this.addObjectPFJ("GaugeBand4", 2511);
        this.addObjectPFJ("GaugeBand5", 2512);
        this.addObjectPFJ("GaugeBand1Label", 2513);
        this.addObjectPFJ("GaugeBand2Label", 2514);
        this.addObjectPFJ("GaugeBand3Label", 2515);
        this.addObjectPFJ("GaugeBand4Label", 2516);
        this.addObjectPFJ("GaugeBand5Label", 2517);
        this.addObjectPFJ("GaugeGlass", 2518);
        this.addObjectPFJ("GaugeTitle", 2519);
        this.addObjectPFJ("GaugeValue", 2520);
        this.addObjectPFJ("GaugeTrendPoint", 2521);
        this.addObjectPFJ("GaugeScaleFactorLbl", 2522);
        this.addObjectPFJ("GaugeMarker", 2523);
        this.addObjectPFJ("GaugeCenterCircle", 2524);
        this.addObjectPFJ("GaugeStyledBackground", 2531);
    }

    private void initAttributesList() {
        this.addAttribute("Gauge.StartAngle", Attr.GaugeStartAngle);
        this.addAttribute("Gauge.StopAngle", Attr.GaugeStopAngle);
        this.addAttribute("Gauge.RelThickness", Attr.GaugeRelativeThickness);
        this.addAttribute("Gauge.ScaleMajorAutoStep", Attr.GaugeMajorAutoStep);
        this.addAttribute("Gauge.ScaleMinorAutoStep", Attr.GaugeMinorAutoStep);
        this.addAttribute("Gauge.Descending", Attr.AxisDescending);
        this.addAttribute("Gauge.LogScale", Attr.LogScale);
        this.addAttribute("Gauge.RelTickLen", Attr.GaugeRelativeTickLength);
        this.addAttribute("Gauge.RelInnerRadius", Attr.GaugeRelativeInnerRadius);
        this.addAttribute("Gauge.BackgroundStyle", Attr.GaugeBackgroundStyle);
        this.addAttribute("Gauge.IgnoreBackgroundStyle", Attr.GaugeIgnoreBackgroundStyle);
        this.addAttribute("Gauge.NeedleStyle", Attr.GaugeNeedleStyle);
        this.addAttribute("Gauge.ShowZero", Attr.GaugeShowZeroLabel);
        this.addAttribute("Visible", Attr.Display);
        this.addAttribute("FillColor", Attr.FillColor);
        this.addAttribute("FillAlpha", Attr.GaugeAlphaChannel);
        this.addAttribute("TextColor", Attr.FillColor);
        this.addAttribute("BorderColor", Attr.BorderColor);
        this.addAttribute("FontName", Attr.FontName);
        this.addAttribute("FontStyle", Attr.FontStyle);
        this.addAttribute("LineWidth", Attr.LineWidth);
        this.addAttribute("OffsetX", Attr.ShadowXOffset);
        this.addAttribute("OffsetY", Attr.ShadowYOffset);
        this.addAttribute("Shadow", Attr.ShadowDisplay);
        this.addAttribute("ShadowColor", Attr.ShadowColor);
        this.addAttribute("NumberFormat", Attr.GaugeNumberFormat);
        this.addAttribute("NumberFormatType", Attr.GaugeNumberFormatType);
        this.addAttribute("PatternNumber", Attr.GaugePatternNumber);
        this.addAttribute(kszFONTSIZE_ATTR, Attr.FontSizeInPoints);
        this.addAttribute(kszFONTSIZEREF_ATTR, Attr.GaugeFontSizeRef);
        this.addAttribute("FillType", Attr.FillType);
        this.addAttribute("GradientDirection", Attr.GradientDirection);
    }

    public void addObjectPFJ(String szName, int nObjectID) {
        this.m_ObjectList.put(szName, new ObjectID(nObjectID));
    }

    public void addAttribute(String szName, Attr attr) {
        this.m_AttrMap.put(szName, attr);
    }

    public void setAttrValue(Object objID, Object attr, Object value) throws IllegalArgumentException {
        ObjectID oid = (ObjectID)objID;
        IdentObj id = StandardLookPFJ.makeIdentObj(oid);
        this.m_Perspective.setAttrValue(id, (Attr)attr, value);
    }

    public Object getAttrValue(Object objID, Object attr) throws IllegalArgumentException {
        ObjectID oid = (ObjectID)objID;
        IdentObj id = StandardLookPFJ.makeIdentObj(oid);
        Object retObj2 = this.m_Perspective.getAttrValue(id, (Attr)attr);
        return retObj2;
    }

    public static IdentObj makeIdentObj(ObjectID oid) {
        return new IdentObj(oid.getObjectID(), -3, -3, oid.getMiscID());
    }

    public Object getAttr(String szAttrName) throws IllegalArgumentException {
        Attr attrObj = this.m_AttrMap.get(szAttrName);
        if (attrObj instanceof Attr) {
            return attrObj;
        }
        throw new RuntimeException("Attribute: " + szAttrName + " is not in the list of attributes");
    }

    public ObjectID getObjectID(String szObject) throws IllegalArgumentException {
        ObjectID objID = this.m_ObjectList.get(szObject);
        CheckParam.checkObjectID(objID);
        return objID;
    }

    public void setFontSize(Object objID, int nFontSize, Object nRefSize) {
        IdentObj y1AxisIdentObj = new IdentObj(528);
        int nFontSizeVC = this.m_Perspective.getVC().destToVirtHeight(nFontSize);
        this.m_Perspective.setFontSizeVC(y1AxisIdentObj, nFontSizeVC);
    }

    public Object getFontSize(Object objID, int nFontSizeRef) throws IllegalArgumentException {
        CheckParam.checkObjectID(objID);
        ObjectID oid = (ObjectID)objID;
        IdentObj idLabel = new IdentObj(oid.getObjectID());
        float nFontSize = this.m_Perspective.getFontSizeAbsolute(idLabel) ? this.m_Perspective.getFontSize(idLabel) : (float)this.m_Perspective.getVC().virtToDestHeight(this.m_Perspective.getFontSizeVC(idLabel));
        return new Float(nFontSize);
    }

    public Perspective getPerspective() {
        return this.m_Perspective;
    }
}

