/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.DateUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IInterval;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class Interval
implements IInterval {
    public static final int TIME_INTERVAL_UNDEFINED = 0;
    public static final int TIME_INTERVAL_SECONDS = 1;
    public static final int TIME_INTERVAL_MINUTES = 2;
    public static final int TIME_INTERVAL_HOURS = 3;
    public static final int TIME_INTERVAL_DAYS = 4;
    public static final int TIME_INTERVAL_WEEKS = 5;
    public static final int TIME_INTERVAL_MONTHS = 6;
    public static final int TIME_INTERVAL_QUARTERS = 7;
    public static final int TIME_INTERVAL_YEARS = 8;
    private static final Logger _logger = Logger.getLogger((String)"Interval");
    private int interval = 1;
    private int count = 0;
    private int[] values;
    private GregorianCalendar start = null;
    private GregorianCalendar end = null;

    protected final void setInterval(int i) {
    }

    protected final void setCount(int i) {
    }

    protected final void setValues(int[] i) {
    }

    protected final void setLabels(String[] s) {
    }

    protected final void setStart(Calendar i) {
    }

    protected final void setEnd(Calendar i) {
    }

    public static int toJavaCalendarInterval(int timeInterval) {
        switch (timeInterval) {
            case 1: {
                return 13;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 2;
            }
            case 8: {
                return 1;
            }
        }
        throw new RuntimeException("Unable to convert to java calendar interval");
    }

    public Interval(int interval, GregorianCalendar start, GregorianCalendar end, int q1StartMonth) {
        this.interval = interval;
        this.start = start;
        this.end = end;
        switch (interval) {
            case 1: {
                this.count = DateUtils.getSecondCount(start, end);
                this.values = DateUtils.getSecondArray(start, end);
                break;
            }
            case 2: {
                this.count = DateUtils.getMinuteCount(start, end);
                this.values = DateUtils.getMinuteArray(start, end);
                break;
            }
            case 3: {
                this.count = DateUtils.getHourCount(start, end);
                this.values = DateUtils.getHourArray(start, end);
                break;
            }
            case 4: {
                this.count = DateUtils.getDayCount(start, end);
                this.values = DateUtils.getDayArray(start, end);
                break;
            }
            case 5: {
                this.count = DateUtils.getWeekCount(start, end);
                this.values = DateUtils.getWeekArray(start, end);
                break;
            }
            case 6: {
                this.count = DateUtils.getMonthCount(start, end);
                this.values = DateUtils.getMonthArray(start, end);
                break;
            }
            case 7: {
                this.count = DateUtils.getQuarterCount(start, end, q1StartMonth);
                this.values = DateUtils.getQuarterArray(start, end, q1StartMonth);
                break;
            }
            case 8: {
                this.count = DateUtils.getYearCount(start, end);
                this.values = DateUtils.getYearArray(start, end);
                break;
            }
            default: {
                _logger.warn((Object)("Interval constructor was passed an unknown interval " + interval + "."));
            }
        }
    }

    public String[] getLabels(int format) {
        String[] labels = null;
        switch (this.interval) {
            case 1: {
                labels = DateUtils.getSecondLabelArray(this.getValues(), format);
                break;
            }
            case 2: {
                labels = DateUtils.getMinuteLabelArray(this.getValues(), format);
                break;
            }
            case 3: {
                labels = DateUtils.getHourLabelArray(this.getValues(), format);
                break;
            }
            case 4: {
                labels = DateUtils.getDayLabelArray(this.getValues(), format);
                break;
            }
            case 5: {
                labels = DateUtils.getWeekLabelArray(this.getValues(), format);
                break;
            }
            case 6: {
                labels = DateUtils.getMonthLabelArray(this.getValues(), format);
                break;
            }
            case 7: {
                labels = DateUtils.getQuarterLabelArray(this.getValues(), format);
                break;
            }
            case 8: {
                labels = DateUtils.getYearLabelArray(this.getValues(), format);
                break;
            }
            default: {
                _logger.warn((Object)("Interval.getLabels() was passed an unknown interval " + this.interval + "."));
            }
        }
        return labels;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getCount() {
        return this.count;
    }

    public int[] getValues() {
        return this.values;
    }

    public GregorianCalendar getStart() {
        return this.start;
    }

    public GregorianCalendar getEnd() {
        return this.end;
    }
}

