/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.DateUtils;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

final class DateScaleUtils {
    private static final Logger _logger = Logger.getLogger((String)"DateScaleUtils");

    DateScaleUtils() {
    }

    public static final double[] getSecondOffsetArray(int base, GregorianCalendar start, GregorianCalendar end) {
        double[] array = null;
        int count = DateUtils.getSecondCount(start, end);
        array = new double[count];
        if (base == 1) {
            double dCount = count;
            for (int i = 0; i < count; ++i) {
                array[i] = 1.0 / dCount;
            }
        } else {
            if (base == 2) {
                throw new IllegalArgumentException("\n\nSecond offsets do not make sense when the base unit is minutes.\n");
            }
            if (base == 3) {
                throw new IllegalArgumentException("\n\nSecond offsets do not make sense when the base unit is hours.\n");
            }
            if (base == 4) {
                throw new IllegalArgumentException("\n\nSecond offsets do not make sense when the base unit is days.\n");
            }
            if (base == 5) {
                throw new IllegalArgumentException("\n\nSecond offsets do not make sense when the base unit is weeks.\n");
            }
            if (base == 6) {
                throw new IllegalArgumentException("\n\nSecond offsets do not make sense when the base unit is months.\n");
            }
            if (base == 8) {
                throw new IllegalArgumentException("\n\nSecond offsets do not make sense when the base unit is years.\n");
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Second array total = " + DateScaleUtils.arrayToString(array)));
            _logger.debug((Object)("Second array total = " + DateScaleUtils.arrayTotal(array)));
        }
        return array;
    }

    public static final double[] getMinuteOffsetArray(int base, GregorianCalendar start, GregorianCalendar end) {
        double[] array = null;
        int count = DateUtils.getMinuteCount(start, end);
        array = new double[count];
        if (base == 1) {
            double secondCount = DateUtils.getSecondCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double seconds = start.get(13);
                if (seconds == 0.0) {
                    seconds = 60.0;
                }
                double secondsInFirstMinute = 60.0 - seconds;
                if (_logger.isDebugEnabled()) {
                    if (secondsInFirstMinute == 0.0) {
                        _logger.debug((Object)"!secondsInFirstMinute shouldn't equal zero!");
                    } else {
                        _logger.debug((Object)("secondsInFirstMinute=" + secondsInFirstMinute));
                    }
                }
                array[0] = secondsInFirstMinute / secondCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 60.0 / secondCount;
            }
            if (count > 1) {
                double secondsInLastMinute = end.get(13);
                _logger.debug((Object)("secondsInLastMinute=" + secondsInLastMinute));
                array[count - 1] = secondsInLastMinute / secondCount;
            }
        }
        if (base == 2) {
            double dCount = count;
            for (int i = 0; i < count; ++i) {
                array[i] = 1.0 / dCount;
            }
        } else {
            if (base == 3) {
                throw new IllegalArgumentException("\n\nMinute offsets do not make sense when the base unit is hours.\n");
            }
            if (base == 4) {
                throw new IllegalArgumentException("\n\nMinute offsets do not make sense when the base unit is days.\n");
            }
            if (base == 5) {
                throw new IllegalArgumentException("\n\nMinute offsets do not make sense when the base unit is weeks.\n");
            }
            if (base == 6) {
                throw new IllegalArgumentException("\n\nMinute offsets do not make sense when the base unit is months.\n");
            }
            if (base == 8) {
                throw new IllegalArgumentException("\n\nMinute offsets do not make sense when the base unit is years.\n");
            }
        }
        _logger.debug((Object)("Minute array total = " + DateScaleUtils.arrayToString(array)));
        _logger.debug((Object)("Minute array total = " + DateScaleUtils.arrayTotal(array)));
        return array;
    }

    public static final double[] getHourOffsetArray(int base, GregorianCalendar start, GregorianCalendar end) {
        double[] array = null;
        int count = DateUtils.getHourCount(start, end);
        array = new double[count];
        if (base == 1) {
            double secondCount = DateUtils.getSecondCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double secondsInFirstMinute = 60 - start.get(13);
                if (_logger.isDebugEnabled()) {
                    if (secondsInFirstMinute == 0.0) {
                        _logger.debug((Object)"!secondsInFirstMinute shouldn't equal zero!");
                    } else {
                        _logger.debug((Object)("secondsInFirstMinute=" + secondsInFirstMinute));
                    }
                }
                array[0] = secondsInFirstMinute / secondCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 60.0 / secondCount;
            }
            if (count > 1) {
                double secondsInLastMinute = end.get(13);
                _logger.debug((Object)("secondsInLastMinute=" + secondsInLastMinute));
                array[count - 1] = secondsInLastMinute / secondCount;
            }
        }
        if (base == 2) {
            double minuteCount = DateUtils.getMinuteCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double minutes = start.get(12);
                double minutesInFirstHour = 60.0 - minutes;
                if (minutesInFirstHour == 0.0) {
                    _logger.debug((Object)"!minutesInFirstHour shouldn't equal zero!");
                } else {
                    _logger.debug((Object)("minutesInFirstHour=" + minutesInFirstHour));
                }
                array[0] = minutesInFirstHour / minuteCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 60.0 / minuteCount;
            }
            if (count > 1) {
                double minutesInLastHour = end.get(12);
                _logger.debug((Object)("minutesInLastHour=" + minutesInLastHour));
                array[count - 1] = minutesInLastHour / minuteCount;
            }
        } else if (base == 3) {
            double dCount = count;
            for (int i = 0; i < count; ++i) {
                array[i] = 1.0 / dCount;
            }
        } else {
            if (base == 4) {
                throw new IllegalArgumentException("\n\nHour offsets do not make sense when the base unit is days.\n");
            }
            if (base == 5) {
                throw new IllegalArgumentException("\n\nHour offsets do not make sense when the base unit is weeks.\n");
            }
            if (base == 6) {
                throw new IllegalArgumentException("\n\nHour offsets do not make sense when the base unit is months.\n");
            }
            if (base == 8) {
                throw new IllegalArgumentException("\n\nHour offsets do not make sense when the base unit is years.\n");
            }
        }
        _logger.debug((Object)("Hour array total = " + DateScaleUtils.arrayToString(array)));
        _logger.debug((Object)("Hour array total = " + DateScaleUtils.arrayTotal(array)));
        return array;
    }

    public static final double[] getDayOffsetArray(int base, GregorianCalendar start, GregorianCalendar end) {
        double[] array = null;
        int count = DateUtils.getDayCount(start, end);
        array = new double[count];
        if (base == 1) {
            double secondCount = DateUtils.getSecondCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double secondsInFirstDay = (24 - start.get(11) - 1) * 3600 + (60 - start.get(12) - 1) * 60 + 60 - start.get(13);
                if (_logger.isDebugEnabled()) {
                    if (secondsInFirstDay == 0.0) {
                        _logger.debug((Object)"!secondsInFirstDay shouldn't equal zero!");
                    } else {
                        _logger.debug((Object)("secondsInFirstDay=" + secondsInFirstDay));
                    }
                }
                array[0] = secondsInFirstDay / secondCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 86400.0 / secondCount;
            }
            if (count > 1) {
                double secondsInLastDay = end.get(11) * 3600 + end.get(12) * 60 + end.get(13);
                _logger.debug((Object)("secondsInLastDay=" + secondsInLastDay));
                array[count - 1] = secondsInLastDay / secondCount;
            }
        } else if (base == 2) {
            double minuteCount = DateUtils.getMinuteCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double minutesInFirstDay = (24 - start.get(11) - 1) * 60 + (60 - start.get(12));
                if (minutesInFirstDay == 0.0) {
                    _logger.debug((Object)"!minutesInFirstDay shouldn't equal zero!");
                } else {
                    _logger.debug((Object)("minutesInFirstDay=" + minutesInFirstDay));
                }
                array[0] = minutesInFirstDay / minuteCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 1440.0 / minuteCount;
            }
            if (count > 1) {
                double minutesInLastDay = end.get(11) * 60 + end.get(12);
                _logger.debug((Object)("minutesInLastDay=" + minutesInLastDay));
                array[count - 1] = minutesInLastDay / minuteCount;
            }
        } else if (base == 3) {
            double hourCount = DateUtils.getHourCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double hoursInFirstDay = 24 - start.get(11);
                if (hoursInFirstDay == 0.0) {
                    _logger.debug((Object)"!hoursInFirstDay shouldn't equal zero!");
                } else {
                    _logger.debug((Object)("hoursInFirstDay=" + hoursInFirstDay));
                }
                array[0] = hoursInFirstDay / hourCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 24.0 / hourCount;
            }
            if (count > 1) {
                double hoursInLastDay = end.get(11);
                _logger.debug((Object)("hoursInLastDay=" + hoursInLastDay));
                array[count - 1] = hoursInLastDay / hourCount;
            }
        } else if (base == 4) {
            double dCount = count;
            for (int i = 0; i < count; ++i) {
                array[i] = 1.0 / dCount;
            }
        } else {
            if (base == 5) {
                throw new IllegalArgumentException("\n\nDay offsets do not make sense when the base unit is weeks.\n");
            }
            if (base == 6) {
                throw new IllegalArgumentException("\n\nDay offsets do not make sense when the base unit is months.\n");
            }
            if (base == 8) {
                throw new IllegalArgumentException("\n\nDay offsets do not make sense when the base unit is years.\n");
            }
        }
        _logger.debug((Object)("Day array total = " + DateScaleUtils.arrayToString(array)));
        _logger.debug((Object)("Day array total = " + DateScaleUtils.arrayTotal(array)));
        return array;
    }

    public static final double[] getWeekOffsetArray(int base, GregorianCalendar start, GregorianCalendar end) {
        double[] array = null;
        int count = DateUtils.getWeekCount(start, end);
        array = new double[count];
        if (base == 1) {
            double secondCount = DateUtils.getSecondCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double secondsInFirstDay = (24 - start.get(11) - 1) * 3600 + (60 - start.get(12) - 1) * 60 + 60 - start.get(13);
                if (_logger.isDebugEnabled()) {
                    if (secondsInFirstDay == 0.0) {
                        _logger.debug((Object)"!secondsInFirstDay shouldn't equal zero!");
                    } else {
                        _logger.debug((Object)("secondsInFirstDay=" + secondsInFirstDay));
                    }
                }
                array[0] = secondsInFirstDay / secondCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 86400.0 / secondCount;
            }
            if (count > 1) {
                double secondsInLastDay = end.get(11) * 3600 + end.get(12) * 60 + end.get(13);
                _logger.debug((Object)("secondsInLastDay=" + secondsInLastDay));
                array[count - 1] = secondsInLastDay / secondCount;
            }
        } else if (base == 2) {
            double minuteCount = DateUtils.getMinuteCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double minutesInFirstDay = (24 - start.get(11) - 1) * 60 + (60 - start.get(12));
                if (minutesInFirstDay == 0.0) {
                    _logger.debug((Object)"!minutesInFirstDay shouldn't equal zero!");
                } else {
                    _logger.debug((Object)("minutesInFirstDay=" + minutesInFirstDay));
                }
                array[0] = minutesInFirstDay / minuteCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 1440.0 / minuteCount;
            }
            if (count > 1) {
                double minutesInLastDay = end.get(11) * 60 + end.get(12);
                _logger.debug((Object)("minutesInLastDay=" + minutesInLastDay));
                array[count - 1] = minutesInLastDay / minuteCount;
            }
        } else if (base == 3) {
            double hourCount = DateUtils.getHourCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double hoursInFirstDay = 24 - start.get(11);
                if (hoursInFirstDay == 0.0) {
                    _logger.debug((Object)"!hoursInFirstDay shouldn't equal zero!");
                } else {
                    _logger.debug((Object)("hoursInFirstDay=" + hoursInFirstDay));
                }
                array[0] = hoursInFirstDay / hourCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 24.0 / hourCount;
            }
            if (count > 1) {
                double hoursInLastDay = end.get(11);
                _logger.debug((Object)("hoursInLastDay=" + hoursInLastDay));
                array[count - 1] = hoursInLastDay / hourCount;
            }
        } else if (base == 4) {
            double dayCount = DateUtils.getDayCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double daysInFirstWeek = 7.0 - (double)start.get(7) + 1.0;
                if (daysInFirstWeek == 0.0) {
                    _logger.debug((Object)"!daysInFirstWeek shouldn't equal zero!");
                } else {
                    _logger.debug((Object)("daysInFirstWeek=" + daysInFirstWeek));
                }
                array[0] = daysInFirstWeek / dayCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 7.0 / dayCount;
            }
            if (count > 1) {
                double daysInLastWeek = end.get(7);
                _logger.debug((Object)("daysInLastWeek=" + daysInLastWeek));
                array[count - 1] = daysInLastWeek / dayCount;
            }
        } else if (base == 5) {
            for (int i = 0; i < count; ++i) {
                array[i] = 1.0 / (1.0 * (double)count);
            }
        } else {
            if (base == 6) {
                throw new IllegalArgumentException("\n\nWeek offsets do not make sense when the base unit is months.\n");
            }
            if (base == 8) {
                throw new IllegalArgumentException("\n\nWeek offsets do not make sense when the base unit is years.\n");
            }
        }
        _logger.debug((Object)("Week array total = " + DateScaleUtils.arrayToString(array)));
        _logger.debug((Object)("Week array total = " + DateScaleUtils.arrayTotal(array)));
        return array;
    }

    public static final double[] getMonthOffsetArray(int base, GregorianCalendar start, GregorianCalendar end) {
        double[] array = null;
        int count = DateUtils.getMonthCount(start, end);
        array = new double[count];
        if (base == 1) {
            double secondCount = DateUtils.getSecondCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double secondsInFirstDay = (24 - start.get(11) - 1) * 3600 + (60 - start.get(12) - 1) * 60 + 60 - start.get(13);
                if (_logger.isDebugEnabled()) {
                    if (secondsInFirstDay == 0.0) {
                        _logger.debug((Object)"!secondsInFirstDay shouldn't equal zero!");
                    } else {
                        _logger.debug((Object)("secondsInFirstDay=" + secondsInFirstDay));
                    }
                }
                array[0] = secondsInFirstDay / secondCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 86400.0 / secondCount;
            }
            if (count > 1) {
                double secondsInLastDay = end.get(11) * 3600 + end.get(12) * 60 + end.get(13);
                _logger.debug((Object)("secondsInLastDay=" + secondsInLastDay));
                array[count - 1] = secondsInLastDay / secondCount;
            }
        } else if (base == 2) {
            double minuteCount = DateUtils.getMinuteCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double minutesInFirstDay = (24 - start.get(11) - 1) * 60 + (60 - start.get(12));
                if (minutesInFirstDay == 0.0) {
                    _logger.debug((Object)"!minutesInFirstDay shouldn't equal zero!");
                } else {
                    _logger.debug((Object)("minutesInFirstDay=" + minutesInFirstDay));
                }
                array[0] = minutesInFirstDay / minuteCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 1440.0 / minuteCount;
            }
            if (count > 1) {
                double minutesInLastDay = end.get(11) * 60 + end.get(12);
                _logger.debug((Object)("minutesInLastDay=" + minutesInLastDay));
                array[count - 1] = minutesInLastDay / minuteCount;
            }
        } else if (base == 3) {
            double hourCount = DateUtils.getHourCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double hoursInFirstDay = 24 - start.get(11);
                if (hoursInFirstDay == 0.0) {
                    _logger.debug((Object)"!hoursInFirstDay shouldn't equal zero!");
                } else {
                    _logger.debug((Object)("hoursInFirstDay=" + hoursInFirstDay));
                }
                array[0] = hoursInFirstDay / hourCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 24.0 / hourCount;
            }
            if (count > 1) {
                double hoursInLastDay = end.get(11);
                _logger.debug((Object)("hoursInLastDay=" + hoursInLastDay));
                array[count - 1] = hoursInLastDay / hourCount;
            }
        } else if (base == 4) {
            double dayCount = DateUtils.getDayCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double daysInFirstMonth = start.getMaximum(5) - start.get(5) + 1;
                if (daysInFirstMonth == 0.0) {
                    _logger.debug((Object)"!daysInFirstMonth shouldn't equal zero!");
                } else {
                    _logger.debug((Object)("daysInFirstMonth=" + daysInFirstMonth));
                }
                array[0] = daysInFirstMonth / dayCount;
            }
            for (int i = 1; i < count - 1; ++i) {
                array[i] = 7.0 / dayCount;
            }
            if (count > 1) {
                double daysInLastMonth = end.get(5);
                _logger.debug((Object)("daysInLastMonth=" + daysInLastMonth));
                array[count - 1] = daysInLastMonth / dayCount;
            }
        } else if (base <= 5) {
            double dayCount = DateUtils.getDayCount(start, end);
            if (count == 1) {
                array[0] = 1.0;
            } else {
                double numDaysInMonth = start.getActualMaximum(5);
                double startDayOfMonth = start.get(5);
                double daysInFirstMonth = numDaysInMonth - startDayOfMonth + 1.0;
                array[0] = daysInFirstMonth / dayCount;
            }
            GregorianCalendar startIterator = new GregorianCalendar();
            startIterator.setTime(start.getTime());
            for (int i = 1; i < count - 1; ++i) {
                startIterator.add(2, 1);
                double top = startIterator.getActualMaximum(5);
                array[i] = top / dayCount;
            }
            if (count > 1) {
                double daysInLastMonth = end.get(5);
                array[count - 1] = daysInLastMonth / dayCount;
            }
        } else if (base == 6) {
            GregorianCalendar endOfMonth = new GregorianCalendar();
            endOfMonth.setTime(start.getTime());
            endOfMonth.set(14, 999);
            endOfMonth.set(13, 59);
            endOfMonth.set(12, 59);
            endOfMonth.set(10, 23);
            endOfMonth.set(5, start.getActualMaximum(5));
            GregorianCalendar startOfMonth = new GregorianCalendar();
            startOfMonth.setTime(start.getTime());
            double totalMs = end.getTimeInMillis() - start.getTimeInMillis();
            for (int i = 0; i < count; ++i) {
                double diff = endOfMonth.getTimeInMillis() - startOfMonth.getTimeInMillis();
                array[i] = diff / totalMs;
                endOfMonth.set(5, 1);
                endOfMonth.add(2, 1);
                endOfMonth.set(5, endOfMonth.getActualMaximum(5));
                startOfMonth.add(2, 1);
                startOfMonth.set(14, 0);
                startOfMonth.set(13, 0);
                startOfMonth.set(12, 0);
                startOfMonth.set(10, 0);
                startOfMonth.set(5, 1);
            }
        } else if (base == 8) {
            throw new IllegalArgumentException("\n\nMonth offsets do not make sense when the base unit is years.\n");
        }
        return array;
    }

    public static final double[] getQuarterOffsetArray(int notUsed, GregorianCalendar start, GregorianCalendar end, int q1StartMonth) {
        double[] array = null;
        int count = DateUtils.getQuarterCount(start, end, q1StartMonth);
        array = new double[count];
        if (count == 1) {
            array[0] = 1.0;
            return array;
        }
        double totalMs = end.getTimeInMillis() - start.getTimeInMillis();
        double nextInterval = DateUtils.getNextQuarterStart(start, q1StartMonth);
        array[0] = (nextInterval - 1.0 * (double)start.getTimeInMillis()) / totalMs;
        long timeAccountedFor = (long)nextInterval;
        GregorianCalendar qtrIterator = new GregorianCalendar();
        qtrIterator.setTimeInMillis((long)nextInterval);
        qtrIterator.add(2, 3);
        int index = 1;
        while (qtrIterator.getTimeInMillis() < end.getTimeInMillis()) {
            double delta = qtrIterator.getTimeInMillis() - timeAccountedFor;
            array[index] = delta / totalMs;
            timeAccountedFor = (long)((double)timeAccountedFor + delta);
            qtrIterator.add(2, 3);
            ++index;
        }
        double totalExcludingLast = 0.0;
        for (int n = 0; n < count - 1; ++n) {
            totalExcludingLast += array[n];
        }
        array[count - 1] = 1.0 - totalExcludingLast;
        return array;
    }

    public static final double[] getYearOffsetArray(int base, GregorianCalendar start, GregorianCalendar end, int q1StartMonth) {
        double[] array;
        block24: {
            int count;
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block23: {
                                array = null;
                                count = DateUtils.getYearCount(start, end);
                                array = new double[count];
                                if (base != 1) break block23;
                                double secondCount = DateUtils.getSecondCount(start, end);
                                if (count == 1) {
                                    array[0] = 1.0;
                                } else {
                                    double secondsInFirstDay = (24 - start.get(11) - 1) * 3600 + (60 - start.get(12) - 1) * 60 + 60 - start.get(13);
                                    if (_logger.isDebugEnabled()) {
                                        if (secondsInFirstDay == 0.0) {
                                            _logger.debug((Object)"!secondsInFirstDay shouldn't equal zero!");
                                        } else {
                                            _logger.debug((Object)("secondsInFirstDay=" + secondsInFirstDay));
                                        }
                                    }
                                    array[0] = secondsInFirstDay / secondCount;
                                }
                                for (int i = 1; i < count - 1; ++i) {
                                    array[i] = 86400.0 / secondCount;
                                }
                                if (count <= 1) break block24;
                                double secondsInLastDay = end.get(11) * 3600 + end.get(12) * 60 + end.get(13);
                                _logger.debug((Object)("secondsInLastDay=" + secondsInLastDay));
                                array[count - 1] = secondsInLastDay / secondCount;
                                break block24;
                            }
                            if (base != 2) break block25;
                            double minuteCount = DateUtils.getMinuteCount(start, end);
                            if (count == 1) {
                                array[0] = 1.0;
                            } else {
                                double minutesInFirstDay = (24 - start.get(11) - 1) * 60 + (60 - start.get(12));
                                if (minutesInFirstDay == 0.0) {
                                    _logger.debug((Object)"!minutesInFirstDay shouldn't equal zero!");
                                } else {
                                    _logger.debug((Object)("minutesInFirstDay=" + minutesInFirstDay));
                                }
                                array[0] = minutesInFirstDay / minuteCount;
                            }
                            for (int i = 1; i < count - 1; ++i) {
                                array[i] = 1440.0 / minuteCount;
                            }
                            if (count <= 1) break block24;
                            double minutesInLastDay = end.get(11) * 60 + end.get(12);
                            _logger.debug((Object)("minutesInLastDay=" + minutesInLastDay));
                            array[count - 1] = minutesInLastDay / minuteCount;
                            break block24;
                        }
                        if (base != 3) break block26;
                        double hourCount = DateUtils.getHourCount(start, end);
                        if (count == 1) {
                            array[0] = 1.0;
                        } else {
                            double hoursInFirstDay = 24 - start.get(11);
                            if (hoursInFirstDay == 0.0) {
                                _logger.debug((Object)"!hoursInFirstDay shouldn't equal zero!");
                            } else {
                                _logger.debug((Object)("hoursInFirstDay=" + hoursInFirstDay));
                            }
                            array[0] = hoursInFirstDay / hourCount;
                        }
                        for (int i = 1; i < count - 1; ++i) {
                            array[i] = 24.0 / hourCount;
                        }
                        if (count <= 1) break block24;
                        double hoursInLastDay = end.get(11);
                        _logger.debug((Object)("hoursInLastDay=" + hoursInLastDay));
                        array[count - 1] = hoursInLastDay / hourCount;
                        break block24;
                    }
                    if (base != 4 && base != 5) break block27;
                    int first = start.get(1);
                    GregorianCalendar endOfYear = DateUtils.getDateTime(first, 12, 31, 23, 59, 59);
                    long totalMs = end.getTimeInMillis() - start.getTimeInMillis();
                    array[0] = count == 1 ? 1.0 : (double)(endOfYear.getTimeInMillis() - start.getTimeInMillis()) * 1.0 / (double)totalMs;
                    for (int i = 1; i < count - 1; ++i) {
                        GregorianCalendar startOfYear = DateUtils.getDateTime(++first, 1, 1, 0, 0, 0);
                        endOfYear = DateUtils.getDateTime(first, 12, 31, 23, 59, 59);
                        array[i] = (double)(endOfYear.getTimeInMillis() - startOfYear.getTimeInMillis()) * 1.0 / (double)totalMs;
                    }
                    if (count <= 1) break block24;
                    array[count - 1] = (double)(end.getTimeInMillis() - endOfYear.getTimeInMillis()) * 1.0 / (double)totalMs;
                    break block24;
                }
                if (base != 6) break block28;
                int firstMonth = start.get(2) + 1;
                int lastMonth = end.get(2) + 1;
                int numMonths = DateUtils.getMonthCount(start, end);
                array[0] = count == 1 ? 1.0 : 1.0 * (double)(12 - firstMonth + 1) / (1.0 * (double)numMonths);
                for (int i = 1; i < count - 1; ++i) {
                    array[i] = 12.0 / (1.0 * (double)numMonths);
                }
                if (count <= 1) break block24;
                array[count - 1] = (double)lastMonth / (1.0 * (double)numMonths);
                break block24;
            }
            if (base == 7) {
                int[] qArray = DateUtils.getQuarterArray(start, end, q1StartMonth);
                double[] qOffsetArray = DateScaleUtils.getQuarterOffsetArray(1, start, end, q1StartMonth);
                int yearCount = 0;
                double offset = 0.0;
                for (int i = 0; i < qArray.length; ++i) {
                    int qIndex = qArray[i];
                    offset += qOffsetArray[i];
                    if (qIndex != 4) continue;
                    array[yearCount] = offset;
                    offset = 0.0;
                    ++yearCount;
                }
            } else if (base == 8) {
                for (int i = 0; i < count; ++i) {
                    array[i] = 1.0 / (1.0 * (double)count);
                }
            }
        }
        return array;
    }

    public static final boolean arrayEqual(double[] o, double[] p) {
        for (int i = 0; i < o.length; ++i) {
            if (p[i] == o[i]) continue;
            return false;
        }
        return true;
    }

    public static final double arrayTotal(double[] o) {
        double t = 0.0;
        for (int i = 0; i < o.length; ++i) {
            t += o[i];
        }
        return t;
    }

    public static final String arrayToString(double[] o) {
        StringBuffer sb = new StringBuffer();
        double d = 0.0;
        for (int i = 0; i < o.length; ++i) {
            d += o[i];
            sb.append("" + o[i] + " ");
        }
        sb.append("total = " + d);
        return sb.toString();
    }

    public static final void main(String[] args) {
        new DateScaleUtils();
    }
}

