/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_Base;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class AxisUtils {
    public static int getAxisOrgin(Perspective p, AxisTemplate template, boolean isVertical) {
        int orgin = 0;
        Point frameDepthOffset = p.getFrameDepthOffset();
        Rectangle frameRect = AxisUtils.getFrameRect(p, template, isVertical);
        orgin = isVertical ? frameRect.y - frameDepthOffset.y : frameRect.x - frameDepthOffset.x;
        return orgin;
    }

    public static int getAxisLength(Perspective p, AxisTemplate template, boolean isVertical) {
        int len = 0;
        Rectangle frameRect = AxisUtils.getFrameRect(p, template, isVertical);
        len = isVertical ? frameRect.height : frameRect.width;
        return len;
    }

    public static Rectangle getFrameRect(Perspective p, AxisTemplate template, boolean isVertical) {
        Rectangle r = null;
        boolean is3D = p.getJGraphType().is3DType();
        if (is3D) {
            JChart_3D chart3D = (JChart_3D)p.getGraphObject();
            switch (template.getAxisObjID()) {
                case 5: {
                    r = chart3D.getRightWall().getProjectedVertices().getBounds();
                    break;
                }
                case 6: {
                    r = chart3D.getLeftWall().getProjectedVertices().getBounds();
                    break;
                }
                case 8: {
                    r = chart3D.getFloor().getProjectedVertices().getBounds();
                }
            }
        } else {
            r = p.getFrameRect(false);
        }
        return r;
    }

    public static IdentObj getAxisLabel(Perspective p, IdentObj label) {
        IdentObj labelId = null;
        int objectId = label.getObjectID();
        switch (objectId) {
            case 514: {
                labelId = Identity.O1Label;
                break;
            }
            case 524: {
                labelId = Identity.X1Label;
                break;
            }
            case 528: {
                labelId = Identity.Y1Label;
                break;
            }
            case 532: {
                labelId = Identity.Y2Label;
                break;
            }
            case 685: {
                labelId = Identity.Y3Label;
                break;
            }
            case 690: {
                labelId = Identity.Y4Label;
                break;
            }
            case 695: {
                labelId = Identity.Y5Label;
                break;
            }
            case 518: {
                labelId = Identity.O2Label;
            }
        }
        return labelId;
    }

    public static final IAxis getAxisObj(Perspective p, int axisId) {
        JChart_Base chart = p.getGraphObject();
        return chart.getAxis(axisId);
    }

    public static int getRectangleSide(Perspective p, IdentObj axisID, boolean isHoriz) {
        int perspectiveSide = p.getAxisSide(axisID);
        int side = 0;
        if (isHoriz) {
            side = 3;
            if (perspectiveSide == 1) {
                side = 2;
            }
            if (perspectiveSide == 2) {
                side = 6;
            }
        } else {
            side = 1;
            if (perspectiveSide == 1) {
                side = 4;
            }
            if (perspectiveSide == 2) {
                side = 5;
            }
        }
        return side;
    }

    public static void polarToCartesian(Point pt, double fAngleInDeg, double relRadius, Dimension frameDim, Point origin, VC vc) {
        Dimension dcFrameDim = vc.virtToDest(frameDim);
        Point dcOrigin = vc.virtToDest(origin);
        double radius = (double)(dcFrameDim.width / 2) * relRadius;
        double fX = radius * Math.cos(fAngleInDeg * (Math.PI / 180));
        double fY = radius * Math.sin(fAngleInDeg * (Math.PI / 180));
        Point ptTemp = new Point(dcOrigin.x + (int)fX, dcOrigin.y + (int)fY);
        ptTemp = vc.destToVirt(ptTemp);
        pt.x = ptTemp.x;
        pt.y = ptTemp.y;
    }
}

