/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.Axis2DObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility.RectangleUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AxisLabelGroupFormatter {
    private int m_count = 0;
    private int m_rotation = 0;
    private int m_desiredSkipCount = 0;
    private int m_actualSkipCount = 0;
    private boolean m_stagger = false;
    private boolean m_wordWrap = false;
    private boolean m_isFinished = false;
    private Rectangle m_constraintBox;
    private Rectangle m_boundingBox;
    private boolean m_isVertical;
    private ITextStyle m_textStyle;
    private Axis2DObj m_axis2D;
    private Perspective m_perspective;
    private IdentObj m_labelID;
    private List<String> m_labels;
    private List<Double> m_labelPositions;
    private int m_numLabels;
    private int m_axisSide;

    public AxisLabelGroupFormatter(AxisObj axisObj, List<String> labels, List<Double> labelPositions, ITextStyle textStyle) {
        this.m_perspective = axisObj.m_Perspective;
        this.m_labelID = axisObj.m_template.getLabel();
        this.m_isVertical = axisObj.isVertical();
        this.m_rotation = this.m_perspective.getTextRotation(this.m_labelID);
        this.m_stagger = this.m_perspective.getLabelStagger(this.m_labelID);
        this.m_wordWrap = this.m_perspective.getTextWrap(this.m_labelID);
        this.m_textStyle = textStyle;
        this.m_labels = labels;
        this.m_labelPositions = labelPositions;
        this.m_actualSkipCount = -1;
        this.m_numLabels = axisObj.getNumLabels();
        this.m_axisSide = axisObj.getAxisSide();
        this.m_boundingBox = null;
        this.m_constraintBox = VC.DEFAULT_RECTANGLE;
        this.m_desiredSkipCount = this.m_perspective.getAutoSkip(this.m_labelID) == 2 ? this.m_perspective.getSkipCount(this.m_labelID) : 0;
        if (axisObj instanceof Axis2DObj) {
            this.m_axis2D = (Axis2DObj)axisObj;
        } else {
            this.m_actualSkipCount = this.m_desiredSkipCount;
            this.m_isFinished = true;
        }
        if (this.m_numLabels < 1) {
            this.m_isFinished = true;
        }
    }

    public void autoFormat() {
        ArrayList<Rectangle> rVectLabels = new ArrayList<Rectangle>(this.m_numLabels);
        while (!this.isFinished()) {
            this.setAxisLabelAttributes();
            rVectLabels.clear();
            Dimension availableSpaceSingleLabelVC = this.m_axis2D.calcMaxLabelDimensionVC(this.m_axisSide, this.m_numLabels, this.m_desiredSkipCount, this.m_stagger, this.m_labelPositions, rVectLabels);
            Dimension availableSpaceSingleLabelDC = this.m_perspective.getVC().virtToDest(availableSpaceSingleLabelVC);
            Dimension maxLabelDimensionDC = this.m_axis2D.findLargestLabelFastest(this.m_numLabels, availableSpaceSingleLabelDC, this.m_labels, this.m_textStyle);
            this.m_actualSkipCount = this.m_axis2D.calcSkipCount(maxLabelDimensionDC, availableSpaceSingleLabelDC, this.m_rotation);
            this.m_boundingBox = this.m_axis2D.calcBoundingBox(this.m_axisSide, this.m_numLabels, this.m_rotation, this.m_textStyle, rVectLabels, this.m_labels, maxLabelDimensionDC);
            this.nextState();
        }
    }

    private void setAxisLabelAttributes() {
        this.m_textStyle.setRotationSetting(this.m_rotation);
        this.m_axis2D.setLabelStagger(this.m_stagger);
        if (this.m_rotation == 3) {
            this.m_textStyle.setWordWrap(false);
        } else {
            this.m_textStyle.setWordWrap(this.m_wordWrap);
        }
    }

    public void nextState() {
        this.calcIsFinished();
        if (this.m_isFinished) {
            return;
        }
        switch (this.m_rotation) {
            default: {
                if (this.m_isVertical) {
                    if (this.m_wordWrap) {
                        this.m_wordWrap = false;
                        break;
                    }
                    this.m_isFinished = true;
                    break;
                }
                if (this.m_stagger) {
                    this.m_rotation = 3;
                    this.m_stagger = false;
                    break;
                }
                this.m_stagger = true;
                break;
            }
            case 3: {
                this.m_stagger = false;
                if (this.m_isVertical) {
                    this.m_rotation = 0;
                    break;
                }
                this.m_rotation = 1;
                break;
            }
            case 1: 
            case 2: {
                if (this.m_isVertical) {
                    if (this.m_stagger) {
                        this.m_stagger = false;
                        this.m_rotation = 0;
                        break;
                    }
                    this.m_stagger = true;
                    break;
                }
                if (this.m_wordWrap) {
                    this.m_wordWrap = false;
                    break;
                }
                this.m_isFinished = true;
            }
        }
        ++this.m_count;
    }

    private void calcIsFinished() {
        boolean maxCountReached;
        this.m_isFinished = false;
        boolean bl = maxCountReached = this.m_count > 10;
        if (this.m_boundingBox == null) {
            this.m_isFinished = true;
            return;
        }
        if (maxCountReached || this.m_desiredSkipCount >= this.m_actualSkipCount || this.m_actualSkipCount == 0) {
            if (this.m_desiredSkipCount >= this.m_actualSkipCount) {
                this.m_actualSkipCount = this.m_desiredSkipCount;
            }
            this.m_isFinished = this.m_isVertical ? RectangleUtil.inBounds(this.m_constraintBox, this.m_boundingBox, RectangleUtil.BOUNDS_TOP | RectangleUtil.BOUNDS_BOTTOM) : RectangleUtil.inBounds(this.m_constraintBox, this.m_boundingBox, RectangleUtil.BOUNDS_RIGHT | RectangleUtil.BOUNDS_LEFT);
            this.m_isFinished = this.m_isFinished || maxCountReached;
        }
    }

    public int getActualSkipCount() {
        return this.m_actualSkipCount;
    }

    private boolean isFinished() {
        return this.m_isFinished;
    }
}

