/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.SimpleBlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Color;
import java.awt.Rectangle;
import org.apache.log4j.Logger;

public class Ticks2D {
    private static final Logger _logger = Logger.getLogger((String)"Ticks2D");
    private Perspective m_Perspective;
    private IdentObj m_id;
    private IBlackBox m_blackBox;
    private Java2DLine m_line2D = null;
    private IAxis m_axis = null;

    public Ticks2D(Perspective p, IAxis axis, IdentObj ticksId) {
        this.m_Perspective = p;
        this.m_axis = axis;
        this.m_id = ticksId;
        this.m_blackBox = new SimpleBlackBoxObj(this.m_Perspective, ticksId, true);
        this.m_line2D = new Java2DLine(this.m_Perspective);
    }

    public void calc(int pos) {
        boolean ticksExistOnLeftOrBottom = this.isLeftOrBottom();
        boolean ticksExistOnRightOrTop = this.isRightOrTop();
        if (ticksExistOnLeftOrBottom) {
            this.calcTick(pos, true, false);
        }
        if (ticksExistOnRightOrTop) {
            this.calcTick(pos, false, true);
        }
    }

    private boolean isLeftOrBottom() {
        int nSide = this.m_axis.getAxisSide();
        boolean leftOrBottom = nSide == 0 || nSide == 2;
        return leftOrBottom;
    }

    private boolean isRightOrTop() {
        int nSide = this.m_axis.getAxisSide();
        boolean rightOrTop = nSide == 1 || nSide == 2;
        return rightOrTop;
    }

    protected void calcTick(int pos, boolean leftOrBottom, boolean rightOrTop) {
        boolean vert = this.m_axis.isVertical();
        int tickLen = this.m_Perspective.getTickLength(this.m_id);
        double tickWidth = Ticks2D.getTickWidth(this.m_Perspective, this.m_id);
        int tickStyle = this.m_Perspective.getTickStyle(this.m_id);
        int angle = this.m_Perspective.getDepthAngle();
        boolean rightWallHasDepth = Perspective.rightWallHasDepth(this.m_Perspective);
        boolean leftWallHasDepth = Perspective.leftWallHasDepth(this.m_Perspective);
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        Rectangle r = this.m_Perspective.getFrameRect(false);
        if (this.m_Perspective.getDrawTicksPerpendicular(this.m_id)) {
            angle = 0;
        }
        if (!rightWallHasDepth && !leftWallHasDepth) {
            angle = 0;
        }
        if (vert) {
            y1 = pos;
            if (rightOrTop) {
                x1 = r.x + r.width;
                if (rightWallHasDepth) {
                    x1 += Math.abs(this.m_Perspective.getFrameDepthOffset().x);
                    if (angle > 0) {
                        y1 = pos - Math.abs(this.m_Perspective.getFrameDepthOffset().y);
                    }
                }
                if (!rightWallHasDepth) {
                    angle = 0;
                }
                if (tickStyle == 2) {
                    angle += 180;
                }
            } else {
                x1 = rightWallHasDepth ? r.x : r.x - this.m_Perspective.getFrameDepthOffset().x;
                if (leftWallHasDepth) {
                    y1 -= Math.abs(this.m_Perspective.getFrameDepthOffset().y);
                }
                if (!leftWallHasDepth) {
                    angle = 0;
                }
                if (tickStyle == 3) {
                    angle += 180;
                }
            }
        } else {
            x1 = pos;
            if (leftOrBottom) {
                x1 = pos - this.m_Perspective.getFrameDepthOffset().x;
                if (rightWallHasDepth) {
                    x1 = pos + Math.abs(this.m_Perspective.getFrameDepthOffset().x);
                }
                y1 = r.y - this.m_Perspective.getFrameDepthOffset().y;
                if (angle > 0) {
                    if (tickStyle == 3) {
                        angle += 180;
                    }
                } else {
                    angle = tickStyle == 2 ? 90 : 270;
                }
            } else {
                y1 = r.y + r.height;
                angle = 90;
                if (tickStyle == 2) {
                    angle += 180;
                }
            }
        }
        x2 = this.getX2(angle, tickLen, x1);
        y2 = this.getY2(angle, tickLen, y1);
        if (tickStyle == 4) {
            if (vert) {
                if (x2 > x1) {
                    int diff = x2 - x1;
                    x1 -= diff / 2;
                    x2 -= diff / 2;
                } else {
                    int diff = x1 - x2;
                    x1 += diff / 2;
                    x2 += diff / 2;
                }
            } else if (y2 > y1) {
                int diff = y2 - y1;
                y1 -= diff / 2;
                y2 -= diff / 2;
            } else {
                int diff = y1 - y2;
                y1 += diff / 2;
                y2 += diff / 2;
            }
        }
        this.m_line2D.createLine(this.m_id, this.m_id, x1, y1, x2, y2, this.m_blackBox, null, tickWidth);
    }

    private int getX2(int angle, int len, int x1) {
        return (int)((double)x1 + (double)len * Math.cos(Math.toRadians(angle)));
    }

    private int getY2(int angle, int len, int y1) {
        double d = Math.sin(Math.toRadians(angle));
        int y2 = (int)((double)y1 + (double)len * d);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Math.sin(" + angle + ") = " + d));
        }
        return y2;
    }

    public static final double getTickWidth(Perspective p, IdentObj id) {
        return p.getLineWidth(new IdentObj(id.getObjectID()));
    }

    public static final void setMajorTickAttributes(Perspective p, IdentObj id, int style, Color color, int len, int width, int stroke, boolean forcePerpendicular, boolean excludeMinTick, boolean excludeMaxTick) {
        p.setDisplay(id, true);
        p.setTickStyle(id, style);
        p.setFillColor(id, color);
        p.setBorderColor(id, color);
        p.setTickLength(id, len);
        p.setLineWidth(id, width);
        p.setLineBasicStrokeType(id, stroke);
        p.setDrawTicksPerpendicular(id, forcePerpendicular);
        p.setExcludeMinLabel(id, excludeMinTick);
        p.setExcludeMaxLabel(id, excludeMaxTick);
    }

    public static final void setTickAttributes(Perspective p, IdentObj id, int style, Color color, int len, int width, int stroke, boolean forcePerpendicular) {
        Ticks2D.setMajorTickAttributes(p, id, style, color, len, width, stroke, forcePerpendicular, false, false);
    }

    public static final void resetTickAttributes(Perspective p, IdentObj id) {
        Ticks2D.setMajorTickAttributes(p, id, 4, Color.black, 320, 1, 1, false, true, true);
        p.setDisplay(id, false);
    }

    public static final void setTickDefaults(Perspective p) {
        Ticks2D.resetTickAttributes(p, Identity.Y1MajorTick);
        Ticks2D.resetTickAttributes(p, Identity.Y2MajorTick);
        Ticks2D.resetTickAttributes(p, Identity.Y3MajorTick);
        Ticks2D.resetTickAttributes(p, Identity.Y4MajorTick);
        Ticks2D.resetTickAttributes(p, Identity.Y5MajorTick);
        Ticks2D.resetTickAttributes(p, Identity.X1MajorTick);
        Ticks2D.resetTickAttributes(p, Identity.O1MajorTick);
        Ticks2D.resetTickAttributes(p, Identity.Y1MinorTick);
        Ticks2D.resetTickAttributes(p, Identity.Y2MinorTick);
        Ticks2D.resetTickAttributes(p, Identity.Y3MinorTick);
        Ticks2D.resetTickAttributes(p, Identity.Y4MinorTick);
        Ticks2D.resetTickAttributes(p, Identity.Y5MinorTick);
        Ticks2D.resetTickAttributes(p, Identity.X1MinorTick);
        Ticks2D.resetTickAttributes(p, Identity.O1MinorTick);
    }
}

