/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Depth2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_Base;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.SumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;

class Scaling {
    public static final int SCALING_ABSOLUTE = 1;
    public static final int SCALING_STACKED = 2;
    public static final int SCALING_PERCENT = 3;
    public static final int SCALING_HIST = 4;
    public static final int SCALING_WATERFALL = 5;
    public static final int SCALING_ABSOLUTEFORCED = 6;
    public static final int SCALING_GANTT = 7;
    public static final int WATERFALLGROUPMODE_NORMAL = 0;
    public static final int WATERFALLGROUPMODE_SUBTOTAL = 1;
    public static final int WATERFALLGROUPMODE_TOTAL = 2;
    public static final int WATERFALLGROUPMODE_EXTRA = 3;
    public static final int WATERFALLGROUPMODE_NORMAL_RESETTOZERO = 4;
    private Perspective m_Perspective;
    private int m_nTotalSeries;
    private int m_nTotalGroups;
    private int[] m_axisAssignments;
    private JChart_Base m_chartBase;
    private Depth2D m_depth2D;

    public Scaling(Perspective perspective, int nTotalSeries, int nTotalGroups, int[] axisAssignments, Depth2D depth2D, JChart_Base chartBase) {
        this.m_Perspective = perspective;
        this.m_nTotalSeries = nTotalSeries;
        this.m_nTotalGroups = nTotalGroups;
        this.m_axisAssignments = axisAssignments;
        this.m_depth2D = depth2D;
        this.m_chartBase = chartBase;
    }

    protected MinMaxObj findLimits(int nAxis, int nScaling, boolean bMustIncludeZero, MinMaxObj mmZoom, DataFormat dataFormat) {
        MinMaxObj minMaxObj = new MinMaxObj(bMustIncludeZero);
        this.setNonDataLimitsScaling(minMaxObj, nAxis);
        switch (nScaling) {
            case 1: {
                this.calcScalingAbsolute(nAxis, dataFormat, minMaxObj, mmZoom, false);
                break;
            }
            case 2: {
                this.calcScalingStacked(nAxis, dataFormat, minMaxObj);
                break;
            }
            case 5: {
                this.calcScalingWaterfall(nAxis, dataFormat, minMaxObj);
                break;
            }
            case 3: {
                this.calcScalingPercent(nAxis, dataFormat, minMaxObj);
                break;
            }
            case 4: {
                this.calcScalingHistogram(nAxis, dataFormat, minMaxObj);
                break;
            }
            case 6: {
                this.calcScalingAbsolute(nAxis, dataFormat, minMaxObj, mmZoom, true);
                break;
            }
            case 7: {
                this.calcScalingGantt(nAxis, dataFormat, minMaxObj);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (!minMaxObj.isValid()) {
            minMaxObj.m_rawMax = 4.0;
            minMaxObj.m_rawMin = -4.0;
            minMaxObj.m_adjMax = 4.0;
            minMaxObj.m_adjMin = -4.0;
        }
        return minMaxObj;
    }

    private void calcScalingAbsolute(int nAxis, DataFormat dataFormat, MinMaxObj minMaxObj, MinMaxObj mmZoom, boolean bForcedAbsolute) {
        int nItems = dataFormat.getNumDataItems();
        for (int s = 0; s < this.m_nTotalSeries; ++s) {
            if (this.seriesNotAssignedToAxis(s, nAxis) || bForcedAbsolute && !this.m_Perspective.getForceSeriesAbsolute(s)) continue;
            for (int g = 0; g < this.m_nTotalGroups; ++g) {
                for (int i = 0; i < nItems; ++i) {
                    DataItem item = dataFormat.getDataItem(i);
                    if (item.ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), nAxis)) continue;
                    DatumObj dObj = this.m_chartBase.getDataValue(s, g, item);
                    double fValue = dObj.value;
                    if (!dObj.m_bOK || fValue <= 0.0 && this.isBadValueInLogscale(nAxis, fValue) || mmZoom != null && (fValue < mmZoom.getAdjMin() || fValue > mmZoom.getAdjMax())) continue;
                    minMaxObj.testRawValue(fValue);
                }
            }
        }
    }

    private void calcScalingGantt(int nAxis, DataFormat dataFormat, MinMaxObj minMaxObj) {
        int nItems = dataFormat.getNumDataItems();
        for (int s = 0; s < this.m_nTotalSeries; ++s) {
            for (int g = 0; g < this.m_nTotalGroups; ++g) {
                for (int i = 0; i < nItems; ++i) {
                    DataItem item = dataFormat.getDataItem(i);
                    if (i != 0 && i != 1 && i != 3 && i != 4) continue;
                    DatumObj dObj = this.m_chartBase.getDataValue(s, g, item);
                    double fValue = dObj.value;
                    if (!dObj.m_bOK) continue;
                    minMaxObj.testRawValue(fValue);
                }
            }
        }
    }

    private void calcScalingStacked(int nAxis, DataFormat dataFormat, MinMaxObj minMaxObj) {
        int nItems = dataFormat.getNumDataItems();
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Perspective.getAccess());
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.m_Perspective.getAccess());
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            SumObj sumObj = new SumObj();
            sEnum.reset();
            while (sEnum.hasNext()) {
                int s = sEnum.next();
                assert (s >= 0 && s < this.m_nTotalSeries);
                if (this.seriesNotAssignedToAxis(s, nAxis) || this.m_Perspective.getForceSeriesAbsolute(s)) continue;
                for (int i = 0; i < nItems; ++i) {
                    DataItem item = dataFormat.getDataItem(i);
                    if (item.ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), nAxis)) continue;
                    DatumObj dObj = this.m_chartBase.getDataValue(s, g, item);
                    double fValue = dObj.value;
                    if (!dObj.m_bOK || fValue <= 0.0 && this.isBadValueInLogscale(nAxis, fValue)) continue;
                    boolean bPos = fValue >= 0.0;
                    boolean bY2 = nAxis == 1;
                    int nRiser = this.m_depth2D.getSeriesType(s);
                    double fSum = sumObj.getSum(bPos, bY2, nRiser) + fValue;
                    sumObj.setSum(bPos, bY2, nRiser, fSum);
                    minMaxObj.testRawValue(fSum);
                }
            }
        }
    }

    private void calcScalingWaterfall(int nAxis, DataFormat dataFormat, MinMaxObj minMaxObj) {
        double fEndOfPreviousStack = 0.0;
        int nItems = dataFormat.getNumDataItems();
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Perspective.getAccess());
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.m_Perspective.getAccess());
        double fHighwaterMark = 0.0;
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            SumObj sumObj = new SumObj();
            sEnum.reset();
            while (sEnum.hasNext()) {
                int s = sEnum.next();
                assert (s >= 0 && s < this.m_nTotalSeries);
                if (this.seriesNotAssignedToAxis(s, nAxis)) continue;
                for (int i = 0; i < nItems; ++i) {
                    DataItem item = dataFormat.getDataItem(i);
                    if (item.ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), nAxis)) continue;
                    DatumObj dObj = this.m_chartBase.getDataValue(s, g, item);
                    double fValue = dObj.value;
                    if (!dObj.m_bOK) continue;
                    if (!sumObj.m_bFirstTime && sumObj.m_bFirstSetIsPositive == fValue < 0.0) {
                        fValue = -fValue;
                    }
                    if (fValue <= 0.0 && this.isBadValueInLogscale(nAxis, fValue)) continue;
                    boolean bPos = fValue >= 0.0;
                    boolean bY2 = nAxis == 1;
                    int nRiser = this.m_depth2D.getSeriesType(s);
                    double fSum = sumObj.getSum(bPos, bY2, nRiser) + fValue;
                    sumObj.setSum(bPos, bY2, nRiser, fSum);
                    int nGroupMode = this.m_Perspective.getWaterfallGroupMode(g);
                    switch (nGroupMode) {
                        case 2: {
                            if (fSum > fHighwaterMark) {
                                fHighwaterMark = fSum;
                            }
                            fSum = 0.0;
                            break;
                        }
                        case 1: 
                        case 3: {
                            break;
                        }
                        default: {
                            fSum += fEndOfPreviousStack;
                        }
                    }
                    minMaxObj.testRawValue(fSum);
                    if (s != sEnum.getLast()) continue;
                    fEndOfPreviousStack = fSum;
                }
            }
            if (!(fHighwaterMark > minMaxObj.getRawMax())) continue;
            minMaxObj.testRawValue(fHighwaterMark);
        }
    }

    private void calcScalingPercent(int nAxis, DataFormat dataFormat, MinMaxObj minMaxObj) {
        int nItems = dataFormat.getNumDataItems();
        int nZeroValue = 0;
        boolean bHasNegValues = false;
        int s = 0;
        do {
            if (this.seriesNotAssignedToAxis(s, nAxis)) continue;
            int g = 0;
            do {
                int i = 0;
                do {
                    DataItem item;
                    if ((item = dataFormat.getDataItem(i++)).ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), nAxis)) continue;
                    DatumObj dObj = this.m_chartBase.getDataValue(s, g, item);
                    double fValue = dObj.value;
                    if (!dObj.m_bOK) continue;
                    if (fValue < 0.0) {
                        bHasNegValues = true;
                    }
                    if (fValue != 0.0) continue;
                    ++nZeroValue;
                } while (i < nItems && !bHasNegValues);
            } while (++g < this.m_nTotalGroups && !bHasNegValues);
            ++s;
        } while (s < this.m_nTotalSeries && !bHasNegValues);
        minMaxObj.testRawValue(1.0);
        if (bHasNegValues) {
            minMaxObj.testRawValue(-1.0);
        } else {
            minMaxObj.testRawValue(0.0);
        }
    }

    private void calcScalingHistogram(int nAxis, DataFormat dataFormat, MinMaxObj minMaxObj) {
        int nItems = dataFormat.getNumDataItems();
        for (int s = 0; s < this.m_nTotalSeries; ++s) {
            for (int g = 0; g < this.m_nTotalGroups; ++g) {
                if (nAxis == 7) {
                    for (int i = 0; i < nItems; ++i) {
                        DataItem item = dataFormat.getDataItem(i);
                        if (item.ignoreInScaling()) continue;
                        DatumObj dObj = this.m_chartBase.getDataValue(s, g, item);
                        double fValue = dObj.value;
                        if (!dObj.m_bOK || fValue <= 0.0 && this.isBadValueInLogscale(nAxis, fValue)) continue;
                        minMaxObj.testRawValue(fValue);
                    }
                    continue;
                }
                throw new RuntimeException("FindLimit should not be called for Y1 axis");
            }
        }
    }

    private boolean isBadValueInLogscale(int axis, double fValue) {
        boolean bIsLog;
        boolean bIsBad = fValue <= 0.0;
        switch (axis) {
            case 7: {
                bIsLog = this.m_Perspective.getX1LogScale();
                break;
            }
            case 0: {
                bIsLog = this.m_Perspective.getY1LogScale();
                break;
            }
            case 1: {
                bIsLog = this.m_Perspective.getY2LogScale();
                break;
            }
            case 2: {
                bIsLog = this.m_Perspective.getY3LogScale();
                break;
            }
            case 3: {
                bIsLog = this.m_Perspective.getY4LogScale();
                break;
            }
            case 4: {
                bIsLog = this.m_Perspective.getY5LogScale();
                break;
            }
            case 8: {
                bIsLog = false;
                break;
            }
            default: {
                bIsLog = true;
            }
        }
        return bIsBad && bIsLog;
    }

    private MinMaxObj setNonDataLimitsScaling(MinMaxObj minMaxObj, int nAxis) {
        for (int i = 0; i < 4; ++i) {
            IdentObj userLineID = this.m_Perspective.getUserLine(i);
            if (this.m_Perspective.getUserLineAxis(userLineID) != nAxis || !this.m_Perspective.getDisplay(userLineID)) continue;
            minMaxObj.testRawValue(this.m_Perspective.getUserLineValue(userLineID));
        }
        return minMaxObj;
    }

    private boolean seriesNotAssignedToAxis(int s, int nAxis) {
        boolean bRelevant = nAxis == 0 || nAxis == 1 || nAxis == 2 || nAxis == 3 || nAxis == 4;
        boolean bNotAssignedToAxis = this.m_axisAssignments[s] != nAxis;
        return bRelevant && bNotAssignedToAxis;
    }
}

