/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IAxisScale;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.DateUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import java.text.Format;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericScale
implements IAxisScale {
    private static final int MAX_NUMBER_OF_GRIDS = 100;
    private static final int[] anNiceDivs = new int[]{1, 10, 2, 5, 3, 4, 20, 25, 50, 100};
    private MinMaxObj m_objMinMax;
    private double m_fScaleMin;
    private double m_fScaleMax;
    private double m_fMajorStep;
    private double m_fMinorStep;
    private int m_MajorCount;
    private int m_MinorCount;
    private double m_fValToRelCoord;
    private boolean m_bLogScale;
    private double m_fLogScaleBase;
    private boolean m_bAutoMax;
    private boolean m_bAutoMin;
    private boolean m_bAutoMajorStep;
    private boolean m_bAutoMinorStep;
    private int m_MajorUnitCount;
    private int m_MinorUnitCount;
    private int m_MajorUnit;
    private int m_MinorUnit;
    private double m_fRawMin;
    private double m_fAxisLengthRel;
    protected double m_fAxisPositionRel;
    private int m_nNumLabels;
    private double m_fBaseMax = 0.0;
    private double m_fBaseMin = 0.0;
    private boolean m_bNonZeroBaseline = false;
    private Perspective m_Perspective = null;
    private JGraphType m_gt = null;
    private AxisTemplate m_template;
    private boolean m_bAscending;
    private boolean m_bDateScale = false;
    private boolean m_bPGSDKDateScale = false;
    public static final double MS_IN_YEAR = 3.1556926E10;
    public static final double MS_IN_QUARTER = 7.8892315E9;
    public static final double MS_IN_MONTH = 2.62974383E9;
    public static final double MS_IN_DAY = 8.64E7;
    public static final double MS_IN_HOUR = 3600000.0;
    public static final double MS_IN_MINUTE = 60000.0;
    public static final double MS_IN_SECOND = 1000.0;
    public static final double[] MS_IN_DATES = new double[]{3.1556926E10, 2.62974383E9, 8.64E7, 3600000.0, 60000.0, 1000.0, 7.8892315E9};
    public static final int USING_YEAR = 0;
    public static final int USING_MONTH = 1;
    public static final int USING_DAY = 2;
    public static final int USING_HOUR = 3;
    public static final int USING_MINUTE = 4;
    public static final int USING_SECOND = 5;
    public static final int USING_QUARTER = 6;
    private int MSindex;
    public static final int[] CALENDAR_FIELDS = new int[]{1, 2, 5, 11, 12, 13, 9};

    public NumericScale(Perspective perspective, AxisTemplate template, MinMaxObj minMaxObj, boolean bAscending, int nAxisOffset, int nAxisSize, double fAxisLengthRel, double fAxisPositionRel) {
        this.m_objMinMax = minMaxObj;
        this.m_nNumLabels = 0;
        this.m_Perspective = perspective;
        this.m_gt = this.m_Perspective.getJGraphType();
        this.m_template = template;
        this.m_fAxisLengthRel = fAxisLengthRel;
        this.m_fAxisPositionRel = fAxisPositionRel;
        this.m_bAscending = bAscending;
        this.m_bDateScale = this.m_Perspective.getUseTimeScaleAxis() && this.m_template.getAxisObjID() == 7;
        this.m_bPGSDKDateScale = this.m_Perspective.getUsePGSDKTimeScaleAxis() && this.m_template.getAxisObjID() == 7 || this.m_template.getAxisObjID() == 0 && JGraphType.getJGraphType(this.m_Perspective.getGraphType()).isGanttType();
    }

    protected void copyNumericScaleParams() {
        this.m_bLogScale = this.m_Perspective.getLogScale(this.m_template.getAxis());
        this.m_fLogScaleBase = this.m_Perspective.getLogScaleBase(this.m_template.getAxis());
        if (this.m_fLogScaleBase < 2.0) {
            this.m_fLogScaleBase = 2.0;
        }
        if (this.m_fLogScaleBase > 100.0) {
            this.m_fLogScaleBase = 100.0;
        }
        this.m_bAutoMajorStep = this.m_Perspective.getGridStepAuto(this.m_template.getMajor());
        this.m_bAutoMinorStep = this.m_Perspective.getGridStepAuto(this.m_template.getMinor());
        this.m_fMajorStep = this.m_Perspective.getGridStep(this.m_template.getMajor());
        this.m_bAutoMax = this.m_Perspective.getScaleMaxAuto(this.m_template.getAxis());
        this.m_bAutoMin = this.m_Perspective.getScaleMinAuto(this.m_template.getAxis());
        this.m_fScaleMax = this.m_bAutoMax ? this.m_objMinMax.getAdjMax() : this.m_Perspective.getScaleMax(this.m_template.getAxis());
        double d = this.m_fScaleMin = this.m_bAutoMin ? this.m_objMinMax.getAdjMin() : this.m_Perspective.getScaleMin(this.m_template.getAxis());
        if (this.m_bNonZeroBaseline && this.m_gt.isScalingAbs() && !this.m_gt.isBubble() && !this.m_gt.isScatter()) {
            double fNZBaseline = this.m_Perspective.getNonZeroBaselineValue(this.m_template.getAxis());
            this.m_fBaseMax = this.m_fScaleMax;
            this.m_fBaseMin = this.m_fScaleMin;
            if (!(fNZBaseline <= 0.0) || !this.isLogScale()) {
                if (fNZBaseline >= this.m_fScaleMax && this.m_bAutoMax) {
                    this.m_fScaleMax = fNZBaseline;
                } else if (fNZBaseline <= this.m_fScaleMin && this.m_bAutoMin) {
                    this.m_fScaleMin = fNZBaseline;
                }
            }
        }
        if (this.m_bPGSDKDateScale) {
            this.m_MajorUnit = this.m_Perspective.getMajorGridTickInterval();
            this.m_MinorUnit = this.m_Perspective.getMinorGridTickInterval();
            this.m_MajorUnitCount = this.m_Perspective.getGridUnitCount(this.m_template.getMajor());
            this.m_MinorUnitCount = this.m_Perspective.getGridUnitCount(this.m_template.getMinor());
            this.m_bAutoMajorStep = this.m_Perspective.getGridUnitAuto(this.m_template.getMajor());
            this.m_bAutoMinorStep = this.m_Perspective.getGridUnitAuto(this.m_template.getMinor());
            if (Math.abs(this.m_fScaleMax - this.m_fScaleMin) == 1.0) {
                this.m_fScaleMax = this.m_fScaleMin;
            }
        }
    }

    public boolean calcNumericScaleInternal() {
        boolean bDataOK = true;
        this.m_bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(this.m_template.getAxis());
        this.copyNumericScaleParams();
        if (!this.m_objMinMax.isValid()) {
            this.m_fScaleMin = 0.0;
            this.m_fScaleMax = 1.0;
            bDataOK = false;
        }
        if (bDataOK) {
            this.calcNumericScale();
            this.calcMinorStep();
            this.m_fValToRelCoord = this.m_fAxisLengthRel / (this.m_fScaleMax - this.m_fScaleMin);
        }
        return bDataOK;
    }

    private void setTimeAxisParameters() {
        if (this.m_bAutoMajorStep) {
            double fSpan = Math.abs(DateUtils.diff((long)this.m_fScaleMin, (long)this.m_fScaleMax, 4));
            if (fSpan > 7300.0) {
                this.m_MajorUnit = 8;
                this.m_MajorUnitCount = Math.min(1000, (int)(fSpan / 2190.0));
            } else if (fSpan > 750.0) {
                this.m_MajorUnit = 8;
                this.m_MajorUnitCount = Math.max(1, (int)(fSpan / 1500.0));
            } else if (fSpan > 75.0) {
                this.m_MajorUnit = 6;
                this.m_MajorUnitCount = Math.max(1, (int)(fSpan / 150.0));
            } else {
                this.m_MajorUnit = 4;
                int majorCount = Math.max(1, (int)fSpan / 5);
                this.m_MajorUnitCount = 1;
                if (fSpan >= 6.0 && fSpan <= 14.0) {
                    this.m_MajorUnitCount = 2;
                } else if (fSpan >= 15.0 && fSpan <= 21.0) {
                    this.m_MajorUnitCount = 3;
                } else if (fSpan >= 22.0 && fSpan <= 29.0) {
                    this.m_MajorUnitCount = 5;
                } else if (majorCount >= 6 && majorCount <= 8) {
                    this.m_MajorUnitCount = 7;
                } else if (majorCount >= 9 && majorCount <= 12) {
                    this.m_MajorUnitCount = 10;
                } else if (majorCount >= 13 && majorCount <= 18) {
                    this.m_MajorUnitCount = 14;
                } else if (majorCount >= 19 && majorCount <= 23) {
                    this.m_MajorUnitCount = 21;
                } else if (majorCount >= 24 && majorCount <= 35) {
                    this.m_MajorUnitCount = 30;
                } else if (majorCount >= 36 && majorCount <= 100) {
                    this.m_MajorUnitCount = 60;
                }
            }
        }
        if (this.m_MajorUnit < this.m_MinorUnit) {
            this.m_MinorUnit = this.m_MajorUnit;
        }
        if (!this.m_bAutoMinorStep) {
            long major = DateUtils.add(0L, this.m_MajorUnit, this.m_MajorUnitCount);
            long minor = DateUtils.add(0L, this.m_MinorUnit, this.m_MinorUnitCount);
            if (minor >= major) {
                this.m_bAutoMinorStep = true;
            }
        }
        if (this.m_bAutoMinorStep) {
            this.m_MinorUnitCount = this.m_MajorUnitCount / 2;
            if (this.m_MinorUnitCount == 0) {
                if (this.m_MajorUnit == 8) {
                    this.m_MinorUnitCount = 6;
                    this.m_MinorUnit = 6;
                } else if (this.m_MajorUnit == 6) {
                    this.m_MinorUnitCount = 15;
                    this.m_MinorUnit = 4;
                } else {
                    this.m_MinorUnitCount = 1;
                    this.m_MinorUnit = 4;
                }
            } else {
                this.m_MinorUnit = this.m_MajorUnit;
            }
        }
        this.m_fMajorStep = (double)DateUtils.add((long)this.m_fScaleMin, this.m_MajorUnit, this.m_MajorUnitCount) - this.m_fScaleMin;
        this.m_fMinorStep = (double)DateUtils.add((long)this.m_fScaleMin, this.m_MinorUnit, this.m_MinorUnitCount) - this.m_fScaleMin;
        if (this.m_fMinorStep > this.m_fMajorStep) {
            this.m_fMinorStep = this.m_fMajorStep;
        }
        this.m_MinorCount = Math.max(1, (int)(this.m_fMajorStep / this.m_fMinorStep) - 1);
        this.adjustMinMaxForGaps();
        this.m_MajorCount = 0;
        double newScaleMax = -1.0;
        while ((newScaleMax = (double)DateUtils.add((long)this.m_fRawMin, this.m_MajorUnit, this.m_MajorUnitCount * this.m_MajorCount)) <= this.m_fScaleMax && this.m_MajorCount++ < 2000) {
        }
    }

    private void adjustMinMaxForGaps() {
        double percentSpacing = (double)this.m_Perspective.getRiserWidth() / 100.0;
        this.m_fRawMin = this.m_fScaleMin;
        double span = Math.abs(this.m_fScaleMax - this.m_fScaleMin);
        double endSpace = Math.max(0.05, 0.1 * percentSpacing);
        if (span > 0.0) {
            endSpace *= span;
        }
        this.m_fScaleMin -= endSpace;
        this.m_fScaleMax += endSpace;
    }

    protected void calcAutoMinMax() {
        double fTop;
        double fBot;
        boolean autoDivsAutoRange;
        double fSpread;
        int nScaleFactor = 0;
        double fMin = this.m_fScaleMin;
        double fMax = this.m_fScaleMax;
        if (FP.equal(fMax, 0.0) && FP.equal(fMin, 0.0)) {
            fMax = 1.0;
        } else if (FP.equal(fMax - fMin, 0.0)) {
            double fDif = fMax / 2.0;
            if (fDif < 0.0) {
                fDif *= -1.0;
            }
            fMin -= fDif;
            fMax += fDif;
        } else if (FP.lessThan(fMax - fMin, 0.0)) {
            fMax = Math.max(fMin, fMax);
            fMin = Math.min(fMin, fMax);
        }
        if (this.m_bDateScale) {
            fSpread = fMax - fMin;
            if (fSpread / 3.1556926E10 > 1.0) {
                this.MSindex = 0;
            } else if (fSpread / 2.62974383E9 > 1.0) {
                this.MSindex = 1;
            } else if (fSpread / 8.64E7 > 1.0) {
                this.MSindex = 2;
            } else if (fSpread / 3600000.0 > 1.0) {
                this.MSindex = 3;
            } else if (fSpread / 60000.0 > 1.0) {
                this.MSindex = 4;
            } else if (fSpread / 1000.0 > 1.0) {
                this.MSindex = 5;
            }
            fSpread = (fMax - fMin) / MS_IN_DATES[this.MSindex];
        } else {
            fSpread = fMax - fMin;
        }
        double fT = Math.log(fSpread) / Math.log(10.0);
        double fTestVal = 0.0;
        double fBaseToUse = this.m_bLogScale ? this.m_fLogScaleBase : 10.0;
        fTestVal = FP.equal(fT - (double)FP.round(fT), 0.0) ? Math.pow(fBaseToUse, fT - 2.0) : Math.pow(fBaseToUse, Math.floor(fT) - 1.0);
        int nFirst2Digits = (int)Math.round(fSpread / fTestVal);
        boolean found = false;
        int i = 0;
        int j = 0;
        if (Math.abs((double)nFirst2Digits * fTestVal - fSpread) <= 1.0E-14) {
            for (i = 0; i < anNiceDivs.length && !found; ++i) {
                j = (int)Math.round((double)nFirst2Digits / (double)anNiceDivs[i]);
                if (3 > j || j > 10) continue;
                found = nFirst2Digits % anNiceDivs[i] == 0;
            }
        }
        boolean bl = autoDivsAutoRange = (this.m_bAutoMax || this.m_bAutoMin) && this.m_bAutoMajorStep;
        nScaleFactor = found && !autoDivsAutoRange ? anNiceDivs[i - 1] : (nFirst2Digits >= 9 && nFirst2Digits <= 16 ? 2 : (nFirst2Digits >= 17 && nFirst2Digits <= 29 ? 4 : (nFirst2Digits >= 30 && nFirst2Digits <= 44 ? 5 : (nFirst2Digits >= 45 && nFirst2Digits <= 79 ? 10 : (nFirst2Digits >= 80 && nFirst2Digits <= 100 ? 20 : (nFirst2Digits > 100 ? (fTestVal > 0.0 ? (int)fSpread / 100 / (int)fTestVal : (int)fSpread / 100 / 64) : 1))))));
        if (this.m_fAxisLengthRel < 1.0) {
            double fTemp = nScaleFactor;
            fTemp /= this.m_fAxisLengthRel;
            while (fTemp >= 20.0) {
                fTemp /= 10.0;
                fTestVal *= 10.0;
            }
            nScaleFactor = fTemp < 20.0 && fTemp > 10.0 ? 20 : (fTemp > 5.0 ? 10 : (fTemp > 4.0 ? 5 : (fTemp > 2.0 ? 4 : 2)));
        }
        double fScaleUnit = (double)nScaleFactor * fTestVal;
        if (this.m_bDateScale) {
            if (fScaleUnit < 1.0) {
                fScaleUnit = 1.0;
            }
            fScaleUnit *= MS_IN_DATES[this.MSindex];
        }
        if (this.m_bDateScale) {
            Double doubleValue = new Double(this.m_fScaleMin);
            long lValue = doubleValue.longValue();
            Date dateValue = new Date(lValue);
            Calendar calDay = Calendar.getInstance();
            calDay.setTime(dateValue);
            int calIndex = this.MSindex;
            if (this.MSindex == 6) {
                calIndex = 1;
            }
            for (i = calIndex + 1; i < CALENDAR_FIELDS.length; ++i) {
                calDay.set(CALENDAR_FIELDS[i], calDay.getMinimum(CALENDAR_FIELDS[i]));
            }
            Date newDate = calDay.getTime();
            fTop = fBot = (double)newDate.getTime();
            int nDateScale = (int)Math.round(fScaleUnit / MS_IN_DATES[this.MSindex]);
            while (FP.lessThan(fTop, fMax)) {
                if (this.MSindex == 6) {
                    calDay.add(CALENDAR_FIELDS[1], nDateScale * 3);
                } else {
                    calDay.add(CALENDAR_FIELDS[this.MSindex], nDateScale);
                }
                newDate = calDay.getTime();
                fTop = newDate.getTime();
            }
        } else {
            fBot = Math.floor(fMin / fScaleUnit) * fScaleUnit;
            if (FP.greaterThan(fScaleUnit, 0.0)) {
                while (FP.greaterThan(fBot, fMin)) {
                    fBot -= fScaleUnit;
                }
            }
            fTop = fBot;
            if (FP.greaterThan(fScaleUnit, 0.0)) {
                while (FP.lessThan(fTop, fMax)) {
                    fTop += fScaleUnit;
                }
            }
        }
        if (FP.equal(fTop, fMax)) {
            fTop = fMax;
        }
        if (this.m_bAutoMin) {
            this.m_fScaleMin = fBot;
        }
        if (this.m_bAutoMax) {
            this.m_fScaleMax = fTop;
        }
        if (this.m_bAutoMajorStep) {
            this.m_fMajorStep = fScaleUnit;
        }
    }

    private void calcLogScale() {
        double fT = Math.log(this.m_fScaleMin) / Math.log(this.m_fLogScaleBase);
        this.m_fScaleMin = Math.floor(fT);
        fT = Math.log(this.m_fScaleMax) / Math.log(this.m_fLogScaleBase);
        this.m_fScaleMax = Math.ceil(fT);
        this.m_fMajorStep = 1.0;
        this.m_fMinorStep = 0.1;
    }

    public double getBaseRelCoord() {
        if (this.m_bLogScale) {
            return this.getValueRelCoord(Math.pow(this.m_fLogScaleBase, this.m_fScaleMin));
        }
        return this.getValueRelCoord(this.m_fScaleMin);
    }

    public double getIntervalStart(int nInterval) {
        return this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + this.m_fMajorStep * (double)nInterval) : this.m_fScaleMin + this.m_fMajorStep * (double)nInterval;
    }

    public double getIntervalStop(int nInterval) {
        return this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + this.m_fMajorStep * (double)(nInterval + 1)) : this.m_fScaleMin + this.m_fMajorStep * (double)(nInterval + 1);
    }

    protected double getLabelRelPos(int nIndex) {
        return this.getMajorGridPos(nIndex);
    }

    @Override
    public double getMajorGridPos(int nIndex) {
        double fVal = this.m_bPGSDKDateScale ? (double)DateUtils.add((long)this.m_fRawMin, this.m_MajorUnit, nIndex * this.m_MajorUnitCount) : (this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + this.m_fMajorStep * (double)nIndex) : this.m_fScaleMin + this.m_fMajorStep * (double)nIndex);
        return this.getValueRelCoord(fVal);
    }

    @Override
    public double getMinorGridPos(int nMajorIndex, int nMinorIndex) {
        double fVal;
        if (this.m_bPGSDKDateScale) {
            int minorUnitCount = (nMinorIndex + 1) * this.m_MinorUnitCount;
            int majorUnitCount = Math.max(nMajorIndex * this.m_MajorUnitCount, 0);
            if (nMajorIndex < 0) {
                minorUnitCount *= -1;
            }
            long startDate = DateUtils.add((long)this.m_fRawMin, this.m_MajorUnit, majorUnitCount);
            fVal = DateUtils.add(startDate, this.m_MinorUnit, minorUnitCount);
        } else {
            fVal = this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + (double)nMajorIndex) * (double)(nMinorIndex + 2) : this.m_fScaleMin + this.m_fMajorStep * (double)nMajorIndex + this.m_fMinorStep * (double)(nMinorIndex + 1);
        }
        return this.getValueRelCoord(fVal);
    }

    public List<String> getNumericLabels() {
        ArrayList<String> vectStrLabels = new ArrayList<String>(this.getNumLabels());
        Format format = this.m_Perspective.getTextFormat(this.m_template.getLabel());
        for (int i = 0; i < this.getNumLabels(); ++i) {
            Double value = new Double(this.calcLabelValue(i));
            vectStrLabels.add(format.format(value));
        }
        return vectStrLabels;
    }

    private double calcLabelValue(int i) {
        double value = 0.0;
        if (this.m_bLogScale) {
            value = Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + (double)i * this.m_fMajorStep);
        } else {
            value = this.m_bPGSDKDateScale ? (double)DateUtils.add((long)this.m_fRawMin, this.m_MajorUnit, i * this.m_MajorUnitCount) : this.m_fScaleMin + (double)i * this.m_fMajorStep;
            if (value > this.m_fScaleMax) {
                value = this.m_fScaleMax;
            }
        }
        return value;
    }

    public List<Double> getNumericLabelsAsDouble() {
        ArrayList<Double> szLabels = new ArrayList<Double>(this.getNumLabels());
        for (int i = 0; i < this.getNumLabels(); ++i) {
            double fLabel = this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + (double)i * this.m_fMajorStep) : this.m_fScaleMin + (double)i * this.m_fMajorStep;
            Double dLabel = new Double(fLabel);
            szLabels.add(dLabel);
        }
        return szLabels;
    }

    public int getNumIntervals() {
        if (this.m_bPGSDKDateScale) {
            throw new RuntimeException("Not Currently implemented.... not needed at time of writing.");
        }
        return (int)((this.m_fScaleMax - this.m_fScaleMin) / this.m_fMajorStep + 1.0);
    }

    @Override
    public int calcNumLabels() {
        if (this.m_bDateScale) {
            this.m_nNumLabels = this.calcDateLabels();
        } else if (this.m_bPGSDKDateScale) {
            this.m_nNumLabels = this.m_MajorCount;
        } else {
            this.m_nNumLabels = 1;
            for (double f = this.m_fScaleMin; f < this.m_fScaleMax; f += this.m_fMajorStep) {
                ++this.m_nNumLabels;
            }
        }
        return this.m_nNumLabels;
    }

    @Override
    public int getNumLabels() {
        return this.m_nNumLabels;
    }

    @Override
    public int getNumMajorGrids() {
        int nNumMajorGrids = this.getNumLabels();
        return nNumMajorGrids;
    }

    @Override
    public int getNumMinorGrids() {
        if (this.m_bPGSDKDateScale) {
            return this.m_MinorCount;
        }
        if (this.m_bLogScale) {
            return 8;
        }
        int nNumMinorGrids = (int)Math.max(Math.floor(this.m_fMajorStep / this.m_fMinorStep), 0.0);
        if (FP.equal(this.m_fMinorStep * (double)nNumMinorGrids, this.m_fMajorStep)) {
            --nNumMinorGrids;
        }
        return nNumMinorGrids;
    }

    public double getValueFromRelCoord(double coord) {
        double val = this.m_bAscending ? (coord - this.m_fAxisPositionRel) / this.m_fValToRelCoord + this.m_fScaleMin : (this.m_fAxisPositionRel + this.m_fAxisLengthRel - coord) / this.m_fValToRelCoord + this.m_fScaleMin;
        if (this.m_bLogScale) {
            val = Math.pow(this.m_fLogScaleBase, val);
        }
        return val;
    }

    public double getValueRelCoord(double fValue) {
        if (!this.m_bLogScale) {
            if (fValue < this.m_fScaleMin) {
                fValue = this.m_fScaleMin;
            }
            if (fValue > this.m_fScaleMax) {
                fValue = this.m_fScaleMax;
            }
        }
        if (this.m_bLogScale) {
            fValue = fValue == 0.0 ? this.m_fScaleMin : Math.log(fValue) / Math.log(this.m_fLogScaleBase);
        }
        double fCoord = this.m_bAscending ? this.m_fAxisPositionRel + (fValue - this.m_fScaleMin) * this.m_fValToRelCoord : this.m_fAxisPositionRel + this.m_fAxisLengthRel - (fValue - this.m_fScaleMin) * this.m_fValToRelCoord;
        fCoord = Math.min(fCoord, 1.0);
        if (!this.m_gt.is3DRibbonType()) {
            fCoord = Math.max(fCoord, 0.0);
        }
        return fCoord;
    }

    public boolean hasNegData() {
        return this.m_fScaleMin < 0.0;
    }

    public boolean isZeroInRange() {
        return !(this.m_fScaleMin > 0.0) && !(this.m_fScaleMax < 0.0);
    }

    protected void calcNumericScale() {
        if (this.m_bPGSDKDateScale) {
            this.setTimeAxisParameters();
            return;
        }
        boolean bNeedUpdateLook = false;
        if (this.m_gt.isPercent()) {
            boolean hasNegativeScale = this.m_objMinMax.getAdjMin() < 0.0;
            boolean hasPositiveScale = this.m_objMinMax.getAdjMax() > 0.0;
            this.m_bAutoMajorStep = false;
            this.m_bAutoMin = false;
            this.m_bAutoMax = false;
            this.m_fScaleMax = hasPositiveScale ? 1.0 : 0.0;
            this.m_fScaleMin = hasNegativeScale ? -1.0 : 0.0;
            if (this.m_Perspective.getGridStepAuto(this.m_template.getMajor())) {
                this.m_fMajorStep = hasNegativeScale && hasPositiveScale ? 0.2 : 0.1;
            }
            this.m_bLogScale = false;
        }
        if (this.m_fScaleMin > this.m_fScaleMax) {
            double temp = this.m_fScaleMin;
            this.m_fScaleMin = this.m_fScaleMax;
            this.m_fScaleMax = temp;
            this.m_bAscending = !this.m_bAscending;
            bNeedUpdateLook = true;
        }
        if (this.m_fMajorStep < 0.0 && !this.m_bAutoMajorStep) {
            this.m_bAutoMajorStep = true;
            this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), true);
        } else if (this.m_fMajorStep > this.m_fScaleMax - this.m_fScaleMin && !this.m_bAutoMajorStep) {
            this.m_bAutoMajorStep = true;
            this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), true);
        } else if (this.m_fMajorStep * 100.0 < this.m_fScaleMax - this.m_fScaleMin && !this.m_bAutoMajorStep) {
            this.m_bAutoMajorStep = true;
            this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), true);
        }
        if (this.m_bLogScale) {
            if (this.m_fScaleMin <= 0.0) {
                this.m_bLogScale = false;
                this.m_Perspective.setLogScale(this.m_template.getAxis(), false);
            }
            if (this.m_fScaleMax <= 0.0) {
                this.m_bLogScale = false;
                this.m_Perspective.setLogScale(this.m_template.getAxis(), false);
            }
            if (this.m_bLogScale) {
                this.calcLogScale();
                this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), true);
                this.m_Perspective.setGridStep(this.m_template.getMajor(), this.m_fMajorStep);
                return;
            }
        }
        if (FP.equal(this.m_fScaleMin, 0.0) && FP.equal(this.m_fScaleMax, 0.0)) {
            this.m_bAutoMax = false;
            this.m_bAutoMin = false;
            this.m_bAutoMajorStep = false;
            this.m_fScaleMax = 5.0;
            this.m_fScaleMin = -5.0;
            this.m_fMajorStep = 1.0;
            this.m_Perspective.setLogScale(this.m_template.getAxis(), false);
            this.m_Perspective.setGridStep(this.m_template.getMajor(), this.m_fMajorStep);
            this.m_Perspective.setScaleMax(this.m_template.getAxis(), this.m_fScaleMax);
            this.m_Perspective.setScaleMin(this.m_template.getAxis(), this.m_fScaleMin);
        }
        if (FP.equal(this.m_fScaleMin, this.m_fScaleMax) && !this.m_bAutoMax && !this.m_bAutoMin) {
            this.m_bAutoMax = true;
            this.m_bAutoMin = true;
            bNeedUpdateLook = true;
        }
        if (this.m_objMinMax.isDataDerived() && (!this.m_Perspective.getUsePGSDKViewing() || this.m_bDateScale)) {
            boolean bSmallRangeSpecialCase = false;
            double fScaleDiff = this.m_fScaleMax - this.m_fScaleMin;
            double nMultiplier = 1.0;
            double dateAdjuster = 1.0;
            double autoMinMaxAdjuster = 1.05;
            if (this.m_bDateScale) {
                dateAdjuster = this.findDateAdjuster();
                if (fScaleDiff < dateAdjuster) {
                    bSmallRangeSpecialCase = true;
                }
            } else if (fScaleDiff < 2.8 * nMultiplier) {
                bSmallRangeSpecialCase = true;
            }
            if (this.m_bAutoMin) {
                if (this.m_fScaleMin < 0.0 && !this.m_bDateScale) {
                    this.m_fScaleMin *= autoMinMaxAdjuster;
                } else if (!bSmallRangeSpecialCase) {
                    this.m_fScaleMin = this.m_bDateScale ? (this.m_fScaleMin -= dateAdjuster) : (this.m_fScaleMin /= autoMinMaxAdjuster);
                }
            }
            if (this.m_bAutoMax) {
                if (this.m_fScaleMax < 0.0 && !this.m_bDateScale) {
                    this.m_fScaleMax /= autoMinMaxAdjuster;
                } else if (!bSmallRangeSpecialCase) {
                    this.m_fScaleMax = this.m_bDateScale ? (this.m_fScaleMax += dateAdjuster) : (this.m_fScaleMax *= autoMinMaxAdjuster);
                }
            }
        }
        if (this.m_bAutoMax || this.m_bAutoMin || this.m_bAutoMajorStep) {
            this.calcAutoMinMax();
        }
        if (!this.m_gt.isPercent()) {
            this.m_Perspective.setGridStep(this.m_template.getMajor(), this.m_fMajorStep);
            if (bNeedUpdateLook || this.m_bAutoMax || this.m_bAutoMin || this.m_bAutoMajorStep) {
                if (bNeedUpdateLook) {
                    this.m_Perspective.setScaleMaxAuto(this.m_template.getAxis(), this.m_bAutoMax);
                    this.m_Perspective.setScaleMinAuto(this.m_template.getAxis(), this.m_bAutoMin);
                    this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), this.m_bAutoMajorStep);
                }
                this.m_Perspective.setAxisDescending(this.m_template.getAxis(), !this.m_bAscending);
                if (!this.m_bNonZeroBaseline || !this.m_gt.isScalingAbs() || this.m_gt.isBubble() || this.m_gt.isScatter()) {
                    this.m_Perspective.setScaleMax(this.m_template.getAxis(), this.m_fScaleMax);
                    this.m_Perspective.setScaleMin(this.m_template.getAxis(), this.m_fScaleMin);
                }
            }
        }
    }

    public boolean isLogScale() {
        return this.m_bLogScale;
    }

    public boolean isDateScale() {
        return this.m_bDateScale;
    }

    private void calcMinorStep() {
        if (this.m_bPGSDKDateScale) {
            return;
        }
        boolean bAutoMinorStep = this.m_Perspective.getGridStepAuto(this.m_template.getMinor());
        boolean bUpdateStep = false;
        this.m_fMinorStep = bAutoMinorStep ? this.m_fMajorStep / 2.0 : this.m_fMajorStep / (double)(this.m_Perspective.getGridCount(this.m_template.getMinor()) + 1);
        if (this.m_fMinorStep < 0.0 && !this.m_bAutoMajorStep) {
            this.m_fMinorStep = this.m_fMajorStep / 2.0;
            bAutoMinorStep = true;
            bUpdateStep = true;
        } else if (this.m_fMinorStep >= this.m_fMajorStep) {
            this.m_fMinorStep = this.m_fMajorStep / 2.0;
            bAutoMinorStep = true;
            bUpdateStep = true;
        } else if (this.m_fMinorStep * 100.0 < this.m_fMajorStep) {
            this.m_fMinorStep = this.m_fMajorStep / 2.0;
            bAutoMinorStep = true;
            bUpdateStep = true;
        }
        if (bUpdateStep || this.m_bLogScale) {
            this.m_Perspective.setGridStepAuto(this.m_template.getMinor(), true);
            this.m_Perspective.setGridStep(this.m_template.getMinor(), this.m_fMinorStep);
        }
    }

    public double getDoubleForMinCoord() {
        return this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin) : this.m_fScaleMin;
    }

    public double getDoubleForMaxCoord() {
        return this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMax) : this.m_fScaleMax;
    }

    public double getMinValue() {
        if (this.m_bLogScale) {
            return Math.pow(this.m_fLogScaleBase, this.m_fScaleMin);
        }
        return this.m_fScaleMin;
    }

    public double getBaseMax() {
        if (this.m_bLogScale) {
            return Math.pow(this.m_fLogScaleBase, this.m_fBaseMax);
        }
        return this.m_fBaseMax;
    }

    public double getBaseMin() {
        if (this.m_bLogScale) {
            return Math.pow(this.m_fLogScaleBase, this.m_fBaseMin);
        }
        return this.m_fBaseMin;
    }

    public double getMaxValue() {
        if (this.m_bLogScale) {
            return Math.pow(this.m_fLogScaleBase, this.m_fScaleMax);
        }
        return this.m_fScaleMax;
    }

    public double getStepValue() {
        return this.m_fMajorStep;
    }

    public boolean isValueOffscale(double value) {
        if (this.m_bLogScale) {
            return value < Math.pow(this.m_fLogScaleBase, this.m_fScaleMin) || value > Math.pow(this.m_fLogScaleBase, this.m_fScaleMax);
        }
        return value < this.m_fScaleMin || value > this.m_fScaleMax;
    }

    public boolean isY2Axis() {
        boolean bY2Axis = this.m_template.getAxis().getObjectID() == 2005;
        return bY2Axis;
    }

    public boolean isY1Axis() {
        boolean bY1Axis = this.m_template.getAxis().getObjectID() == 2004;
        return bY1Axis;
    }

    private double findDateAdjuster() {
        double fSpread = this.m_fScaleMax - this.m_fScaleMin;
        if (fSpread / 3.1556926E10 > 0.95) {
            return 1.5778463E9;
        }
        if (fSpread / 2.62974383E9 > 0.95) {
            return 1.314871915E8;
        }
        if (fSpread / 8.64E7 > 0.95) {
            return 4320000.0;
        }
        if (fSpread / 3600000.0 > 0.95) {
            return 180000.0;
        }
        if (fSpread / 60000.0 > 0.95) {
            return 3000.0;
        }
        if (fSpread / 1000.0 > 0.95) {
            return 50.0;
        }
        return 0.0;
    }

    public int calcDateLabels() {
        double f = this.m_fScaleMin;
        Double doubleValue = new Double(f);
        long lValue = doubleValue.longValue();
        Date dateValue = new Date(lValue);
        Calendar calDay = Calendar.getInstance();
        calDay.setTime(dateValue);
        int nDateScale = (int)Math.round(this.m_fMajorStep / MS_IN_DATES[this.MSindex]);
        int nNumLabels = 1;
        if (nDateScale != 0) {
            while (FP.lessThan(f, this.m_fScaleMax)) {
                if (this.MSindex == 6) {
                    calDay.add(CALENDAR_FIELDS[1], nDateScale * 3);
                } else {
                    calDay.add(CALENDAR_FIELDS[this.MSindex], nDateScale);
                }
                dateValue = calDay.getTime();
                f = dateValue.getTime();
                ++nNumLabels;
            }
        }
        return nNumLabels;
    }
}

